
/**
*	Program Name:	BOOTER
*
*	Filename:	init.c
*
*	$Log:   /b/gregs/bridge/booter/main/init.c_v  $
 * 
 *    Rev 1.3   01 Sep 1993 11:32:46   vinay
 * setting the mfg values to default if there was an error in reading eeprom
 * 
 *    Rev 1.2   31 Aug 1993 15:11:58   vinay
 * changed the default flash size
 * 
 *    Rev 1.1   31 Aug 1993 11:26:38   vinay
 * moved the loading of application from flash from main.c to here.
 * initializing port location variables
 * 
 *    Rev 1.0   16 Jul 1993 16:24:12   franks
 * Initial revision.
 * 
 *    Rev 1.2   15 Apr 1992 17:29:10   kwok
 * Adding the pvcs keyword $Log$ into the file header.
*
*	Comments:
*
*	Copyright (c) 1992 by Huges LAN Systems.
**/
#include <krnl.h>
#include <types.h>
#include <target.h>
#include <sys.h>
#include <malloc.h>
#include <dips.h>
#include <led.h>
#include <sncvar.h>
#include <netbuf.h>
#include <ether.h>
#include <nim960h.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include <memory.h>

#define FRONT 1
#define BACK  2

extern int Port_A_ConfigState;
extern int Port_B_ConfigState;
extern NIM960_HDR Nim960Header;		/* My nim960 header	*/
extern void brip_free_task();
extern void brip_rcv_task();
char Port4EthNid[6];

extern int EepromError;
init()
{
	int	port = SV_NMBR_PORT;
	int	i,res = 0;
	

	Load_FebConfiguration(); 

	if(EepromError)
		{
		EepromError = 0;
		PutEep();
		}
			
	SetMyNids();
	InitPort4Nid();
	pktInit(); 

	/* If we are NOT bringing up the tester */
	if (!(sys.sys_switch & DIP_TESTER))
	{
		/* Do the sonic tests. */

		for(i = 0; i < 3; i++)
		{
			if((res = chnl_test(i)) != 0)
				printf("SONIC test failed.  (0x%x)\n",res);
			if(res)
				ErrorAbort(16);
		}

		if(eep_boot_rec.eep_ThinNet & LOAD_FROM_FLASH)
				load_application();
		else 
		{
		/*
		** eep_boot_rec.eep_ThinNet has the info about downloading 
		** from the network and burning the application into flash.
		*/
			UpdateImage(eep_boot_rec.eep_ThinNet);
			
		}
	}


	if(nvr_fddi_rec.UI_Defaults.Port1_PC_Type == 0)
		Port_A_ConfigState = FRONT;
	else
		Port_A_ConfigState = BACK;


	if(nvr_fddi_rec.UI_Defaults.Port6_PC_Type == 1)
		Port_B_ConfigState = FRONT;
	else
		Port_B_ConfigState = BACK;

	disable_wdt();
	tester();
	enable_wdt();
}


InitPort4Nid() {

	extern char Port4EthNid[6];

	memcpy(&Port4EthNid[0], (NID *)MyNid(3), 6);
	swap_bits(&Port4EthNid[0], 6);

}

PutEep()
{
		if (PutEeprom(EEP_BOOT_ADDR, &eep_boot_rec, EEP_BOOT_SIZE) != EEPROM_AOK)
			printf("EEPROM Error: Cannot default the BOOT record\n");
		if (PutEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) != EEPROM_AOK)
			printf("EEPROM Error: Cannot default the MFG record\n");
}

/* NVR_FDDI nvr_fddi_rec; */
Load_FebConfiguration()
{
#ifdef vinay
	LoadEeprom();
#endif
	if( InitNvram(NVRAM, eep_mfg_rec.eep_nvram_size) != NVRAM_AOK )
		printf("NVRAM Error: Cannot init NVRAM\n");

	if( GetFDDIRec(&nvr_fddi_rec) != NVRAM_AOK)
		PutFDDIRec(&nvr_fddi_rec);
#ifdef notdef
	if (Nvram_Load(NVR_FDDI_ADDR, &nvr_fddi_rec, NVR_FDDI_SIZE) != NVRAM_AOK)
        {
		printf("NVRAM Error: Cannot read the FDDI record\n");
		setNVRAM_FDDIDefaults();
		if(Nvram_Updt(NVR_FDDI_ADDR, &nvr_fddi_rec, NVR_FDDI_SIZE) != NVRAM_AOK)
			printf("NVRAM Error: Cannot default the FDDI record\n");
		}
#endif

	return;
}

LoadEeprom()
{

	memset(&eep_mfg_rec,0,EEP_MFG_SIZE);
	memset(&eep_boot_rec,0,EEP_BOOT_SIZE);

	if(GetEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) != EEPROM_AOK)
		{
		EepromError = 1;
		printf("EEPROM Error: Cannot read the BOOT record\n");
		MfgErrSetDefault();

		/* Default_eep_mfg();  Must wait until the kernel is 
                **                     started before this call can be
		**		       made.....			
		*/
		}

	if (GetEeprom(EEP_BOOT_ADDR, &eep_boot_rec, EEP_BOOT_SIZE) != EEPROM_AOK)
		{
		EepromError = 1;
		printf("EEPROM Error: Cannot read the BOOT record\n");
		EEPBootDefault();
		}
}


MfgErrSetDefault()
	{
	printf("Defaulting the EEP mfg record\n");
	memset(&eep_mfg_rec, 0, sizeof(EEP_MFG));
	eep_mfg_rec.eep_marker = 0;
	eep_mfg_rec.eep_sram_size = 0x20000;	/* 128 K	*/
	eep_mfg_rec.eep_dram_size = 0x400000;	/* 4 M		*/
	eep_mfg_rec.eep_shram_size = 0x80000;	/* 512 K	*/
	eep_mfg_rec.eep_nvram_size = 0x20000;	/* 128 K	*/
	eep_mfg_rec.eep_eeprom_size = 0x2000;	/* 8 K		*/
	eep_mfg_rec.eep_fprom_size = 0xc0000;	/* 3/4 M		*/
    SetEEP_FDDIDefaults();
	}



EEPBootDefault()
{
	char nodate[8];
	memset(&eep_boot_rec, 0, sizeof(EEP_BOOT));
	memset(nodate,0,8);
        strcpy(eep_boot_rec.eep_request_file, "h836");
        memcpy(eep_boot_rec.eep_BurnDate, nodate, 8);
        memcpy(eep_boot_rec.eep_BurnTime, nodate, 8);
	eep_boot_rec.eep_ring_number = 0;
        /*
         *      This variable will be used for downloading and 
         *      FLASH programming.
         */
        eep_boot_rec.eep_ThinNet = LOAD_FROM_FLASH;/* load from flash */
}

Default_eep_mfg()
{
	MfgErrSetDefault();
	if (PutEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) != EEPROM_AOK)
		printf("EEPROM Error: Cannot default the MFG record\n");
}

TestBoot()

	{
	int	port = SV_NMBR_PORT-1;

	if(eep_boot_rec.eep_ThinNet == UPDATE_FLASH)
		UpdateImage(1);
	else
		UpdateImage(0);
	while(port--)
		chnl_stop(port);
	}


IsPacketForMe(DBD *d)

	{
	return IsMyNid(d->db_buffer, d->db_rcvportno);
	}
