
/**
*	Program Name:	BOOTER
*
*	Filename:	main.c
*
*	$Log:   /b/gregs/bridge/booter/main/main.c_v  $
 * 
 *    Rev 1.7   06 Jan 1994 15:27:52   gregs
 * Changed the starting location of the memory used by shmalloc so as to 
 * make use of the full 1M of shared ram.
 * 
 *    Rev 1.6   29 Oct 1993 09:38:28   gregs
 * Added SetBPRingZero for FDDI loopback test use, moved WDOG to loader.
 * 
 *    Rev 1.5   15 Oct 1993 13:18:46   gregs
 * added tickle of watch dog so gary can fix i960 reset problem.
 * 
 *    Rev 1.4   06 Oct 1993 09:31:50   gregs
 * made brip task stacks 512 words to match declaration in map/map.c
 * 
 *    Rev 1.3   31 Aug 1993 11:28:40   vinay
 * cleaned up the code and moved load_application to init.c
 * 
 *    Rev 1.2   30 Aug 1993 08:44:18   vinay
 * took out some unwanted code and changed the checing of ring_number
 * with -1 to 0xffff
 * 
 *    Rev 1.1   24 Aug 1993 16:18:26   vinay
 * new rev 8/24/93
 * 
 *    Rev 1.0   16 Jul 1993 16:24:14   franks
 * Initial revision.
 * 
 *    Rev 1.4   11 May 1992 16:05:12   pvcs
 * Declare the dummy apl (type APPL) to keep util.o happy.
 * 
 *    Rev 1.3   11 May 1992 15:48:16   kwok
 * Abort and flicker the LEDs if the timer doesn't work properly.
 * 
 *    Rev 1.2   15 Apr 1992 17:28:40   kwok
 * Adding the pvcs keyword $Log$ in the file header.
*
*	Comments:
*
*	Copyright (c) 1992 by Huges LAN Systems.
**/
#include <krnl.h>
#include <target.h>
#include <memory.h>
#include <eeprecs.h>
#include <nim960h.h>
#include <uart.h>
#include <dips.h>
#include <led.h>
#include <sys.h>
#include <sncvar.h>
#include <malloc.h>
#include <nvrecs.h>
#include <flash.h>
#include <pkt.h>

extern void init();
extern byte * RamByteTest(byte *, int);

word init_stk[800];
word brip_free_stk[512];
word brip_rcv_stk[512];
extern word bss_start;
extern word end, etext;
extern word load_addr;
extern char *error_msgs[];
extern NIM960_HDR Nim960Header;		/* My nim960 header	*/
extern	int	snc_init;
int fault_cnt;
ulong program_id = 0x3e7;
int	NumberOfSonicPort = SV_NMBR_PORT-1;
word gdb;
APPL	apl;	/* dummy to keep util.o happy	*/
static char *WhichBank(int bank);
void	JumpToNewProgram(unsigned *);
#ifdef notdef
word	aplLocation = 0x40000;		/* offset of appl. in flash */
#endif
word	aplLocation = 0x40000;		/* zzz for the time being */

int EepromError = 0;
int turn0 = 0;
int turn1 = 0;
/* extern int bootStage; */

main()
{
	register NIM960_HDR *nim960_hdr = (NIM960_HDR *)(FEPROM + aplLocation);
	register EEP_MFG *ram_mfg_ptr;
	register int baud;
	unsigned short	csum;
	int i;
	int res;

	/* Disable Bus watch dog timer and Enable 4 LANs */
	/*set_ctrl1(0xffff, DISABLE_BUS_WDT | 0xf); */
	set_ctrl1(CTRL1_BUS_WDT | CTRL1_NVR | CTRL1_EEPROM, DISABLE_BUS_WDT | DISABLE_NVR | DISABLE_EEPROM);
	set_ctrl1(CTRL1_LR0 | CTRL1_LR1 | CTRL1_LR2, ENABLE_LR0 | ENABLE_LR1 | ENABLE_LR2 );
	set_ctrl1(CTRL1_FDDIA_PT | CTRL1_FDDIB_PT, PEER_TREEA_OFF | PEER_TREEB_OFF);

	ShowSLed(0, 0x8ffff);

	/* we do not use BridgeStatus for port control in the booter */
	/* bootStage = 1; */

	Dip_reset();
	baud = GetDipBaud();
	sys.sys_baud = baud;
	ttyinit(baud);

	fault_cnt = 1;		/* for TTY i/o before StartKernel */
	PrintHdr();
	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_RED | LED_ACT_RED);

	/* Read the mfg record from EEPROM.  If there is a problem it will
	be updated later (can't write EEPROM until after StartKernel) */

	if (InitEeprom(EEPROM, EEPROM_SIZE) != EEPROM_AOK)
	{
		EepromError = 1;
		printf("EEPROM error: cannot initialize EEPROM\n");
	}
	LoadEeprom();

	ShowSLed(1, 0x8ffff);

	/* scc_init_chnl_a(); */

	/*set_ctrl1(0x400, 0x0000); */

#ifdef notdef		/* not on the new h/w */
	/* set the DRAM size (1M X 4 or 256K X 4) */
	if (eep_mfg_rec.eep_dram_size > 0x200000)
		set_ctrl2(CTRL2_DRAM_SIZE, DRAM_SIZE_4M);	/* 1M X 4 */
	else
		set_ctrl2(CTRL2_DRAM_SIZE, DRAM_SIZE_1M);	/* 256K X 4 */
#endif
	/* Abort if any of the 3 timers does not work properly.  */
	if (!(sys.sys_switch & DIP_TESTER))
	{
		if( tmr_test(0, 0) != 0  ||  tmr_test(1, 0) != 0  
			||  tmr_test(2, 0) != 0)
		{
			printf("Timer test failed, aborting\n");
			ErrorAbort(0);
		}
	
		printf("Testing Memory\n");
		if (TestSram() != 0 && TestDramQuick() != 0  &&  TestSharedRam() != 0 )
		{
			printf("Memory tests failed, aborting..\n");
			ErrorAbort(1);

		}
	}

	memset((char *)&end, 0, BOOT_AREA_END-(int)&end);
	initmalloc(&end, BOOT_AREA_END-(int)&end);/* init DRAM malloc/free */


	/* Booter code starts at BOOT_AREA_START, the data immediately
		follows it in DRAM, and the DRAM malloc area follows the
		data area, up to BOOT_AREA_END */
	initsmalloc(SRAM, SMALLOC_SIZE);	/* init SRAM malloc/free */

	/*
	* init share ram heap space used by shmalloc
	*/
	memset((char *)SHRAM, 0, eep_mfg_rec.eep_shram_size);
/*	get_shmalloc_fddi(&shram_addr, &shram_size); */
#define	FDDI_SHRAM_AREA_START	ALIGN(0x500f0000,2)
#define	FDDI_SHRAM_AREA_SIZE	ALIGN(0x00007000,2)

	initshmalloc(FDDI_SHRAM_AREA_START, FDDI_SHRAM_AREA_SIZE);


	sys.sys_ledb = 0;
	sys.sys_ledm = 0;
	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_GRN | LED_ACT_OFF);
/*	SetPortDefault(); */
	fault_cnt = 0;
	snc_init = 0; 

	StartKernel(init, init_stk, 3200, 10, 10);

	Blink7SegLed(15);		/* should never get here */
	for(;;)
	{
		ReSchedule();
	}
}
load_application()
{
        register NIM960_HDR *nim960_hdr;
	register NIM960_HDR *header;
        register int error;
	register int size;
	ushort chksum = 0;

	
	/*
	* compressed format for flash checked out
	* uncompress the code into memory
	*/
	nim960_hdr = (NIM960_HDR *) down_load_flash((struct flash_info *)(FEPROM+aplLocation),0);
        if (nim960_hdr == 0)
        {
        printf("Down load failed\n");
        return(0);
        }

	header = (NIM960_HDR *)nim960_hdr;
	(*((int (*)())header->Entry))(0); 
	return;
}

tcb_malloc(size)
word size;
{
	return smalloc(size);
}

stk_malloc(size)
word size;
{
	return smalloc(size);
}

FlickerLeds()
	{
	}

tn_init()
	{
	return 0;
	}
tcp_init()
	{
	return 0;
	}
netio_init()
	{
	return 0;
	}
nmres_init()
	{
	return 0;
	}
SendToSTP(DBD *d)
	{
	snc_put_dbd(d);
	}
icmp_pinged()
	{
	}	

IsSyscardIP()
	{
	return 0;
	}
IsAdminPort()
	{
	return 0;
	}


get_ring_number()
{
	/* if boot record overrides DIP sw */
	if( eep_boot_rec.eep_ring_number != 0xffff )	
		return( eep_boot_rec.eep_ring_number );
	else		/* get ring no. from DIP sw */
		return((sys.sys_switch & DIP_RING_NUM)  >> RING_NUM_SHIFT);
}

SetBPRingZero()
{
	eep_boot_rec.eep_ring_number = 0;	/* force to ring 0 */
}

get_token_ring_speed()
{
	return(eep_boot_rec.eep_ring_rate);			/* hub ring speed */
}

