/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
	
# ------ declare the below symbols public

	.globl	_start
	.globl	_error
	.globl  _abort
	.globl	_fatal
	.globl	_reinit_sysctl		# "reset command"
	.globl  _ram_proc_table
	.globl	_ram_control_table
	.globl	_ram_int_table
	.globl	_ram_prcb

	.globl	_int_stack
        .globl  _sup_stack

	.globl	_start_frame
	.globl	_Nim960Header

  	.set	NIM960_MAGIC,		0x5566	
	.set	NIM960_HDR_SIZE,	336
	.set	PROGRAM_NAME_OFFSET,	48	
	.set	COPYRIGHT_OFFSET,	80	

	.set	SRAM,			0x2ff80000
	.set	LEDBIO,			0x90000040
	.set	LEDMIO,			0x90000060

	.text
        .align  4

/*
 *************	The nim960 header ******************
 *
 *	struct nim960_header
 *		{
 *		unsigned short	signature;	
 *		unsigned short	CheckSum;	
 *		unsigned long	FileLength; 	
 *		unsigned long	time;		
 *		unsigned long	TextLength;	
 *		unsigned long	DataLength;	
 *		unsigned long	BssLength;	
 *		unsigned long	Entry;		
 *		unsigned long	TextLoadAddress;
 *		unsigned long	DataLoadAddress;
 *		unsigned long	ProgramId;
 *		unsigned char	version[8];	
 *		char	name[32];		
 *		char	CopyRightMessage[256];	
 *		};
 */	


/*
 *	The nim960 module header
 *	The application programmer must not touch these 
 *	fields.
 */
_Nim960Header:
	.short	NIM960_MAGIC	/* signature for the header	*/
	.short	0		/* check sum			*/
	.word	0		/* file length			*/
	.word	0		/* time of creation		*/
_tlen:	.word	0		/* length of text		*/
_dlen:	.word	0		/* length of data		*/
_blen:	.word	0		/* length of bss		*/
_eaddr:	.word	_start		/* entry address		*/
_taddr:	.word	0		/* text load address		*/
_daddr:	.word	0		/* Data load address		*/

/*
 *	The application programmer should fill in the following
 *	records.
 */
	.word	836		/* Program ID			*/
	.asciz	"1.10"		/* version, 8 chars max (incl. null) */

	.org	PROGRAM_NAME_OFFSET
	/* 
	 *	program name 
 	 *	should no more than 32 characters 
	 *	(including terminating NULL).
	 */
	.asciz	"836 FDDI-ETHERNET BRIDGE BOOTER" 

	.org	COPYRIGHT_OFFSET
	/* 
	 *	Copy right notice, 
 	 *	should no more than 256 characters 
	 *	(including terminating NULL).
	 */
	.asciz	"Copyright (C) Hughes LAN Systems 1993"
	.org	NIM960_HDR_SIZE	- 1	/* offset starts at 0	*/

/*****	End of nim 960 header		********/





	.align 4

_start:	# --  Processor starts execution here after reset.
	mov	 0, g14		# g14 used by C compiler
#
# --  zero out uninitialized data area
#
	lda 	_end, g0	# find end of .bss
	lda 	_bss_start, g1	# find beginning of .bss
	lda	0, g2		

zero_loop: 	st	g2, (g1)	# to zero out uninitialized
	addo	4, g1, g1	# data area
	cmpoble g1, g0, zero_loop	# loop until _end reached

_reinit_sysctl:

# --  Turn READY led red, and ACTIVE led off.
	lda	LEDBIO, g0
	lda	0x00000004, g1
	stos	g1, (g0)

# --  Turn all PORT led's ON.
	lda	LEDMIO, g0
	lda	0x000000ff, g1
	stos	g1, (g0)

# --
# --  Copy the .data area into RAM.  It has been packed
# --  in the EPROM after the code area, so call a routine to
# --  move it

############# REMOVED FOR DEBUGGING ON ICE - GJS ###################

# --
# --   copy the control table to RAM
# --
	lda	112, g0			# load length of int. table
	lda	_rom_control_table, g1	# load source 
					# copy STEP control table to ram table
	lda	_ram_control_table, g2	# load adderss of new table
	bal	move_data		# branch to move routine

# --
# --  copy the interrupt table to RAM
# --
	lda	1024, g0		# load length of PRCB
	lda	_rom_int_table, g1	# load source
	lda	_ram_int_table, g2	# load destination
	bal	move_data		# branch to move routine
# --
# --  copy the _sys_proc_table table to RAM
# --
	lda	64, g0			# load length of PRCB
	lda	_sys_proc_table, g1	# load source
	lda	_ram_proc_table, g2	# load destination
	bal	move_data		# branch to move routine
# --
# --  copy PRCB to RAM
# --
	lda	64, g0			# load length of PRCB
	lda	_rom_prcb, g1		# load source
	lda	_ram_prcb, g2		# load destination
	bal	move_data		# branch to move routine
# --
# --  fix up the PRCB to point to RAM control table
# --
	lda	_ram_control_table, g12	# load address
	st	g12,4(g2)		# store into PRCB
# --
# --  fix up the PRCB to point to RAM interrupt table
# --
	lda	_ram_int_table, g12	# load address
	st	g12,16(g2)		# store into PRCB
# --
# --  fix up the PRCB to point to RAM sys_proc_table
# --
	lda	_ram_proc_table, g12	# load address
	st	g12,20(g2)		# store into PRCB

# 
# 
# --  It is time to issue the 
# --  REINITIALIZE sysctl, which will start us anew with
# --  our new PRCB.
# --  
#
	ldconst 0x300, r4
	ldconst start_again_ip, r5
	ldconst _ram_prcb, r6
	sysctl	r4, r5, r6
# -------- execution will now resume at start_again_ip ------- #

# --  execution should never fall through here
	b	_error

# --  The processor will begin execution here after being
# --  reinitialized.  We will now set up the stacks and continue.

start_again_ip:
#
# --	Before call to main, we need to take the processor out
# --	of the "interrupted" state.  In order to do this, we will
# --	execute a call statement, then "fix up" the stack frame
# --	to cause an interrupt return to be executed.
#
# --	The CX interrupt return requires an interrupt frame and
# --	a preceding stack frame.  The latter must contain a "valid"
# --	(non-0) pfp.  We'll allocate the latter as a dummy frame,
# --	and point its pfp at itself.
#

	st	sp,(sp)			# dummy pfp -> dummy frame
	mov	sp,fp			# allocate dummy frame
	ldconst	64, g0			# .
	addo	sp, g0, sp		# .
	call	fix_stack		# go in as a normal call, come
					#   out as an interrupt return
	lda	_sup_stack,fp 	# set up sup stack space
	lda	-0x40(fp), pfp		# load pfp (just in case)
	lda	0x40(fp), sp		# set up current stack ptr


	mov	 0, g14			# g14 used by C compiler
					# for arguement lists past
					# 13 arguements.
					# Initialize to 0
#	call	_Di			# disable board interrupts


#
# -- loop added here for debug purpose only.
#

#loop:	b	loop

/*
 * remember the frame, so that we can set it up if necessary
 */
	st	fp, _start_frame
	lda	0x00000000, g0	/* prio = 0 */
	lda	0x001f0000, g1
	modpc	g1, g1, g0


# --  Turn all PORT led's off.
	lda	LEDMIO, g0
	lda	0x00000000, g1
	stos	g1, (g0)

#
# --   call main code from here
#

	callx	 _main

# ------- execution will never return to this point
_fatal:
_abort:
_error:
	flushreg
_error1:
	b	_error1


#
# --- routine to turn off int state
#
fix_stack:
	flushreg
	or	pfp, 7, pfp	# put interrupt return
				# code into pfp
#
# -- 	we have reserved area on the stack before the call to this
# --	routine.  We need to build a phony interrupt record here
# --	to force the processor to pick it up on return.  Also, we
# --	will take advantage of the fact that the processor will
# --	restore the PC and AC to it's registers
# --	old value 0xd81f0002
#

	ldconst	0xd81f0002, g0  # the upper "d8" is required
				#   by the CX microcode for
				#   interrupt return
	st	g0, -16(fp)	# store contrived PC
	ldconst	0x3b001000, g0 	# set up arith. controls 
	st	g0, -12(fp)	# store contrived AC
	ret

#
# --   Below is the software loop to move data
#
move_data:	
	ldconst	0, g4		# initialize offset to 0
moveloop:
	ldob	(g1)[g4*1], g8	# load 4 words into g8
	stob	g8, (g2)[g4*1] 	# store to RAM proc. block
	addi	g4, 1, g4	# increment index	
	cmpibg	g0,g4,moveloop	# loop until done
	bx	(g14)

# --
# --   test ram, and clear it
# --
test_ram:
	ldconst 0x55555555, g2		
	not	g2, g3
	ldconst 0x00000000, g4

testloop:
	st	g2, (g1)
	ld	(g1), g2
	st	g3, (g1)
	ld	(g1), g3
	st	g4, (g1)
	and	g2, g3, g5
	not	g5, g6
	cmpobne.f	0, g6, _error

	addo	4, g1, g1
	subi	4, g0, g0	/* dec length                */
	cmpible.t	0, g0, testloop	/* loop until end reached   */

	bx	(g14)
# -- Stacks
#	The _trap_stack should never get used because we never take
#	the processor out of supervisor mode (and thus never transition
#	into it).  If application code will us out of supervisor mode, 
#	care must be taken to increase the size of the _trap_stack.
#
	.bss	_ram_proc_table, 64, 6
	.bss	_ram_control_table, 112, 6
	.bss	_ram_int_table, 1024, 6
	.bss	_ram_prcb, 64, 6
	.bss	_int_stack,  0x1000, 6	# interrupt stack
	.bss	_sup_stack,  0x2000, 6	# supervisor stack

	.data
	_start_frame:	.word	0x5555 /* addr of first user frame: for gdb960 */
