/**			       
*
*	Program Name:	BOOTER
*
*	Filename:	tdummy.c
*
*	$Log:   /b/gregs/bridge/booter/main/tdummy.c_v  $
 * 
 *    Rev 1.6   06 Jan 1994 15:25:36   gregs
 * Changed the number of FDDI receive buffers to 128 to match the change 
 * in the application and FDDI driver.
 * 
 *    Rev 1.5   26 Oct 1993 10:37:40   gregs
 * Moved MEM_InitPSPPool() call to separate routine (InitPSPMem) and 
 * made init_if() call that instead.
 * 
 *    Rev 1.4   12 Oct 1993 11:09:06   gregs
 * ifdef'd out some unused routines, fixed set_seven_segment_display().
 * 
 *    Rev 1.3   01 Oct 1993 10:35:16   vinay
 * added a dummy function 
 * 
 *    Rev 1.2   03 Sep 1993 16:41:08   vinay
 * 
 *    Rev 1.1   16 Jul 1993 16:58:52   franks
 * 
 *    Rev 1.0   16 Jul 1993 16:24:18   franks
 * Initial revision.
 * 
 *    Rev 1.3   18 Sep 1992 17:05:42   kwok
 * remove RTTBL in tummy.c
 * 
 * 
 *    Rev 1.2   15 Apr 1992 17:29:36   kwok
 * Adding the pvcs keyword $Log$ into the file header.
*
*	Creation Date:	4.29.91
*
*	Date:		4.29.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This file contains some dummy functions for
*			the BOOTER. 
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <uart.h>
#include <eeprecs.h>
#include <dips.h>
#include <tcpip.h>
#include <mpd.h>
#ifdef 0
#include <nvrrecs.h>
#endif
#include <brip.h>
#include "../../i960/bp_ring/scc_defs.h"
#include "../../i960/bp_ring/scc_buff.h"

int	debg;
enter_debug(){}

prc_age() { }
v2_rcv(DBD *d) { snc_put_dbd(d); }
lat_rcv(DBD *d, int dummy) { snc_put_dbd(d); }
IsSlipPort(DBD *p, in_name ip) { return 0; }
IsSlipIP(in_name ip) { return 0; }
icmp_bad_dm() { }	
RipInit() { return 0; }
getch() { return UartGetch(); }
putch(int c) { return UartPutch(c); }
IsMyPortIp() { return 0; }
ifEntryInit() { }
BasicNmiInt_c() { }
log_reset() { }
		
CloseTelnet() { }
AdmConClose() { }
AdmFuncardReset() { }
IsSlipPacket() { return FALSE; }


/* ARE THESE TABLE ALOCATIONS THE RIGHT SIZE??? */
int fddi_port_pstats_tbl[150];
int fddi_if_pstats_tbl[150];
int fddiHost_control_tbl[150];
int fddi_rs_control_tbl[1250];
byte UI2PortMap[100];
int NumberOfPorts;
int MonpMbox[16];
static int init_if_flag = FALSE;
int media_state = FALSE;
byte* port_num2lst;
byte* port_lst2num;

/*
* set if we want to monitor scc traffic
*/
static int sccMonitor = 0;

/* temporary dummies */
int bitRevTab;
int port_tx_flkcnt;
int drv_errs;

/* HOSTENTRY        fddihosts[CON_MAC_COUNT][MAX_HOST_COUNT]; */
int        fddihosts[2*64];
/* FDDI_SMT_STATS  fddi_smt_stats_tbl[CON_MAC_COUNT]; */
int  fddi_smt_stats_tbl[64];
int *PortInitState;
byte  MacIDWaitResponse = 0;  /* dummy var, used by application */

int RcvBcastQhead;
int RcvBcastQtail;

byte frontPanelLed[16];
int *MACHost[64];
#ifdef 0
NVR_BOOT nvr_boot_rec;
#endif
MONP_Diag (){return 0;}
MONP_Init (){return 0;}
MONP_hash (){return 0;}
MONP_PstatsDataPkt () { return 0; }
MONP_PstatsMACPkts (){return 0;}
MONP_MLstats (){return 0;}
MONP_get_free_pstats (){return 0;}
MONP_get_free_monp_msg (){return 0;}
MONP_Process (){return 0;}
MONP_UpdateSMTStats (){return 0;}
first_in_queue (){return 0;}
next_in_queue (){return 0;}
get_rs_entry (){return 0;}
push_queue (){return 0;}
prev_in_queue (){return 0;}
size_of_queue (){return 0;}
is_empty_queue (){return 0;}
de_queue (){return 0;}
insert_queue (){return 0;}
svc_sysUpTime (){return 0;}
sysUpTime_leaf (){return 0;}
detatch_queue (){return 0;}
init_fdrmon(){return 0;}
strobe_wdt(){}
dprintf(){}
ProcessEchoResponse (){return 0;}	/* from mapproc.o */
LED_SetInterfaceLED (){}
send_portdisable_trap(){}


InitPortList ()
{
#ifdef notdef
  int max_ports, i;

  if ((port_num2lst = (byte *)lmalloc(sizeof(byte) * NumberOfPorts)) == NULL) {
    if (get_debug() )
      printf("Error: no memory for num2list table\n");
    return FALSE;
  }
  max_ports = 1 << NumberOfPorts;
  if ((port_lst2num = (byte *)lmalloc(sizeof(byte) * max_ports)) == NULL) {
    if (get_debug() )
      printf("Error: no memory for num2list table\n");
    return FALSE;
  }
  for (i=0; i < max_ports; i++)
    port_lst2num[i] = 0;
  for (i=0; i < NumberOfPorts; i++)  {
    port_num2lst[i] = 1 << i;
    port_lst2num[1 << i] = i;
  }
#endif
  return TRUE;
}

/*
* Returns:	1 = debug mode is on
*		0 = debug mode is off
*/
get_debug()
{
	int	debug;

#ifdef notdef		/* GJS */
	/*
	* if the debug is defined in the boot record
	* it overrides the dip switch
	*/
	if (nvr_boot_rec.nvr_debug != -1)
		debug = nvr_boot_rec.nvr_debug;

	else
#endif
		/*
		* get start up mode code from the debug dip switch
		*/
		debug = ~Dip_read() & DIP_DEBUG_ON;

	return(debug);
}

#ifdef NOT_NEEDED
chnl_free_dbd(int* dbd)
{
  f_free_dbd(dbd);
}
#endif 


word
chnl_init(source)
int source;   /* 0 from booter, 1 from application */
{
  if (media_state)
    return(TRUE);
  media_state = TRUE;
  if (InitPortList() == FALSE)
    return FALSE;
  if (!init_fddi(source))
    return FALSE;
  DoConnect();        /* Activate FDDI */
  return TRUE;
}

#define DBD_BUFFER_SIZE         (4096-32)
#define DBD_COUNT               64
#define DBD_RES_WORD            8


#define FDDI_RX_BUF_CNT     128
#define FDDI_SHRAM_START	0x50030000
InitPSPMem()
{
	int retCode;
	if( (retCode = MEM_InitPSPPool(FDDI_SHRAM_START, FDDI_RX_BUF_CNT)) != 0 )
		printf("MEM_InitPSPPool() returned error\n");
	return(retCode);
}


init_if()
{

	if (init_if_flag)   /* if it has been called */
	  return 1;

	if( InitPSPMem() != 0 )
		return(0);

	if (chnl_init(0))		/* init FDDI */
	{
		init_if_flag = TRUE;
		return(1);
	}
	else {
		printf("Unable to initialize Fddi media interface!\n");
		return 0;
	}
}


long
crit_on()
{
	long value;
	extern word ram_control_table[];

	/*
	* Setup Interrupt control Register ICON
	*/
	value = (ram_control_table[7] & 0x400);

	ram_control_table[7] |= 0x400; /* global interrupt disable */
	send_sysctl(0x401, 0, 0);

	return(value);
}

crit_off(long old_value)
{
	extern word ram_control_table[];
	/*
	* Setup Interrupt Control Register ICON
	*/
	if (old_value == 0)
		{
		ram_control_table[7] &= 0xfbff; /* global interrupt enable */
		send_sysctl(0x401, 0, 0);
		}

	return;
}


/*
* Invoked from tester manu with hidden command "zcc".
* This routine is provided to:
*	1. transmit scc test frames
*	2. monitor scc traffic
*/
TestSCC()
{
	volatile int	c;
	volatile int delay;

	printf("\n\n");
	printf("	-- Testing SCC channel --	\n");
	printf("\n\n");

	while (1)
	{
		while (1)
		{
			printf("(0) Exit\n");
			printf("(1) Transmit SCC frames with confirm\n");
			printf("(2) Transmit SCC frames continuously\n");
			printf("(3) Monitor SCC frames\n");
			printf("==> ");
			while ((c = getch()) == -1)
				ReSchedule();
			printf("\n");
			if ('0' <= c && c <= '3')
				break;
		}

		if (c == '0')
			break;

		if (c == '3')
		{
			printf("hit any key to start, type x to stop\n");
			while ( getch() == -1 )
				ReSchedule();
			printf("\n");
			sccMonitor = 1;
			for (;;)
			{
				ReSchedule();
				if (getch() == 'x')
				{
					sccMonitor = 0;
					return;
				}
			}
		}

		if (c == '2')
		{
			printf("hit any key to start, type x to stop\n");
			while ( getch() == -1 )
				ReSchedule();
			printf("\n");
		}
	
		while(1)
		{
			/* delay */
			for (delay=0; delay<0x8; delay++)
				ReSchedule();

			/* send test frame */
			SendTestFrame();
			if (c == '2')
			{
				if ( getch() == 'x')
					break;
				continue;
			}
			while (1)
			{
				printf(" => (y/n)? ");
				while ((c = getch()) == -1)
					ReSchedule();
				printf("\n");
				if (c == 'n' || c == 'y')
					break;
			}
			if (c == 'n')
				break;
		}
	}
	return;
}

/*
* Send a test SCC frame
*/
SendTestFrame(d_slot, d_line, type)
{
	SCC_BD		*tx_bd;
	BRIP_FRAME	*frame;
	int		port;
	byte		myBridgeLineMask  = 0;
	int		bline;
	static word	count = 0;

	if ( !(frame = (BRIP_FRAME *)get_scc_tx_buff(sizeof(BRIP_FRAME))) )
	{
		printf("No more scc_tx_buff\n");
		return 1;
	}
		
	if ( !(tx_bd = get_scc_bd(BD_XMT)) )
	{
		printf("No more scc_bd\n");
		return 1;
	}

	tx_bd->length = sizeof(BRIP_FRAME);
	tx_bd->buff_ptr = (byte *)frame;
	tx_bd->bd_type = BD_XMT;

	frame->dst_slot = 0xaa;
	frame->crtl = 0;
	frame->src_slot = GetSlotID();

	frame->frame_type_hi = 0xaa;
	frame->frame_type_lo = 0xaa;

	frame->version_major = 0xbb;
	frame->version_minor = 0xbb;

	frame->dst_line = 0xcc;
	frame->src_line = 0xcc;

	frame->hub_ring = 0xdd;

	printf(".");
	scc_send(tx_bd);
	return 0;
}

/*
* Called from brip receive task.
* Intercept and print every frame we receive and transmit
* if sccMonitor is set
*/
PrintSccFrame(frame)
KA_FRAME	*frame;
{
	char	*frmTypeFiltMsg[5] = {"REQ", "RSP", "RMV", "INS", "KA"};

	if (sccMonitor)
	{
		int	type;

		if (frame->frame_type_hi == BRIP_FRAME_TYPE)
			type = frame->frame_type_lo - 10 - 1;

		if (frame->src_slot == GetSlotID())
			printf("* ");		/* my frame */

		printf("(%d,%d) (%d,%d) (%d,%d) (%d,",
			frame->src_slot, frame->src_line,
			frame->dst_slot, frame->dst_line,
			frame->dsn_line, frame->usn_line,
			frame->hub_ring);

		if (0 <= type && type <= 4)
		{
			printf("%s)\n", frmTypeFiltMsg[type]);
		}
		else	/* unknown type, print value */
		{
			printf("%d)\n", type);
		}
	}
}


/*
* routines to support bp_ring, dummies for now
byte get_xmt_line(void) { return GetSlotID(); }
*/
#if 0
get_device_type() {return 0;}
get_media_type() {return 0;}
get_media_speed() {return 0;}
#endif

set_seven_segment_display(char ring_num) 
{
	HW_SLed(ring_num);
}

void switch_rcv_line(short x, byte y) {}
CheckIsKeepAlive() {return 0;}
TurnOnAllLed (){return 0;}
TurnOffAllLed (){return 0;}
tcp_transmit_complete(){}
DebugStrBreak(){}
DebugStr(){}
inc_reset_type() {

}
