#############################################################################
#	Program Name:	BOOTER for cheetah
#
#	Filename:	Makefile
#
#	Creation Date:	7.16.93
#
#	Date:		7.16.93
#
#	Version:	1.0
#
#	Programmers:	Frank Salzmann and Vinay Gundi
#
#	Modifications:
#
#	Comments:	The makefile for the booter
#			This makefile will call all other makefiles 
#			to produce the booter image.  The directory
#			structures are:=
#
#			Makefile	This file
#				
#			main.c		The main function
#			booter/
#				system/	It contains the startup module,
#					fault table, interrupt table and
#					prob ...etc.
#
#	Copyright (c) 1993 by Hughes LAN Systems
#
#############################################################################
# Defaults to GNU/960 tool set:
#

.LOGFILE .c_v(.c)
.LOGFILE .s_v(.s)
.LOGFILE .h_v(.h)

CC	= gcc960			# gnu960 cross C compiler 
ARCH	= -ACA				# This is CA architecture
OPT	= -O3 -c -DSTANLEY  			# O3 - optimization level 3
					# c  - compile only
VERSION	=
VER	=
CFLAGS	= ${ARCH} -I${IDIR1} -I${IDIR2} ${OPT} -mstrict-align 
					#
					# I - 	specify the search path for
					# 	any include files
					# mstrict-align
					#	Sequences of smaller memory
					#	reference are used instead
					#	of larger ones which might
					#	not be correctly aligned.
AS	= gas960			# gnu960 assembler
ASFLAGS	= ${ARCH}
LD	= gld960  			# gnu960 linker
TOOLSET = ${GFLAG}

# Essential under System V, harmless elsewhere
SHELL = /bin/sh

# Standard rules
#
.c_v.c:
	=get $(GETOPTS) $<\($@\)

.h_v.h:
	=get $(GETOPTS) $<\($@\)

.s_v.s:
	=get $(GETOPTS) $<\($@\)

.c.o:
	${CC} ${CFLAGS} $*.c

.s.o:
	${AS} ${ASFLAGS} -o $*.o $*.s


#------------------------------------------------------------------------------
# Where to find things (include files, ROM images)
#------------------------------------------------------------------------------
#ROOT	= /h/pvcs
ROOT	= junk				# so it can't clobber my changes
PIDIR1	= ${ROOT}/bridge/include	# where the .h_v files are
PIDIR2	= ${ROOT}/i960/include
PSDIR	= ${ROOT}/bridge/booter		# where the .c_v and .s_v files are

IDIR1	= ../include
IDIR2	= ../../i960/include
.PATH.h_v = ${PIDIR1} ;${PIDIR2} 
.PATH.h   = ${IDIR1} ;${IDIR2} 
.PATH.c_v = ${PSDIR}
.PATH.s_v = ${PSDIR}


ODIR	= ../lib
TCPLIB	= ../../i960/lib
FDDI	= ../../fddi/fddicon/lib
#------------------------------------------------------------------------------
# TARG OBJECT FILES
#------------------------------------------------------------------------------
BOOTER_OBJS= main/bootmain \
	tftpboot/tftpboot.o \
	tester/tester.o config/config.o \
	${TCPLIB}/krnl.o \
	${TCPLIB}/uart.o ${TCPLIB}/slip.o system/system  \
	${ODIR}/util.o  ${ODIR}/tr_util.o  ${TCPLIB}/util.o \
	/b/gregs/bridge/sonic/sonic ${ODIR}/snciramvar.o \
	${ODIR}/sncsramvar.o \
	${FDDI}/smtcsp.o ${FDDI}/smtfbm.o ${FDDI}/smtmsp.o \
	${FDDI}/smtcspif.o ${FDDI}/smtfbmif.o ${FDDI}/smtmspif.o \
	/b/gregs/i960/lib/bp_ring.o 
#	program_flash.o compapi.o flash.o\
#	${TCPLIB}/sonic.o ${ODIR}/snciramvar.o ${ODIR}/sncsramvar.o \

TARG_IBR = system/imi.o

# Address at which 960CX Initial Boot Record must be linked
IBR_ADDR = 0xffffff00
BOOTER_ADDR = 0x30200000
#BOOTER_DATA = 0x2ffe0000

booter: Makefile dummy 
	
	${LD} ${ARCH} -o booter  -Ttext ${BOOTER_ADDR} \
		-e _start -defsym _load_addr=${BOOTER_ADDR} \
		${BOOTER_OBJS} \
		../cam.o \
		/b/gregs/fddi/fddicon/drv/inram/inramvar.o \
		/b/gregs/fddi/fddicon/drv/inram/sramvar.o \
		/b/gregs/fddi/i960/util/config.o \
		/b/gregs/fddi/fddicon/tester/edfddinvr.o \
		/b/gregs/fddi/boot/tester/boothelp.o \
		/b/gregs/fddi/i960/libutil/menuparse.o \
		${ODIR}/libtest.a \
		${FDDI}/libtester.a \
		${FDDI}/libfddidrv.a \
		${FDDI}/libfddiutil.a \
		${FDDI}/libfddimap.a \
		${FDDI}/libfddiutil.a \
		${TCPLIB}/libtcpip.a ${TCPLIB}/libutil.a \
		${TCPLIB}/libc.a \
		${FDDI}/libfddicoll.a

	gnm960 -n -o booter  > map
	makenim booter 
	boutnim booter /tftpboot/booter.nim
#	${LD} ${ARCH} -o ibr -T ${IBR_ADDR} -R vinboot \
#		-defsym _cs6=-_rom_prcb-_start ${TARG_IBR} 
#	grom960 -l0x40000 -m -i -ovinboot.bin vinboot ibr,0x3ff00
#	boutcoff -l vinboot
#	awk -f map.awk b.map > smap
#	sort -b +1 -2 smap -o smap

new:	
	make mkdir 
	make getcfg 
	make getmf 
	cd ../../i960; make sbnew
	make booter

source:
	make mkdir 
	make getcfg 
	make getmf
	make getsrc
	cd ../../i960; make VER=${VERSION} sbsource

dummy:
	cd main; make
	cd ../../i960; make stbooter
	cd ../tester; make
	cd ../ramvar; make booter
	cd ../util; make
	cd ../tr_util; make
	cd system; make
	cd tftpboot; make
	cd tester; make
	cd config; make
mkdir:
	mkdir system tftpboot tester config
	cd ..; mkdir util tester ramvar lib include
	cd ../..; mkdir i960

getcfg:
	cp ${PSDIR}/system/pvcs.cfg system/pvcs.cfg
	cp ${PSDIR}/tftpboot/pvcs.cfg tftpboot/pvcs.cfg
	cp ${PSDIR}/tester/pvcs.cfg tester/pvcs.cfg
	cp ${PSDIR}/config/pvcs.cfg config/pvcs.cfg
	cp ${PSDIR}/../util/pvcs.cfg ../util/pvcs.cfg
	cp ${PSDIR}/../tester/pvcs.cfg ../tester/pvcs.cfg
	cp ${PSDIR}/../ramvar/pvcs.cfg ../ramvar/pvcs.cfg
	cp ${PSDIR}/../../i960/pvcs.cfg ../../i960/pvcs.cfg

getmf:
	cd system; get -cpvcs.cfg Makefile
	cd tftpboot; get -cpvcs.cfg Makefile
	cd tester; get -cpvcs.cfg Makefile
	cd config; get -cpvcs.cfg Makefile
	cd ../util; get -cpvcs.cfg Makefile
	cd ../tester; get -cpvcs.cfg Makefile
	cd ../ramvar; get -cpvcs.cfg Makefile
	cd ../../i960; get -cpvcs.cfg Makefile

getsrc:
	get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/local.lst
	cd system; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/system/local.lst
	cd tftpboot; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/tftpboot/local.lst
	cd tester; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/tester/local.lst
	cd config; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/config/local.lst
	cd ../util; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/../util/local.lst
	cd ../tester; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/../tester/local.lst
	cd ../ramvar; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/../ramvar/local.lst

#main/startup.o:	Makefile

#main/tdummy.o:	Makefile ${IDIR2}/types.h ${IDIR2}/dbd.h \
#		${IDIR2}/uart.h ${IDIR1}/eeprecs.h ${IDIR2}/eeprom.h \
#		${IDIR1}/dips.h ${IDIR2}/tcpip.h ${IDIR2}/lme.h

#main/main.o:		Makefile ${IDIR2}/krnl.h ${IDIR1}/target.h  \
#		${IDIR1}/memory.h ${IDIR2}/types.h \
#		${IDIR2}/eeprom.h ${IDIR2}/nim960h.h ${IDIR2}/uart.h \
#		${IDIR1}/dips.h ${IDIR1}/led.h ${IDIR1}/sys.h \
#		${IDIR1}/eeprecs.h ${IDIR2}/sncvar.h ${IDIR2}/malloc.h \
#		${IDIR2}/dbd.h ${IDIR1}/sys.h ${IDIR2}/sonic.h

#main/init.o:		Makefile ${IDIR2}/krnl.h ${IDIR1}/target.h  \
#		${IDIR1}/memory.h ${IDIR2}/types.h \
#		${IDIR2}/eeprom.h ${IDIR2}/nim960h.h ${IDIR2}/uart.h \
#		${IDIR1}/dips.h ${IDIR1}/led.h ${IDIR1}/sys.h \
#		${IDIR1}/eeprecs.h ${IDIR2}/sncvar.h ${IDIR2}/malloc.h \
#		${IDIR2}/netbuf.h ${IDIR2}/dbd.h ${IDIR2}/ether.h \
#		${IDIR2}/sonic.h
#main/program_flash.o:	Makefile ${IDIR2}/types.h flash.h \
#		${IDIR1}/eeprecs.h ${IDIR1}/nvrecs.h ${IDIR2}/nim960h.h
#
##config.o:		Makefile ${IDIR2}/types.h \
#	#	${IDIR2}/eeprom.h ${IDIR2}/nim960h.h ${IDIR2}/uart.h \
#	#	${IDIR2}/nvram.h ${IDIR2}/time.h ${IDIR1}/sys.h \
#	#	${IDIR1}/eeprecs.h ${IDIR2}/sncvar.h ${IDIR2}/tcpip.h \
#	#	${IDIR1}/nvrecs.h
#
#main/compapi.o: Makefile ${IDIR2}/types.h ${IDIR2}/flash.h
#

#main/debugasm.o:	Makefile
#main/flash.o:		Makefile
