/**			       
*
*	Program Name:	STANLEY TESTER
*
*	Filename:	diagnos.c
*
*	Creation Date:	6.12.91
*
*	$Log:   /b/gregs/bridge/booter/tester/ptbl.c_v  $
 * 
 *    Rev 1.5   13 Jan 1994 10:25:36   franks
 * Changed to memory size comments to reflect the current memory sizes for the FDDI 
 * bridge.
 * 
 *    Rev 1.4   20 Oct 1993 08:18:02   gregs
 * Added Fddi port ('q') cmd (fddi loopback test).
 * 
 *    Rev 1.3   13 Oct 1993 13:33:00   gregs
 * 2 tests named 'c', so I made the BMAC test 'b'.
 * 
 *    Rev 1.2   12 Oct 1993 10:12:44   vinay
 * changed Default_eep_mfg to hide
 * 
 *    Rev 1.1   31 Aug 1993 11:33:20   vinay
 * added some routines to the menu
 * 
 *    Rev 1.0   16 Jul 1993 16:25:42   franks
 * Initial revision.
 * 
 *    Rev 1.2   15 Apr 1992 17:31:38   kwok
 * Adding the pvcs keyword $Log$ in the file header
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the TESTER module.  It allows an user
*			to invoke tests on the hardware.
*			This is based on the nim386 tester program.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <memory.h>
#include <eeprecs.h>
#include <nim960h.h>
#include <sys.h>
#include <cmd.h>

/* external routines to do testing */
extern	int	TestAdminBus();
extern	int	Test7SegDisp();
extern	int	TestBridge();
extern	int	TestConfig();
extern	int	TestDips();
extern	int	TestDram();
extern	int	TestEepEdit();
extern	int	TestEeprom();
extern	int	TestFlash();
extern	int	TestHSB();
extern	int	TestLeds();
extern	int	TestMfg();
extern	int	TestNVedit();
extern	int	TestNvram();
extern	int	reset();
extern	int	TestRefresh();
extern	int	TestSram();
extern	int	TestSharedRam();
extern	int	TestPort();
extern	int	TestFddiLoop();
extern	int	TestStatus();
extern	int	TestTimer();
extern	int	TestUart();
extern	int	TestBoot();
#ifdef notsupported 
extern	int	TestPort4();
#endif
extern	int	fddi_test_bmac();
extern	int	fddi_test_bsi();
extern	int	TestSMT();
extern	int	fddi_test_phys();
extern	int	initialize_configuration();
extern	int	TestSCC();
extern	int boot_fddi_display();
extern	int boot_fddi_edit();
extern	int Default_eep_mfg();

/* control flags */
static int test_cnt = 0;	/* counts tests specified */
static int qtst_cnt = 0;	/* counts quasi tests specified */
static int info_cnt = 0;	/* counts info stuff specified */
static int repeat_flg = 0;	/* repeat mode flag */
static int report_flg = 0;	/* give report flag */
static int abort_flg  = 0;	/* abort activity flag */
static int break_flg  = 0;	/* break on error flag */
static int test_pass = 0;	/* test sequence number */
static int exit_flg = 0;	/* exit the tester	*/

static char str[LINEMAX];

PT ptbl[] = 
	{
	{ 'a', TEST, TestAdminBus,    -1, 0, 0, 0, 0, 0, "Admin bus"},
	{ 'c', TEST, Test7SegDisp,    -1, 0, 0, 0, 0, 0, "7 Segment Display"},
	{ 'd', TEST, TestDram,	 -1, 0, 0, 0, 0, 0, "Dynamic RAM"},
	{ 'e', TEST, TestEeprom, -1, 0, 0, 0, 0, 0, "EEPROM"},
	{ 'f', TEST, TestFlash,	 -1, 0, 0, 0, 0, 0, "Flash EPROM"},
/*	{ 'h', TEST, TestHSB, 	 -1, 0, 0, 0, 0, 0, "High speed bus"},*/
	{ 'L', QTST, TestLeds,   -1, 0, 0, 0, 0, 0, "LEDs sequence"},
	{ 'D', QTST, TestDips,	 -1, 0, 0, 0, 0, 0, "DIP switches"},
	{ 'n', TEST, TestNvram,  -1, 0, 0, 0, 0, 0, "Non-Volatile RAM"},
	{ 'r', TEST, TestRefresh,  -1, 0, 0, 0, 0, 0, "Refresh circuitry"},
	{ 's', TEST, TestSram,  -1, 0, 0, 0, 0, 0, "Static RAM"},
	{ 't', TEST, TestTimer,  -1, 0, 0, 0, 0, 0, "TIMER"}, 
	{ 'u', TEST, TestUart,   -1, 0, 0, 0, 0, 0, "UART"},
	{ 'x', TEST, TestSharedRam, -1, 0, 0, 0, 0, 0, "Shared RAM"},
	{ 'p', TEST, TestPort,    -1, 0, 0, 0, 0, 0, "SONIC PORT(s)"},
	{ 'q', TEST, TestFddiLoop,    -1, 0, 0, 0, 0, 0, "FDDI PORT"},
/* FDDI ********************************************************/
	{ 'i', HIDE, TestSMT,	 -1, 0, 0, 0, 0, 0, "Test FDDI SMT"},
	{ 'g', HIDE, fddi_test_bsi, -1,0,0,0,0,0,   "fddi bsi test"},
	{ 'b', HIDE, fddi_test_bmac, -1, 0, 0, 0, 0, 0, "fddi mac test"},
	{ 'k', HIDE, fddi_test_phys, -1,0,0,0,0,0,   "fddi phy test"},
	{ 'm', HIDE, initialize_configuration,  0, 0, 0, 0, 0, 0, "Manufacturing program"},
	{ 'z', HIDE, TestSCC,  0, 0, 0, 0, 0, 0, "SCC testing program"},
	{ 'M', HIDE, boot_fddi_display,	0,0,0,0,0,0, "fddi rec display"},
	{ 'F', INFO, boot_fddi_edit,	0,0,0,0,0,0, "fddi rec edit"},
	{ 'Y', HIDE, Default_eep_mfg,	0,0,0,0,0,0, "default eep_mfg"},
/* FDDI ********************************************************/
	{ 'C', INFO, TestConfig,   -1, 0, 0, 0, 0, 0, "Configuration status"},
	{ 'E', INFO, TestEepEdit,  0, 0, 0, 0, 0, 0, "Edit EEPROM"}, 
	{ 'R', INFO, reset,   -1, 0, 0, 0, 0, 0, "Reboot"},
/*	{ 'm', HIDE, TestMfg,  0, 0, 0, 0, 0, 0, "Manufacturing program"}, */
/*  	{ 'N', INFO, TestNVedit, -1, 0, 0, 0, 0, 0, "Edit non-volatile RAM"},*/
	{ 'S', INFO, TestStatus, -1, 0, 0, 0, 0, 0, "Status of Tests"},
	{ 'B', INFO, TestBoot, -1, 0, 0, 0, 0, 0, "Boot the Application"},
/*	{ 'P', INFO, TestPort4, -1, 0, 0, 0, 0, 0, "Change Port 4 configuration"},*/
	{ 0 }
	};

extern NIM960_HDR Nim960Header;		/* My nim960 header	*/

PrintHdr()
{
	int i, offset;

	printf("\r\n\n");
	offset = (80 - (strlen(Nim960Header.name) + 9 + 5))/2;
	for (i = 0; i != offset; i++)
		printf(" ");
	printf(Nim960Header.name);
	printf(" Version ");
	printf(Nim960Header.version);
	printf("\r\n");
	offset = (80 - strlen(Nim960Header.CopyRightMessage))/2;
	for (i = 0; i != offset; i++)
		printf(" ");
	printf(Nim960Header.CopyRightMessage);
	printf("\n");
}


EEP_MFG ManuRec;
EEP_BOOT BooterRec;

TestMfg()
{
	int error_code;
	EEP_MFG *MRec = &eep_mfg_rec;
	EEP_BOOT *BRec = &eep_boot_rec;
	EEP_MFG *MfgRec = &ManuRec;
	EEP_BOOT *BootRec = &BooterRec;

	if((error_code = GetEeprom(EEP_MFG_ADDR, MRec, EEP_MFG_SIZE)) != EEPROM_AOK)
	{
		MfgErrSetDefault(error_code);
		PutMfgRec(MRec);
	}

	if (GetBootRec(BRec))
		PutBootRec(BRec);

	memcpy(MfgRec, MRec, sizeof(EEP_MFG));
	memcpy(BootRec, BRec, sizeof(EEP_BOOT));

	printf("\r\n");
	PrintManuRecord((EEP_MFG *)MfgRec);
	printf("\r\n");
	printf("Port 4 Configuration : %s\n", "FDDI");
	printf("\r\n");

	if (AskYesNo("Do you want to modify the records ([y]/n) ? "))
	{
		printf("\r\n");
		MfgRec->eep_srlno = AskUnsigned("Enter S/N",
					MfgRec->eep_srlno);
		MfgRec->eep_level = AskLevel("Enter Rev Level",
					MfgRec->eep_level);
		MfgRec->eep_mfgdt = AskDate("Enter Mfg date",
					MfgRec->eep_mfgdt);
		MfgRec->eep_altdt = AskDate("Enter FCO date",
					MfgRec->eep_altdt);
#ifdef notsupported
		BootRec->eep_ThinNet = AskPort4Config("Port 4 Configuration (a(AUI)/t(TRANSCEIVER))", BootRec->eep_ThinNet ? 't' : 'a');

#endif
		printf("\r\n");
		if (!(AskYesNo("Do you want to keep default memory sizes ([y]/n) ? ")))
			ChangeMemorySize(MfgRec);
		printf("\r\n");
		PrintManuRecord((EEP_MFG *)MfgRec);
		printf("\r\n");
		printf("Port 4 Configuration : %s\n", BootRec->eep_ThinNet ? "TRANSCEIVER" : "AUI");
		printf("\r\n");

		if (AskYesNo("Do you want to update the records ([y]/n) ? "))
		{
			memcpy(MRec, MfgRec, sizeof(EEP_MFG));
			memcpy(BRec, BootRec, sizeof(EEP_BOOT));
			PutMfgRec(MfgRec);
			PutBootRec(BootRec);
#ifdef notsupported
			Port4Config(BootRec->eep_ThinNet);
#endif
		}
	}

}


ChangeMemorySize(MfgRec)
EEP_MFG *MfgRec;
{
	printf("\r\n");
	MfgRec->eep_sram_size = AskUnsigned("Size of SRAM in Kbytes (Default : 512)",
					MfgRec->eep_sram_size / 1024) * 1024;

	MfgRec->eep_dram_size = AskUnsigned("Size of DRAM in Kbytes (Default : 4096)",
					MfgRec->eep_dram_size / 1024) * 1024;

	MfgRec->eep_shram_size = AskUnsigned("Size of SHRAM in Kbytes (Default : 1024)",
					MfgRec->eep_shram_size / 1024) * 1024;
	MfgRec->eep_nvram_size = AskUnsigned("Size of NVRAM in Kbytes (Default : 128)",
					MfgRec->eep_nvram_size / 1024) * 1024;
	MfgRec->eep_eeprom_size = AskUnsigned("Size of EEPROM in Kbytes (Default : 8)",
					MfgRec->eep_eeprom_size / 1024) * 1024;
	MfgRec->eep_fprom_size = AskUnsigned("Size of FEPROM in Kbytes (Default : 768)",
						MfgRec->eep_fprom_size / 1024) * 1024;
}

#ifdef notsupported
TestPort4()
{
	int error_code;
	EEP_BOOT *BootRec = &eep_boot_rec;

	if (GetBootRec(BootRec))
		PutBootRec(BootRec);

	printf("\r\n");
	BootRec->eep_ThinNet = AskPort4Config("Port 4 Configuration (a(AUI)/t(TRANSCEIVER)) ", BootRec->eep_ThinNet ? 't' : 'a');

	PutBootRec(BootRec);

	Port4Config(BootRec->eep_ThinNet);
}
#endif

PutMfgRec(MfgRec)
EEP_MFG *MfgRec;
{
	int error_code;

	if ((error_code = PutEeprom(EEP_MFG_ADDR, MfgRec, EEP_MFG_SIZE)) != EEPROM_AOK)
		printf("EEPROM Error %d: Cannot update the Manufacturing record\n", error_code);
	return (error_code);
}

GetBootRec(BootRec)
EEP_BOOT *BootRec;
{
	int error_code;

	if ((error_code = GetEeprom(EEP_BOOT_ADDR, BootRec, EEP_BOOT_SIZE)) != EEPROM_AOK)
	{
		printf("EEPROM Error %d: Cannot read the BOOT record\n", error_code);
		memset(BootRec, 0, sizeof(EEP_BOOT));
		strcpy(BootRec->eep_request_file, "h836");
		/*
		 *	Always try to load from FLASH
		 */
		eep_boot_rec.eep_ThinNet = LOAD_FROM_FLASH;
	}
	return (error_code);
}

PutBootRec(BootRec)
EEP_BOOT *BootRec;
{
	int error_code;

	if ((error_code = PutEeprom(EEP_BOOT_ADDR, BootRec, EEP_BOOT_SIZE)) != EEPROM_AOK)
		printf("EEPROM Error %d: Cannot update the BOOT record\n", error_code);
	return (error_code);
}


