/**
*	Program Name:	BOOTER
*
*	Filename:	testeeprom.c
*
*	$Log:   /b/gregs/bridge/booter/tester/testeeprom.c_v  $
 * 
 *    Rev 1.0   16 Jul 1993 16:25:44   franks
 * Initial revision.
 * 
 *    Rev 1.1   15 Apr 1992 17:30:22   kwok
 * If the MFG and BOOT records are valid, save them before the test and re
 * restore them after the test.
*
*	Comments:
*
*	Copyright (c) 1992 by Huges LAN Systems.
**/
#include <types.h>
#include <memory.h>
#include <eeprecs.h>

unsigned char *TestEepromPage(unsigned char *PageAddress);
unsigned char *TestEepromLock(unsigned char *LastPage);

/*
 *	Test the Eeprom
 */
int TestEeprom()

	{
	unsigned char	*ErrorAddress;
	unsigned char	*PageAddress;	/*	of eeprom 	*/
	int	Pages;		/* this many pages of eeprom	*/
	int	TimeTicks;
	int	size;
	int	EepromMfgOk = 0;	/* is eeprom record ok	*/
	int	EepromBootOk = 0;		/* is eeprom record ok	*/
	int	code;
	/*
	 *	Manufacturer record
	 */
	EEP_MFG	*MfgPtr = &eep_mfg_rec; 

	size = MfgPtr->eep_eeprom_size;
	printf("\n(This test takes approximately 30 seconds)\n");
	Pages = MfgPtr->eep_eeprom_size / EEP_PAGE_SIZE;
	PageAddress = (unsigned char *)EEPROM;
	/*
	 *	Save the manufacturer record if it is valid.
	 */
	if (GetEeprom(EEP_MFG_ADDR, &eep_mfg_rec, EEP_MFG_SIZE) == EEPROM_AOK)
		{
		EepromMfgOk = 1;
		}
	if (GetEeprom(EEP_BOOT_ADDR, &eep_boot_rec, EEP_BOOT_SIZE) == EEPROM_AOK)
		EepromBootOk = 1;
	TimeTicks = RealTimeTicks();
	while (Pages--)
		{
		if ((ErrorAddress = TestEepromPage(PageAddress)) != NULL)
			{
			printf("EEPROM error: address %X\n", ErrorAddress);
			InitEeprom(EEPROM, size);
			return 1;
			}
		if (RealTimeTicks() - TimeTicks > 100)
			{
			/*
			 *	Print a '.' every second to signal that
			 *	we are still alive.
			 */
			putchar('.');
			ReSchedule();
			TimeTicks = RealTimeTicks();
			}
		/*
		 *	Wait 10 ms before we write to the eeprom 
		 *	again.
		 */
		delay(2);	
		PageAddress += EEP_PAGE_SIZE;
		}
	/*
	 *	Restore the manufacuturer record and the boot record.
	 */
	if (EepromMfgOk || EepromBootOk)
		{
		code = PutEeprom(EEP_HDR_ADDR, &Eeprom_header, EEP_HDR_SIZE);
		if (code != EEPROM_AOK)
			printf("EEPROM error %d: Cannot restore header\n", code);
		if (EepromMfgOk)
			PutMfgRec(&eep_mfg_rec);
		if (EepromBootOk)
			PutBootRec(&eep_boot_rec);
		}
	delay(100);	/* wait for a second	*/
	if ((ErrorAddress = TestEepromLock((unsigned char *)EEPROM + 
				size - EEP_PAGE_SIZE)) != NULL)
		{
		printf("\nEEPROM error: Protection circuitry failed\n");
		printf("ErrorAddress = %X\n", ErrorAddress);
		InitEeprom(EEPROM, size);
		return 1;
		}
	InitEeprom(EEPROM, size);
	return 0;
	}

unsigned char *TestEepromPage(unsigned char *PageAddress)

	{
	volatile char *address = (volatile char *)PageAddress;
	unsigned  char	pattern = 0x5a;
	int	RecordSize;	/* in number of words	*/
	int	i;

	for (i = 0; i < 2; i++)
		{
		if (i == 1)
			{
			/*
			 *	pattern is different for the 2nd pass
			 */
			pattern = 0xa5;			
			}
		RecordSize = EEP_PAGE_SIZE;
		/*
		 *	Write to the page
		 */
		EnableEeProm();
		Di();
		while(RecordSize--)
			*address++ = (char)pattern;
		Ei();
		DisableEeProm();
		delay(2);	/* wait a bit	*/
		RecordSize = EEP_PAGE_SIZE;
		/*
		 *	restore the address
		 */
		address = (volatile char *)PageAddress;
		while(RecordSize--)
			{
			if (*address++ != pattern)
				return (unsigned char *)address - 1;
			}
		address = (volatile char *)PageAddress;
		}
	return NULL;
	}

unsigned char *TestEepromLock(unsigned char *LastPage)

	{
	unsigned char	data[EEP_PAGE_SIZE];
	int	RecordSize;
	int	i;

	/*
	 *	Save the original data
	 */
	memcpy(data, LastPage, EEP_PAGE_SIZE);
	/*
	 *	Write to the eeprom without releasing the lock.
	 */
	DisableEeProm();	/* make sure it is disabled	*/
	Di();
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		LastPage[RecordSize] = ~data[RecordSize];
		}
	Ei();
	delay(2);
	/*
	 *	Since we have not release the lock, the data should 
	 *	not be changed at all.
	 */
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		if (LastPage[RecordSize] != data[RecordSize])
			{
			/*
			 *	If the record has been changed,
			 *	then we restore the data.
			 */
			Di();
			EnableEeProm();
			for (i = 0; i < EEP_PAGE_SIZE; i++)
				LastPage[i] = data[i];
			DisableEeProm();
			Ei();
			return LastPage + RecordSize;
			}
		}
	return NULL;
	}
