/*
 *	bootp main for testing bootp cleint
 */

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <tcpip.h>
#include <error.h>
#include "../tcpip/bootp/bootp.h"


#define	BP_MAX_IP	4	/*	We accept this many ip addresses
				 *	in bootp reply in each ip address
				 *	categories.
				 *	i.e.	router addresses, 
				 *		domain name server addreess
				 *		...etc
				 */
struct	bootpinfo
	{
	in_name	yiaddr;		/*	my ip address returned from
				 *	bootp server
				 */
	in_name	siaddr;		/*	bootp server ip adderss	*/
	in_name	NetMask;	/*	subnet mask field	*/
	in_name	Router[BP_MAX_IP];	/*	routers ip addresses	*/
	in_name	DomainNameServer[BP_MAX_IP];
	in_name	TimeServer[BP_MAX_IP];	/*	time server ip 		*/
	char	file[BP_FILENAME_LENGTH];	/*	boot file name	*/
	long	TimeOffset;	/*	time offset of the local subnet
				 *	in seconds from UTC.
				 */
	char	MyHostName[BP_MYNAME_LENGTH];
	};

extern struct	bootpinfo	bootpinfo;

Bootpmain()

	{
	in_name	my_ip = 0;
	in_name	server_ip = 0;
	char	filename[128];
	byte	*p;

     
	filename[0] = '\0';
	if (udpboot(my_ip, server_ip, filename) == 0)
		{
		printf("Bootp failed\n");
		return;
		}
	printf("Boot OK\n");
	p = (byte*)&bootpinfo.yiaddr;
	printf("my ip = %d.%d.%d.%d", *p, *(p + 1), *(p + 2), *(p + 3));
	p = (byte *)&bootpinfo.siaddr;
	printf("\tserver ip = %d.%d.%d.%d\n", *p, *(p + 1), *(p + 2), *(p + 3));
	printf("filename = %s\n", bootpinfo.file);
	p = (byte*)&bootpinfo.NetMask;
	printf("netmask = %d.%d.%d.%d\n", *p, *(p + 1), *(p + 2), *(p + 3));
	PrintServers("Router ip ", bootpinfo.Router);
	PrintServers("Domain Name ", bootpinfo.DomainNameServer);
	PrintServers("TimeServer ", bootpinfo.TimeServer);
	printf("Time offset = %ld\n", bootpinfo.TimeOffset);
	printf(bootpinfo.MyHostName);
	return NULL;
	}

PrintServers(char *message, in_name *ip)

	{
	byte	*p;
	int	i = 4;

	printf(message);
	while(i--)
		{
		p = (byte *)ip;
		if (*ip++ != 0)
			printf("=>%d.%d.%d.%d<= ", p[0], p[1], p[2], p[3]);
		else
			break;
		}
	}
	

