/**			       
*
*	Program Name:	nim960 bridge boot code
*
*	Filename:	tftpinit.c
*
*	Creation Date:	2.15.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	It contains functions to initialize tftp.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
#include <krnl.h>
#include <target.h>
#include <types.h>
#include <dips.h>
#include <sncvar.h>
/*#include <task.h>*/
#include <netbuf.h>
#include <tcpip.h>
#include <eeprecs.h>
#include <led.h>
#include <sys.h>
#include <nvrecs.h>

/*
 *	For the booter, buffer size of 600 and 10 dbds are more
 *	than enough
 */
#define	DBD_BUFFER_SIZE		1500		
#define	DBD_COUNT		15	

extern	MBOX	ReceiveMbox;
extern	int	snc_init;
extern	char ETBROADCAST[];

int	PollPacket();
char 	*TcpipError(int error);
extern int (*pkt_proc_upcall)();
extern	int fault_cnt;

#define FRONT 1
#define BACK 2
extern int A_Port_Config_State ;
extern int B_Port_Config_State ;

tcpip	my_tcpip;	/* this defines the tcpip parameters	*/

EEP_MFG		eep_mfg_rec;
EEP_BOOT	eep_boot_rec;

TftpInit()

	{
	static	int	inited = 0;
	int	code;	/* return code from tcpip_init	*/
	byte	*start_dbd;
	int	x;

	NumberOfSonicPort = SV_NMBR_PORT - 1;
	
	if (inited != 0)
		{
		return !InstallSonic(PollPacket, 0);
		}

	if ((start_dbd = (byte *)malloc((sizeof(DBD) + DBD_BUFFER_SIZE) * DBD_COUNT)) == NULL)
		{
		printf("Abort: not enough memory for dbd buffer\n");
		inited = 0;
		return FALSE;
		}

	init_dbd(start_dbd, DBD_BUFFER_SIZE, DBD_COUNT);

	/* initialize the fddi driver */

	scc_init_chnl_a();

	if(nvr_fddi_rec.UI_Defaults.Port1_PC_Type == 3)	
		A_Port_Config_State = BACK;
	else
		A_Port_Config_State = FRONT;
	
	if(nvr_fddi_rec.UI_Defaults.Port6_PC_Type == 3)
		B_Port_Config_State = BACK;
	else
		B_Port_Config_State = FRONT;

	init_if(); 

	CamInit(); 

	/* Add some delay to allow fddi to connect prior to attempting  */
	/* to send a bootp request.                                     */
	for(x=0; x < 100; x++) {
		delay(5);
		ReSchedule();
	}


	inited = 1;


	/*
	 *	boot from tftp loader
	 *	Initialize the kernel, port driver, tasks ...etc
	 */
	my_tcpip.numtcps = 0;
	my_tcpip.numudps = 2;
	my_tcpip.ifNumber = NumberOfSonicPort+1;
	if ((code = tcpip_init(&my_tcpip)) != 0)
		{
		/*	abort	*/
		printf("Cannot start tcpip (%d): %s\n", code, TcpipError(code));
		inited = 0;
		return FALSE;
		}

	return !InstallSonic(PollPacket, 0);
	}


/*
 *	Add all of my MAC addresses into the cam for soninc port
 *	number "PortNo".
 */
static AddMyAddressesToCam(int PortNo)

	{
	int	i;
	int	ret;

	for (i = 0; i < NumberOfSonicPort; i++)
		{
		if ((ret = chnl_cam_add(PortNo, MyNid(i))) != 0)
			break;
		}
	return ret;
	}

/*
 *	Initialise the network drivers
 */
InstallSonic(int (*UpCall)(), int PromiscuousMode)
{
	int	ret = 0;
	int	PortNo;
	int	PortsFailed = 0;/* 	how many ports have failed */
	int	mode;
	int	i;
	register KRNL *krnl_ptr = &krnl;

	mode = PromiscuousMode ? 
		SV_RCVMD_PRO | SV_RCVMD_AMC | SV_RCVMD_BRD : SV_RCVMD_IND;
	Di();
	/*
	 *	Config the sonic driver and init the
	 *	dbd buffer management.
	 */
	set_leds(LED_MONO, LED_MONO_COLOR, 0xff);

	/* put some delay */
	for(i=0;i<0xffff;i++)
	  ;

	/*
	* do ethernet ports only
	*/
	chnl_config(0,mode,0x50000000,0x70000080);
	chnl_config(1,mode,0x50010000,0x70000100);
	chnl_config(2,mode,0x50020000,0x70000180); 

	/*
	* do ethernet ports only
	*/
	for(i=0;i<3;i++)
	{
	   	ret=chnl_start(i);
	} 
	if (!PromiscuousMode)
	{
		for (PortNo=0; PortNo<NumberOfSonicPort; PortNo++)
		{
			if (AddMyAddressesToCam(PortNo) != 0 ||
				chnl_cam_add(PortNo, ETBROADCAST) != 0)
				PortsFailed++;
		}
	}

	chnl_set_upcall(UpCall);
	pkt_proc_upcall = UpCall;
	snc_init=1;
	Ei();
	/*
	 *	Return ok if at least one port is
	 *	working.
	 */
	return PortsFailed == SV_NMBR_PORT ? 1 : 0;
}

/*
 *	Packet processing for the KERNEL.
 *	This function will be called by the sonic driver whenever
 *	there is at least a packet received.
 */
PollPacket()

	{
	register int PortNum;
	register int PortBit;
	register PKT * pp;

	if (!snc_init)
		return 0;

	ClearPortLedStatus();

	for(PortNum=0, PortBit = 1; PortNum<NumberOfSonicPort; PortNum++, PortBit <<= 1)
		{
		chnl_receive(PortNum);
		}

	pp = (PKT *)GetFddiPkt();
	if(pp) {
		pp->pktDataPtr++;
		SendMessage((MSGHDR *)pp, (MBOX *)&ReceiveMbox);
	}

	return 0;
	}


getBatchCnt()
{
	return 2;
}

