/**			       
*
*	Program Name:	nim960 bridge
*
*	Filename:	tftpmain.c
*
*	$Log:   /b/gregs/bridge/booter/tftpboot/tftpmain.c_v  $
 * 
 *    Rev 1.1   31 Aug 1993 11:31:52   vinay
 * fixed some bugs related to AskBurn 
 * 
 *    Rev 1.0   16 Jul 1993 16:24:56   franks
 * Initial revision.
 * 
 *    Rev 1.2   17 Apr 1992 14:20:30   kwok
 * Update the flash prom burn cycles.
*
*	Creation Date:	2.13.91
*
*	Date:		
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	The tftp loader programme.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <dips.h>
#include <sys.h>
#include <eeprecs.h>
#include <led.h>
#include <netbuf.h>
#include <error.h>
#include <tcpip.h>
#include <nim960h.h>
#include <udp.h>
#include <tftpboot.h>
#include <tftp.h>
/**
#include <nvrecs.h>
#include <log.h>
***/
/********
#define	ERR_IP_ADDR		11
#define ERR_SRVRIP_ADDR		12
#define ERR_CONFIG_FILE		13
********/
extern void	*lmalloc(int);
extern int	TRxPacket(); 
extern	tcpip	my_tcpip;
extern  int DumpFddiPkt; 

byte	tolower();
int	BootImage(int);
int	IsSlip(void);
int	SlipBaud(void);
extern word aplLocation;
void	GetBootRecord(BOOT_BLOCK *boot);
int	CheckSumOk(ushort *buffer, long size);
int	ProgramFlash(void *feprom, byte *data, ulong length);


static BOOT_BLOCK	boot_data;
static SaveFlashBurnStatus();
static int TftpParametersOk(EEP_BOOT *boot_rec);
static int IsIpMulticast(in_name ip, in_name netmask);
static CopyToFlash(byte *data, int length);

/*
 * name		tftpmain	- The entry for tftp loader
 *
 * synopsis	tftpmain(int mode, AskToBurnFlash)
 *		int	mode;	<< which mode tftp should be in.
 *				1	TFTP_MODE_AUTO
 *				3	TFTP_MODE_MANUAL
 *		int	AskToBurnFlash;	0	burn the flash prom 
 *						after download.
 *					otherwise, ask the user whether 
 *					to burn the flash or not.
 *
 * description	This is the tftp loader.  It begines by loading all
 *		parameters relevent to the load.  It supports two
 *		parameterization methods: 
 *		1	automatic mode
 *		It uses the parameters stored in eeprom.
 *		After loading, the image is burned into the flash prom and
 *		is executed. 
 *
 *		3	manual mode
 *		The load parameters are gathered from eeprom. The user
 *		will be prompted to specify any changes to the eeprom
 *		load parameters, whether to load over the ethernets or
 *		over the uart, and whether or not to burn the image
 *		into flash eprom.
 *
 * returns	if fails to load the image file
 *		or jump to the new image and never return.
 */

tftpmain(int mode, int AskToBurnFlash)

	{
	ulong	FileLength;
	NIM960_HDR	*header;
	int	BurnFlash = 0;
	int	RetCode;
	int	status;
	EEP_BOOT *boot_rec = &eep_boot_rec;

	/*	clear record	*/
	memset(&boot_data, 0, sizeof(boot_data));
	boot_data.mode = mode;
	GetBootRecord(&boot_data);


/***********
	if(IsIpMulticast(boot_data.MyIP, boot_data.NetMask))
		Display7Seg(ERR_IP_ADDR);

	if(IsIpMulticast(boot_data.ServerIP, boot_data.NetMask))
		Display7Seg(ERR_SRVRIP_ADDR);

	if(strlen(boot_data.FileName) == 0)
		Display7Seg(ERR_CONFIG_FILE);
**********/
	/*
	 *	Set up my ip address, net_mask and router address
	 */
	my_tcpip.in_me = boot_data.MyIP;
	my_tcpip.net_mask = boot_data.NetMask;
	my_tcpip.net_gway = boot_data.RouterIP;
	boot_rec->eep_image_file[0] = '\0';
	/* 
	 *	Get the Image file
	 */
	printf("\nDownloading the configuration file %s\n",
		boot_data.FileName);
	status = getloadfile(boot_rec->eep_ServerIP, boot_data.FileName);
	if (status == 0)
		{
		/*
		 *	No response from the server
		 */
		printf("\nError: Cannot get the configuration file %s from %s\n",
			boot_data.FileName, 
			inet_ntoa(boot_rec->eep_ServerIP));
		return;
		}
	if (boot_rec->eep_image_file[0] == '\0')
		{
			/*
			 *	We have downloaded the configuration file.
			 *	however, the "load" keyword is not found.
			 */
			printf("\nError: The \"load filename\" is not found in the configuration file %s\n",
			boot_data.FileName);
			return;
		}
	/*
	 *	We have the image file name
	 */
	printf("\nDownloading the Image file %s\n",
		boot_rec->eep_image_file);
	FileLength = TftpLoadFile(boot_data.ServerIP, 
			boot_rec->eep_image_file,
			"octet", TRxPacket); 
	if (FileLength == 0)
		return 0;
	if (CheckImage(boot_data.LoadAddress, FileLength) == 0)
		return 0;
	printf("\nFile loaded\n");
	DumpFddiPkt = TRUE;      /* Stop processing frames from FDDI */
	if (AskToBurnFlash)
		{
		BurnFlash = 1;
		printf("File is being burned to the flash proms\n");
		flush();

		/*
		** Check if the image needs to be compressed.  If so
		** compress the image and burn it into flash.
		*/

		if(program_flash((void *)(FEPROM+aplLocation), boot_data.LoadAddress, FileLength) == 0)
		{
			printf("Error burning file to flash eprom\n");
			return 0;
		}
#ifdef REM
		if (CopyToFlash(boot_data.LoadAddress, FileLength) == 0)
			{
			return 0;
			}
#endif
		}
	/*
	 *	or we ask the user if he wants to program the 
	 *	flash eprom on manual mode.
	 */
	else 
		{
		if (AskYesNo("Do you want to program the flash eprom ([y]/n) "))
			{
			BurnFlash = 1;
		/*
		** Check if the image needs to be compressed.  If so
		** compress the image and burn it into flash.
		*/
		if(program_flash((void *)(FEPROM+aplLocation), boot_data.LoadAddress, FileLength) == 0)
		{
			printf("Error burning file to flash eprom\n");
			return 0;
		}
#ifdef REM
			if (CopyToFlash(boot_data.LoadAddress, FileLength) == 0)
				{
				return 0;
				}
#endif
			}
		}
	if (BurnFlash)
		{
		printf("\nFile has been burned into the flash proms successfully\n");
		flush();
		SaveFlashBurnStatus();
		}
	flush();
	eep_boot_rec.eep_ThinNet = LOAD_FROM_FLASH; 
					/* Do not update FLASH and always
					   try to load from flash */
	SaveEepBoot();
	BroadcastArpReply(_initp->in_me);
	TimeDelay10Ms(100);	/* wait for a second	*/
	stop_timers();
	Di();

	header = (NIM960_HDR *)boot_data.LoadAddress;
	(*((int (*)())header->Entry))(0); 
	}

/*
 * name		GetBootRecord	- manually or from eeprom
 *
 * synopsis	GetBootRecord(boot)
 *		BOOT_BLOCK	*boot; >>	to be initialized
 *
 * description	If the Automatic DIP switch is on, then the parameters
 *		such as my ip address, server ip address, file to be
 *		loaded ...etc, required by tftp will be from the eeprom. 
 *		Otherwise, the user is prompted to enter those
 *		parameters from the console.
 *
 * returns	nothing
 */

void GetBootRecord(boot)
BOOT_BLOCK *boot;

	{
	int	confirmed = 0;
	int	yes = 0;
	int	EepromDataOk = 1;	/* assume eeprom is ok	*/
	EEP_MFG	*mfg = &eep_mfg_rec;	/* Manufacture data		*/
	EEP_BOOT	*bootrec = &eep_boot_rec;/* boot record		*/

	boot->DramSize = mfg->eep_dram_size;
	boot->SramSize = mfg->eep_sram_size;
	if (!TftpParametersOk(bootrec)) 
		{
		EepromDataOk = 0;
		}
	else
		{
		boot->MyIP = bootrec->eep_IP;
		boot->ServerIP = bootrec->eep_ServerIP;
		boot->NetMask = bootrec->eep_NetMask;
		boot->RouterIP = bootrec->eep_RouterIP[0];
		strcpy(boot->FileName, bootrec->eep_config_file);
		}
	/*
	 *	If we are in automatic mode and the boot record in
	 *	the eeprom is ok, we are done.
	 */
	if (boot->mode == TFTP_MODE_AUTO && EepromDataOk)
		return;
	/*
	 *	If the boot record is good and we are in
	 *	manual mode, we ask the user if he wants to use
	 *	these parameters rather than to enter these data
	 */
	if (EepromDataOk)
		{
		yes = UseBootRecord(boot);
		}
	if (!yes)
		{
		/*
		 *	No, the user does not want to use the boot record 
		 *	stored in the eeprom or the boot record is bad.
		 *	We have to ask the user to enter boot record.
		 */
		EnterBootRecord(boot);
		bootrec->eep_IP = boot->MyIP;
		bootrec->eep_ServerIP = boot->ServerIP;
		bootrec->eep_NetMask = boot->NetMask;
		if ((boot->MyIP & boot->NetMask) != 
			(boot->ServerIP & boot->NetMask))
			bootrec->eep_RouterIP[0] = boot->RouterIP;
		strcpy(bootrec->eep_config_file, boot->FileName);
		/*
		 *	Save new records to eeprom
		 */
		if (AskYesNo("Do you want to save these records in EEPROM ([y]/n)"))
			{
			SaveEepBoot();
			}

		}
	/* 
	 *#####	return for now
	 */
	return;
	while (confirmed == 0)
		{
		yes = AskYesNo("Load over ethernet ([y]/n)");
		boot->IsSlip = !yes;
		if (boot->IsSlip != 0)
			{
			/*
			 *	Ask for the baud rate
			 */
			boot->baud = AskForBaud();
			}
		confirmed = AskYesNo("Confirm ([y]/n)");
		}
	}
/*
 * name		SetLoadAddress
 *
 * synopsis	SetLoadAddress(header, LoadAddress)
 *		NIM960_HDR	*header;<< nim960 header
 *		byte	**LoadAddress; >> where to load the file
 *
 * description	If the nim960 signature is OK, it set the load address
 *		to be the TextLoadAddress in the nim960 header.
 *		It then checks if there are enough ram space to
 *		load the file. 
 *		This function is called when the first tftp packet
 *		has been received.
 *
 * returns	TRUE	file header is ok and address has been set
 *		FALSE	error
 */
SetLoadAddress(NIM960_HDR *header, byte **LoadAddress)

	{
	ulong	TextAddress;
	ulong	FileLength;

	/*
	 *	Because of alignment problem, we have to copy
	 *	out the followin before we do anything with them.
	 */
	LongCopy(&TextAddress, &header->TextLoadAddress);
	LongCopy(&FileLength, &header->FileLength);


	/*
	 *	Check if file is a NIM960 file.
	 */
	if (header->signature != NIM960_MAGIC)
		{
		printf("Error: Invalid file format\n");
		return FALSE;
		}
	/*
	 *	If the loading address in not in 
	 *	the the SRAM or DRAM address space,
	 *	we cannot load the file at all.
	 */
	if (!AddressInDram(TextAddress) &&
		!AddressInSram(TextAddress))
		{
		printf("Load address (%X) not in RAM \n,", TextAddress);
		return FALSE;
		}

	*LoadAddress = (byte *)TextAddress;
	boot_data.LoadAddress = (byte *)TextAddress;

	/*
	 *	this is how much free space available to load
	 *	the program.
	 */
	boot_data.size = (byte*)DRAM + boot_data.DramSize - boot_data.LoadAddress;
	if (FileLength > boot_data.size)
		{
		printf(" File too big %d, RAM size = %d\n", header->FileLength,
			boot_data.size);
		return FALSE;
		}
	return TRUE;
	}

/*
 *	Test if address is in the Dram address space
 *	returns TRUE if yes
 *		FALSE	otherwise
 */
AddressInDram(byte *address)

	{
	return (((byte *)DRAM + boot_data.DramSize) >= address &&
		(address >= (byte *)DRAM));
	}
/*
 *	Test if address is in the Sram address space
 *	It is assumed that the Dram starts right after the Sram.
 *	returns TRUE if yes
 *		FALSE	otherwise
 */
AddressInSram(byte *address)

	{
	return (((byte *)SRAM + boot_data.SramSize) >= address &&
		(address >= (byte *)SRAM));
	}


/*
 *	Are we on SLIP ?
 */
IsSlip()
	{
	return boot_data.IsSlip;
	}
/*
 *	Return the baud rate for SLIP
 */
SlipBaud()
	{
	return boot_data.baud;
	}

LongCopy(ushort *to, ushort *from)
	
	{
	*to++ = *from++;
	*to = *from;
	}
/*
 *	Save the date and time the flash is programed.
 */
static SaveFlashBurnStatus()

	{

	char	p[9];
	strcpy(p,"BOOTPROM"); /* we don't know the date and time	*/

	memcpy(eep_boot_rec.eep_BurnDate, p, 8);
	memcpy(eep_boot_rec.eep_BurnTime, p, 8);
	eep_boot_rec.eep_BurnCycles++;
	eep_boot_rec.eep_ThinNet = LOAD_FROM_FLASH; /* Do not update FLASH and always
					   try to load from flash */
	SaveEepBoot();
	}

/*
 *	Tftp parameters are ok if
 *	-	my ip address is ok	and
 *	-	server ip address is ok	and
 *	-	config file is not NULL	and
 *	-	if (server is on a differnet network)
 *	-		there is at least one valid router ip
 */
static int TftpParametersOk(EEP_BOOT *boot_rec)

	{
	if (!IsIpMulticast(boot_rec->eep_IP, boot_rec->eep_NetMask) && 
		!IsIpMulticast(boot_rec->eep_ServerIP, boot_rec->eep_NetMask) &&
		boot_rec->eep_config_file[0] != '\0')
		{
		if ((boot_rec->eep_IP & boot_rec->eep_NetMask) == (boot_rec->eep_ServerIP & boot_rec->eep_NetMask) ||
			!IsIpMulticast(boot_rec->eep_RouterIP[0], boot_rec->eep_NetMask) ||
			!IsIpMulticast(boot_rec->eep_RouterIP[1], boot_rec->eep_NetMask))
			return TRUE;
		}

	return FALSE;
	}

static int IsIpMulticast(in_name ip, in_name netmask)
	{
	return ip == 0 || ip == -1 || (ip & ~netmask) == ~netmask;
	}

#ifdef notused
static CopyToFlash(byte *data, int length)

	{
	int	left;	/* to be burned	next	*/
	int	size;	/* to be burned now	*/
	int	ret;

	if (length > eep_mfg_rec.eep_fprom_size)
		{
		printf("Error: file size (%d) is bigger than the flash size (%d)\n",
			length, eep_mfg_rec.eep_fprom_size);
		return FALSE;
		}

	if (length > MIN_FLASH_SIZE)
		{
		size = MIN_FLASH_SIZE;;
		left = length - size;
		}
	else
		{
		size = length;
		left = 0;
		}
	if ((ret = ProgramFlash((void *)FEPROM, data, size)) == FALSE)
		return ret;
	if (left != 0)
		ret = ProgramFlash((void *)FEPROM + size, data + size, left);
	return ret;			
	}
#endif
