/**			       
*
*	Program Name:	nim960 bridge
*
*	Filename:	autoconf.c
*
*	$Log:   /b/gregs/bridge/config/autoconf.c_v  $
 * 
 *    Rev 1.7   08 Nov 1993 14:10:50   vinay
 * fixed the printing of the addnl wrong message when there is a location change
 * 
 *    Rev 1.6   12 Oct 1993 09:11:12   franks
 * No change.
 * 
 *    Rev 1.5   29 Sep 1993 10:16:56   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:49:24   vinay
 * commented out the UpdateImage()
 * 
 *    Rev 1.3   10 Sep 1993 15:20:28   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:19:02   franks
 * No change.
 * 
 *    Rev 1.1   03 Sep 1993 11:58:12   vinay
 * sending a change of location trap
 * 
 *    Rev 1.0   31 Jul 1993 10:38:36   vinay
 * Initial revision.
 * 
 *    Rev 1.2   05 Mar 1993 15:07:44   kwok
 * Send an ARP broadcast to flush the arp table on the host even though
 * the time server ip is not returned from bootp server.
 * 
 *    Rev 1.1   09 Jun 1992 19:19:38   kwok
 * Call the function SetDefaultAll() to set all bridge parameters to their
 * default values. This will fix problem #113.
 * 
 *    Rev 1.0   30 Mar 1992 17:31:54   pvcs
 * Initial revision.
*
*	Creation Date:	12.5.91
*
*	Date:		
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	The auto configuration.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <dips.h>
#include <eeprecs.h>
#include <led.h>
#include <nvrecs.h>
#include <netbuf.h>
#include <error.h>
#include <sys.h>
#include <tcpip.h>
#include <udp.h>
#include <tftpboot.h>
#include <tftp.h>
#include <bootp.h>
#include <prcctl.h>
#define	MANUAL_CONFIG_TIMEOUT	1000	/* 10 seconds	*/
#define	CONFIG_RESET_TIMEOUT	30000	/* 5 minutes	*/
/*
 *	Number of seconds between 1.1.1990 and 1.1.1970
 */
#define	TIME_OFFSET_1_1_1970	2208988800

int ChangeOfLocation = 0;
ushort oldHubId;
ushort oldSlotId;


extern	unsigned int	BootUpSeconds;
extern	int	InBootStage;

int UpdateImage(int mode);
int AutoConfig(void);



static int	SameHubSlotId(void);
static int	ConsoleConfig(void);
static void	PrintErrorParam(EEP_BOOT *boot_rec);
static void	CopyBootpInfo(void);
static int	TftpParametersOk(EEP_BOOT *boot_rec);
static int	IsIpMulticast(in_name ip, in_name netmask);
static int	BootpReqSend(EEP_BOOT *boot_rec);
static int	ReStartOnLocChange(void);

/*
 *	The auto-configuration sequence
 */
AutoConfig()

	{
	int	BootpOK;

	InBootStage = 1; /* we are in the boot-up stage */
BootpAgain:
	BootpOK = 0;

	printf("\nBridge is being configured, please wait ...\n");
	if (!eep_boot_rec.eep_LocalConfig)
		{
		/*
		 *	We have to do a bootp request,
		 *	and save the record if bootp returns ok.
		 */
		if ((BootpOK = BootpReqSend(&eep_boot_rec)) != 0)
			SaveEepBoot();
		}
	
	if (!BootpOK)
		{
		/*
		 *	Bootp fails or is disabled.
		 */
		if (!SameHubSlotId())
			{
			/*
			 *	bootp failed/disabled and we are new.
			 *	We check if we can carry on or re-start
			 *	the boot sequence.
			 */
			if (ReStartOnLocChange())
				goto BootpAgain;
			}
		}
	if (BootpOK || SameHubSlotId())
		{
		/*
		 *	If bootp is disabled set BootpOK

		if(eep_boot_rec.eep_LocalConfig)
			BootpOK = 1;
		 */
		/*
		 *	Bootp is ok or I am in the same hub 
 		 *	as before. I can carry on.
		 */
		if (!BootpOK && !ChangeOfLocation)
			{
			/*
			 *	bootp has failed.
			 */
			printf("Since this module has not been moved\n"); 
			printf("the previous bridge parameters are retained\n");
			}
		/*
		 *	Tftp the configuration file
		 *	and config the module.
		 */
		if (TftpParametersOk(&eep_boot_rec))
			{
			/*
			 *	Get the configuration file and 
			 *	config the bridge... This is to be done !!!
			 */
#ifdef kwok
			boot_rec->eep_image_file[0] = '\0';
			/* 
			 *	Get the Image file
			 */
			printf("\nDownloading the configuration file %s\n",
				eep_boot_rec.eep_config_file);
			status = getloadfile(eep_boot_rec.eep_ServerIP, 
					eep_boot_rec.eep_config_file);
			if (status == 0)
				{
				/*
				 *	No response from the server
				 */
				printf("\nError: Cannot get the configuration file %s from %s\n",
					eep_boot_rec.eep_config_file, 
					inet_ntoa(eep_boot_rec.eep_ServerIP));
				}
#endif
			}
		else
			{
			PrintErrorParam(&eep_boot_rec);
			}
		}
	/*
	 *	Update the hud id and slot id if I am inside a hub, and
	 *	the hubid slotid pairs is not the same as my last
	 *	Hubid and slotid.
	 */
	if (!SameHubSlotId())
		{
		eep_boot_rec.eep_hubid = GetHubID();
		eep_boot_rec.eep_slotid = GetSlotID();
		SaveEepBoot();
		}
	/*
	 *	Get the current time from the time server if I
	 *	know the ip address of a time server and I know who I am.
	 */
	if (!IsIpMulticast(eep_boot_rec.eep_TimeServer, _initp->net_mask) &&
		!IsIpMulticast(_initp->in_me, _initp->net_mask))
		{
		printf("\nSending time request to %s\n", 
			inet_ntoa(eep_boot_rec.eep_TimeServer));
		BootUpSeconds = GetTimeFromServer(eep_boot_rec.eep_TimeServer);
		if (BootUpSeconds != 0)
			{
			printf("Time reply received\n\n");
			/*
			 *	We want the time is number of seconds since
			 *	1.1.1970.
			 */
			BootUpSeconds -= TIME_OFFSET_1_1_1970;
			/*
			 *	We have to adjust for the time gap between 
			 *	the boot up time and the time it gets this
			 *	time response from the server.
			 */
			BootUpSeconds -= (RealTimeTicks() / 100);
			/*
			 *	Adjust from GMT to local time
			 */
			BootUpSeconds += eep_boot_rec.eep_OffsetGMT;
			}
		else
			{
			printf("Warning: No response from the time server\n");
			printf("The time is not set on this module\n");
			}
		}
	BroadcastArpReply(_initp->in_me);
	fls_arp_cache();
	/*
	 *	We are no longer in the BOOT stage.
	 *	From now on, we accept packet only if the destination 
	 *	MAC address
	 *	matches the incoming port's MAC address.
	 */
	InBootStage = 0;
	}

/*
 *	Check if I am in the same Hub and Slot as before.
 */
static int SameHubSlotId()
	{
	if (!IsStandalone())
		{
		if (  GetHubID() != (oldHubId = eep_boot_rec.eep_hubid) || 
			GetSlotID() != (oldSlotId = eep_boot_rec.eep_slotid))
			{
			ChangeOfLocation = 1;
			return 0;
			}
		}
	return 1;
	}
/*
 *	Ask the user if he/she wants to config. the module 
 *	manually or start the auto-config sequence again.
 *	If there is no response after 5 min., it times out and return.
 */
static int ConsoleConfig()
	{
	int	ticks;	/*	for 5 minutes time out	*/
	int	PromptTicks;	/* for 10 seconds time out	*/
	int	ch;
	int	prompt = 1;

	ticks = RealTimeTicks();
	PromptTicks = ticks;
	for (;;)
		{
		if ((RealTimeTicks() - PromptTicks) > MANUAL_CONFIG_TIMEOUT)
			{
			prompt = 1;
			PromptTicks = RealTimeTicks();
			}
		if (prompt)
			{
			printf("\n\nDo you want to configurate this module manually [y/n] ? \n");
			printf("[y] to jump to the bridge program with all ports disabled\n");
			printf("[n] to re-start the auto-configuration ==>");
			prompt = 0;
			}
		if ((RealTimeTicks() - ticks) > CONFIG_RESET_TIMEOUT)
			{
			printf("\nConsole prompt times out, auto-configuration is re-started\n\n");
			return FALSE;
			}
		ch = getch();
		if (ch != -1)
			{
			putchar(ch);
			putchar('\n');
			if (ch == 'y' || ch == 'Y')
				return TRUE;
			if (ch == 'N' || ch == 'n')
				return FALSE;
			ticks = RealTimeTicks();
			PromptTicks = RealTimeTicks();
			prompt = 1;
			}
		ReSchedule();
		}
	}

#ifdef vinay
UpdateImage(int mode)

	{
	int	status;
	in_name	bad_ip;
	EEP_BOOT *boot_rec = &eep_boot_rec;

	InBootStage = 1;
	/*
	 *	Bootp to get my ip, server ip and the config. file
	 *	if necessary
	 */
	set_leds(LED_BI, LED_RDY | LED_ACT, LED_RDY_GRN | LED_ACT_RED);
	if (!eep_boot_rec.eep_LocalConfig)
		{
		if (BootpReqSend(boot_rec) == FALSE)
			{
			InBootStage = 0;
			return APPL_BRIDGE;
			}
		}
	if (TftpParametersOk(boot_rec))
		{
		boot_rec->eep_image_file[0] = '\0';
		/* 
		 *	Get the Image file
		 */
		printf("\nDownloading the configuration file %s\n",
			boot_rec->eep_config_file);
		status = getloadfile(boot_rec->eep_ServerIP, 
				boot_rec->eep_config_file);

		if (status != 0 &&
			boot_rec->eep_image_file[0] != '\0')
			{
			/*
			 *	We have the image file name
			 */
			printf("\nDownloading the Image file %s ...\n",
				boot_rec->eep_image_file);
			tftpmain(mode);	
			}
		else if (status == 0)
			{
			/*
			 *	No response from the server
			 */
			printf("\nError: Cannot get the configuration file %s from %s\n",
				boot_rec->eep_config_file, 
				inet_ntoa(boot_rec->eep_ServerIP));
			}
		else
			{
			/*
			 *	We have downloaded the configuration file.
			 *	however, the "load" keyword is not found.
			 */
			printf("\nError: The \"load filename\" is not found in the configuration file %s\n",
				boot_rec->eep_config_file);
			}
		}
	else
		{
		PrintErrorParam(boot_rec);
		}
	/*
	 *	We are no longer in the BOOT stage.
	 *	From now on, we accept packet only if the destination MAC address
	 *	matches the incoming port's MAC address.
	 */
	InBootStage = 0;
	return APPL_BRIDGE;
	}
#endif 
static void PrintErrorParam(EEP_BOOT *boot_rec)
	{
	if (IsIpMulticast(boot_rec->eep_IP, boot_rec->eep_NetMask))
		printf("\nError: IP address of this module is invalid (%s)\n",
			inet_ntoa(boot_rec->eep_IP));
	else if (IsIpMulticast(boot_rec->eep_ServerIP, boot_rec->eep_NetMask))
		printf("\nError: IP address of the server is invalid (%s)\n",
			inet_ntoa(boot_rec->eep_ServerIP));
	else if (boot_rec->eep_config_file[0] == '\0')
		printf("\nError: Configuration file is not set\n");
	else
		{
		printf("\nError: Router IP addresses invalid\n");
		printf("Primary router IP = %s Secondary router IP = %s\n",
			inet_ntoa(boot_rec->eep_RouterIP[0]),
			inet_ntoa(boot_rec->eep_RouterIP[1]));
		}
	}
/*
 *	copy info returned from bootp to my data structure and the
 *	eeprom.
 */
static void CopyBootpInfo()

	{
	int	i;

	_initp->in_me = bootpinfo.yiaddr;
	eep_boot_rec.eep_IP = _initp->in_me;
	eep_boot_rec.eep_ServerIP = bootpinfo.siaddr;
	eep_boot_rec.eep_BootpServer = bootpinfo.siaddr;
	eep_boot_rec.eep_NetMask = bootpinfo.NetMask;
	_initp->net_mask = bootpinfo.NetMask;
	for (i = 0;  i < BP_MAX_IP; i++)
		{
		if (bootpinfo.Router[i] != 0)
			eep_boot_rec.eep_RouterIP[i] = bootpinfo.Router[i];
		}
	if (bootpinfo.Router[0] != 0)
		_initp->net_gway = bootpinfo.Router[0];
	if (bootpinfo.Router[1] != 0)
		_initp->net_gway2 = bootpinfo.Router[1];
	strcpy(eep_boot_rec.eep_config_file, bootpinfo.file);
	eep_boot_rec.eep_OffsetGMT = bootpinfo.TimeOffset;
	eep_boot_rec.eep_TimeServer = bootpinfo.TimeServer[0];
	}
/*
 *	Tftp parameters are ok if
 *	-	my ip address is ok	and
 *	-	server ip address is ok	and
 *	-	config file is not NULL	and
 *	-	if (server is on a differnet network)
 *	-		there is at least one valid router ip
 */
static int TftpParametersOk(EEP_BOOT *boot_rec)

	{
	if (!IsIpMulticast(boot_rec->eep_IP, boot_rec->eep_NetMask) && 
		!IsIpMulticast(boot_rec->eep_ServerIP, boot_rec->eep_NetMask) &&
		boot_rec->eep_config_file[0] != '\0')
		{
		if ((boot_rec->eep_IP & boot_rec->eep_NetMask) == (boot_rec->eep_ServerIP & boot_rec->eep_NetMask) ||
			!IsIpMulticast(boot_rec->eep_RouterIP[0], boot_rec->eep_NetMask) ||
			!IsIpMulticast(boot_rec->eep_RouterIP[1], boot_rec->eep_NetMask))
			return TRUE;
		}
	return FALSE;
	}

static int IsIpMulticast(in_name ip, in_name netmask)
	{
	return ip == 0 || ip == -1 || (ip & ~netmask) == ~netmask;
	}

static int BootpReqSend(EEP_BOOT *boot_rec)

	{
	in_name	myip = _initp->in_me;
	int	ret;

	_initp->in_me = 0;
	printf("Sending BOOTP request file %s\n", 
		boot_rec->eep_request_file[0] == NULL ? "(NULL)" :
		boot_rec->eep_request_file);
	if (udpboot(0, 0, boot_rec->eep_request_file) != FALSE)
		{
		/*
		 *	We have a reply.
		 */
		printf("BOOTP reply received\n");
		CopyBootpInfo();
		ret = TRUE;
		}
	else
		{
		_initp->in_me = myip;
		printf("Warning: No response from BOOTP server\n");
		ret = FALSE;
		}
	return ret;
	}

static int ReStartOnLocChange()

	{
	if (sys.sys_switch & DIP_DEFAULT_OK)
		{
		/*
		 *	Default is ok, reset all parameters to
		 *	be factory default.
		 */
		printf("A location changed is detected\n");
		printf("The module parameters are set to factory default\n");
        	/*
        	*
        	*       Send a changeoflocation trap
        	*       to the manager and reset the changeoflocation flag.
        	*
        	*/
#ifdef 0
        	if(ChangeOfLocation)
        	{
                	specific_trap(10, 0,(byte *)NULL, 0,0,0,0,0,
                                	oldHubId,oldSlotId,eep_boot_rec.eep_hubid,
                                	eep_boot_rec.eep_slotid);
	
                	ChangeOfLocation = 0;
        	}
#endif

		SetDefaultAll();
		ClearBootRecord();
		_initp->in_me = 0;
		_initp->net_mask = 0;
		_initp->net_gway = 0;
		_initp->net_gway2 = 0;

		return FALSE;
		}
	else
		{
		/*
		 *	If default is not allowed,
		 *	we ask the user if he/she wants to
		 *	carry on with all port disabled, or
		 *	re-start the sequence
		 */
		if (ConsoleConfig())
			{
			/* 
			 *	The user wants to carry on
			 *	and config. the bridge
			 *	manually.
			 */
			BridgeStatus->PortState &= ~0x0f;
			prc.Prc_PortState &= (byte)~0x0f;
			SaveBStatus();
			pre_proc_prcctl();
			return FALSE;
			}
		else
			{
			if (eep_boot_rec.eep_LocalConfig)
				printf("Warning: Bootp request is disabled\n");
			return TRUE; 
			}
		}
	}

TimeDelay10Ms(int counter)

	{
	unsigned ticks;

	ticks = RealTimeTicks();
	while((RealTimeTicks() - ticks) < counter)
		ReSchedule();
	}
