
/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834cmd2.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/834cmd2.c_v  $
 * 
 *    Rev 1.14   08 Nov 1993 15:27:02   vinay
 * fixed STANDARD and EXTENDED kw lengths
 * 
 *    Rev 1.13   22 Sep 1993 09:22:22   vinay
 * changed all functions accepting IP addresses to accept NONE to clear IP Addr.
 * 
 *    Rev 1.12   17 Sep 1993 11:33:20   vinay
 * changed the pri and secondary router ip functions to accept none
 * 
 *    Rev 1.11   16 Sep 1993 11:36:20   gregs
 * lsh sep/16/93 Replaced sscanf by atod in define bridge timeout to reject
 * garbage after the value.
 * 
 *    Rev 1.10   14 Sep 1993 09:31:34   vinay
 * fixed def port x res e ro garbage and def mod vt disableggar bugs
 * 
 *    Rev 1.9   13 Sep 1993 12:02:36   vinay
 * fixed the min length for , ENABLE and DISABLE
 * 
 *    Rev 1.8   08 Sep 1993 09:28:44   gregs
 * lsh Replaced call to GetIPAddress by GetNetMask for Def mod netmask command.
 * 
 *    Rev 1.7   07 Sep 1993 18:36:08   gregs
 * 
 * 
 *    Rev 1.6   03 Sep 1993 11:07:58   gregs
 * fixed code to accept 'e' or 'd' for enalbe and disable.
 * 
 *    Rev 1.5   22 Aug 1993 15:38:54   vinay
 * changed the forward and filter kw lengths to 2
 * 
 *    Rev 1.4   22 Aug 1993 15:28:42   vinay
 * changed the length of the keywords according to the new requirement
 * 
 *    Rev 1.3   16 Aug 1993 14:39:08   vinay
 * fixed the accepting of junk after ip address
 * 
 *    Rev 1.2   29 Jul 1993 16:33:58   vinay
 * 
 *    Rev 1.1   11 Jun 1993 12:10:14   vinay
 * changed ENABLE to ENABL as the compiler was giving a warning of redefinition
 * 
 *    Rev 1.0   04 May 1993 16:03:48   franks
 * Initial revision.
 * 
 *    Rev 1.6   05 Mar 1993 15:00:16   kwok
 * set the _initp->gway1Metric or _initp->gway2Metric to 0 after setting
 * the primary or/and secondary router address(es).
 * 
 *    Rev 1.5   13 May 1992 14:32:12   franks
 * 1). New command define bridge port external to replace define bridge aui.
 * 2). Two new commands, define primary router and define secondary router
 *     to replace the define iprouter command.
 * 3). Fixed BMExpression routine so that an error code is returned if the
 *     bmexpression string is >15 characters.
 * 
 *    Rev 1.4   04 May 1992 12:16:18   franks
 * No change.
 * 
 *    Rev 1.3   17 Apr 1992 16:17:30   franks
 * No change.
 * 
 *    Rev 1.2   16 Apr 1992 14:46:46   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:06:00   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:48:02   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/


#include <types.h>
#include <target.h>
#include <bridges.h>
#include <utility.h>
#include <prcadr.h> 
#include <krnl.h>
#include <prcctl.h>
#include <sncvar.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include <stp.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <param.h>
#include <cpb.h>
#include <834parser.h>
#include <834error.h>

/* EXTERNAL VARIABLE DEFINITIONS */
extern char *APPLSOFTVERSION;
extern IP IPDevice[];
extern PRCCTL prc;
extern NVR_BSTATUS *BridgeStatus;
extern ERRORLOG ErrorLogTable[];
extern Port_data port_info[];
extern Bridge_data bridge_info;
extern void BitmaskStatusScreen();
extern TIMER IntervalTimer;
extern TIMER InactivityTimer;
extern tcpip *_initp;
extern unsigned long InitTimeSeconds;
extern unsigned long InitDateSeconds;
extern long GmtOffset;
extern uint Ports;             /* Bitmask of port list entered on cmd line */
extern uint BlockPermit;       /* Flag to indicate Block or Permit operation */
extern RAM_PIT rampit;

/******************************************************************************/

define() {
	/* This function just indicates that there should be more        */
	/* parameters following the Define portion of the command */
	return(0);
}

DefineBrg()  {
	/* This function just indicates that there should be more        */
	/* parameters following the Define Bridge portion of the command */
	return(0);
}

/******************************************************************************/

/*	Start DefineAlarmMgr()  */
DefineAlarmMgr( CPB_P pcpb ) {

	int IPNumber;
	int i, length;
	int NumArgs = 0;
	char *kw;
	char Buffer[20];
	char ipa[20];
	char *MgrAdr;
	unsigned long address;
	uint retcode;

#ifdef 0
	/* Get the reset of the parameters */
	NumArgs = sscanf(&pcpb->cmd[pcpb->cl_idx], "%d%s", &IPNumber, Buffer);
	
	if ( NumArgs == 2 )
#endif
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if(!atod(kw,&IPNumber))
		return KW_UN_AMB;
	pcpb->cl_idx += length;
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += length;

	strcpy(Buffer,kw);
	if(pcpb->cl_idx > pcpb->cmdlen)
	{
		/* modify the command line pointer */
		/* this will cause the error msg to be correct */
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

		if (IPNumber >= 1 && IPNumber <= 2) {

/*
		    pcpb->cl_idx += length;
*/
			switch (IPNumber)
			{
				case 1:
				if(strcmp(Buffer,"NONE") != 0)
				{
					retcode = (GetIPAddress(&IPDevice[6], Buffer, &ipa));
					if( retcode )
							return(retcode);

					/* convert ip address from string to long */
					address = inet_addr(ipa);
				}
				else
					address = 0L;
				if (address == -1)  {
					return(ERR_IP_ADDRESS);
				}

                    /* Set Alarm Switches to Default */
				if(!address)
					set_deftrap(1, address);

				/* Modify the ip address in NVRAM */
				BridgeStatus->SnmpMgr[0] = address;

				/* Modify the working copy of the address */
				/* ??????? = address;	 */

				/* Save the updated NVRAM record */
				SaveBStatus();
				break;

				case 2:
				if(strcmp(Buffer,"NONE") != 0)
				{
					retcode = (GetIPAddress(&IPDevice[7], Buffer, &ipa));
					if( retcode )
							return(retcode);

					/* convert ip address from string to long */
					address = inet_addr(ipa);
				}
				else
					address = 0L;

				if (address == -1)  {
					return(ERR_IP_ADDRESS);
				}

                    /* Set Alarm Switches to Default */
				if(!address)
					set_deftrap(2, address);

				/* Modify the ip address in NVRAM */
				BridgeStatus->SnmpMgr[1] = address;

				/* Modify the working copy of the address */
				/* ??????? = address;	 */

				/* Save the updated NVRAM record */
				SaveBStatus();
				break;
#ifdef BOB
				case 3:
					retcode = (GetIPAddress(&IPDevice[8], Buffer, &ipa));
					if( retcode )
							return(retcode);

					/* convert ip address from string to long */
					address = inet_addr(ipa);
					if (address == -1)  {
						return(ERR_IP_ADDRESS);
					}

					/* Modify the ip address in NVRAM */
					BridgeStatus->SnmpMgr[2] = address;

					/* Modify the working copy of the address */
					/* ??????? = address;	 */

					/* Save the updated NVRAM record */
					SaveBStatus();
					break;

				case 4:
					retcode = (GetIPAddress(&IPDevice[9], Buffer, &ipa));
					if( retcode )
							return(retcode);

					/* convert ip address from string to long */
					address = inet_addr(ipa);
					if (address == -1)  {
						return(ERR_IP_ADDRESS);
					}

					/* Modify the ip address in NVRAM */
					BridgeStatus->SnmpMgr[3] = address;

					/* Modify the working copy of the address */
					/* ??????? = address;	 */

					/* Save the updated NVRAM record */
					SaveBStatus();
					break;
#endif
			}
		}
		else
			return (OUT_OF_RANGE);
	}
	else
		return (CMD_SYNTAX_ERR);

	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End DefineAlarmMgr()  */


/******************************************************************************/
                       /* Start DefineBrgAutoCfg() */
DefineBrgAutoCfg( CPB_P pcpb ) {

	PRCCTL *prcctl = &prc;
	uint length;
	char *kw;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	/* If enabling or disabling the auto config mode */

	if( strncmp(kw, "DISABLE", strlen(kw)) == 0 ) {
		eep_boot_rec.eep_LocalConfig = BRG_MODE_ENABLE;
	}
	else
	if( strncmp(kw, "ENABLE", strlen(kw)) == 0 ) {
		eep_boot_rec.eep_LocalConfig = BRG_MODE_DISABLE;
	}
	else
		return( CMD_SYNTAX_ERR );

	SaveEepBoot();
	pcpb->cl_idx += length;
	return(0);
}
/* End DefineBrgAutoCfg() */

/******************************************************************************/
							/*	Start DefineBrgAuthent()  */
DefineBrgAuthent( CPB_P pcpb )  {

	unsigned int ReturnCode;
	uint length;
	char *kw;
	int PswdType;


	PswdType = 1;		/*	The password type is CONSOLE  */
	pcpb->cl_idx = pcpb->cmdlen;
	switch (SNMPOrConsolePswd(PswdType))
	{
		case INVAL_PWD:
			return (INVAL_PWD);

		case PWD_VER_FAIL:
			return (PWD_VER_FAIL);

		default:
			SaveBStatus();            /* Record change in NVRAM */
			return (0);
	}
#ifdef BOB	
	else
	if ((strncmp(kw, strlwr(SNMPPSWD), 4) == 0) )
	{
		PswdType = 2;	   /*	The password type is SNMP  */
		pcpb->cl_idx = pcpb->cmdlen;
		switch (SNMPOrConsolePswd(PswdType))
		{
			case INVAL_PWD:
				return (INVAL_PWD);

			case PWD_VER_FAIL:
				return (PWD_VER_FAIL);
		}
	}
	else
		return (CMD_SYNTAX_ERR);
#endif

}
/*	End DefineBrgAuthent()	*/

/******************************************************************************/
					/*	Start DefinePortExternal()  */
DefinePortExternal( CPB_P pcpb ) {

	char *kw;
	uint length;
	uint PortMask = Ports;   /* Ports is a global variable */

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

    if( PortMask != PORT4 ) {
	   pcpb->cl_idx += length;
       return(ERR_ONLY_PORT4);
    }

	if( strncmp( kw, "AUI" , 2) == 0 )
        Port4Config(DISABLE_THINET);
	else
	if( strncmp( kw, "TRNSCVR" , 2) == 0 ) {
        if( TransceiverType() == TRANSCEIVER_BLANK )
             return(ERR_NO_TRNSCVR);

        printf("\n**** AUI CABLE MUST BE DISCONNECTED FOR PROPER OPERATION **** \n\n"); 
        Port4Config(ENABLE_THINET);
    }
    else
       return(CMD_SYNTAX_ERR);
       
	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}

/******************************************************************************/
							/*	Start DefineBrgBMDefine()  */
DefineBrgBMDefine( CPB_P pcpb ) {

	unsigned char Number;
	char *kw;
	uint Offset  = 0;
	uint Index   = 0;
	uint NumArgs = 0;
	uint length;
	char Buffer[36];
	RECORDMASK ValueMask;
	BINARYMASK BinaryMask;

	memset(Buffer, NULL, sizeof(Buffer));
	memset(&ValueMask, NULL, sizeof(RECORDMASK));
	memset(&BinaryMask, NULL, sizeof(BINARYMASK));

	NumArgs=sscanf(&pcpb->cmd[pcpb->cl_idx],"%s %d %s",&Number,&Offset,Buffer);

	if (NumArgs == 3)
	{
		Number = toupper(Number);
			/* check value range */
		if (Number < MINNUMBER || Number > MAXNUMBER)
			return (ERR_BITMASK_NUMBER);

		/* adjust cmd line for error message */
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		pcpb->cl_idx += length;

			/* check value range  */
		if (Offset < MINOFFSET || Offset > MAXOFFSET)
			return (ERR_BITMASK_OFFSET);

		/* adjust cmd line for error message */
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		pcpb->cl_idx += length;

		ChangeToIndex(Number, &Index);	/* Convert the number into an index  */

		if (strlen(Buffer) == 8)
		{
			if (HexToMask(Buffer, &ValueMask, 4))
				return (ERR_BITMASK_MASK);
			else
			{
				/* Make sure that the bitmask has not already been defined */
				if( strlen(BridgeStatus->BMElement[Index].ValueString) > 0 )
					return( ERR_ALREADY_DEF );

				/* adjust cmd line for error message */
			   length=pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		       pcpb->cl_idx += length;

		       memcpy(&BridgeStatus->BMElement[Index].BitMask.bm_mask,
							 &ValueMask.AddressMask, 4);

				memcpy(&BridgeStatus->BMElement[Index].BitMask.bm_mtch, 
							 &ValueMask.AddressValue, 4);
				
				memcpy(BridgeStatus->BMElement[Index].ValueString, Buffer,
							 sizeof(Buffer));
				BridgeStatus->BMElement[Index].BitMask.bm_ofst = Offset;
			} 
		}
		else
		if (strlen(Buffer) == 32)
		{
			if (BinaryToMask(Buffer, &BinaryMask))
				return (ERR_BITMASK_MASK);
			else
			{
			   /* adjust cmd line for error message */
			   length=pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		       pcpb->cl_idx += length;

				BridgeStatus->BMElement[Index].BitMask.bm_mask = BinaryMask.BinMask;
				BridgeStatus->BMElement[Index].BitMask.bm_mtch = BinaryMask.BinValue;

				memcpy(BridgeStatus->BMElement[Index].ValueString, Buffer, sizeof(Buffer));
				BridgeStatus->BMElement[Index].BitMask.bm_ofst = Offset;

				printf ("Binary Mask: %08lX\n", BridgeStatus->BMElement[Index].BitMask.bm_mask);
				printf ("Binary Value: %08lX\n", BridgeStatus->BMElement[Index].BitMask.bm_mtch);
			}

		}
		else
			return (ERR_BITMASK_MASK);
	}
	else
		return (CMD_SYNTAX_ERR);

	if(pcpb->cmdlen > pcpb->cl_idx)
		return CMD_SYNTAX_ERR;
	SaveBStatus();            /* Record change in NVRAM */
	return (0);
}
/*	End BMDefine()	*/

/******************************************************************************/
						/*	Start DefineBrgContact()  */

DefineBrgContact( CPB_P pcpb ) {

	char Buffer[80];

	/* if no parameter is entered then clear the contact entry */
	if( pcpb->cl_idx >= pcpb->cmdlen )
		strcpy(Buffer, "NONE");
	else {
		pcpb->cl_idx;
	    sscanf(&pcpb->cmd[pcpb->cl_idx], "%[^\0]", Buffer);
	}
	if (strlen(Buffer) <= 20  )
	{
		strcpy(&BridgeStatus->Contact, Buffer);
	}
	else
		return (ERR_STR_TOO_LONG);

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End DefineBrgContact()  */

/******************************************************************************/
/* Start DefineBrgCfgFile() */
DefineBrgCfgFile( CPB_P pcpb ) {

	char Buffer[80],*kw;
	EEP_BOOT *eep;
	int kw_sz;

	memset(Buffer,0,80);
	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;


	/* if no parameter is entered then syntax error  */
	if( pcpb->cl_idx >= pcpb->cmdlen )
		return( CMD_SYNTAX_ERR );
	else {
		/*
		sscanf(&pcpb->cmd[pcpb->cl_idx], "%s", Buffer);
		strcpy(Buffer,&pcpb->cmd[pcpb->cl_idx]);
		*/
		kw_sz = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_SENSITIVE);
		strcpy(Buffer,kw);
		pcpb->cl_idx += kw_sz;
	}
	if (strlen(Buffer) <= 63  )
	{
		strcpy(&eep->eep_config_file, Buffer);
	}
	else
		return (ERR_STR_TOO_LONG);

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/
							/*	Start DefineBrgIPAddr()  */
DefineBrgIPAddr( CPB_P pcpb ) {

	uint retcode;
	int NumArgs = 0;
	char ipa[20];
	char Buffer[20];
	EEP_BOOT *eep;
	unsigned long address;
    int WasTelnet = FALSE;

	/* Get the IP parameter */
	sscanf(&pcpb->cmd[pcpb->cl_idx], "%s",  Buffer);
	pcpb->cl_idx += strlen(Buffer);
	
	if(strcmpi(Buffer,"NONE") != 0)
	{	
		retcode = GetIPAddress(&IPDevice[0], Buffer, &ipa);
		if( retcode )
			return(retcode);
		/* convert ip address from string to long */
		address = inet_addr(ipa);
	}
	else
		address = 0L;

	if(pcpb->cl_idx < pcpb->cmdlen)
		return CMD_SYNTAX_ERR;

	if (address == -1)  {
		return(ERR_IP_ADDRESS);
	}

	if( IsTelnetActive() ) {
		if( address == 0L ) {
		    printf("\nCannot clear IP Address while telnet session is active\n");
			return(0);
		}
		WasTelnet = TRUE;
	    CloseTelnet();
	}

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* Modify the ip address in the boot record */
	eep->eep_IP = address;

	/* Modify the working copy of the address */
	_initp->in_me = address;	

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	/*	K Kong	3.4.92
	 *	Set the IP in the adminbus 
	 */
	AdmSetIP(address);
	if( WasTelnet )
	    TelnetExit();
	return (0);
}
/*	End DefineBrgIPAddr()  */

#ifdef FRANKS
/******************************************************************************/
/*	Start DefineBrgIPRouter()  */
DefineBrgIPRouter( CPB_P pcpb ) {

	int IPNumber;
	int i, length;
	int NumArgs = 0;
	uint retcode;
	char Buffer[20];
	char ipa[20];
	char *kw;
	char *RouterAdr;
	unsigned long address;
	EEP_BOOT	*BootRec = &eep_boot_rec;


	/* Get the reset of the parameters */
	NumArgs = sscanf(&pcpb->cmd[pcpb->cl_idx], "%d%s", &IPNumber, Buffer);
	
	if ( NumArgs == 2 )
	{
		/* modify the command line pointer */
		/* this will cause the error msg to be correct */
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

		if (IPNumber >= 1 && IPNumber <= 2) {

		    pcpb->cl_idx += length;
			switch (IPNumber)
			{
				case 1:
					retcode = (GetIPAddress(&IPDevice[2], Buffer, &ipa));
					if( retcode )
							return(retcode);

					/* convert ip address from string to long */
					address = inet_addr(ipa);
					if (address == -1)  {
						return(ERR_IP_ADDRESS);
					}

					/* Modify the ip address in NVRAM */
					BridgeStatus->Routers[0] = address;

					/* Modify the working copy of the address */
					/* ??????? = address;	 */
					/*
					 *	K Kong	10.3.91
					 *	Save it in the eeprom.
					 */
					BootRec->eep_RouterIP[0] = address;
					SaveEepBoot();

					_initp->net_gway = address;
					_initp->gway1Metric = 0;
					/* Save the updated NVRAM record */
					SaveBStatus();
					/*
					 *	K Kong	3.5.92
					 *	Tell the adminbus driver that
					 *	the primary router adddress
					 *	has been changed.
					 */
					AdmSetRouter(address);
					break;

				case 2:
					retcode = (GetIPAddress(&IPDevice[3], Buffer, &ipa));
					if( retcode )
							return(retcode);

					/* convert ip address from string to long */
					address = inet_addr(ipa);
					if (address == -1)  {
						return(ERR_IP_ADDRESS);
					}

					/* Modify the ip address in NVRAM */
					BridgeStatus->Routers[1] = address;

					/* Modify the working copy of the address */
					/* ??????? = address;	 */
					/*
					 *	K Kong	10.3.91
					 *	Save it in the eeprom.
					 */
					BootRec->eep_RouterIP[1] = address;
					SaveEepBoot();

					_initp->net_gway2 = address;
					_initp->gway2Metric = 0;

					/* Save the updated NVRAM record */
					SaveBStatus();
					break;
			}
		}
		else
			return (OUT_OF_RANGE);
	}
	else
		return (ERR_IP_ADDRESS);

	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*  End DefineBrgIPRouter() */

#endif
/******************************************************************************/
           /*	Start DefineBrgPrimaryRouter()  */
DefineBrgPrimaryRouter( CPB_P pcpb ) {

	int IPNumber;
	int i, length;
	int NumArgs = 0;
	uint retcode;
	char Buffer[20];
	char ipa[20];
	char *kw;
	char *RouterAdr;
	unsigned long address;
	EEP_BOOT	*BootRec = &eep_boot_rec;


#ifdef 0
	/* Get the reset of the parameters */
	NumArgs = sscanf(&pcpb->cmd[pcpb->cl_idx], "%s", Buffer);
#endif
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += length;

	if(pcpb->cl_idx  < pcpb->cmdlen)
		return CMD_SYNTAX_ERR;
	
	if(strcmpi(kw,"NONE") == 0)
		address = 0L;
	else
	{
		strcpy(Buffer,kw);	
    		retcode = (GetIPAddress(&IPDevice[2], Buffer, &ipa));
		if( retcode )
			return(retcode);
	
		/* convert ip address from string to long */
		address = inet_addr(ipa);
		if (address == -1)  
			return(ERR_IP_ADDRESS);
	}

	/* Modify the ip address in NVRAM */
	BridgeStatus->Routers[0] = address;

	/* Modify the working copy of the address */
	/* ??????? = address;	 */
	/*
	 *	K Kong	10.3.91
	 *	Save it in the eeprom.
	 */
	BootRec->eep_RouterIP[0] = address;
	SaveEepBoot();

	_initp->net_gway = address;
	if(!address)
		_initp->gway1Metric = 16;
	else
		_initp->gway1Metric = 0;

	/* Save the updated NVRAM record */
	SaveBStatus();
	/*
	 *	K Kong	3.5.92
	 *	Tell the adminbus driver that
	 *	the primary router adddress
	 *	has been changed.
	 */
	AdmSetRouter(address);

	return (0);
}
/*  End DefineBrgPrimaryRouter() */

/******************************************************************************/
           /*	Start DefineBrgSecondaryRouter()  */
DefineBrgSecondaryRouter( CPB_P pcpb ) {

	int IPNumber;
	int i, length;
	int NumArgs = 0;
	uint retcode;
	char Buffer[20];
	char ipa[20];
	char *kw;
	char *RouterAdr;
	unsigned long address;
	EEP_BOOT	*BootRec = &eep_boot_rec;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += length;
		
	if(pcpb->cl_idx  < pcpb->cmdlen)
		return CMD_SYNTAX_ERR;
	
	if(strcmpi(kw,"NONE") == 0)
		address = 0L;
	else
	{
		strcpy(Buffer,kw);
		retcode = (GetIPAddress(&IPDevice[3], Buffer, &ipa));
		if( retcode )
			return(retcode);

		/* convert ip address from string to long */
		address = inet_addr(ipa);
		if (address == -1)  {
			return(ERR_IP_ADDRESS);
		}
	}

	/* Modify the ip address in NVRAM */
	BridgeStatus->Routers[1] = address;

	/* Modify the working copy of the address */
	/* ??????? = address;	 */
	/*
	 *	K Kong	10.3.91
	 *	Save it in the eeprom.
	 */
	BootRec->eep_RouterIP[1] = address;
	SaveEepBoot();

	_initp->net_gway2 = address;
	if(!address)
		_initp->gway2Metric = 16;
	else
		_initp->gway2Metric = 0;

	SaveBStatus();/* Save the updated NVRAM record */

	return (0);
}
/*  End DefineBrgSecondaryRouter() */
/******************************************************************************/
						/*	Start DefineBrgLocation()  */

DefineBrgLocation( CPB_P pcpb ) {

	char Buffer[80];

	/* if no parameter is entered then clear the contact entry */
	if( pcpb->cl_idx >= pcpb->cmdlen )
		strcpy(Buffer, "NONE");
	else {
		pcpb->cl_idx;
	    sscanf(&pcpb->cmd[pcpb->cl_idx], "%[^\0]", Buffer);
	}

	if (strlen(Buffer) <= 20  )
	{
		strcpy(&BridgeStatus->Location, Buffer);
	}
	else
		return (ERR_STR_TOO_LONG);

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End DefineBrgLocation()  */

/******************************************************************************/
						/*	Start DefineBrgName()  */

DefineBrgName( CPB_P pcpb ) {

	char Buffer[80];

	memset(Buffer, NULL, 80);

	/* if no parameter is entered then clear the contact entry */
	if( pcpb->cl_idx >= pcpb->cmdlen )
		strcpy(Buffer, "HLS 836");
	else {
		pcpb->cl_idx;
	    sscanf(&pcpb->cmd[pcpb->cl_idx], "%[^\0]", Buffer);
	}

	if (strlen(Buffer) <= 20  )
	{
		strcpy(&BridgeStatus->Name, Buffer);
	}
	else
		return (ERR_STR_TOO_LONG);

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End DefineNameBrg()  */

/******************************************************************************/
/*	Start DefineBrgNetMask()  */
DefineBrgNetMask( CPB_P pcpb )  {

	char ipa[20];
	char Buffer[20];
	uint retcode;
	EEP_BOOT *eep;
	unsigned long address;


	/* Get the IP parameter */
	sscanf(&pcpb->cmd[pcpb->cl_idx], "%s",  Buffer);
	pcpb->cl_idx += strlen(Buffer);

	if(strcmpi(Buffer,"NONE") != 0)
	{
		retcode = GetNetMask(&IPDevice[1], Buffer, &ipa);
		if( retcode )
			return(retcode);

		/* convert ip address from string to long */
		address = inet_addr(ipa);
	}
	else
		address = 0L;

	if(pcpb->cl_idx < pcpb->cmdlen)
		return CMD_SYNTAX_ERR;

	if (address == -1)  {
		return(ERR_IP_ADDRESS);
	}

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;
	/* (EEP_BOOT *) GetEeprom(EEP_BOOT_ADDR, sizeof(EEP_BOOT)); */

	/* Modify the ip address in the boot record */
	eep->eep_NetMask = address;

	/* Modify the working copy of the address */
	_initp->net_mask = address;	

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	/*	K Kong	3.4.92
	 *	Set the NetMask in the adminbus 
	 */
	AdmSetNetMask(address);
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End DefineBrgNetMask() */



/******************************************************************************/
                           /* Start DefineBrgRqstFile() */
DefineBrgRqstFile( CPB_P pcpb ) {

	char Buffer[80];
	EEP_BOOT *eep;

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* if no parameter is entered then set entry to null  */
	if( pcpb->cl_idx >= pcpb->cmdlen )
		memset(Buffer, NULL, 80);
	else {
		pcpb->cl_idx;
	    sscanf(&pcpb->cmd[pcpb->cl_idx], "%[^\0]", Buffer);
	}
	if (strlen(Buffer) <= 63  )
	{
		strcpy(&eep->eep_request_file, Buffer);
	}
	else
		return (ERR_STR_TOO_LONG);

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}
/* End DefineBrgRqstFile() */



/******************************************************************************/
/* Start DefineBrgSrvrIP() */
DefineBrgSrvrIP( CPB_P pcpb ) {

	char ipa[20];
	char Buffer[20];
	uint retcode;
	EEP_BOOT *eep;
	unsigned long address;


	/* Get the IP parameter */
	sscanf(&pcpb->cmd[pcpb->cl_idx], "%s",  Buffer);
	pcpb->cl_idx += strlen(Buffer);
	
	if(strcmpi(Buffer,"NONE") != 0)
	{	
		retcode = GetIPAddress(&IPDevice[1], Buffer, &ipa);
		if( retcode )
			return(retcode);

		/* convert ip address from string to long */
		address = inet_addr(ipa);
	}
	else
		address = 0L;

	if(pcpb->cl_idx < pcpb->cmdlen)
		return CMD_SYNTAX_ERR;
	if (address == -1)  {
		return(ERR_IP_ADDRESS);
	}

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* Modify the ip address in the boot record */
	eep->eep_ServerIP = address;

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/
			/* Start DefineBrgStpMode() */
DefineBrgStpMode( CPB_P pcpb )  {

	PRCCTL *prcctl = &prc;
	uint length;
	char *kw;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	/* If enabling or disabling the spanning tree mode */

	if( strncmp(kw, "DISABLE",strlen(kw)) == 0 ) {

		/* Remove the STP address from the working database so that       */
		/* when the stp mode is disabled, BPDU packets will be forwarded  */
		/* as normal packets instead of being sent up the protocol stack  */
		/* Remove the STP address only if STP mode was previously enabled */
		if(BridgeStatus->StpMode != STP_MODE_DISABLE)
		    DelStpAddr();

		prcctl->Prc_StpMode   = (byte)STP_MODE_DISABLE;
		BridgeStatus->StpMode  = STP_MODE_DISABLE;
		disable_stp();
	}
	else
	if( strncmp(kw, "ENABLE", strlen(kw)) == 0 ) {

		/* Add the STP address to the working database only if STP mode */
		/* was previously disabled.                                     */
		if(BridgeStatus->StpMode != STP_MODE_ENABLE)
		     AddStpAddr();

		prcctl->Prc_StpMode   = (byte)STP_MODE_ENABLE;
		BridgeStatus->StpMode  = STP_MODE_ENABLE;
		enable_stp();
	}
	else
		return( CMD_SYNTAX_ERR );

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}


/******************************************************************************/
						/*	Start DefineBrgSymbolic()  */
DefineBrgSymbolic( CPB_P pcpb )  {

	unsigned int Miscellaneous;
	uint length;
	char *kw;

	/* Get argument to symbolic command */
	length = pick_a_kw( &pcpb->cmd[pcpb->cl_idx], &kw, CASE_INSENSITIVE );

	if (strncmp("ENABLE", kw, strlen(kw)) == 0)
	{
		Miscellaneous = SYMBOLIC;	/*	Symbolic interpretation alloc bit  */
		SetBitOrNot(&Miscellaneous, ENABL, &BridgeStatus->Miscellaneous);
	}
	else
	if	(strncmp("DISABLE", kw, strlen(kw)) == 0)
	{
		Miscellaneous = SYMBOLIC;	/*	Symbolic interpretation alloc bit  */
		SetBitOrNot(&Miscellaneous, DISABL, &BridgeStatus->Miscellaneous);
	}
	else
		return ( CMD_SYNTAX_ERR );

	SaveBStatus();			/* Record Change in NVRAM */
	pcpb->cl_idx += length;
	return (0);
}
 /*  End DefineBrgSymbolic()  */

/******************************************************************************/
                         /* Start DefineBrgTimeOut() */
DefineBrgTimeOut( CPB_P pcpb ) {

    uint length;
	int timeout;
	char *kw;


	/* Get argument to symbolic command */
	length = pick_a_kw( &pcpb->cmd[pcpb->cl_idx], &kw, CASE_INSENSITIVE );

	if (!atod(kw, &timeout))
		return (CMD_SYNTAX_ERR);

    if( timeout < 0 || timeout > 60 )
		return( OUT_OF_RANGE );
	else
	if( timeout == 0 ) {
		BridgeStatus->TimeOut = timeout;
		StopTimer(&InactivityTimer);
	}
    else {
		BridgeStatus->TimeOut = timeout;
    }

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}

/************************************************************************/ 

DefinePort( CPB_P pcpb )  {

	uint Length = 0;
	uint RetCode;
	extern uint Ports;      /* Global Variable */
	char *CmdLine = &pcpb->cmd[pcpb->cl_idx];

	/* Get the port list from the command line and store it */
	RetCode = PortList( &CmdLine, &Ports, &Length );

	if(RetCode) {
	    return(RetCode);
	}

	/* Adjust the command line pointer */
	pcpb->cl_idx += Length;
	return(0);
}

/****************************************************************************/ 

DefinePortBlock( CPB_P pcpb ) {

	extern uint BlockPermit;  /* Global Variable */

	BlockPermit = BLOCK;
	return(0);
}

/****************************************************************************/ 

DefinePortPermit( CPB_P pcpb ) {

	extern uint BlockPermit;  /* Global Variable */

	BlockPermit = PERMIT;
	return(0);
}

/****************************************************************************/ 

DefinePrtProt( CPB_P pcpb ) {

	extern uint BlockPermit;
	uint retval = 0;

	if( BlockPermit == BLOCK )
		retval = Block( pcpb, Ports );
	else
	if( BlockPermit == PERMIT )
		retval = Permit( pcpb, Ports );
	else			
		return(0);

	pcpb->cl_idx = pcpb->cmdlen;
	return(retval);
}

/****************************************************************************/ 

DefinePrtBitmask( CPB_P pcpb ) {

	extern uint BlockPermit;
	uint        retcode = 0;

	if( BlockPermit == BLOCK )
		retcode = BMExpression( pcpb, Ports );
	else
	if( BlockPermit == PERMIT )
		retcode = BMExpression( pcpb, Ports );
	else			
		return(retcode);

	return(retcode);
}

/****************************************************************************/ 
						/*	Start BMExpression()  */
BMExpression( CPB_P pcpb, uint PortMask )  {

	PRCCTL *prcctl = &prc;
	unsigned char ExpressionBuffer[BMFOLEN];
	unsigned char ReversePolish[BMFOLEN];
	uint          FunctReturnCode, i;
	byte          cmdptr;

	memset(&ExpressionBuffer, NULL, sizeof(ExpressionBuffer));
	memset(&ReversePolish, NULL, sizeof(ReversePolish));

	cmdptr = pcpb->cl_idx; 
	FunctReturnCode = RemoveBlank(&ExpressionBuffer, &pcpb->cmd[pcpb->cl_idx]);
    
	if(FunctReturnCode) {
		pcpb->cl_idx = cmdptr; 
		return(FunctReturnCode);
	}

	FunctReturnCode = ParseExpression(&ReversePolish, &ExpressionBuffer);

	if(FunctReturnCode) {
		pcpb->cl_idx = cmdptr; 
		return(FunctReturnCode);
	}

	if ( BlockPermit == PERMIT )
	{
		for (i = 1; i <= MAXPORTBIT; i <<= 1)
		{
			if (i & PortMask)
			{
				switch (i)
				{
					case PORT1:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[0].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[0], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[0].BMMode = PERMIT;
						prcctl->Prc_BitMskFltMode           |= (byte)PORT1; 
						prcctl->Prc_BitMskFlt               |= (byte)PORT1;
						break;

					case PORT2:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[1].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[1], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[1].BMMode = PERMIT;
						prcctl->Prc_BitMskFltMode           |= (byte)PORT2;
						prcctl->Prc_BitMskFlt               |= (byte)PORT2;
						break;

					case PORT3:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[2].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[2], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[2].BMMode = PERMIT;
						prcctl->Prc_BitMskFltMode           |= (byte)PORT3;
						prcctl->Prc_BitMskFlt               |= (byte)PORT3;
						break;

					case PORT4:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[3].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[3], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[3].BMMode = PERMIT;
						prcctl->Prc_BitMskFltMode           |= (byte)PORT4;
						prcctl->Prc_BitMskFlt               |= (byte)PORT4;
						break;

					case PORT5:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[4].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[4], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[4].BMMode = PERMIT;
						prcctl->Prc_BitMskFltMode           |= (byte)PORT5;
						prcctl->Prc_BitMskFlt               |= (byte)PORT5;
						break;
				}
			}
		}
	}
	else
	if ( BlockPermit == BLOCK )
	{
		for (i = 1; i <= MAXPORTBIT; i <<= 1)
		{
			if (i & PortMask)
			{
				switch (i)
				{
					case PORT1:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[0].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[0], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[0].BMMode = BLOCK;
						prcctl->Prc_BitMskFltMode           &= (byte)MASKPORT1;
						prcctl->Prc_BitMskFlt               |= (byte)PORT1;
						break;

					case PORT2:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[1].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[1], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[1].BMMode = BLOCK;
						prcctl->Prc_BitMskFltMode           &= (byte)MASKPORT2;
						prcctl->Prc_BitMskFlt               |= (byte)PORT2;
						break;

					case PORT3:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[2].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[2], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[2].BMMode = BLOCK;
						prcctl->Prc_BitMskFltMode           &= (byte)MASKPORT3;
						prcctl->Prc_BitMskFlt               |= (byte)PORT3;
						break;

					case PORT4:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[3].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[3], NULL, 
													  sizeof(BMEXPRESSION));
						BridgeStatus->BMExpression[3].BMMode = BLOCK;
						prcctl->Prc_BitMskFltMode           &= (byte)MASKPORT4;
						prcctl->Prc_BitMskFlt               |= (byte)PORT4;
						break;

					case PORT5:
						DecrementDefinition(
							  &BridgeStatus->BMExpression[4].BMExpRevPolish);
						memset(&BridgeStatus->BMExpression[4], NULL, 
													  sizeof(BMEXPRESSION));
						
						BridgeStatus->BMExpression[4].BMMode = BLOCK;
						prcctl->Prc_BitMskFltMode           &= (byte)MASKPORT5;
						prcctl->Prc_BitMskFlt               |= (byte)PORT5;
						break;
				}
			}
		}
	}
	else
		return (CMD_SYNTAX_ERR);

	/* Set the expression */

	strupr(ExpressionBuffer);/* Convert the input expr buf to uppercase  */

	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		if (i & PortMask)
		{
			switch (i)
			{
				case PORT1:
					memcpy(&BridgeStatus->BMExpression[0].BMExpRevPolish, &ReversePolish, sizeof(ReversePolish));
					memcpy(&BridgeStatus->BMExpression[0].BMExpString, &ExpressionBuffer, sizeof(ExpressionBuffer));
					IncrementDefinition(&BridgeStatus->BMExpression[0].BMExpRevPolish);
					memcpy(&prcctl->Prc_BitMskFltExp[0], &ReversePolish, sizeof(ReversePolish));
					break;

				case PORT2:
					memcpy(&BridgeStatus->BMExpression[1].BMExpRevPolish, &ReversePolish, sizeof(ReversePolish));
					memcpy(&BridgeStatus->BMExpression[1].BMExpString, &ExpressionBuffer, sizeof(ExpressionBuffer));
					IncrementDefinition(&BridgeStatus->BMExpression[1].BMExpRevPolish);
					memcpy(&prcctl->Prc_BitMskFltExp[1], &ReversePolish, sizeof(ReversePolish));
					break;

				case PORT3:
					memcpy(&BridgeStatus->BMExpression[2].BMExpRevPolish, &ReversePolish, sizeof(ReversePolish));
					memcpy(&BridgeStatus->BMExpression[2].BMExpString, &ExpressionBuffer, sizeof(ExpressionBuffer));
					IncrementDefinition(&BridgeStatus->BMExpression[2].BMExpRevPolish);
					memcpy(&prcctl->Prc_BitMskFltExp[2], &ReversePolish, sizeof(ReversePolish));
					break;

				case PORT4:
					memcpy(&BridgeStatus->BMExpression[3].BMExpRevPolish, &ReversePolish, sizeof(ReversePolish));
					memcpy(&BridgeStatus->BMExpression[3].BMExpString, &ExpressionBuffer, sizeof(ExpressionBuffer));
					IncrementDefinition(&BridgeStatus->BMExpression[3].BMExpRevPolish);
					memcpy(&prcctl->Prc_BitMskFltExp[3], &ReversePolish, sizeof(ReversePolish));
					break;

				case PORT5:
					memcpy(&BridgeStatus->BMExpression[4].BMExpRevPolish, &ReversePolish, sizeof(ReversePolish));
					memcpy(&BridgeStatus->BMExpression[4].BMExpString, &ExpressionBuffer, sizeof(ExpressionBuffer));
					IncrementDefinition(&BridgeStatus->BMExpression[4].BMExpRevPolish);
					memcpy(&prcctl->Prc_BitMskFltExp[4], &ReversePolish, sizeof(ReversePolish));
					break;
			}
		}
	}
	
	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/*	End BMExpression()	*/



/******************************************************************************/
						/*	Start DefinePortLearn()  */
DefinePortLearn( CPB_P pcpb )  {

	PRCCTL *prcctl = &prc;
	uint RetCode = 0;
	uint PortMask = Ports;   /* Ports is a global variable */
	uint length;
	char *state;


	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);

	/* Check the syntax of the argument to the port state command */
	if( strncmp( state, "ENABLE" , strlen(state)) != 0 &&
		strncmp( state, "DISABLE", strlen(state)) != 0 )
			return( CMD_SYNTAX_ERR );

	
	else {
		/* NVRAM structure */
		RetCode = SetPortList(state, &BridgeStatus->Learning,
								 "DISABLE", "ENABLE", PortMask);
		if( RetCode )
			return( RetCode );

		/* DRAM control structure */
		RetCode = SetPrcPortList(state, &prcctl->Prc_Learning,
								 "DISABLE", "ENABLE", (byte)PortMask);

		if( RetCode )
			return( RetCode );
	}

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx += length;
	return (0);
}
/*	End DefinePortLearn()	*/

/******************************************************************************/
/*	Start DefinePortPacSize()  */
DefinePortPacSize( CPB_P pcpb )  {

	PRCCTL *prcctl = &prc;
	uint RetCode = 0;
	uint PortMask = Ports;   /* Ports is a global variable */
	uint i;
	uint length;
	uint PortNum;
	char *state;

	
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);

	/* Check the syntax of the argument to the port state command */
	if( strlen(state) < 4 || 
		(strcmpi( state, "EXTENDED") != 0 &&
		strcmpi( state, "STANDARD") != 0 ))
			return( CMD_SYNTAX_ERR );

	else
	{
		/* Set the min and max packet sizes in the prcctl struct */
		RetCode =  (SetPrcPortList(state, &prcctl->Prc_PacketSize,
										"STANDARD","EXTENDED", (byte)PortMask));
		if(RetCode) 
			return(RetCode);

		/* Set bit in NVRAM status for display and storage purposes */
		RetCode =  (SetPortList(state, &BridgeStatus->PacketSize,
										"STANDARD", "EXTENDED", PortMask));
		if(RetCode) 
			return(RetCode);
		SaveBStatus();            /* Record change in NVRAM */
		pcpb->cl_idx += length;
	}
	return (RetCode);
}
/*	End DefinePortPacSize()	*/


/******************************************************************************/
					/*	Start DefinePortRestrict()  */
DefinePortRestrict( CPB_P pcpb )  {

	PRCCTL *prcctl = &prc;
	uint RetCode;
	uint PortMask = Ports;   /* Ports is a global variable */
	uint i;
	int length;
	uint PortNum;
	char *state,*tstate;
	int	 temp;

	
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);
	temp = pcpb->cl_idx;
	temp += length;
	temp += pick_a_kw(&pcpb->cmd[temp],&tstate,CASE_INSENSITIVE);

	if(pcpb->cmdlen > temp)
	{
		temp += pick_a_kw(&pcpb->cmd[temp],&tstate,CASE_INSENSITIVE);
		pcpb->cl_idx = temp;
		return CMD_SYNTAX_ERR;
	}

	/* Check the syntax of the argument to the port state command */
	if( strcmpi( state, "ENABLE"  )== 0 )
	{
		pcpb->cl_idx += length; 
		RetCode = SetRestrict(&pcpb->cmd[pcpb->cl_idx], FILTER, PortMask);
	}
	else if ( strcmpi( state, "DISABLE" ) == 0 )
	{
		pcpb->cl_idx += length; 
		RetCode = SetRestrict(&pcpb->cmd[pcpb->cl_idx], FORWARD, PortMask);

	}
	else
			return( CMD_SYNTAX_ERR );

	if( RetCode )
			return( RetCode );
	
    
	/* Record change in NVRAM */
	SaveBStatus();				     
	pcpb->cl_idx = pcpb->cmdlen;
	return( RetCode );
}
/*	End DefinePortRestrict()	*/


/****************************************************************************/ 
						/*	Start DefinePortState()  */
DefinePortState( CPB_P pcpb )  {

	PRCCTL *prcctl = &prc;
	uint RetCode = 0;
	uint PortMask = Ports;   /* Ports is a global variable */
	byte i;
	uint length;
	uint PortNum;
	char *state;

	
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);

	/* Check the syntax of the argument to the port state command */
	if( strcmpi( state, "ENABLE") == 0 )  {

	   LedsOn(PortMask);
    }
	else
	if( strcmpi( state, "DISABLE") == 0 )
	   LedsOff(PortMask);
	else
	   return( CMD_SYNTAX_ERR );

	{
		/* Set port state for none spanning tree operation */
		RetCode = (SetPortList(state, &BridgeStatus->PortState, "DISABLE",
					"ENABLE", PortMask));
		RetCode = (SetPrcPortList(state, &prcctl->Prc_PortState, "DISABLE",
				 	"ENABLE", (byte)PortMask));

		/* Set port state for spanning tree */
		if( prcctl->Prc_StpMode == (byte)STP_MODE_ENABLE )   {
			for( i=1, PortNum=1; i <= MAXPORTBIT; i<<=1, PortNum++ ) 
				if( i & (byte)PortMask ) 
					if( i & prcctl->Prc_PortState ) 
						enable_port( PortNum );
					else
						disable_port( PortNum );
	    }
	    SaveBStatus();            /* Record change in NVRAM */
	}

	pcpb->cl_idx += length;
	return (RetCode);
}
/*	End DefinePortState()  */


/******************************************************************************/

						/*	Start DefinePortThrshld()  */
DefinePortThrshld( CPB_P pcpb )  {

	uint RetCode;
	uint PortMask = Ports;   /* Ports is a global variable */
	uint length;
	char *state;


	/*
	RetCode = SetThreshhold(&pcpb->cmd[pcpb->cl_idx], "transmit", "receive", 
							PortMask);
	if( RetCode )
		return( RetCode );
	*/

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);
	pcpb->cl_idx += length;

	/* Check the syntax of the argument to the port state command */
	if( strncmp( state, "TRANSMIT" , 3) != 0 &&
		strncmp( state, "RECEIVE", 3) != 0 )
			return( CMD_SYNTAX_ERR );

	if( strncmp( state, "TRANSMIT", 3 ) == 0 ) {

		printf("\nFeature Has Not Been Implemented.\n");
		pcpb->cl_idx = pcpb->cmdlen;
		return(0);
	}
		
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);
	pcpb->cl_idx += length;

	/* Check the syntax of the argument to the port state command */
	if( strncmp( state, "ENABLE" , 6) != 0 &&
		strncmp( state, "DISABLE", 7) != 0 )
			return( CMD_SYNTAX_ERR );

	else {

		/* Set port state for none spanning tree operation */
		RetCode = (SetPortList(state, &BridgeStatus->RxThreshhold, "DISABLE",
					"ENABLE", PortMask));

		/* Enable/Disable the Rx Threshhold in the channel driver */
		if( strncmp(state, "ENABLE", 6) == 0 )
		    SetRxThreshhold(PortMask);
		else
		    ClearRxThreshhold(PortMask);
    }

	pcpb->cl_idx = pcpb->cmdlen;
	SaveBStatus();			/* Record Change in NVRAM */
	return (0);
}
/*	End Threshhold()  */


/******************************************************************************/
						/*	Start DefinePortUnkMCast()  */
DefinePortUnkMCast( CPB_P pcpb ) {
 
	PRCCTL *prcctl = &prc;
	uint RetCode;
	uint PortMask = Ports;   /* Ports is a global variable */
	uint length;
	char *state;

	
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);

	/* Check the syntax of the argument to the port state command */
	if( strlen(state) < 2 && strncmp( state, "FILTER", strlen(state)) != 0 
		&& strncmp( state, "FORWARD", strlen(state)) != 0 )
		
			return( CMD_SYNTAX_ERR );

	else {
	
		RetCode = SetPortList(state, &BridgeStatus->UnkMCast,
							  "FORWARD", "FILTER", PortMask);
		if( RetCode )
			return( RetCode );

		RetCode = SetPrcPortList(state, &prcctl->Prc_UnknMcast,
							  "FORWARD", "FILTER", (byte)PortMask); 
		if( RetCode )
			return( RetCode );
	}

	pcpb->cl_idx += length;
	SaveBStatus();			/* Record Change in NVRAM */
	return (0);
}
/*	End DefinePortUnkMCast()	*/



/******************************************************************************/
					/*	Start DefinePortUnkUCast()  */
DefinePortUnkUCast( CPB_P pcpb ) {

	PRCCTL *prcctl = &prc;
	uint RetCode;
	uint PortMask = Ports;   /* Ports is a global variable */
	uint length;
	char *state;

	
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&state,CASE_INSENSITIVE);

	/* Check the syntax of the argument to the port state command */
	if( strncmp( state, "FILTER" , 2) != 0 &&
		strncmp( state, "FORWARD", 2) != 0 )
			return( CMD_SYNTAX_ERR );

	else {

		RetCode = SetPortList(state, &BridgeStatus->UnkUCast,
							  "FORWARD", "FILTER", PortMask);
		if( RetCode )
			return( RetCode );

		RetCode = SetPrcPortList(state, &prcctl->Prc_UnknUcast,
							  "FORWARD", "FILTER", (byte)PortMask); 
		if( RetCode )
			return( RetCode );
	}

	pcpb->cl_idx += length;
	SaveBStatus();			/* Record Change in NVRAM */
	return (0);
}
/*	End DefinePortUnkUCast()	*/


/******************************************************************************/
					/*	Start DefineBrgTerminal()  */
DefineBrgTerminal( CPB_P pcpb ) {

	char *kw;
	uint length;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( strcmpi( kw, "ENABLE") == 0 )
		BridgeStatus->TermType = VT100;
	else if( strcmpi( kw, "DISABLE") == 0 )
		BridgeStatus->TermType = NONVT100;
	else
		return KW_UN_AMB;

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}
