/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834stpcmd.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/834stpcmd.c_v  $
 * 
 *    Rev 1.1   06 Aug 1993 14:48:28   vinay
 * put the fddi path cost
 * 
 *    Rev 1.0   04 May 1993 16:03:54   franks
 * Initial revision.
 * 
 *    Rev 1.4   04 May 1992 12:16:30   franks
 * No change.
 * 
 *    Rev 1.3   17 Apr 1992 16:17:50   franks
 * No change.
 * 
 *    Rev 1.2   16 Apr 1992 14:46:58   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:07:08   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:48:10   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/

#include <types.h>
#include <target.h>
#include <krnl.h>
#include <netbuf.h>
#include <prcctl.h>
#include <bridges.h>
#include <stp.h>
#include <nvrecs.h>
#include <cpb.h>
#include <834error.h>


extern NVR_BSTATUS *BridgeStatus;
extern PRCCTL prc;

/* structure to describe each spanning tree parameter */
struct parm
{
	char*		p_sptr;	/* ptr to parameter string */
	int		p_cnt;	/* min no. of characters for a match */
	int		p_id;	/* parameter identifier    */
	unsigned int	p_min;	/* min allowed value       */
	unsigned int	p_max;	/* max allowed value       */
};

/* Parameter identifiers */
#define	DEFAULT			1
#define	STATE0			2
#define	STATE1			3
#define	PRIORITY0		4
#define	PRIORITY1		5
#define PATHCOST0		6
#define PATHCOST1		7
#define HELLOTIME		8
#define LIFETIME		9
#define FORWARDDELAY	10
#define	BRIDGEPRIORITY	11

#define	STATE2			12
#define	STATE3			13
#define	PRIORITY2		14
#define	PRIORITY3		15
#define PATHCOST2		16
#define PATHCOST3		17

static struct parm parmlist[] =
{
	"default",			7,	DEFAULT,		0,	0,
	"priority1",		9,	PRIORITY0,		0,	255,	/* range: 0 to 255 */
	"priority2",		9,	PRIORITY1,		0,	255,	/* range: 0 to 255 */
	"priority3",		9,	PRIORITY2,		0,	255,	/* range: 0 to 255 */
	"priority4",		9,	PRIORITY3,		0,	255,	/* range: 0 to 255 */
	"pathcost1",		9,	PATHCOST0,		1,	65535,	/* range: 1 to 65535 */
	"pathcost2",		9,	PATHCOST1,		1,	65535,	/* range: 1 to 65535 */
	"pathcost3",		9,	PATHCOST2,		1,	65535,	/* range: 1 to 65535 */
	"pathcost4",		9,	PATHCOST3,		1,	65535,	/* range: 1 to 65535 */
	"hellotime",		1,	HELLOTIME,		1,	10,		/* range: 1 to 10	 */
	"lifetime",		1,	LIFETIME,		6,	40,		/* range: 6 to 40	 */
	"forwarddelay",		1,	FORWARDDELAY,	4,	30,		/* range: 4 to 30 	 */
	"bridgepriority", 	1,  BRIDGEPRIORITY,	0,	65535,	/* range: 0 to 65535 */
};
#define	N_PARMS	(sizeof(parmlist) / sizeof(struct parm))


/*****************************************************************************/



char UnixSpanTreeText[]=
"Form:    %s\n"
"Usage:   Set/Display spanning tree parameters.\n\n"
"\t\t PARAMETER              VALUE RANGE\n\n"
"\t\t mode                   enable, disable\n"
"\t\t priorityX              0-255   (dec)\n"
"\t\t pathcostX              1-65535 (dec)\n"
"\t\t hellotime              1-10    (sec)\n"
"\t\t lifetime               6-40    (sec)\n"
"\t\t forwardelay            4-30    (sec)\n"
"\t\t bridgepriority         0-65535 (dec)\n\n"
"\t\t NOTE: X = Port Number.\n\n"
"Example: %s-> sp mode=enable\n"
"\t\t Places the bridge into the spanning tree mode.\n";


/*****************************************************************************/
/* -------------------------------------------------------------*
 *  EDIT TRACK OF This Routine :     STP_dft_rst                *
 * -------------------------------------------------------------*
 *  This routine is called from application if system is mixed  *
 *  up and won't talk to TBC, so user could bring sytem back to *
 *  default & normal situiation.                                *
 * ------------------------------------------------------------ */
STP_dft_rst()

	{ 
	int	port;

	/* default hello time is 2 seconds */
	SetHelloTime(DEFAULT_HELLO_TIME);
	BridgeStatus->HelloTime = DEFAULT_HELLO_TIME;

	/* default max age is 20 seconds */
	SetMaxAge(DEFAULT_MAX_AGE); 
	BridgeStatus->MaxAge = DEFAULT_MAX_AGE;

	/* default forward delay is 15 seconds */
	SetForwardDelay(DEFAULT_FORWARD_DELAY); 
	BridgeStatus->ForwardDelay = DEFAULT_FORWARD_DELAY;

	set_bridge_priority(Stanley_priority);
	BridgeStatus->BridgePriority = Stanley_priority;
	for (port = One; port < NumberOfStpPorts ; port++)
		{
		BridgeStatus->priority[port-1] = DEFAULT_PORT_PRIORITY;
		BridgeStatus->PathCost[port-1] = Ethernet10_pathcost;
		set_port_priority(port, DEFAULT_PORT_PRIORITY);
		set_path_cost(port, Ethernet10_pathcost);
		}
	BridgeStatus->priority[port-1] = DEFAULT_PORT_PRIORITY;
	BridgeStatus->PathCost[port-1] = Fddi_pathcost;
	set_port_priority(port, DEFAULT_PORT_PRIORITY);
	set_path_cost(port, Fddi_pathcost);
		
	SaveBStatus();
	}



char *PortMode2Name[] =
	{
	"STP",
	"DISABLED",
	"ENABLED",
	""
	};

char *PortState2Name[] = {
	"ST-DIS",
	"ST-LIS",
	"ST-LER",
	"ST-FWD",
	"ST-BLK",
	""
};

/******************************************************************************/
/*  Start PrintPortState() */
void PrintPortState() {

	PRCCTL *prcctl = &prc;
	uint mode;
	uint state;
	uint port_no;

		for (port_no = 0; port_no < NumberOfStpPorts; port_no++) {
			
			mode = (uint)prcctl->Prc_StpMode; 
			if( mode == STP_MODE_ENABLE ) {
				state = (uint)prcctl->Prc_PortStpState[port_no];
				printf("%-11s", PortState2Name[state]);	
			}
			else {
				PrintPrcBitSetOrNot(&prcctl->Prc_PortState,
				"FORWARD", "DISABLE");
				break;
			}
		}
}

/******************************************************************************/
DefineStpBrgPriority( CPB_P pcpb ) {

	char *kw;
	uint length;
	uint value;

	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value); 
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( value > 0 && value <= 65535 ) {

		BridgeStatus->BridgePriority = value;
		set_bridge_priority(value);
	}
	else
		return( OUT_OF_RANGE );

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}

/******************************************************************************/
DefineStpForward( CPB_P pcpb ) {

	char *kw;
	uint length;
	uint value;

	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value); 
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( value >= 4 && value <= 30 ) {

		BridgeStatus->ForwardDelay = value;
		SetForwardDelay(value);
	}
	else
		return( OUT_OF_RANGE );

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}
/******************************************************************************/
						/* Start DefineStpHello() */
DefineStpHello( CPB_P pcpb ) {

	char *kw;
	uint length;
	uint value;

	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value); 
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( value >= 1 && value <= 10 ) {

		BridgeStatus->HelloTime = value;
		SetHelloTime(value);
	}
	else
		return( OUT_OF_RANGE ); 

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}

/******************************************************************************/
						/* Start DefineStpLifeTime() */
DefineStpLifeTime( CPB_P pcpb ) {

	char *kw;
	uint length;
	uint value;

	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value); 
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( value >= 6 && value <= 40 ) {

		BridgeStatus->MaxAge = value;
		SetMaxAge(value);
	}
	else
		return( OUT_OF_RANGE );

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}
/******************************************************************************/
						/* Start DefineStpPathCost() */
DefineStpPathCost( CPB_P pcpb ) {

	uint PortNum;
	uint PortMask;
	uint length;
	uint RetCode;
	uint value;
	uint i;
	char *CmdLine;
	char *kw;

	/* Get the pathcost value */
	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value); 
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( value < 1 || value > 65535 ) 
		return( OUT_OF_RANGE );
	else
		pcpb->cl_idx += length;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if( strncmp(kw, "PORT", 2) != 0 )
		return( CMD_SYNTAX_ERR );
	else
		pcpb->cl_idx += length;

	/* Get the port list from the ecommand line */
	CmdLine = &pcpb->cmd[pcpb->cl_idx];
	RetCode = PortList( &CmdLine, &PortMask, &length );
	if( RetCode )
		return( RetCode );
	else
		pcpb->cl_idx += length;

	for( i=1, PortNum=1; i <= MAXPORTBIT; i <<= 1, PortNum++ ) {

		if( i & PortMask ) {
			
			BridgeStatus->PathCost[PortNum-1] = value;
			set_path_cost(PortNum, value);
		}
	}

	SaveBStatus();
	return(0);
}

/******************************************************************************/
						/* Start DefineStpPortPriority() */
DefineStpPortPriority( CPB_P pcpb ) {

	uint PortNum;
	uint PortMask;
	uint length;
	uint RetCode;
	int value;
	uint i;
	char *CmdLine;
	char *kw;

	/* Get the pathcost value */
	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value); 
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( value < 0 || value > 255 ) 
		return( OUT_OF_RANGE );
	else
		pcpb->cl_idx += length;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	if( strncmp(kw, "PORT", 2) != 0 )
		return( CMD_SYNTAX_ERR );
	else
		pcpb->cl_idx += length;

	/* Get the port list from the ecommand line */
	CmdLine = &pcpb->cmd[pcpb->cl_idx];
	RetCode = PortList( &CmdLine, &PortMask, &length );
	if( RetCode )
		return( RetCode );
	else
		pcpb->cl_idx += length;

	for( i=1, PortNum=1; i <= MAXPORTBIT; i <<= 1, PortNum++ ) {

		if( i & PortMask ) {
			
			BridgeStatus->priority[PortNum-1] = value;
			set_port_priority(PortNum, value);
		}
	}

	SaveBStatus();
	return(0);
}

