#include <types.h>
#include <target.h>
#include <krnl.h>
#include <ascii.h>
#include <param.h>
#include <834parser.h>
#include <cpb.h>
#include <834error.h>
#include <smtmacro.h>
#include <smtdefs.h>

#ifdef vinay
#include <cmd_stri.h>
#include <cmd_tbl.h>

extern char *status_h[];
extern char *riro_parm[];

byte mask_tbl[] = {0x1f,0x3f,0x7f,0xff};
#endif

/*********************************************************
**
**   find_delimeter
**
**    find the specified delimeter in the given string
**    and return number of the delimeter found in the
**    string.
**
**********************************************************/

find_delimeter(s,c)
char s[];
char c;
{

   int i;
   int count=0;

	for(i=0;;i++)
	{
		if(s[i] == 0)
			return count;
		if(s[i] == c)
			count++;
	}
}

/*************************************************************************
**
**	verify_timer_input 
**	verifies the timer value is specified in seconds, msecs, microsecs
**	if no units are specified it will be in FDDI time
**
*************************************************************************/
#define MAX_TIMER_VAL_IN_MICROSECS 	171798691L
#define MAX_TIMER_VAL_IN_MILLISECS 	171798
#define MAX_TIMER_VAL_IN_SECS		171
#define MIN_TIMER_VAL 			0
#define MAX_TIMER_VAL			2147483647L

int verify_timer_input( kw, num)
char *kw;
uint  *num;
{
char *tempkw;
uint timer_value,val, f;
char b;
int  i;

    f = sscanf(kw, "%ld%c", &timer_value, &b);

    if ( f != 1 && f != 2 )
        return -1;

    if ( f == 1)
    {
		if (timer_value > MAX_TIMER_VAL)
			return -1;
        *num = timer_value;
        return 0;
    }

    if  ( f == 2 )
        if  ( b != 'u' && b != 'm' &&  b != 'U' &&  b != 'M'
                    && b != 's' &&   b!= 'S')
            return -1;


	if(b == 'u' || b == 'U')
		if(timer_value > MAX_TIMER_VAL_IN_MICROSECS)
			return -1;


    /* convert from msecs to fdditime */
    if ( b == 'm' || b == 'M' )
	{
		if(timer_value > MAX_TIMER_VAL_IN_MILLISECS)
			return -1;
	
        	timer_value  = timer_value * 1000;
	}

    /* convert from secs to fdditime */
    if ( b == 's' || b == 'S' )
        timer_value  = timer_value * 1000000L;

    timer_value  =  MUsecs2Fddi(timer_value);
    *num = timer_value;

    return 0;
}

/*****************************************************************************
**
**	chk_parm()
**	
******************************************************************************/
chk_parm(argvp,parmp)
char *argvp;
char *parmp[];
{
        int i;
        int     val,found;

        found = 0;
        for(i=0; parmp[i] != 0; i++)
        {

                if(strcmpi(argvp,parmp[i]) == 0)
                {
                        if(strlen(argvp) == strlen(parmp[i]))
                                return(i);
                        if(found)
                                return(-1);
                        found = 1;
                        val = i;
                }
        }
        if(found)
                return(val);
        return (-1);
}

/*****************************************************************************
**
**	validPort()
**	checks if the specified port is valid
**
*****************************************************************************/
validPort(kw)
char *kw;
{
	if((*kw == 'A' || *kw == 'a') && strlen(kw) < 2)
		return 1;

	if((*kw == 'B' || *kw == 'b') && strlen(kw) < 2)
		return 2;

	return -1;
}

interpret_name(kw,kw_sz,phy)
char    *kw;
int     kw_sz;
unsigned char phy[];
{
        char    * tmp2;
        char    tmp1[10];
        int     len;
        int     i;
        int     dot=0;
	extern char *company_name[];

        if ((dot=find_delimeter(kw,'.'))==0)
            return INV_PHY_ADDR;

        tmp2=kw;
        for (i=0;i<kw_sz;i++,tmp2++) {
            if (*tmp2 != '.')
                tmp1[i]=*tmp2;
            else {
                dot=1;
                break;
            }
        }
        tmp1[i]='\0';

        if (dot==0)
            return(INV_PHY_ADDR);

        i = chk_complete_parm(tmp1,company_name);

        switch (i) {
            case 0: phy[0]=phy[1]=0; /* sytek */
                    phy[2]=0x10;
                    len=3;
                    break;
            case 1: phy[0]=phy[1]=0;/* cbltrn */
                    phy[2]=0x1d;
                    len=3;
                    break;
            case 2: phy[0]=phy[1]=0; /* netgen */
                    phy[2]=0x65;
                    len=3;
                    break;
            case 3: phy[0]=phy[1]=0; /* mips */
                    phy[2]=0x6b;
                    len=3;
                    break;
            case 4: phy[0]=phy[1]=0; /* proten */
                    phy[2]=0x6b;
                    len=3;
                    break;
            case 5: phy[0]=phy[1]=0; /* wellft */
                    phy[2]=0xa2;
                    len=3;
                    break;
            case 6: phy[0]=phy[1]=0; /* ncd */
                    phy[2]=0xa7;
                    len=3;
                    break;
            case 7: phy[0]=phy[1]=0; /* wd */
                    phy[2]=0xc0;
                    len=3;
                    break;
            case 8: phy[0]=0x08; /* sun */
                    phy[1]=0;
                    phy[2]=0x20;
                    len=3;
                    break;
            case 9: phy[0]=0x08; /* unisys */
                    phy[1]=0;
                    phy[2]=0x0b;
                    len=3;
                    break;
            case 10:phy[0]=0x08; /* apollo */
                    phy[1]=0;
                    phy[2]=0x1e;

                    len=3;
                    break;
            case 11: phy[0]=0x08; /* exceln */
                    phy[1]=0;
                    phy[2]=0x6e;
                    len=3;
                    break;
            case 12: phy[0]=0x08; /* dec */
                    phy[1]=0;
                    phy[2]=0x2b;
                    len=3;
                    break;
            case 13: phy[0]=0x02; /* micom */
                    phy[1]=0x07;
                    phy[2]=0x01;
                    len=3;
                    break;
            case 14: phy[0]=0x02; /* 3com */
                    phy[1]=0x60;
                    phy[2]=0x8c;
                    len=3;
                    break;
            case 15: phy[0]=0x00; /* HLS */
                    phy[1]=0x80;
                    phy[2]=0xbb;
                    len=3;
                    break;
            default: len=6;
                    break;
        }
        if (len==3) {
            tmp2++;
            if (str2phy(tmp2,phy,len)) {
                return(INV_PHY_ADDR);
            }
        }

        if (len==6) {
            if (str2phy(kw,phy,len)) {
                return(INV_PHY_ADDR);
            }
        }

        return 0;
}

int chk_complete_parm(argvp,parmp)
char *argvp;
char *parmp[];
{
        int i;
        int     val,found;

        found = 0;
        for(i=0; parmp[i] != 0; i++)
        {

             if(strcmpx(argvp,parmp[i]) == 0)
                 {
                        found = 1;
                        val = i;
                 }
        }

        if(found)
                return(val);
        return (-1);
}

/****************************************************************
 * str2phy()
 *
 * Inputs: character string
 *         48 bit physical address
 *
 * Ascii to physical address conversion.
 *
 ****************************************************************/
str2phy (string, phys,len)
char *string;
unsigned char phys[];
int len;
{
        int i, val;
        int dot=0;
        char * tmp;

        tmp=string;

        if (len==6) {
            if ((dot=find_delimeter(tmp,'.')) != 5)
                return(1);
        }

        if (len==3) {
            if ((dot=find_delimeter(tmp,'.')) != 2)
                return(1);
        }

        if ( (string[0]=='.'))
           return(1);

        for (i=0;;i++) {
            if (string[i]==0) {
                if (string[i-1]=='.')
                    return(1);
                else
                    break;
            }
        }

        for (i = 6-len; i < 6; i++)
        {
                val = 0;
                if (isxdigit (*string))
                {
            		val = (hexval (*string));
                        string++;
                }

                if (isxdigit (*string))
                {
   			tmp = string;
   			tmp--;
            /*-------------------------------------*/
            /* if addr in xx.xx format, left shift */
            /* prev char by 4 and add current char */
            /*-------------------------------------*/
                        val = (hexval(*tmp) << 4) + hexval (*string);
                        string++;
                }

      		if (i<5)
      		{
         		if (*string == '.')
         		{
            			string++;
         			if(*string == '.')
               				return 1;
         		}
         		else
            			return 1;
      		}

                phys[i] = val;

                if ( i == 5)
                {
                        if  ( *string >= '!' && *string <= '~' )
                        /* if the 3rd ch in last byte is a printable ch */
                        {
                                return 1;
                        }
                }


        }

   return (0);
}

/****************************************************************
 * hexval()
 *
 * Inputs: character
 *
 * Return the hex value of a character.
 *
 ****************************************************************/
hexval (c)
        unsigned char c;
        {
        if (isdig (c))
                return (c - '0');
        return (c - 'A' + 10);
        }

int isxdigit(c)
char c;
{
    if (isdig(c))
        return(1);
    else {
        if (c>='A' && c<='F')
            return(1);
        if (c>='a' && c<='f')
            return(1);
        else
            return(0);
    }
}
isdig(char c)

{
  if(c >= '0' && c <= '9')
     return 1;
  return 0;
}
