/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      showfddi.c
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/


#include <types.h>
#include <target.h>
#include <bridges.h>
#include <filter.h>
#include <utility.h>
#include <prcadr.h> 
#include <krnl.h>
#include <prcctl.h> 
#include <sncvar.h>
#include <nvram.h>
#include <eeprecs.h>
#include <nvrecs.h>
/*********
#include <stp.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
**************/
#include <cpb.h>
#include <834error.h>
#include <log.h>
#include <rlog.h>

#include <smtmacro.h>
#include <smtdefs.h>
#include <mibdefs.h>
#include <smttypes.h>
#include <fddihdr.h>
#include <rfc1285.h>
#include "/b/gregs/fddi/fddicon/include/edfddinvr.h"
#include "/b/gregs/fddi/fddicon/include/drv.h"
#include <define.h>


#define SHOW_PATH 	0
#define SHOW_MAC 	1


/*
extern NVR_FDDI nvr_fddi_rec;
*/

extern TLVSetCountType setCount;
extern SMTStationIdType myStationId;

extern char Mac[];
extern char Path[];
extern char TRAFFIC[];
extern char FDDIINT_MAC_STA_SCREEN[];
extern char FDDIINT_PATH_STA_SCREEN[];
extern char FDDI_PORT_STA_SCREEN[];
extern char FDDI_SMT_STA_SCREEN[];
extern char FDDI_TRAFFIC_SCREEN[];
extern char LLC[];
extern char TVX[];
extern char T_MIN[];
extern char T_MAX[];
extern char T_PRI[];
extern char PRIMARY[];
extern char SECONDARY[];
extern char CONNECT[];
extern char DISCONNECT[];
extern char DISABLED[];
extern char ENABLED[];
#ifdef vinay
extern char NONE[];
#endif
extern char COPIED[];
extern char ISOLATED[];
extern char Stripping[];
extern char Frame_Status[];
extern char Path_Requested[] ;
extern char Not_Copied_Threshold[] ;
extern char Frame_Error_Threshold[];
extern char Priority_Level[];
extern char Timer_Value[];
extern char PARAMETER[];
extern char Rmode[];
extern char Trace_Max[];
extern char TVX_Lower[];
extern char T_Max_Lower[];
extern char Ring_Latency[];
extern char Attachment_Policy[];
extern char Connection_Policy[];
extern char Config_Policy[];
extern char Operation_Version[];
extern char Report_Limit[];
extern char User_Data[];
extern char T_Notify[];
extern char T_Req[];
extern char T_Min[];
extern char T_Max[];
extern char COUNTER[];
extern char VALUE[];
extern char Mac_Tx_Count[];
extern char Mac_Copied_Count[];
extern char Mac_Error_Count[] ;
extern char Mac_Rx_Token_Count[] ;
extern char Mac_Lost_Count[] ;
extern char Mac_TVX_Expired_Count[];
extern char Mac_Ring_Op_Count[];
extern char Mac_Not_Copied_Count[] ;
extern char Action[];
extern char Port_Location[];
extern char Link_Error_Alarm[];
extern char Maint_Line_State_Symbol[];
extern char Link_Error_Cutoff[];
extern char Port_Mac_Loop_Time[];
/*********************************************************************/

extern char *port_action[];
extern char *port_conn_policy[];
extern char *port_attach_policy[];	
extern char *connection_policy_parm[];
extern char *smt_config_policy[];
extern char *port_maintline_state[];
extern char *port_connect_state[];
extern char *mac_path_requested[];

extern int A_Port_Config_State; 
extern int B_Port_Config_State; 

int ShowFddiMac(CPB_P pcpb)
{
	if(pcpb->cl_idx < pcpb->cmdlen)
		return KW_UN_AMB;
		Header();
		Copyright();
		printf("\t\t\t\t\t\t\t%s\n\n",FDDIINT_MAC_STA_SCREEN);
		showfddiimac();
		return(0);
}

int ShowFddiPath(CPB_P pcpb)
{
	if(pcpb->cl_idx < pcpb->cmdlen)
		return KW_UN_AMB;
		Header();
		Copyright();
		printf("\t\t\t\t\t\t\t%s\n\n",FDDIINT_PATH_STA_SCREEN);
		showfddiipath();
		return(0);
} 

int ShowFddiPorts(CPB_P pcpb)
{
	if(pcpb->cl_idx < pcpb->cmdlen)
		return KW_UN_AMB;
	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t%s\n\n",FDDI_PORT_STA_SCREEN);
	show_fddi_ports();
	return 0;
}

int ShowSmt(CPB_P pcpb)
{
	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t%s\n\n",FDDI_SMT_STA_SCREEN);
	showmodsmt();
	return 0;
}

int ShowBrgFddi(CPB_P pcpb)
{
	char    *kw;
	int     kw_sz, i,j,k;
	int     port;
	
	if(pcpb->cl_idx < pcpb->cmdlen)
		return KW_UN_AMB;

	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t\t%s\n\n",FDDI_TRAFFIC_SCREEN);
	FDDIMainTrafficScreen();
	return 0;
}

showfddiimac()
{
	int value;
	TLVParamType    buffer;
	char *kw;
	char temp[128];
	extern int strippingflag;
	
	printf("%-22s\t\t\t\t%-10s\n\n",PARAMETER,VALUE);

	/* LLC */
	buffer.paramType = fddiMACLLCServiceAvailable;
	buffer.paramLen  = 4;
	buffer.MACINDEX = 1;
/*	
	ShowMibAttr(SHOW_MAC,fddiMACLLCServiceAvailable,4,1,&value);
	if((value =GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL)) != RC_SUCCESS)
	printf("GET FAILED\n");

	printf("LLC VALUE = %x\n",buffer.MACPARAM8);
	printf("%-22s\t\t\t\t%-10s\n",LLC,(buffer.MACPARAM8 == 1)?ENABLED:DISABLED);
*/

	/* TVX */
	ShowMibAttr(SHOW_MAC,fddiMACTvxValue,4,1,&value);
	printf("%-22s\t\t\t\t%-d\n",TVX,MFddi2Usecs(-value));

	/* T_REQ */
	ShowMibAttr(SHOW_MAC,fddiMACT_Req,4,1,&value);
	printf("%-22s\t\t\t\t%-d\n",T_Req,MFddi2Usecs(-value));


	/* T_MIN */
	ShowMibAttr(SHOW_MAC,fddiMACT_Min,4,1,&value);
	printf("%-22s\t\t\t\t%-d\n",T_Min,MFddi2Usecs(-value));


	/* T_MAX */
	ShowMibAttr(SHOW_MAC,fddiMACT_Max,4,1,&value);
	printf("%-22s\t\t\t\t%-d\n",T_Max,MFddi2Usecs(-value));

	/* MAC STATE */
#ifdef vinay
	buffer.paramType = fddiSMTECMState;
	buffer.paramLen  = 0;
	kw = (buffer.SMTPARAM8 == 0) ? "CONNECT": "DISCONNECT";
	value =  GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-22s\t\t\t\t%-d\n","State",kw);

	/* STRIPPING */
	kw = (strippingflag == 0)? ENABLED:DISABLED;
	printf("kw : 0x%x DIS : 0x%x\n",kw,DISABLED);
	delay(100);
	enter_debug(0x1);
	printf("%-22s\t\t\t\t%-10s\n",Stripping,kw);

	/* FRAME STATUS */
	buffer.paramType = fddiMACFrameStatus;
	buffer.paramLen  = 0;
	buffer.MACINDEX = 1;
	value = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	memset(temp, 0, 128);
	if(buffer.MACPARAM16 == 1) 
		strcpy(temp, "NONE");
	else
		strcpy(temp,COPIED);

	printf("%-22s\t\t\t\t%-10s\n",Frame_Status,temp);
#endif

	/* PATH REQUESTED */
	buffer.paramType = fddiMACPathsRequested;
	buffer.paramLen  = 0;
	buffer.MACINDEX = 1;
	value = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
/****
	kw = (buffer.MACPARAM8 == 1) ? PRIMARY: SECONDARY;
*****/
	memset(temp, 0, 128);
	getConnlist(2/*only 2 parametrs */,buffer.MACPARAM8,temp,mac_path_requested);
	if(buffer.MACPARAM8 == 8)
		strcpy(temp,ISOLATED);

	printf("%-22s\t\t\t\t%-10s\n",Path_Requested,temp);

	/* NOT COPIED THRESHOLD */
	buffer.paramType = fddiMACNotCopiedThreshold;
	buffer.paramLen  = 0;
	buffer.MACINDEX = 1;
	GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = (int)buffer.MACPARAM16;		
	printf("%-22s\t\t\t\t%-d\n",Not_Copied_Threshold,value);

	
	/* FRAME ERROR THRESHOLD */
	buffer.paramType = fddiMACFrameErrorThreshold;
	buffer.paramLen  = 0;
	buffer.MACINDEX = 1;
	value = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-22s\t\t\t\t%-d\n",Frame_Error_Threshold,buffer.MACPARAM16);

	/* MAC DOWNSTREAM PORT TYPE */
	buffer.paramType = fddiMACDownstreamPORTType;
	buffer.paramLen  = 4;
	buffer.MACINDEX = 1;
	value = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	memset(temp,0,128);
	if(value == RC_SUCCESS)
	{
		if(buffer.MACPARAM8 == 0) strcpy(temp,"A");
		if(buffer.MACPARAM8 == 1) strcpy(temp,"B");
		if(buffer.MACPARAM8 == 2) strcpy(temp,"S");
		if(buffer.MACPARAM8 == 3) strcpy(temp,"M");
		printf("%-22s\t\t\t%-s\n\n","MAC Downstream PORT Type",temp);
	}

#ifdef REMOVED
	/* PRIORITY LEVEL */
	printf("%-16s\t%c\t\t%c\t\t%c\t\t%c\t\t%c\t\t%c\n",Priority_Level,'1','2','3','4',
								'5','6');
	printf("%-16s\t%-4d\t%-4d\t%-4d\t%-4d\t%-4d\t%-4d\n",Timer_Value,
		nvr_fddi_rec.MACInfo[0].T_Pri[0],
		nvr_fddi_rec.MACInfo[0].T_Pri[1],
		nvr_fddi_rec.MACInfo[0].T_Pri[2],
		nvr_fddi_rec.MACInfo[0].T_Pri[3],
		nvr_fddi_rec.MACInfo[0].T_Pri[4],
		nvr_fddi_rec.MACInfo[0].T_Pri[5]);
#endif
	Scroll(4);
	printf("\n");
}

/***********************************************************************
**
**	SHOW FDDI PATH SCREEN
**
************************************************************************/
showfddiipath()
{
	int value1;
	int value2;
	TLVParamType    buffer;
	
	printf("%-18s\t\t\t\t%-12s\n\n",PARAMETER,PRIMARY /*,SECONDARY*/);
	
	/* RMODE PRIMARY */
	ShowMibAttr(SHOW_PATH,fddiPATHClassPATHT_Rmode,4,1,&value1);


	/* RMODE SECONDARY */
/**
	ShowMibAttr(SHOW_PATH,fddiPATHClassPATHT_Rmode,4,2,&value2);
**/
	printf("%-18s\t\t\t\t%-10d\t\t\n",Rmode,MFddi2Usecs(value1)/*,MFddi2Usecs(value2)*/);

	/* TRACE MAX (EXPIRATION) */
	ShowMibAttr(SHOW_PATH,fddiPATHClassTrace_MaxExpiration,4,1,&value1);
/**
	ShowMibAttr(SHOW_PATH,fddiPATHClassTrace_MaxExpiration,4,2,&value2);
**/
	printf("%-18s\t\t\t%-10d\t\t%\n",Trace_Max,MFddi2Usecs(value1)/*,MFddi2Usecs(value2)*/);

	/* TVX LOWER BOUND */
	ShowMibAttr(SHOW_PATH,fddiPATHClassTVXLowerBound,4,1,&value1);
/**
	ShowMibAttr(SHOW_PATH,fddiPATHClassTVXLowerBound,4,2,&value2);
**/
	printf("%-18s\t\t\t%-10d\t\t%\n",TVX_Lower,MFddi2Usecs(value1)/*,MFddi2Usecs(value2)*/);

	/* T_MAX LOWER */
	ShowMibAttr(SHOW_PATH,fddiPATHClassT_MaxLowerBound,4,1,&value1);
/**
	ShowMibAttr(SHOW_PATH,fddiPATHClassT_MaxLowerBound,4,2,&value2);
**/
	printf("%-18s\t\t\t%-10d\t\t\n",T_Max_Lower,MFddi2Usecs(value1)/*,MFddi2Usecs(value2)*/);

	/* RING LATENCY */
	ShowMibAttr(SHOW_PATH,fddiPATHClassPATHRingLatency,4,1,&value1);
/***
	ShowMibAttr(SHOW_PATH,fddiPATHClassPATHRingLatency,4,2,&value2);
***/
	printf("%-18s\t\t%-10d\t\t\n",Ring_Latency,MFddi2Usecs(value1)/*,MFddi2Usecs(value2)*/);
	Scroll(12);
}

/*********************************************************************
**
**	SHOW MOD SMT SCREEN
**
*********************************************************************/
showmodsmt()
{
	int value,i;
	int res;
	TLVParamType    buffer;
	char *kw,temp[128],*ptr;
	
	printf("%-24s\t\t\t%s\n\n","PARAMETER","VALUE");

	/* CHECK THIS WITH GREG AND FRANK */
#ifdef vinay
	buffer.paramType = fddiATTACHMENTInsertPolicy;
	buffer.paramLen  = 0;
	buffer.ATTACHINDEX = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	if(buffer.ATTACHPARAM8 == 0)
		value = 2;
	else
		value = buffer.ATTACHPARAM8;
	printf("%-24s\t\t\t%d\n",Attachment_Policy,buffer.SMTPARAM16);
#endif
	/* SMT CONNECTION POLICY */
	buffer.paramType = fddiSMTConnectionPolicy;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t",Connection_Policy);
	if(buffer.SMTPARAM16 == 0)
		printf("%-60s\n","NONE");
	else
	{
		memset(temp, 0, 128);
		getConnlist(16/*16 parameters */,buffer.SMTPARAM16,temp,connection_policy_parm);
        }
	printf("%-s\n",temp);

	/* SMT CONFIG POLICY */
	buffer.paramType = fddiSMTConfigPolicy;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	kw = (buffer.SMTPARAM16 == 2) ? smt_config_policy[0]:"NONE";
	printf("%-24s\t\t\t%-20s\n",Config_Policy,kw);

	/* SMT OPVERSION */
	buffer.paramType = fddiSMTOpVersionId;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t%d\n",Operation_Version,buffer.SMTPARAM16);

	/* SMT REPORT LIMIT */
	buffer.paramType = fddiSMTReportLimit;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t%d\n",Report_Limit,buffer.SMTPARAM32);

	/* SMT USERDATA */
	buffer.paramType = fddiSMTUserData;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t%s\n",User_Data,buffer.SMTOTHER);

	/* SMT T_NOTIFY */
	buffer.paramType = fddiSMTT_Notify;
	buffer.paramLen  = 0;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t%d  %s\n",T_Notify,buffer.SMTPARAM16,"Seconds");

	Scroll(11);
}
/***********************************************************************
**
**	SHOW FDDI MAIN TRAFFIC SCREEN
**
***********************************************************************/
extern uint MacTx_Ct ;
extern uint MACCopied_Ct ;
extern uint MACToken_Ct ;
extern uint MACError_Ct ;
extern uint MACLost_Ct ;
extern uint MACTvxExpired_Ct ;
extern uint MACRingOp_Ct ;
extern uint MACNotCopied_Ct ;
FDDIMainTrafficScreen()
{
	uint value = 0L;


	printf("%-20s\t\t\t\t%s\n\n",COUNTER,VALUE);

	/*
	* MAC TX COUNTS 
	*/

	ShowMibAttr(SHOW_MAC,fddiMACTransmit_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_Tx_Count,(value >= MacTx_Ct) ? 
			value - MacTx_Ct :value - (MacTx_Ct=0));

	/*
	* MAC RX COUNTS  = CopiedCt + Fddi_Rcv_Pkt 
	*/

	ShowMibAttr(SHOW_MAC,fddiMACCopied_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_Copied_Count,(value >= MACCopied_Ct) ?
				value - MACCopied_Ct: value - (MACCopied_Ct=0));
					

	/*
	* MAC RX TOKEN COUNTS 
	*/

	ShowMibAttr(SHOW_MAC,fddiMACToken_Ct,4,1,&value);

	printf("%-20s\t\t\t\t%-d\n",Mac_Rx_Token_Count,(value >= MACToken_Ct) ? 
			value - MACToken_Ct: value - (MACToken_Ct=0));

	/*
	* MAC ERROR COUNT 
	*/
	ShowMibAttr(SHOW_MAC,fddiMACError_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_Error_Count,(value >= MACError_Ct) ? 
			value - MACError_Ct: value - (MACError_Ct=0));

	/*
	* MAC LOST COUNT 
	*/

	ShowMibAttr(SHOW_MAC,fddiMACLost_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_Lost_Count, (value >= MACLost_Ct)? 
			value - MACLost_Ct: value - (MACLost_Ct=0));

	/*
	* MAC TVX EXPIRED COUNT 
	*/
	ShowMibAttr(SHOW_MAC,fddiMACTvxExpired_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_TVX_Expired_Count,(value >= MACTvxExpired_Ct)? value - MACTvxExpired_Ct:value - (MACTvxExpired_Ct=0));

	/*
	* MAC TRT EXPIRED COUNT 
	*/
/*********************************
	ShowMibAttr(SHOW_MAC,fddiMACTvxExpired_Ct,0,0,&value);
	printf("%-20s\t\t\t\t%d\n","Mac TRT Expired Count",value);
********************************/

	/*
	* MAC RING OP COUNT 
	*/
	ShowMibAttr(SHOW_MAC,fddiMACRingOp_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_Ring_Op_Count, (value >= MACRingOp_Ct) ? 
		value - MACRingOp_Ct:value - (MACRingOp_Ct=0));

	/*
	* MAC NOT COPIED COUNT 
	*/

	ShowMibAttr(SHOW_MAC,fddiMACNotCopied_Ct,4,1,&value);
	printf("%-20s\t\t\t\t%-d\n",Mac_Not_Copied_Count,
		(value >= MACNotCopied_Ct)? 
		value - MACNotCopied_Ct: value - (MACNotCopied_Ct = 0));

	Scroll(9);
}


show_fddi_ports()
{
	uint value,value1;
	uint res;
	TLVParamType    buffer;
	char *kw, *kw1;
	char temp_kw[64],temp_kw1[64];


	printf("%-24s\t\t\t\t%-16s%s\n\n","PARAMETER","PORT A","PORT B");

	/****************************************************************/
	/* FDDI PORT ACTION */
	/****************************************************************/
	buffer.paramType = fddiPORTAction;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = buffer.PORTPARAM16;
	buffer.paramType = fddiPORTAction;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8s\t\t%-8s\n",Action,/*port_action[value],port_action[buffer.PORTPARAM8]*/ENABLED,ENABLED);

	/****************************************************************/
	/* FDDI PORT TYPE */
	/****************************************************************/
	/* port A */
	if (nvr_fddi_rec.UI_Defaults.Port1_PC_Type == 0)
		kw = "FRONT";
	if (nvr_fddi_rec.UI_Defaults.Port1_PC_Type == 3)
		kw = "BACK";

	/* port B */
	if (nvr_fddi_rec.UI_Defaults.Port6_PC_Type == 1)
		kw1 = "FRONT";
	if (nvr_fddi_rec.UI_Defaults.Port6_PC_Type == 3)
		kw1 = "BACK";

	printf("User Defined %-12s\t\t\t\t%-8s\t\t%-8s\n",Port_Location,kw,kw1);

	/*
	 * Actual port A & B locations
	 */
	kw  = (A_Port_Config_State == 1)? "FRONT": "BACK";
	kw1 = (B_Port_Config_State == 1)? "FRONT": "BACK";
		
	printf("Current %-17s\t\t\t\t%-8s\t\t%-8s\n",Port_Location,kw,kw1);

	
	/****************************************************************/
	/* FDDI PORT TB_MAX */
	/****************************************************************/
	buffer.paramType = fddiPORTTB_Max;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = MFddi2Usecs(-(buffer.PORTPARAM32));
	buffer.paramType = fddiPORTTB_Max;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8d\t\t%-8d\n","Tb_Max (micro sec)",value,MFddi2Usecs(-(buffer.PORTPARAM32))/*usec*/);

	/****************************************************************/
	/* FDDI PORT Connect state */
	/****************************************************************/
	buffer.paramType = fddiPORTConnectState;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = buffer.PORTPARAM16;
	buffer.paramType = fddiPORTConnectState;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8s\t\t%-8s\n","Connect State",port_connect_state[value],port_connect_state[buffer.PORTPARAM16]);

	/****************************************************************/
	/* FDDI PORT LER ALARM */
	/****************************************************************/
	buffer.paramType = fddiPORTLer_Alarm;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = buffer.PORTPARAM8;

	buffer.paramType = fddiPORTLer_Alarm;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8d\t\t%-8d\n",Link_Error_Alarm,value,buffer.PORTPARAM8);

	/****************************************************************/
	/* FDDI PORT LER CUTOFF */
	/****************************************************************/
	buffer.paramType = fddiPORTLer_Cutoff;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = buffer.PORTPARAM8;
	buffer.paramType = fddiPORTLer_Cutoff;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8d\t\t%-8d\n",Link_Error_Cutoff,value,buffer.PORTPARAM8);


	/****************************************************************/
	/* FDDI PORT CONNECTION POLICY */
	/****************************************************************/
	buffer.paramType = fddiPORTConnectionPolicies;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = buffer.PORTPARAM8;
	memset(temp_kw, 0, 64);
	getConnlist(3/*only 3 parametrs */,value,temp_kw,port_conn_policy);
	if(strlen(temp_kw) == 0) strcpy(temp_kw,"NONE");

	buffer.paramType = fddiPORTConnectionPolicies;
	buffer.paramLen  = 4;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value1 = buffer.PORTPARAM8;
	memset(temp_kw1, 0, 64);
	getConnlist(3,value1,temp_kw1,port_conn_policy);
	if(strlen(temp_kw1) == 0) strcpy(temp_kw1,"NONE");

	
	printf("%-24s\t\t\t\t%-16s%-14s\n",Connection_Policy,temp_kw,temp_kw1);


	/****************************************************************/
	/* FDDI PORT ATTACHMENT POLICY 					*/
	/****************************************************************/
	/* Get the attribute for port A */
	buffer.paramType = fddiATTACHMENTInsertPolicy;
	buffer.paramLen  = 0;
	buffer.ATTACHINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = buffer.ATTACHPARAM8;

	/* Get the Attribute for port B */
	buffer.paramType = fddiATTACHMENTInsertPolicy;
	buffer.paramLen  = 0;
	buffer.ATTACHINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8s\t\t%s\n",Attachment_Policy,port_attach_policy[value],port_attach_policy[buffer.ATTACHPARAM8]);

	/****************************************************************/
	/* FDDI PORT MAC LOOPTIME 					*/
	/****************************************************************/
	/* Get the attribute for port A */
	buffer.paramType = fddiPORTMACLoop_Time;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = MFddi2Usecs(buffer.PORTPARAM32);

	/* Get the Attribute for port B */
	buffer.paramType = fddiPORTMACLoop_Time;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-32s\t\t%-10d\t\t%-10d\n",Port_Mac_Loop_Time,value,MFddi2Usecs(buffer.PORTPARAM32));
	/****************************************************************/


	/****************************************************************/
	/* FDDI PORT MAINTLINESTATE  					*/
	/****************************************************************/
	/* Get the attribute for port A */
	buffer.paramType = fddiPORTMaintLineState;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	value = (int)buffer.PORTPARAM8;

	/* Get the Attribute for port B */
	buffer.paramType = fddiPORTMaintLineState;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	printf("%-24s\t\t\t\t%-8s\t\t%-8s\n",Maint_Line_State_Symbol,port_maintline_state[value],port_maintline_state[(int)buffer.PORTPARAM8]);


	/****************************************************************/
	/* FDDI Port PC Neighbor 					*/
	/****************************************************************/
	buffer.paramType = fddiPORTPC_Neighbor;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 1;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	memset(temp_kw,0,64);
	memset(temp_kw1,0,64);
	strcpy(temp_kw,"UNKNOWN");
	strcpy(temp_kw1,"UNKNOWN");
	switch(buffer.PORTPARAM8)
	{
		case 0x00:
			strcpy(temp_kw,"A");
			break;
		case 0x01:
			strcpy(temp_kw,"B");
			break;
		case 0x02:
			strcpy(temp_kw,"S");
			break;
		case 0x03:
			strcpy(temp_kw,"M");
			break;
	}
	buffer.paramType = fddiPORTPC_Neighbor;
	buffer.paramLen  = 0;
	buffer.PORTINDEX = 2;
	res = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
	switch(buffer.PORTPARAM8)
	{
		case 0x00:
			strcpy(temp_kw1,"A");
			break;
		case 0x01:
			strcpy(temp_kw1,"B");
			break;
		case 0x02:
			strcpy(temp_kw1,"S");
			break;
		case 0x03:
			strcpy(temp_kw1,"M");
			break;
	}
	printf("%-24s\t\t\t\t%-8s\t\t%-8s\n","Port Neighbor",temp_kw,temp_kw1);
	
	Scroll(5);
}

getConnlist(index,value,kw,portindex)
int index;
int value;
char *kw;
char *portindex[];
{
	int i;

	*kw = '\0';

	for(i = 0; i < index; i++)
		if(value & (1 <<i))
			sprintf(kw+strlen(kw),"%s,",portindex[i]);

	return 0;
}
/*************************************************************************
**
**	Function used to get the mib attributes for 
**	MAIN TRAFFIC SCREEN, 
**	part of FDDI INTERFACE MAC STATUS
**
**
**************************************************************************/
ShowMibAttr(macORpath,type,paramlen,index,value)
int macORpath,type,paramlen,index;
uint *value;
{
	TLVParamType    buffer;
	int result;

	switch (macORpath)
	{
	case SHOW_PATH:
		buffer.paramType = type;
		buffer.paramLen  = paramlen;
		buffer.PATHINDEX = index;
		result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
		*value = -buffer.PATHPARAM32;
		break;


	case SHOW_MAC:
		buffer.paramType = type;
		buffer.paramLen = paramlen;
		buffer.MACINDEX = index;
	
		result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);

		*value = buffer.MACPARAM32;
		break;
	}
	return ;
}
