/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834cmdmain.c
*
*       $Log:   /b/gregs/bridge/declike/main/834cmdmain.c_v  $
 * 
 *    Rev 1.10   19 Nov 1993 08:56:58   gregs
 * Fixed date/time logging of power fail and button resets.
 * 
 *    Rev 1.9   15 Nov 1993 10:14:02   gregs
 * Fixed extended reset bug
 * 
 *    Rev 1.8   11 Nov 1993 15:34:26   gregs
 * Reordered the way in which an extended push button reset is processed.
 * 
 *    Rev 1.7   05 Nov 1993 09:04:20   gregs
 * Added some delay to allow fddi to initialize prior to attempting 
 * a bootp request.
 * 
 *    Rev 1.6   05 Nov 1993 08:45:18   vinay
 * fixed the redraw (^R) command. and commented out KERNEL_PROG and TFTP_LOADER
 * 
 *    Rev 1.5   14 Oct 1993 08:06:28   franks
 * Added routine to initialize the offline B-Phy.
 * 
 *    Rev 1.4   22 Sep 1993 09:24:40   vinay
 * fixed the clearing of IP addr with change of location.
 * 
 *    Rev 1.3   03 Sep 1993 11:45:32   vinay
 * made changes related to change of location
 * 
 *    Rev 1.2   18 May 1993 09:53:52   franks
 * 
 *    Rev 1.1   04 May 1993 16:19:16   franks
 * 
 *    Rev 1.0   04 May 1993 16:03:22   franks
 * Initial revision.
 * 
 *    Rev 1.7   17 Dec 1992 09:55:14   franks
 * Changed nvr_udp to a pointer reference when calling memset.
 * 
 *    Rev 1.6   13 May 1992 18:53:32   suresh
 * On malloc failure invoke InitAbort instead of reset().
 * 
 *    Rev 1.5   13 May 1992 09:58:58   kwok
 * Do not init the adminbus driver in here. The adminbus driver does lmalloc()
 * and the adminbus driver has to keep this memory after jumping to a different
 * program such as tftp. We init the admin bus drvier in init.c and then set
 * the ip, netmask ....etc right after the bootp request.
 * 
 *    Rev 1.4   04 May 1992 12:21:28   franks
 * No change.
 * 
 *    Rev 1.3   20 Apr 1992 12:47:20   franks
 * 1). Fixed bug that caused ^U to be printed when ^u command was issued
 *     from the command line.
 * 
 *    Rev 1.2   17 Apr 1992 15:52:18   pvcs
 * Initialize the adminbus driver right after the auto configuration; 
 * i.e. call AdmBusInit() after calling AutoConfig().
 * 
 *    Rev 1.1   14 Apr 1992 13:11:38   franks
 * 1). Modified call_bridge routine so that the console is marked inactive
 *     when the application is started/restarted.
 * 
 *    Rev 1.0   30 Mar 1992 17:49:30   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		call_bridge()
******************************************************************************/




#include <target.h>
#include <bridges.h>
#include <filter.h>
#include <nvrecs.h>
#include <krnl.h>
#include <stp.h>
#include <prcadr.h>
#include <prcctl.h>
#include <time.h>
#include <nim960h.h>
#include <sys.h>
#include <dips.h>
#include <led.h>
#include <log.h>
#include <eeprecs.h>
#include <tcpip.h>

/* NEW INCLUDES FOR THE DECLIKE USER INTERFACE */
#include <ascii.h>
#include <param.h>
#include <834parser.h>
#include <cpb.h>

/* EXTERNAL DEFINITIONS */
extern NVR_PROTOCOLS nvr_udpd;
extern NIM960_HDR    Nim960Header;
extern APPL          apl;
extern PRCCTL        prc;
extern SEM           RemoteDisconnected;
extern SEM           SwUpdateFromSnmp;

/* GLOBAL VARIABLE DEFINITIONS  */
extern ERRORLOG         ErrorLogTable[MAXLOGTABLE];
extern uint             ErrorLogCount;
extern uint             ConsoleActive;
extern uint             ClearCounterTicks;
extern ADR              *adr_recs;
extern ADR              **adr_hshs;
extern NID              LocalAddress[NUMLADR];				
extern ADR              *NidSortAry;
extern ADR		        *NvFilterTab;
extern NVR_BSTATUS      *BridgeStatus;
extern NVR_NID_RECS     *NvramNids;
extern NVR_RESETLOG     *RstLog;
extern unsigned char    *APPLSOFTVERSION = &Nim960Header.version[0];
extern struct tm        DateTime;
extern IP               IPDevice[];
extern TIMER            IntervalTimer;
extern TIMER            InactivityTimer;
extern TIMER            SortTblTimer;
extern MBOX             TrRcvMBox;
extern MBOX             ValidTblMBox; 
extern unsigned long    InitTimeSeconds; /* Initial time in secs, from user */
extern unsigned long    InitDateSeconds; /* Initial time in secs, from user */
extern long             GmtOffset;       /* Offset from GMT based on geo loc */
extern NID              STPLAdr;         /* STP Group Address */
extern NID              BCastAdr;        /* Broadcast Address */
extern NVR_SYS          nvr_sys;
extern ushort		oldHubId;
extern ushort		oldSlotId;
extern int		ChangeOfLocation;

/* New Global definitions for the DecLike Parser */
extern RAM_PIT rampit;
extern CPB_T   cpb;


/* FUNCTION PROTOTYPES */
void    GetLine();
void    LowerString();
int     prc_proc_pkt();
int     PollPacket();
int     TimedOut();

/******************************************************************************/
						/* Start call_bridge()  */

/*****************************************************************************/
/* NOTE:                                                                     */
/* This is the main entry point for the bridge application. Do NOT change    */
/* the order that the initialization routines are called.                    */
/*****************************************************************************/

call_bridge(int FirstTime)
{
	int           i,x;
	uint          RetCode;
        uint          ExtndRst = 0;
	uint          RandNumber;
	ADR	          *Current;
	ADR	          *Previous;
	ERRORLOG      *ErrorLogPointer;
	unsigned char RandPort;
	unsigned char mybuff[11];
	RAM_PIT *pram = &rampit;		 /* global definition */


	ErrorLogPointer = ErrorLogTable;

	/* SNMP use. Sort ram address database for get-next request */
	NidSortAry   = (ADR *)lmalloc( sizeof( ADR *) * ADR_REC_CNT ); 
	if(NidSortAry == NULL) { 
		printf("Error: lmalloc NidSortAry\n");
		InitAbort();
	}

	/* SNMP use. Sort nvram address database for get-next request */
	NvFilterTab   = (ADR *)lmalloc( sizeof( ADR *) * NVRADR_REC_CNT); 
	if(NvFilterTab == NULL) { 
		printf("Error: lmalloc NvFilterTab\n");
		InitAbort();
	}

	NvramNids    = (NVR_NID_RECS *)lmalloc( sizeof(NVR_NID_RECS)); 
	if(NvramNids == NULL) { 
		printf("Error: lmalloc NvramNids\n");
		InitAbort();
	}

	/*	Clear the BridgeStatus structure  */
	memset(BridgeStatus, NULL, sizeof(NVR_BSTATUS));

	/*	Clear the reset log structure  */
	memset(RstLog, NULL, sizeof(NVR_RESETLOG));

	
	/* Initialize the reset event log from nvram */
	if( GetRstLog() )  {
	    memset(RstLog, NULL, sizeof(NVR_RESETLOG));
		printf("Reset Log Initialized.\n\n");
		SaveRstLog();
	}

	/*  Clear the UDPDIR Stucture */
	memset(&nvr_udpd, NULL, sizeof(nvr_udpd));


	/*  Get the BridgeStatus from NVRAM */
	/*  If unable to get status then re-initialize this portion of NVRAM */
	if( GetBStatus() )  {
		STP_dft_rst();        /* spanning tree parameters */
		SetBridgeDefault();   /* bridge parameters */
		printf("Bridge Parameters Initialized To Default Values.\n\n");
	}

	/*  Get the user defined protocol table from NVRAM */
	if( GetProtocolTbl() ) {
		UserProtsToDefault();
		printf("User-Defined Protocol Record Initialized.\n\n");
	}

	/*	Clear all working database address table  */
	/* memset(adr_recs, NULL, sizeof(adr_recs)); */

	/* Initialize all the address records into a free list */
	prc_ini_addr();


	/* Declare and Initialize the Packet Processing Control Structure */
	prc_init();

	/*      Initialize the Protocol Filtering Table and Index Table */
	InitPFilTable();

	/* Put local addresses into the ram address table */
	InitLAdr();
	InitAddressTbl();

	/* Get cause of last reset from nvr_sys and then set it to 0 */
        if( nvr_sys.nvr_reset != 0xff ) /* If not a software reset */
		ExtndRst = ServiceHardWareReset(nvr_sys.nvr_reset);

	/* Get static address from NVRAM and load them into the RAM Database */
	if( GetSavedAdr() ) {
		SaveStaticRecs();
		printf("Initialized NVRAM Address Database.\n\n");
	}

	/* Initialize the packet processing control structure */
	InitPrcctl();


	/* Initialize the FDDI/Ethernet translation buffers. */
        InitEFTranslation();

	/* Create the Status and Traffic command interval timer */
	CreatTimer(&IntervalTimer);

	/* Create the Traffic screen receive mail box */
	CreatMailbox( &TrRcvMBox );
	
	/* Create the command console inactivity timer */
	CreatTimer(&InactivityTimer);

	/* Create timer to determine if SNMP sort table is valid */
	CreatTimer(&SortTblTimer);

	/* Add some delay to allow fddi to connect prior to attempting	*/
	/* to send a bootp request.					*/
	for(x=0; x < 100; x++) {
		delay(5);
		ReSchedule();
	}

	/* Call the AutoConfig function */
	if (FirstTime)
		{
		AutoConfig();
		/*
		 *	K Kong	5.13.92
		 *	Inform the admin bus driver  my ip, netmask ...etc 
		 */
		AdmSetIP(eep_boot_rec.eep_IP);
		AdmSetRouter(eep_boot_rec.eep_RouterIP[0]);
		AdmSetBootServer(eep_boot_rec.eep_BootpServer);
		AdmSetNetMask(eep_boot_rec.eep_NetMask);
		AdmSetBootFile(eep_boot_rec.eep_request_file);
		}

	/* If not in spanning tree mode then forward BPDU packets */
	if( BridgeStatus->StpMode == STP_MODE_DISABLE )
	    DelStpAddr();

	/* Initialize ClearCounterTicks counter */
	ClearCounterTicks = 0;

	/* Setup and Initialize the Sonic channel driver  */
	InstallSonic(prc_proc_pkt, 1);  

	/* Initialze the date time structure */
	InitDateTime();

        /* If a non-software reset occured log it now */
	if(ExtndRst) {
	  if(ExtndRst == 1)
	    RecordRst(RSTMSG0); /* Power Fail */
	  else
	    if(ExtndRst == 2)
	      RecordRst(RSTMSG1); /* Button Reset */
	  else
	    RecordRst(RSTMSG9); /* Extended Reset */
	}
	/*	K Kong	8.20.91
	 *	Init the spanning tree stack.
	 */
	stp_stack_init();

#ifdef FSFIX
	/* Initialize the Receive threshold counter */
	ClearRxThreshhold(0xf);
	SetRxThreshhold(BridgeStatus->RxThreshhold);

#endif
	    
	/* Return reset reason to 0 */
	nvr_sys.nvr_reset = 0;
	if (RetCode = Nvram_Updt( NVR_SYS_ADDR, &nvr_sys, NVR_SYS_SIZE ))
		printf("Error: (%d) Cannot save SYS REC to NVRAM..\n", RetCode);

	/* Initialize the port LED's based on port state */
	LedsOff(0xf);
	LedsOn(BridgeStatus->PortState);


	/*
	*
	*	If there is change in location send a changeoflocation trap
	*	to the manager and reset the changeoflocation flag.
	*
	*/
	if(ChangeOfLocation)
	{
		/* Send a location change trap */
		specific_trap(10, 0,(byte *)NULL, 0,0,0,0,0,
				oldHubId,oldSlotId,GetHubID(),
				GetSlotID());

		ChangeOfLocation = 0;
	
	}
	/*  Mark the bridge application as being initialized. */
    /*  Packet processing may now commence */
	apl.inited[APPL_BRIDGE] = 1;

    /* Initialize bridge status leds */
	set_leds(LED_BI, LED_BI_COLOR, (LED_RDY_GRN | LED_ACT_GRN));

    /* Mark console so that a telnet session is allowed */
	ConsoleActive = FALSE;


	/*	Sit here and wait until valid password is entered  */
	putchar('\n');
	WaitForPassword(); 
    	pram->mode = CMDMODE;

	/*  Start the console inactivity timer */
	if( BridgeStatus->TimeOut > 0 ) {
	    StartTimerCall( &InactivityTimer, 
			    (int)(BridgeStatus->TimeOut*60*100), 
		            (void *)TimedOut, (int)pram );
	}
	ConsoleActive = TRUE;

	/*	Start the console command interpreter  */
	/*  When the command interpreter returns, indicating that the bridge */
	/*  application is exiting. Mark the application as uninitialized.   */
	RetCode = ConsoleTask();

    /* Clean up before leaving the bridge application */
	apl.inited[APPL_BRIDGE] = 0;
	disable_stp();
	StopTimer(&IntervalTimer);
	StopTimer(&InactivityTimer);
	StopTimer(&SortTblTimer);
	return(RetCode);
}
/*	End call_bridge()  */

/*****************************************************************************/
						/* Start ConsoleTask() */
ConsoleTask()
{
	int    ch;                      /* temp char storage */
	char    i, j;
	RAM_PIT *pram = &rampit;		 /* global definition */
	CPB_P   pcpb  = &cpb;			 /* global definition */
	int     sta;
	int     SwitchApp;
	int     JustGotPassWord = FALSE;

	pram->ii=0;
	pram->ndi =0;
	pcpb->inputlen = MAX_CL-1;
	pram->access = 0xf;

	exit_cmd();
    
	while( 1 )   {

		/* Wait for an input character. */
		while( 1 ) {

	        	if(pram->mode == PASSWORDMODE) 
				break;

			ch = getch();
			ReSchedule();
			if( ch != -1 )
			{
				break;
			}

			/* Check if telnet session has been terminated by the console */
			if( AcptSignal( &RemoteDisconnected ) != 0 ) {
					if( JustGotPassWord == FALSE )
					    pram->mode = PASSWORDMODE;
			}
			JustGotPassWord = FALSE;
			
#ifdef 0
			/* Look for software update signal from snmp */
			if( AcptSignal( &SwUpdateFromSnmp ) != 0 ) {
		        	SwUpdateMsg();
                		return(APPL_TFTP);
			}
#endif
		}	
		
		
		switch(pram->mode) {
		
			case CMDMODE:
				ch = DoConsoleCmd(&SwitchApp,ch);
				/* Intercept return code, Do we switch programs? */
				switch( SwitchApp )  {

/*****************
					case KERNEL_PROG:  return(APPL_KRNL); 

					case TESTER_PROG:  return(APPL_CONFIG);
					
					case PACMON_PROG:  return(APPL_PACKET);

					case TFTP_LOADER:  return(APPL_TFTP);
*******************/

					case RESET:	       return(APPL_RESET);
				}
				break;

			case HELPMODE:
				/* try to reduce task code size  */
				ch = do_helpmode(ch); 
				break;

			case PASSWORDMODE:
				Scroll(2);
				StopTimer(&InactivityTimer);
				ConsoleActive     = FALSE;
				if( WaitForPassword() ) {
                     return(APPL_TFTP);
				}
				pram->mode        = CMDMODE;
				JustGotPassWord   = TRUE;
				ConsoleActive     = TRUE;
				ch = '\n';
		        printf("%s-> ", Model());
				break;
		}	

		if(ch < BLANK) {
			
			if((pram->ii >= MAX_CL-1) && (ch == BELL))
				putchar(ch);

			else
			if(ch != CR  && ch != LF && ch != 0x12 && ch != 0x15 && ch != BS) {
				putchar('^');
				putchar(ch+0x40);
			}
	    }	
		else
			putchar(ch);

		/* Reset the inactivity timer */
		if( BridgeStatus->TimeOut > 0 ) {

		    StopTimer( &InactivityTimer );
	        StartTimerCall( &InactivityTimer, (BridgeStatus->TimeOut*6000),
		    		(void *)TimedOut, (int)pram);
		}
	  }	/* end of while loop */
}

/*****************************************************************************/
						/* Start DoConsoleCmd() */
DoConsoleCmd(SwitchApp,c)
int *SwitchApp;
char c;
{
	register RAM_PIT *pram = &rampit;
	CPB_P    pcpb          = &cpb;
	int sta, j;

	/************************
	** the port is in the command mode.
	**  only printable characters, delkey,
	**  CR, and BLANK that are acceptable
	** in this mode. The character normally should be echoed.
	**************************/

	switch(c)
	{
	case LF:
	case CR:
		/* character is CR  ** command line is completed */
		pram->cmd_line[pram->ii] = 0;
		putchar('\n');
		if( pram->ii == 0) /* if no input char yet */
		{
			memset(pram->cmd_line, NULL, MAX_CL);
			pram->mode = CMDMODE;
			exit_cmd(); 
			break;
		}  
		else
		{      /* some input char(s) */
			memset(pram->prev,NULL,MAX_CL);
			memcpy( pram->prev, pram->cmd_line, pram->ii);
			prepare_cpb();
			pram->ii = 0;
			*SwitchApp = 0;	  /* which application to switch to */

			if((sta=executecmd(pcpb))) {
		
				/* Intercept return code, Do we switch programs? */
				switch( sta )  {

					case KERNEL_PROG:  *SwitchApp = KERNEL_PROG;
										return;

					case TESTER_PROG:  *SwitchApp = TESTER_PROG;
										return;

					case PACMON_PROG:  *SwitchApp = PACMON_PROG;
										return;

					case TFTP_LOADER:  *SwitchApp = TFTP_LOADER;
										return;

					case RESET:		   *SwitchApp = RESET;
										return;
					default:
									   usererr(sta,pcpb); 
				}
			}	
			exit_cmd(); 
		}
		break;

	case 0x12:   /* ^R for Redraw the last command */
		if(pram->ii < strlen(pram->prev))
		{
			memcpy( &pram->cmd_line[pram->ii], &pram->prev[pram->ii], 
			strlen(&pram->prev[pram->ii]) ); 
			echo_line(&pram->cmd_line[pram->ii]);
			pram->ii = strlen(pram->prev);
		}
		break;

	case 0x15:  /* ^U for delete line */
		if(pram->ii > 0)
		{
			for(j=pram->ii;j > 0;j--)
				do_BS();
			pram->ii = 0;
		}
		break;

	default:
	
		/* delkey on the command line */
		/* if(c == (BS & 0x7f)  )      ### HARD CODE DELETE KEY ### */
		if(c == BS || c == 0x7f)     /* ### HARD CODE DELETE KEY ### */
		{
			do_BS();
			break;
		}
		if(pram->ii >= MAX_CL-1)
			c = BELL;
		else
			pram->cmd_line[pram->ii++] = c;
	}	/* end of switch */
	return c;
}

/*****************************************************************************/
						/* Start prepare_cpb() */
prepare_cpb()
{
	RAM_PIT *pram = &rampit;
	CPB_P pcpb    = &cpb;

	pcpb->access = pram->access;
	pcpb->cmd = (char *)&pram->cmd_line[0];
	pcpb->cmdlen = pram->ii;
	pcpb->cl_idx = 0;
	pcpb->node = 0L;
}

/*****************************************************************************/
							/* Start do_BS() */
do_BS()
{
	RAM_PIT *pram = &rampit;
	if(pram->ii > 0)
	{
		pram->cmd_line[pram->ii] = '\0';
		pram->ii--;
		if(pram->cmd_line[pram->ii] < BLANK)
		{
			/* if one of CTL character , need to back two character */
			tty_out(0x08);
			tty_out(BLANK);
			tty_out(0x08);
		}
		tty_out(0x08);
		putchar(BLANK);
		tty_out(0x08);
	}
}

/*****************************************************************************/
						/* Start echo_line() */
echo_line(buf)
char *buf;
{

	while(*buf != 0)
	{ char c = *buf;
		if(c < 0x20)
			printf("^%c", c+0x40);
		else
			printf("%c", c);

		buf++;
	}
}

/*****************************************************************************/
							/* Start exit_cmd() */
exit_cmd()
{

	RAM_PIT *pram = &rampit;
	CPB_P   pcpb  = &cpb;

	/*reset index of cmd_line */
	pram->ii = 0;
	pcpb->cl_idx = 0;
	memset(pram->cmd_line, NULL, MAX_CL);
	switch(pram->mode )
	{
	    case CMDMODE:
	    	printf("%s-> ", Model());
	    	pram->mode = CMDMODE;
	    	/* clear command process block on port */
	    	memset(pcpb, NULL, sizeof(CPB_T));
	    	pcpb->inputlen = MAX_CL-1;
			break;
		case PASSWORDMODE:
			break; 
	}
}

clear_cmd() {

	RAM_PIT *pram = &rampit;
	CPB_P   pcpb  = &cpb;

	/*reset index of cmd_line */
	pram->ii = 0;
	pcpb->cl_idx = 0;
	memset(pram->cmd_line, NULL, MAX_CL);
	/* clear command process block on port */
	memset(pcpb, NULL, sizeof(CPB_T));
	pcpb->inputlen = MAX_CL-1;
}
