
/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834help.c
*
*       $Log:   /b/gregs/bridge/declike/main/834help.c_v  $
 * 
 *    Rev 1.1   06 Jul 1994 10:09:24   gregs
 * Fixed a bug which caused the bridge to crash whenever a telnet session was allowed
 * to timeout when a help display was at a pause prompt waiting for the user to hit a key.
 * 
 *    Rev 1.0   04 May 1993 16:03:24   franks
 * Initial revision.
 * 
 *    Rev 1.3   13 May 1992 14:53:24   franks
 * No change.
 * 
 *    Rev 1.2   04 May 1992 12:19:06   franks
 * 1). Modifed routine so that help will print minimum required characters
 *     in uppercase.
 * 
 *    Rev 1.1   14 Apr 1992 13:11:32   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:49:32   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*                      DecLike Help Routines 	
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/

#include <target.h>
#include <bridges.h>

/* NEW INCLUDES FOR THE DECLIKE USER INTERFACE */
#include <ascii.h>
#include <param.h>
#include <834parser.h>
#include <cpb.h>
#include <834helpstr.h>
#include <bridges.h>
#include <nvrecs.h>

extern NVR_BSTATUS *BridgeStatus;
extern CMDNODE_T root_node;
extern CMDNODE_T root_br[];
extern RAM_PIT rampit;
extern CPB_T   cpb;


/*****************************************************
** do_helpmode
******************************************************/
do_helpmode(c)
char c;
{
	register RAM_PIT *pram = &rampit;
	CPB_P pcpb             = &cpb;

	switch(c){
	case CR:
		if(pram->ii == 0)
		{
			HELP_P phelp=(HELP_P) pcpb->parmptr;
			/* firt char is CR */
			if(phelp->count == 0)
			{
				/*no more ascend node */
				pram->mode = CMDMODE;
				printf("\n");
			}
			else
			{
				phelp->count--;
				pcpb->node = phelp->node[phelp->count];
				prnt_prompt(pcpb);
			}
		}
		else
		{
			pram->cmd_line[pram->ii] = 0;
			pcpb->cmdlen = pram->ii;
			pcpb->cmd = (char *)pram->cmd_line;
			pcpb->cl_idx = 0;
			executehelp(pcpb);
		}
		exit_cmd();
		break;

	case '?':     /* question Mark, re-print current help  */

		printf("\n\n");
		prnt_help(pcpb);
		exit_cmd();
		c = ' ';
		break;

	case 0x1A:  /* CTL-Z */

		pram->mode = CMDMODE;
		pram->ii = 0;
		printf("\n");
		exit_cmd();
		c = ' ';
		break;

	default:
		/* delkey on the command line */
		if(c == BS || c == 0x7f )
		{
			do_BS();
			break;
		}
		if(pram->ii >= MAX_CL-1)
			c=BELL;
		else
			pram->cmd_line[pram->ii++]= c;

	}
	return c;
}

/******************************************************************************/
							/* Start root_help() */
root_help( CPB_P pcpb)  {

	RAM_PIT *pram;
	HELP_P  phelp=(HELP_P) pcpb->parmptr;

	pram= (RAM_PIT *)&rampit;
	pram->mode=HELPMODE;
	memset(pcpb->parmptr,NULL,PARAMAX);
	
	pcpb->operation = FHELP;
	phelp->count=0;
	phelp->node[0] = pcpb->node;
	executehelp(pcpb);
	return 0;
}

/******************************************************************************/
							/* Start executehelp() */
executehelp(pcpb)
CPB_P pcpb;
{
	char *kw;
	int retcode;
	int length;
	int i,j;
	char c;
	char NO_DOC[] = "\nSorry, no documentation for %s ";
	struct help_struct *phelp;

	remove_tail(pcpb);		/* remove trailing blanks */

	if(pcpb->node == 0)
	{
		pcpb->node=(CMDNODE_P)&root_node;
		memset(pcpb->parmptr, NULL, PARAMAX);
	}

	if(pcpb->cmdlen == 0)
		pcpb->node = (CMDNODE_P)&root_br[0];

	if(pcpb->cmdlen > 0)
	{
		/* only if the command length i greater than 0 */
		for(; pcpb->cl_idx <= pcpb->cmdlen;)
		{
			if((retcode=find_node(pcpb)) != 0)
			{
				printf(NO_DOC,&pcpb->cmd[pcpb->cl_idx]);

				/* update cl_idx in error conditions */
				pcpb->cl_idx=pcpb->cmdlen+1;	
				break;
			}
			else
			{
				phelp = (struct help_struct *)pcpb->parmptr;
			
			    /* THIS IS FOR A COMMAND WHICH PROVIDES ITS OWN 
				HELP FUNCITON. */

				if(pcpb->node->flag1 & PROC_HELP) {
				/* If I need to jump into the routine, */
				/* I do it                             */
					(*pcpb->node->kw_proc) (pcpb);
				}

				/* found a node */
				phelp->count++;
				phelp->node[phelp->count]=pcpb->node;
			}
		}
	}
	if(pcpb->node == (&root_node))
		pcpb->node = root_br;
	prnt_help(pcpb);

	return(0);
}

/*****************************************************************************/
							/* Start prnt_help() */
prnt_help( CPB_P pcpb)  {

	prnt_hlptxt(pcpb);
	prnt_branches(pcpb);
	prnt_prompt(pcpb);
}

/*****************************************************************************/
							/* Start prnt_hlptxt() */
prnt_hlptxt( CPB_P pcpb) {

	HELP_P phelp=(HELP_P) pcpb->parmptr;
	char *hlptext=pcpb->node->help;
	char *subtext;
	char cmdstr[30];
	int level;
	int i;

	printf("\n\n");
	if(phelp->count == 0)
	{
		printf("%s\n", phelp->node[0]->kw);

	}
	else
	{
		for( i=1; i <= phelp->count; i++ )
		{
			if(phelp->node[i]->flag1 & PREFIX)
				printf("[%s] ",phelp->node[i]->suffix);

			/* Convert the cmd string to uppercase, but */
			/* don't change it permently.               */
			memset(cmdstr, NULL, sizeof(cmdstr));
			strcpy(cmdstr ,phelp->node[i]->kw); 
			/* strupr(cmdstr); */                  /* FRANKTEMP */

			printf("%s ",cmdstr); 
			if( strcmpi(cmdstr, "PORT") == 0 && 
				((strcmpi(phelp->node[i-1]->kw, "Define") == 0) ||
                 (strcmpi(phelp->node[i-1]->kw, "Clear")  == 0))) 
	            printf("{port-list} "); 

			if(phelp->node[i]->flag1 & MKW)
			{
				int len = strlen(phelp->node[i]->kw)+1;
				printf("%s ",(phelp->node[i]->kw+len));
			}
			if((phelp->node[i]->suffix != 0) && !(phelp->node[i]->flag1 & PREFIX))
				printf("[%s] ",phelp->node[i]->suffix);
		}
	}

	/* print help text */
	PrntHlpStr( hlptext );
	printf("\n");
}

/*****************************************************************************/
							/* Start prnt_branches() */
prnt_branches( CPB_P pcpb) {

	CMDNODE_P ap;
	int i;
	int n=0;
	char *kw2;

	if((rampit.mode == PASSWORDMODE) || (pcpb->node->branches == 0))
		return;

	printf("%s\n",TADDITION);
	for(ap=(CMDNODE_P)pcpb->node->branches;ap->kw != 0;ap++)
	{
		if(pcpb->operation == FSET && ap->flag1  & NO_SET)
			continue;
		if(pcpb->operation == FDEFINE &&  ap->flag1 & NO_DEFINE)
			continue;
		/* Don't print hidden commands */
                if(strcmpi("HLS", ap->kw) == 0)
			continue;
		
		i=26;
		if(ap->flag1 & PREFIX)
		{
			printf("%s ",ap->suffix);
			i -= strlen(ap->suffix)+1;
		}

		i -= strlen(ap->kw);
		if (ap->flag1 & MKW)
		{
			kw2=ap->kw+strlen(ap->kw)+1;
		    printf("%s %s",ap->kw,kw2);
			i -= 1+strlen(kw2);
		}
		else {
			printf("%s",ap->kw);
		}

		if(ap->suffix != 0 && !(ap->flag1 & PREFIX))
		{
			i -= 1+strlen(ap->suffix);
			printf(" %s",ap->suffix);
		}

		for( ; i > 0; i--)
			printf(" ");

		n++;
		if((n % 3)  == 0)
		{
			printf("\n");
			n=0;
		}
	}
	if(n != 0)
		printf("\n");
	printf("\n");
}

/*****************************************************************************/
							/* Start prnt_prompt() */
prnt_prompt( CPB_P pcpb)  {

	HELP_P phelp=(HELP_P) pcpb->parmptr;
	int i;

	if(pcpb->node->branches == 0)
	{
		pcpb->node=(CMDNODE_P)pcpb->node->asc_node;
		if(pcpb->node == phelp->node[phelp->count - 1])
			phelp->count--;
		else
			phelp->node[phelp->count] = pcpb->node;
	}

	/* print prompt */
	printf("\n");
	if(phelp->count == 0)
		printf(Topic);
	else
	{
		for(i=1;i<=phelp->count;i++)
			printf("%s ",phelp->node[i]->kw);
		printf(Subtopic);
	}

}

/*****************************************************************************/
                         /* Start PrntHlpStr() */
PrntHlpStr( char *txt ) {

	uint lines;
    char ch;

	for( lines = 0 ; *txt != '\0'; txt++ ) {

		if( *txt == '\n' ) {
			lines++;
		}

        if( lines == 20 ) {
			 if( Pageinate() )
			     break;
			lines = 0;
		}

		putchar(*txt);
	}
}
