
/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834util1.c
*
*       $Log:   /b/gregs/bridge/declike/util/834util1.c_v  $
 * 
 *    Rev 1.13   19 Nov 1993 10:08:18   gregs
 * When the bridge is first initialized add saved port 4 addresses to the cam.
 * 
 *    Rev 1.12   11 Nov 1993 15:49:00   vinay
 * changed fddi rcv counter from copied count to copied count + fddi_rcv_pkt
 * 
 *    Rev 1.11   08 Nov 1993 15:32:58   vinay
 * fixed the counter problem
 * 
 *    Rev 1.10   13 Sep 1993 12:08:14   gregs
 * lsh 9/13/93 Changed default name from multi-port ... to HLS 836.
 * 
 *    Rev 1.9   13 Sep 1993 12:01:16   vinay
 * changed the string order for strcmpi in SetPortList and SetPrcPort..
 * 
 *    Rev 1.8   13 Sep 1993 10:17:34   vinay
 * changed strncmp in SetPortList and SetPrcPortList to strcmpi
 * 
 *    Rev 1.7   08 Sep 1993 09:28:20   gregs
 * lsh Added GetNetMask routine.
 * 
 *    Rev 1.6   03 Sep 1993 11:09:46   gregs
 * modified SetRestrict routine to use FORWARD/FILTER instead ENABLE/DISABLE
 * 
 *    Rev 1.5   30 Aug 1993 18:08:00   gregs
 * Fixed code to accept lower case indices 'a' to 'j'.
 * 
 *    Rev 1.4   16 Aug 1993 14:28:44   vinay
 * fixed 2 bugs 1. clear mod counters was not clearing fddi counters
 * 2. restart the inactivity timer after a character is recieved by the screen pause prompt.
 * 
 * 
 *    Rev 1.3   30 Jul 1993 13:39:50   franks
 * Internal engineering release
 * 
 *    Rev 1.2   18 Jun 1993 11:26:38   franks
 * Changed the InitLAdr routine so that it adds the FDDI port address twice
 * Once in cononical, and once in non-cononical form to the working database.
 * 
 *    Rev 1.1   18 Jun 1993 10:08:18   vinay
 * Added the clear fddi counter support
 * 
 *    Rev 1.0   04 May 1993 16:04:14   franks
 * Initial revision.
 * 
 *    Rev 1.6   13 May 1992 14:39:22   franks
 * 1). Changed the ip status screen so that the primary and secondary 
 *     router fields display.
 * 
 *    Rev 1.5   04 May 1992 12:52:12   franks
 * No change.
 * 
 *    Rev 1.4   17 Apr 1992 16:18:10   franks
 * No change.
 * 
 *    Rev 1.3   16 Apr 1992 14:47:18   franks
 * No change.
 * 
 *    Rev 1.2   16 Apr 1992 10:52:42   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:12:58   franks
 * 1). No changes make.
 * 
 *    Rev 1.0   30 Mar 1992 17:51:52   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/

#include <types.h>
#include <target.h>
#include <bridges.h>
#include <utility.h>
#include <krnl.h>
#include <stp.h>
#include <sncvar.h>
#include <nvrecs.h>
#include <prcadr.h> 
#include <prcctl.h>
#include <eeprecs.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <dips.h>
#include <cpb.h>
#include <priv_tbl.h>
#include <834error.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>
#include <cpb.h>
#include <param.h>
#include <834parser.h>

/*  Function Declarations */

uint HashNid();
void PrintBitMaskHeader();
void PrintBitExpressionHeader();
void PrintMultipleIP();
void PrintMultipleHeader();
char *GetEepIpAddr();
struct tm *Ticks2DateTm();

/*****************************************************************************/
                     /*   EXTERNAL VARIABLES DECLARATION   */

extern char          *APPLSOFTVERSION;
extern char          *HLSVersion;
extern NVR_BSTATUS   *BridgeStatus;
extern Port_data     port_info[];
extern Bridge_data   bridge_info;
extern PRCCTL        prc;
extern NID           LocalAddress[];
extern NVR_NID_RECS  *NvramNids;
extern NVR_PROTOCOLS nvr_udpd;
extern NVR_RESETLOG  *RstLog;
extern tcpip         *_initp;
extern SV            sv_var[];
extern SDV           *sv_sdvs;
extern TIMER         IntervalTimer;
/* extern long          *snmp_count;  */
extern uint          ClearCounterTicks;



/*****************************************************************************/
/* Start bswap() */
bswap( unsigned *Val ) {
	
	uint temp = *Val;

	*Val = 0;
	*Val = (((temp << 8) & 0xffff) | (temp >> 8));
}

/*****************************************************************************/
/*	Start PrintIPAddress()  */
void PrintIPAddress( IPAddress1)
long IPAddress1;
{
	char *ipa;

	ipa = (char *) inet_ntoa( IPAddress1 );
	if ( IPAddress1 == 0 )
	{
		printf (" %s\n",
				 NA);
	}
	else
	{
		printf (" %s\n",
				ipa);
	}
}
/*	End PrintIPAddress()  */

/*****************************************************************************/
/* Start SaveBStatus() */
SaveBStatus()  {
	uint RetCode;
#ifdef vinay
printf("SaveBSTATUS ADDR = %x; size = %x\n",NVR_BSTATUS_ADDR,NVR_BSTATUS_SIZE);
#endif
	RetCode = Nvram_Updt( NVR_BSTATUS_ADDR, BridgeStatus, NVR_BSTATUS_SIZE );
	if(RetCode) 
		printf("Error: (%d) Cannot save BridgeStatus to NVRAM..\n", RetCode);
}
/* End SaveBStatus() */

/******************************************************************************/
/* Start GetBStatus() */
GetBStatus()  {
	uint RetCode;

	RetCode = Nvram_Load( NVR_BSTATUS_ADDR, BridgeStatus, NVR_BSTATUS_SIZE );
	if(RetCode) { 
#ifdef 0
printf("ADDR =  %x; SIZE = %x\n", NVR_BSTATUS_ADDR,NVR_BSTATUS_SIZE );
#endif
		printf("Error: (%d) Cannot load BridgeStatus from NVRAM..\n", RetCode);
		return(1);
	}
	else
		return(0);
}
/* End GetBStatus() */

/*****************************************************************************/
/* Start SaveRstLog() */
SaveRstLog()  {
	uint RetCode;

	RetCode = Nvram_Updt( NVR_RESETLOG_ADDR, RstLog, NVR_RESETLOG_SIZE );
	if(RetCode) 
		printf("Error: (%d) Cannot save Reset Log to NVRAM..\n", RetCode);
}
/* End SaveRstLog() */

/******************************************************************************/
/* Start GetRstLog() */
GetRstLog()  {
	uint RetCode;

	RetCode = Nvram_Load( NVR_RESETLOG_ADDR, RstLog, NVR_RESETLOG_SIZE );
	if(RetCode) { 
		printf("Error: (%d) Cannot load Reset Log from NVRAM..\n", RetCode);
		return(1);
	}
	else
		return(0);
}
/* End GetRstLog() */

/******************************************************************************/
/* Start AdrToNvram() */
AdrToNvram()  {
	uint RetCode;

	RetCode = Nvram_Updt( NVR_NID_RECS_ADDR, NvramNids, NVR_NID_RECS_SIZE );
	if(RetCode) 
		printf("Error: (%d) Cannot Save NvramNids To NVRAM..\n", RetCode);
}
/* End AdrToNvram() */

/******************************************************************************/
/* Start NvramToAdr() */
NvramToAdr()  {
	uint RetCode;

	RetCode = Nvram_Load( NVR_NID_RECS_ADDR, NvramNids, NVR_NID_RECS_SIZE );
	if(RetCode) {
	 /*printf("Error: (%d) Cannot Load NVRAM Address Database..\n", RetCode); */
		return(1);
	}
	else
		return(0);
}
/* End NvramToAdr() */


/******************************************************************************/
/* Start SaveProtocolTbl() */
SaveProtocolTbl()  {
	uint RetCode;

	RetCode = Nvram_Updt( NVR_PROTOCOLS_ADDR, &nvr_udpd,
						  NVR_PROTOCOLS_SIZE );
	if(RetCode) 
		printf("Error: (%d) Cannot save user defined protocols to NVRAM..\n",
				RetCode);
}
/* End SaveProtocolTbl() */

/******************************************************************************/
/* Start GetProtocolTbl() */
GetProtocolTbl()  {
	uint RetCode;

	RetCode = Nvram_Load( NVR_PROTOCOLS_ADDR, &nvr_udpd,
						  NVR_PROTOCOLS_SIZE );
	if(RetCode) {
		printf("Error: (%d) Cannot load user defined protocols from NVRAM..\n",
				RetCode);
		return(1);
	}
	else
		return(0);
}
/* End GetProtocolTbl() */

/******************************************************************************/
/*  Start InitDateTime() */
InitDateTime()  {

	uint yr;
	uint mon;
	struct tm *DateTm;
	extern struct tm DateTime;
	extern unsigned long BootUpSeconds;     /* located in init.c */
	extern unsigned long InitDateSeconds;
	extern unsigned long InitTimeSeconds;

	/* If time protocol failed */
	if( BootUpSeconds == 0 ) {
	    InitDateSeconds  = THE70S; /* secs between jan 1 1970 and jan 1 1990 */
	    InitTimeSeconds	 = 0;

	    DateTime.tm_sec  = 0;	  	  /* Seconds */
    	DateTime.tm_min  = 0;	  	  /* Minutes */
    	DateTime.tm_hour = 0;	  	  /* Hours (0-24) */
    	DateTime.tm_mday = 1;	  	  /* Day of Month (1-31) */
    	DateTime.tm_mon  = 0;     	  /* Month (0-11; January = 0) */
    	DateTime.tm_year = 90;    	  /* Current year minus 1900 */
	}
	else {
		InitDateSeconds = BootUpSeconds;
		InitTimeSeconds = 0;

        /* get the current date and time */
        DateTm = Ticks2DateTm();	
	
	    if(DateTm == 0) {
	
	        DateTime.tm_sec  = 0;	  	  /* Seconds */
	        DateTime.tm_min  = 0;	  	  /* Minutes */
	        DateTime.tm_hour = 0;	  	  /* Hours (0-24) */
        	DateTime.tm_mday = 1;	  	  /* Day of Month (1-31) */
	        DateTime.tm_mon  = 0;     	  /* Month (0-11; January = 0) */
	        DateTime.tm_year = 90;    	  /* Current year minus 1900 */
	        
			InitDateSeconds  = THE70S; /*secs tween jan 1 1970 and jan 1 1990*/
	        InitTimeSeconds	 = 0;
		}
		else {

	        DateTime.tm_mday = DateTm->tm_mday;
	        DateTime.tm_mon  = DateTm->tm_mon ;
	        DateTime.tm_year = DateTm->tm_year;
	        DateTime.tm_hour = DateTm->tm_hour;
	        DateTime.tm_min  = DateTm->tm_min;
	        DateTime.tm_sec  = DateTm->tm_sec;

			yr = DateTime.tm_year+1900;
            InitDateSeconds = DateToSeconds(DateTime.tm_mday,
											DateTime.tm_mon,
											yr);
			InitTimeSeconds = ((DateTime.tm_hour * 3600) +
							   (DateTime.tm_min  * 60)   +
							   (DateTime.tm_sec));
        }
	}
	return(0);
}

/******************************************************************************/
                        /* Start Ticks2Time() */
struct tm *Ticks2DateTm() {

	unsigned long TimeTicks;
	extern unsigned long InitTimeSeconds;
	extern unsigned long InitDateSeconds;
	extern long GmtOffset;

	/* Get time ticks  since system started */
	TimeTicks = RealTimeTicks();

	/* Convert ticks to seconds. Each tick = 10ms */
	TimeTicks /= 100;

	/* Add in time set by user and convert to hour, min, sec format */
	TimeTicks += InitTimeSeconds + InitDateSeconds;

	return( gmtime( &TimeTicks ) );	

}
/******************************************************************************/
                         /*  Start GetDate() */
GetDate( uint *day, uint *mon, uint *yr )  {

	struct tm *DateTm;

	/* get the current date and time */
	DateTm = Ticks2DateTm();	

	if(DateTm == 0)
		return(1);
	
	*day = DateTm->tm_mday;
	*mon = DateTm->tm_mon + 1;
	*yr  = DateTm->tm_year+1900;
	return(0);
}
/******************************************************************************/
                         /*  Start GetTime() */
GetTime( uint *hour, uint *min, uint *sec )  {

	struct tm *DateTm;

	/* get the current date and time */
	DateTm = Ticks2DateTm();	

	if(DateTm == 0)
		return(1);
	
	*hour = DateTm->tm_hour;
	*min  = DateTm->tm_min;
	*sec  = DateTm->tm_sec;
	return(0);
}


/******************************************************************************/
/*  Start GetUpTime() */
GetUpTime( uint *day, uint *hour, uint *min ) {

	uint TimeTicks;
	uint secs;

	TimeTicks = RealTimeTicks();
	secs  = TimeTicks / 100;

	*day  = secs / 3600 / 24;
	*hour = ((secs / 3600) - (*day * 24));
	*min  = (secs % 3600)/60;
	return( 0 );
}


/******************************************************************************/
/*  Start DateToSeconds() */
DateToSeconds( uint day, uint mon, uint yr) {

	uint InitSeconds = 631152000;    /* secs between jan 1 1970 & jan 1 1990 */
	uint i, days;
	uint seconds = 0;
	uint DaysInMonth[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

	/* Seconds between jan 1 1990 and jan 1 of yr */
	for(i=1990; i < yr; i++)  {

		/* check for leap year */
		if((i % 4) == 0) 
			days = 366;
		else
			days = 365;

		seconds += (days*24*3600);
	}


	/* Seconds between jan 1 and mon 1 */
	for(i=0; i < mon; i++)  {

		/* If month is Feburary check if it's leap year */
		if( (i == 1) && ((yr % 4) == 0)) {
			seconds += (29*24*3600);
        }
		else
			seconds += (DaysInMonth[i]*24*3600);
	}	

	/* Seconds between mon 1 @ 00:00:00  and day @ 00:00:00 */
	for(i=1; i < day; i++) {

		seconds += (24*3600);
	}
	
	return( InitSeconds + seconds );
}

/******************************************************************************/
/* Start InitPrcctl() */
InitPrcctl() {

	register PRCCTL *prcctl = &prc;
	uint i;
	uint BitSet;

	prcctl->Prc_Learning    = (byte)BridgeStatus->Learning;
	prcctl->Prc_ProtFlt     = (byte)BridgeStatus->ProtFilter;
	prcctl->Prc_ProtFltMode = (byte)BridgeStatus->FilterMode;
	prcctl->Prc_RestInUcast = (byte)BridgeStatus->RestrictInUCast;
	prcctl->Prc_RestInMcast = (byte)BridgeStatus->RestrictInMCast;
	prcctl->Prc_RestOut     = (byte)BridgeStatus->RestrictOutbound;
	prcctl->Prc_UnknUcast   = (byte)BridgeStatus->UnkUCast;
	prcctl->Prc_UnknMcast   = (byte)BridgeStatus->UnkMCast;
	prcctl->Prc_AgeCnt      = (byte)0xa;
	prcctl->Prc_PortState   = (byte)BridgeStatus->PortState; 
	prcctl->Prc_StpMode     = (byte)BridgeStatus->StpMode; 
	prcctl->Prc_PacketSize  = (byte)BridgeStatus->PacketSize;


	for( i=0, BitSet=1; i < ACTUALMAXPORT; i++, BitSet<<=1)  {

		prcctl->Prc_PortStpState[i]  = (byte)1;
		strcpy(&(prcctl->Prc_BitMskFltExp[i]),
			   &(BridgeStatus->BMExpression[i].BMExpRevPolish[0]));

		switch( BridgeStatus->BMExpression[i].BMMode )  {

			case NONE:	 prcctl->Prc_BitMskFlt     &= (byte)~BitSet;
						 break;	

			case BLOCK:  prcctl->Prc_BitMskFlt 	  |=  (byte)BitSet;
						 prcctl->Prc_BitMskFltMode &= (byte)~BitSet;
						 break;	

			case PERMIT: prcctl->Prc_BitMskFlt 	  |= (byte)BitSet;
						 prcctl->Prc_BitMskFltMode |= (byte)BitSet;
						 break;	
	 	}
#ifdef FSFIX

	    /* Plus I am guilty of initializing one channel driver param here.  */
	    /* The channel driver automatically enables the rx thresshold       */
		/* function. When the application is initialize it will check NVRAM */
		/* and turn of rx thresshold if necessary.                          */

		if( !(BridgeStatus->RxThreshhold & BitSet) ) 
			sv_vars[i].sv_xmtwdt = (shrt)0;
#endif
	}
	return(0);
}

/******************************************************************************/
/* Start InitAddressTbl() */
/* Will add  proprietary addresses to the RAM address table. These addresses */
/* include the 4 port ethernet addresses, the spanning tree group address and */
/* a broadcast address. These addresses will be assigned to port 0 to         */
/* distinguish them from other learned addresses. They will not be displayed  *//* and cannot be deleted by the user. They will be hidden from the user.      */

InitAddressTbl() {

	uint i;
	uint hash;
	ADR  *NewAdrNode;

	for( i=0; i < NUMLADR; i++ ) {

		hash = HashNid( &LocalAddress[i] );
	 	NewAdrNode = prc_get_addr();
		NewAdrNode->adr_hom = 0;
		SetInUse( NewAdrNode );
		memcpy( &NewAdrNode->adr_low, &LocalAddress[i], 6 );
		AddToHashTbl( hash, NewAdrNode );
	}
}

/******************************************************************************/
/*  Start InitLAdr() */
InitLAdr()  {

	uint i;
	NID  *LNid;
	char  tmpnid[6];
	extern NID STPLAdr;
	extern NID BCastAdr;
	extern char Port4EthNid[6];

	for( i=0; i < ACTUALMAXPORT; i++ )  {

		LNid = (NID *) MyNid(i);	
		memcpy( &LocalAddress[i], LNid, 6 );
	}

	/*********************************************************************
	**** The following is a change made to accomadate FDDI. The port 4 
	**** ethernet address is added twice to the database. Once in 
   **** cononical format and once in non-cononical format.
	***/
	memcpy( &tmpnid[0], (char *)MyNid(i-1) ,  6 );
	swap_bits(&tmpnid[0], 6);
	memcpy( &LocalAddress[i++], &tmpnid[0], 6 );
	memcpy( &Port4EthNid[0], &tmpnid[0], 6);  /* Store a copy for later use */
	/*********************************************************************/
	memcpy( &LocalAddress[i++], &STPLAdr, 6 );   /* STP Group Address */
	memcpy( &LocalAddress[i], &BCastAdr, 6 );    /* Broadcast Address */
}
/*  End InitLAdr() */

/******************************************************************************/
/* Start SaveStaticRecs() */
SaveStaticRecs() {

	uint i,t;
	uint cnt = 0;
	ADR  *AdrRec;

	for(t=0; t<800; t++) {
		NvramNids->nvr_nids[t].adr_flg = 0;
		memset( &(NvramNids->nvr_nids[t].adr_low), NULL, 6);
	}

	/* Search ram address table for static addresses */
	for( i=0, t=0; i < ADR_REC_CNT && t < 800; i++ ) {

		AdrRec = &adr_recs[i];	
		if( (AdrRec->adr_flg & ADR_FLG_STC)           /* Statis Rec */
		  &&(AdrRec->adr_flg & ADR_FLG_NUS))   {	  /* Rec in use */
			cnt++;
			CopyAdrRec( &(NvramNids->nvr_nids[t++]), AdrRec ); 
		}	
	}
	AdrToNvram();
	printf("\n\n%d Static Address Records Saved.\n", cnt);
	return(0);
}

/******************************************************************************/
/*  Start CopyAdrRec() */
/*  Will copy a address record from one buffer to another */
CopyAdrRec( ADR *toBuf, ADR *fromBuf) {

	memcpy( &toBuf->adr_low, &fromBuf->adr_low, 6);
	toBuf->adr_hom = fromBuf->adr_hom;
	toBuf->adr_out = fromBuf->adr_out;
	toBuf->adr_in  = fromBuf->adr_in;
	toBuf->adr_flg = fromBuf->adr_flg;
	toBuf->adr_nxt = (ADR *)NULL;
}

/******************************************************************************/
/*  Start GetSavedAdr() */
GetSavedAdr()  {

	uint i;
	uint hash;
	ADR  *NewAdrNode;

	/* Get static record from Nvram */
	if( NvramToAdr() )
		return(1);

	/* Add static records to the ram address database */
	
	for( i=0 ; i < 800; i++ ) {
		if( NvramNids->nvr_nids[i].adr_flg & ADR_FLG_NUS )  { 	
			NewAdrNode = prc_get_addr();
			CopyAdrRec( NewAdrNode, &(NvramNids->nvr_nids[i]) );  
			hash = HashNid( (NID *)&NewAdrNode->adr_low );	
			AddToHashTbl( hash, NewAdrNode );
			/* If the address is on fddi port then add to cam  */
			if(NewAdrNode->adr_hom & 0x08)
				CamAdd((ushort *)&NewAdrNode->adr_low);
			
		}	 
	}

}

/*****************************************************************************/
/* Set BridgeStatus structure to default values.                             */

SetBridgeDefault() {

	uint i;
	extern int A_Port_Config_State;
	extern int B_Port_Config_State;

	memset(BridgeStatus, NULL, sizeof(NVR_BSTATUS));

	BridgeStatus->UnkMCast           = DISABLEMODE;
	BridgeStatus->UnkUCast           = DISABLEMODE;
	BridgeStatus->RestrictInMCast    = DISABLEMODE;
	BridgeStatus->RestrictInUCast    = DISABLEMODE;
	BridgeStatus->RestrictOutbound   = DISABLEMODE;
	BridgeStatus->FilterMode         = BLOCKMODE;
	BridgeStatus->ProtFilter         = DISABLEMODE;
	BridgeStatus->BFilterMode        = BLOCKMODE;
	BridgeStatus->StpMode            = STP_MODE_ENABLE;
	BridgeStatus->PortState          = ENABLEMODE;
	BridgeStatus->Learning           = ENABLEMODE;
	BridgeStatus->PacketSize         = STANDRD;
	BridgeStatus->Miscellaneous      = SYMBOLIC;
	BridgeStatus->TermType           = NONVT100;
	BridgeStatus->RxThreshhold       = ENABLEMODE;
	BridgeStatus->SNMPAuthentication = SNMP_ACC_NONE;

	/* By disabling LocalConfig ==> AutoConfig is enabled */
    /*BridgeStatus->LocalConfig      = BRG_MODE_DISABLE;	*/

	/*	Set up Name, Location, and Contact   */
	strcpy(BridgeStatus->Name,    "HLS 836");
	strcpy(BridgeStatus->Location,"");
	strcpy(BridgeStatus->Contact, "");

	setNVRAM_FDDIDefaults(&nvr_fddi_rec);
	PutFDDIRec(&nvr_fddi_rec);
	insert_hub_ring(0, get_ring_number());

				
	/* Initialize pre-defined protocol filter table to null */
	for( i=0; i < PROTNUM; i++ )
		BridgeStatus->PFilterList[i] = 0;

	/* Initialize the password to the default value: "bridge" */ 
	InitPassword("");  

	BridgeStatus->TimeOut          = (uint)5;
	/* Initialize Spanning Tree to default. */
	STP_dft_rst();
}

/******************************************************************************/
/***	commented out by K kong	3.18.92
SetHubSlotDefault() {

	BridgeStatus->hubid  = 0;
	BridgeStatus->slotid = 0;
}
***/
/******************************************************************************/
/*	Start WaitForPassword()  */
WaitForPassword()
{
	int  ch;
	int  RetCode;
	extern SEM SwUpdateFromSnmp;
	unsigned char Buffer[MAXPSWD];	/*	Password buffer to check against the stored value  */

	for(;;)		/*	Loop until valid password is entered  */
	{

		printf("Please Enter %s password: ", CONSOLE);
     
		Dip_reset();

        /* skip the password check? */
		if( sys.sys_switch & DIP4 )  { 
			/* Wait for any character */
			/* tty_in();	*/
			while(1) {

				ch = getch();
				ReSchedule();
				if( ch != -1 )
					break;
			   
				if( AcptSignal( &SwUpdateFromSnmp ) != 0 ) { 
					SwUpdateMsg();
					return( APPL_TFTP );
				}
			}
			break;
		}
		else
		if( (RetCode = GetPassword(Buffer, MAXPSWD)) == INVAL_PWD )
		{
			putchar ('\n');
			printf ("*****  Password entered is invalid  *****\n\n\n");
		}
		else
		if( RetCode == APPL_TFTP ) {
			return( APPL_TFTP );
		}
		else
		if (strcmp(&BridgeStatus->ConsolePassword, Buffer) == 0)
		{
			break;
		}
		else
		{
			putchar ('\n');
			printf ("*****  Password entered does not match  *****\n\n\n");
		}
	}

	putchar ('\n');
	return (0);
}
/*	End WaitForPassword()  */


/******************************************************************************/
/*	Start DoubleSwapHighLow()  */
void DoubleSwapHighLow(Value)
unsigned long *Value;
{
	unsigned long V1, V2;

	/*	First, swap low and high word  */
	*Value = ((*Value & 0x0000FFFF) << 16) | ((*Value & 0xFFFF0000) >> 16);

	/*	Then, swap low and high byte  */
	*Value = ((*Value & 0x00FF00FF) << 8) | ((*Value & 0xFF00FF00) >> 8);

}
/*	End DoubleSwapHighLow()  */

/******************************************************************************/
/*	Start PressAnyKey()  */
void PressAnyKey()
{
	printf ("\n\n**********     Press any key to continue or Escape key to abort     **********\n");
}
/*	End PressAnyKey()  */


/******************************************************************************/
/*	Start Pageinate()  */
Pageinate()
{
	unsigned char InChar;
	void TimedOut();
	extern RAM_PIT rampit;
	extern TIMER InactivityTimer;

	PressAnyKey();
	while ((InChar = tty_in()) == 0);		/*	Wait for a character  */
	StopTimer( &InactivityTimer );
	StartTimerCall( &InactivityTimer, (BridgeStatus->TimeOut*6000),
					(void *)TimedOut, (int)&rampit);
	return (InChar == ESC ? TRUE : FALSE);
}
/*	End Pageinate()  */


/******************************************************************************/
/*	Start Model()  */
char* Model()
{
	return ("836");
}
/*	End Model()  */

/******************************************************************************/
/* Start HashNid() */

uint HashNid( register NID *np )  {

   uint val;

   val =  (( np->nid[0] ^ np->nid[1] ^ np->nid[2] ) >> 1) ;
   return( val );
}

/* End HashNid() */

/***************************************************************/
/* These counters are for clearing the FDDI TX and RX Counters */
/***************************************************************/
uint ClrModMACtc = 0L;
/****
uint ClrModMACNotcc = 0L;
****/
uint ClrModMACcc = 0L;
extern uint Fddi_Rcv_Pkt;


/*  Start ClearMainTrScrn() */
void ClearMainTrScrn()  {

	int i;

	for( i=0; i < ACTUALMAXPORT; i++ )  {
		/*
		prcctl->prc_cnt_xmtd[i] = 0;
		prcctl->prc_cnt_rcvd[i] = 0;
		
		prcctl->prc_cnt_lrng[i] = 0;
		prcctl->prc_cnt_lxmt[i] = 0;
		prcctl->prc_cnt_ldsc[i] = 0;
		prcctl->prc_cnt_rbig[i] = 0;
		prcctl->prc_cnt_rsml[i] = 0;
		prcctl->prc_cnt_xbig[i] = 0;
		prcctl->prc_cnt_xsml[i] = 0;
		prcctl->prc_cnt_home[i] = 0;
		prcctl->prc_cnt_rsux[i] = 0;
		prcctl->prc_cnt_rskm[i] = 0;
		prcctl->prc_cnt_rsku[i] = 0;
		prcctl->prc_cnt_rdum[i] = 0;
		prcctl->prc_cnt_rduu[i] = 0;
		prcctl->prc_cnt_rdkx[i] = 0;
		prcctl->prc_cnt_rpro[i] = 0;
		prcctl->prc_cnt_xpro[i] = 0;
		prcctl->prc_cnt_rbmf[i] = 0;
		prcctl->prc_cnt_tbmf[i] = 0;
		prcctl->prc_cnt_free[i] = 0;
		prcctl->prc_cnt_rspn[i] = 0;
		prcctl->prc_cnt_tspn[i] = 0;
		prcctl->prc_cnt_rblk[i] = 0;
		prcctl->prc_cnt_tblk[i] = 0;
		*/

		sv_sdvs[i].sv_txcnt    = 0;
		sv_sdvs[i].sv_rxcnt    = 0;
		sv_vars[i].sv_crc      = 0;
		sv_vars[i].sv_lst      = 0;
		sv_vars[i].sv_rxfifo   = 0;
		sv_vars[i].sv_txfail   = 0;
		sv_vars[i].sv_clsn     = 0;
		sv_vars[i].sv_xmtlk    = 0;
		sv_vars[i].sv_rcvlk    = 0;
	}
	StpClearCounters();
	SnmpClearCounters();
	TcpClearCounters();
	UdpClearCounters();
	IpClearCounters();
	IcmpClearCounters();
	IfClearCounters();
	ClearModFddiCt();
    ClearCounterTicks = RealTimeTicks();
}
/*  End ClearMainTrScrn() */

/* 
**	This routine will remember the current traffic counter values
**	and when these counters get displayed, these values are subtracted
**	from the the actual counters and displayed.
*/

ClearModFddiCt()
{
	/*
	* ShowMibAttr gets the counter values in ClrModMAC* 	
	*/
	
	ShowMibAttr(1,fddiMACTransmit_Ct,4,1,&ClrModMACtc);
	ShowMibAttr(1,fddiMACCopied_Ct,4,1,&ClrModMACcc);
	ClrModMACcc +=  Fddi_Rcv_Pkt;
	/*********
	ShowMibAttr(1,fddiMACNotCopied_Ct,4,1,&ClrModMACNotcc);
	*********/
}

/******************************************************************************/
/*	Start Scroll()  */
void Scroll(Time)
int Time;
{
	int counter;

	for (counter = 1; counter <= Time; counter++)
		printf ("\n");
}
/*	End Scroll()  */

/******************************************************************************/
/* Start AddToHashTbl() */
AddToHashTbl( uint HashVal, ADR *NewNode )  {
	
	NewNode->adr_nxt  = adr_hshs[HashVal];
	adr_hshs[HashVal] = NewNode;
	return( 0 );
}
/* End AddToHashTbl() */

/******************************************************************************/
/*	Start Header()  */
void Header()
{
	printf ("\t\t\t       %s\n", MainHeader);
}
/*	End Header()  */


/******************************************************************************/
/*	Start Copyright()  */
void Copyright()
{
	printf ("\t\t\t\t\t   %s\n", MainCopyright);
}
/*	End Copyright()  */

/******************************************************************************/
                              /* Start PortList() */
PortList(Vector3, Which2, Length)
unsigned char **Vector3;
unsigned int *Which2;
unsigned int *Length;
{
	uint cnt = 0;
	uint AllFlag;

	*Which2 = 0;
	*Length = 0;
	AllFlag = TRUE;

	/*	Increment until next non blank character	*/
	while (**Vector3 == ' ') {
		(*Vector3)++;
		(*Length)++;
	}

	/*	If character is a '*', set all port bits and mark flag	*/
	while (**Vector3 == CHARACTER_ALL)
	{
		SetPortBit(Which2, ALLPORT);
		(*Vector3)++;
		AllFlag = FALSE;
		(*Length)++;
		cnt++;
	}

	/*	Increment until next non blank character	*/
	while (**Vector3 == ' ') {
		(*Vector3)++;
		(*Length)++;
	}

	/*	If character is '1234' and flag is TRUE then continue	*/
	while (((**Vector3 == CHARACTER_ONE)   ||
			(**Vector3 == CHARACTER_TWO)   ||
			(**Vector3 == CHARACTER_THREE) ||
			(**Vector3 == CHARACTER_FOUR)  ||
			(**Vector3 == CHARACTER_FIVE)  ||    
			(**Vector3 == CHARACTER_ALL)   ||
			(**Vector3 == ' '))            && (AllFlag)
		  )
	{
		(*Length)++;
		switch (*((*Vector3)++))
		{
			case CHARACTER_ONE:
				SetPortBit(Which2, PORT1);
				cnt++;
				break;

			case CHARACTER_TWO:
				SetPortBit(Which2, PORT2);
				cnt++;
				break;

			case CHARACTER_THREE:
				SetPortBit(Which2, PORT3);
				cnt++;
				break;

			case CHARACTER_FOUR:
				SetPortBit(Which2, PORT4);
				cnt++;
				break;

			case CHARACTER_FIVE:
				return( ERR_INV_ARG );
                /* SetPortBit(Which2, PORT5); 5PORT -- Delete this line... */
				break;

			case CHARACTER_ALL:
				return ( CMD_SYNTAX_ERR );

			case ' ':
				break;
		}
	}
        /* Make sure that a port list was entered */
	if( cnt == 0 ) 
	    return( ERR_NO_PORT );
	else
	    return (0);
}
/*	End PortList()  */

/******************************************************************************/
/*	Start SetPortBit()	*/
SetPortBit(Which2, SetBit)
unsigned int *Which2;
unsigned int SetBit;
{
	*Which2 |= SetBit;

	return (0);
}
/*	End SetPortBit()	*/


/******************************************************************************/
/*  Start ClearPortBit() */
ClearPortBit(Which2, ClearBit)
unsigned int *Which2;
unsigned int ClearBit;
{
    *Which2 &= ~ClearBit;

    return 0;
}
/*  End ClearPortBit() */

/******************************************************************************/
/*	Start ByteSetPortBit()	*/
ByteSetPortBit(Which2, SetBit)
byte *Which2;
byte SetBit;
{
	*Which2 |= SetBit;

	return (0);
}
/*	End ByteSetPortBit()	*/


/******************************************************************************/
/*  Start ByteClearPortBit() */
ByteClearPortBit(Which2, ClearBit)
byte *Which2;
byte ClearBit;
{
    *Which2 &= ~ClearBit;

    return 0;
}
/*  End ByteClearPortBit() */



/******************************************************************************/
/*	Start SetBitOrNot()	*/
SetBitOrNot(Which2, FwdFilt2, Value2)
unsigned int *Which2;
unsigned int FwdFilt2;
unsigned int *Value2;
{
	switch (FwdFilt2)
	{
		case FILTER:
			*Value2 |= *Which2;
			break;

		case FORWARD:
			*Value2 &= ~(*Which2);
			break;
	}

	return (0);
}
/*	End SetBitOrNot()	*/

/******************************************************************************/
/*	Start SetPrcBitOrNot()	*/
SetPrcBitOrNot(Which2, FwdFilt2, Value2)
byte *Which2;
unsigned int FwdFilt2;
byte *Value2;
{
	switch (FwdFilt2)
	{
		case FILTER:
			*Value2 |= *Which2;
			break;

		case FORWARD:
			*Value2 &= ~(*Which2);
			break;
	}
	return (0);
}
/*	End SetPrcBitOrNot()	*/

/******************************************************************************/
/* Start SetInUse() */
SetInUse( ADR *node ) {

	node->adr_flg |= ADR_FLG_NUS;
}

/* End SetInUse() */

/******************************************************************************/

/*	Start GetPassword()  */
GetPassword(Buffer1, BufferLength1)
unsigned char *Buffer1;		/*	Buffer to store incomming input characters  */
unsigned BufferLength1;		/*	Buffer length  */
{
	unsigned int i = 0;		/* character index counter            */
	unsigned char InComming = FALSE;
	int InChar;
    extern SEM SwUpdateFromSnmp;

	while (!InComming)
	{
		/* while ((InChar = tty_in()) == 0); */

		while(1) {

			InChar = getch();
			ReSchedule();
			if( InChar != -1 )
				break;
		   
			if( AcptSignal( &SwUpdateFromSnmp ) != 0 ) { 
				SwUpdateMsg();
				return( APPL_TFTP );
			}
		}

		switch (InChar)
		{
			case BKS:				/*	Backspace if possible  */
				if (i != 0) 
					i--;
				break;

			case CR:				/*	Carriage return  */
				Buffer1[i] = '\0';
				InComming = TRUE;	/*  Set the end of password to NULL  */
				break;

			case NULL:				/*	Carriage return  */
				Buffer1[i] = '\0';
				InComming = TRUE;	/*  Set the end of password to NULL  */
				break;

			default:
				if (i == BufferLength1 - 1)
					i--;
				Buffer1[i++] = ~InChar;	     /* 1's complement the char */
				/* overwrite last character if end     */
				break;
		}	/*	End switch  */
	}	/*	End while  */

	return ((i > 8) ? INVAL_PWD: NULL);
}
/*	End GetPassword()  */

/******************************************************************************/
/*  Start InitPassword() */
InitPassword(char *PassWord)  {

	char *PswdBuf;
	char *ch;

	PswdBuf = BridgeStatus->ConsolePassword;
	for(ch = PassWord; *ch != NULL; ch++)  {
		*PswdBuf++ = ~(*ch);
	}
	*PswdBuf = '\0';
}
/*  End InitPassword() */

/******************************************************************************/
/* Start toHexInt()   */
toHexInt(register char *NumStr)  {


	register  int i;
		  int value = 0;
		  int vh,position;


	for(i=0, position=0x1000; i<4; i++, position/=0x10)  {
		vh = 0;
		if((vh=ascii2Hex(*NumStr++)) == BADHEX)
			return( ERR_INV_ARG );

		value += vh * position;
	}
	return(value);
}
/* End toHexInt() */


/******************************************************************************/
/* Start ascii2Hex() */
ascii2Hex( register char c )  {

	if ('0' <= c && c <= '9')
		return (c-'0');
	if ('a' <= c && c <= 'f')
		return (c - 'a' + 10);
	if ('A' <= c && c <= 'F')
		return (c - 'A' + 10);
	return(BADHEX);
}
/* End ascii2Hex() */

/******************************************************************************/
/*	Start PrintDateTime()  */
void PrintDateTime()
{
	uint day, mon, yr;
	uint hr, min, sec;

	if(GetTime( &hr, &min, &sec )) {
		hr = 0; min = 0; sec = 0;
	}
	if(GetDate( &day, &mon, &yr )) {
		day = 1; mon = 1; yr = 1990;
	}

	printf ("\n%-8s %02d-%02d-%02d                                    %-8s \
	%02d:%02d:%02d\n",
	"Date", mon, day, yr, "Time", hr, min, sec);
}
/*	End PrintDateTime()  */

/******************************************************************************/
/*	Start PrintBitSetOrNot()  */
void PrintBitSetOrNot(Value, BitOnString, BitOffString)
unsigned int *Value;
char *BitOnString, *BitOffString;
{
	int i;

	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		if (*Value & i)
			printf ("%-11s", BitOnString);
		else
			printf ("%-11s", BitOffString);
	}
}
/*	End PrintBitSetOrNot()  */

/******************************************************************************/
/*	Start PrintPrcBitSetOrNot()  */
void PrintPrcBitSetOrNot(Value, BitOnString, BitOffString)
byte *Value;
char *BitOnString, *BitOffString;
{
	byte i;

	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		if (*Value & i)
			printf ("%-11s", BitOnString);
		else
			printf ("%-11s", BitOffString);
	}
}
/*	End PrintPrcBitSetOrNot()  */

/******************************************************************************/
/*	Start STPState()  */
char *STPState(state)
int state;
{
	char* ReturnCode;
	ReturnCode = NULL;

	switch (state)
	{
		case 0:
			ReturnCode = "DISABLED";
			break;

		case 1:
			ReturnCode = "LISTENING";
			break;

		case 2:
			ReturnCode = "LEARNING";
			break;

		case 3:
			ReturnCode = "FORWARDING";
			break;

		case 4:
			ReturnCode = "BLOCKING";
			break;
	}

	return (ReturnCode);
}
/*	End STPState()  */

/******************************************************************************/
/*	Start ControlCmdHeader()  */
void ControlCmdHeader(cptr2, Category2)
struct cmd *cptr2;
char *Category2[];
{
	printf ("\n%-20s      %-22s         %s %s\n\n",
			cptr2->CmdName, Category2, HLSVersion, APPLSOFTVERSION);
}
/*	End ControlCmdHeader()  */

/******************************************************************************/
/*	Start CommandSyntax()	*/
char *CommandSyntax(cptr2, Buffer)
struct cmd *cptr2;
char Buffer[110];
{
	char *Temp1, *Temp2;

	memset(Buffer, NULL, 110);


	Temp1 = cptr2->ShortHelp;
	Temp2 = Buffer;

	while (*Temp1 != '\n')
		*Temp2++ = *Temp1++;

	return (Buffer);
}
/*	End CommandSyntax()	*/

/******************************************************************************/
/*	Start STPPrintPortHeader()  */
void STPPrintPortHeader()
{
	/* 5PORT  - Uncomment when using 5 ports.....
	printf ("\t\t      %s 1       %s 2       %s 3       %s 4       %s 5 - HSB\n", PORT, PORT, PORT, PORT, PORT); 
	*/
	printf ("\t\t      %s 1       %s 2       %s 3       %s 4                 \n", PORT, PORT, PORT, PORT);
}
/*	End STPPrintPortHeader()  */


/******************************************************************************/
/*	Start PortHeader()  */
void PortHeader()
{
	/* 5PORT - Uncomment when using 5 ports....
	printf ("\t\t\t\t      %s 1     %s 2     %s 3     %s 4     %s 5 - HSB\n", PORT, PORT, PORT, PORT, PORT);
	*/
	printf ("\t\t\t\t      %s 1     %s 2     %s 3     %s 4               \n", PORT, PORT, PORT, PORT);
}
/*	End PortHeader()  */


/******************************************************************************/
/*	Start PrintThreshhold()  */
void PrintThreshhold(Value)
unsigned int Value[];
{
	int i;

	for (i = 1; i <= ACTUALMAXPORT; i++)
	{
		if (Value[i] == MINTHRESH)
			printf ("%-11s", DISABLESTRING);
		else
			printf ("%-11d", Value[i]);
	}
}
/*	End PrintThreshhold()  */

/******************************************************************************/
/*	Start GetIPAddress()  */
GetIPAddress(IP1, Vector2, ipa)
IP *IP1;
char *Vector2;
char *ipa;
{
	unsigned int argument, a, b, c, d;
	unsigned char e;

	argument = sscanf(Vector2, "%d.%d.%d.%d%c", &a, &b, &c, &d, &e);
	sscanf(Vector2, "%s", ipa);
	if (argument != 4 && argument != 5)
		return (ERR_IP_ADDRESS);

	if (a > 255 || b > 255 || c > 255 || d > 255)
	{
		return (ERR_IP_ADDRESS);
	}

	if (a == 255 && b == 255 && c== 255 && d == 255)
		return (ERR_IP_ADDRESS);

	if (a == 0 && b == 0 && c==  0 && d == 0)
		return (ERR_IP_ADDRESS);

	if (a == 127 )
		return (ERR_IP_ADDRESS);

	if (a == 255 )
		return (ERR_IP_ADDRESS);

	if ( (a & 0xE0) == 0xE0)
		return (ERR_IP_ADDRESS);

	if ( (a & 0xC0) == 0x80)
	{
		if (c == 0 && d == 0)
			return (ERR_IP_ADDRESS);
	}

	if ( (a & 0xE0) == 0xC0)
	{
		if (d == 0)
			return (ERR_IP_ADDRESS);
	}

	if (argument == 5)
		if (e != ' ' && e != '\t')
			return (ERR_IP_ADDRESS);

	IP1->IP[0] = a;
	IP1->IP[1] = b;
	IP1->IP[2] = c;
	IP1->IP[3] = d;

	if ((long*)IP1->IPAddress == 0L)
		printf ("\nIP address of 0 will be not applicable.\n");

	return (0);
}
/*	End GetIPAddress()  */

GetNetMask(IP1, Vector2, ipa)
IP *IP1;
char *Vector2;
char *ipa;
{
	unsigned int argument, a, b, c, d;
	unsigned char e;

	argument = sscanf(Vector2, "%d.%d.%d.%d%c", &a, &b, &c, &d, &e);
	sscanf(Vector2, "%s", ipa);
	if (argument != 4 && argument != 5)
		return (ERR_IP_ADDRESS);

	if (a == 0 && b == 0 && c==  0 && d == 0)
		return (ERR_IP_ADDRESS);

	if (argument == 5)
		if (e != ' ' && e != '\t')
			return (ERR_IP_ADDRESS);

	return 0;
}

/******************************************************************************/
/*	Start BitmaskStatusScreen()  */
void BitmaskStatusScreen()
{
	int i;

	PrintBitMaskHeader();
	for (i = 0; i < 10; i++)
	{
		switch (i)
		{
			case 0:
				printf ("%-5s", "A");
				break;

			case 1:
				printf ("%-5s", "B");
				break;

			case 2:
				printf ("%-5s", "C");
				break;

			case 3:
				printf ("%-5s", "D");
				break;

			case 4:
				printf ("%-5s", "E");
				break;

			case 5:
				printf ("%-5s", "F");
				break;

			case 6:
				printf ("%-5s", "G");
				break;

			case 7:
				printf ("%-5s", "H");
				break;

			case 8:
				printf ("%-5s", "I");
				break;

			case 9:
				printf ("%-5s", "J");
				break;
		}

		if (BridgeStatus->BMElement[i].ValueString[0] != NULL)
		{
			printf ("%-34s", strupr(BridgeStatus->BMElement[i].ValueString));
			printf ("%-8d", BridgeStatus->BMElement[i].BitMask.bm_ofst);
			if (strlen(BridgeStatus->BMElement[i].ValueString) == 8)
				printf ("%-13s", HEXADECIMAL);
			else
				printf ("%-13s", BINARY);
			printf ("%-d", BridgeStatus->BMElement[i].BitMask.bm_count);
		}
		else
		{
			printf ("%-34s", NA);
			printf ("%-8s", NA);
			printf ("%-13s", NA);
			printf ("%-8s", NA);
		}

		putchar ('\n');
	}

	putchar ('\n');

	PrintBitExpressionHeader();
	for (i = 0; i < ACTUALMAXPORT; i++)
	{
		switch (i)
		{
			case 0:
				printf ("%-12c", CHARACTER_ONE);
				break;

			case 1:
				printf ("%-12c", CHARACTER_TWO);
				break;

			case 2:
				printf ("%-12c", CHARACTER_THREE);
				break;

			case 3:
				printf ("%-12c", CHARACTER_FOUR);
				break;

			case 4:
				printf ("%-12c", CHARACTER_FIVE);
				break;
		}


		if (BridgeStatus->BMExpression[i].BMMode != NULL)
		{
			switch (BridgeStatus->BMExpression[i].BMMode)
			{
				case PERMIT:
					printf ("%-18s", "PERMIT");
					break;

				case BLOCK:
					printf ("%-18s", "BLOCK");
					break;
			}

			printf ("%-34s", BridgeStatus->BMExpression[i].BMExpString);
		/*	printf ("%-8s", BridgeStatus->BMExpression[i].BMExpRevPolish); */
		}
		else
		{
			printf ("%-18s", NA);
			printf ("%-34s", NA);
		}

		putchar ('\n');
	}
}
/*	End BitmaskStatusScreen()  */


/******************************************************************************/
/*	Start PrintBitMaskHeader()  */
void PrintBitMaskHeader()
{
	printf ("No.    4 Byte Bit Mask Definition     Offset    Format     Times Used\n");
	printf ("---  -------------------------------  ------  -----------  ----------\n");
}
/*	End PrintBitMaskHeader()  */


/******************************************************************************/
/*	Start PrintBitExpressionHeader()  */
void PrintBitExpressionHeader()
{
	printf ("Port No.    Filtering Mode    Bit Mask Filtering Expression\n");
	printf ("--------    --------------    -----------------------------\n");
}
/*	End PrintBitExpressionHeader()  */


/******************************************************************************/
/*	Start SNMPStatusScreen()  */
void SNMPStatusScreen()
{
	EEP_BOOT *BootRec = &eep_boot_rec;
	char Buffer[20];
	char *ipa;
	int i;

	printf ("%-14s %s\n", "Name", BridgeStatus->Name);
	printf ("%-14s %s\n", "Location", BridgeStatus->Location);
	printf ("%-14s %s\n\n", "Contact", BridgeStatus->Contact);

	ipa = (char *)GetEepIpAddr( MYIPADDR );
	if( ipa == 0L )
		printf ("%-14s %s\n", "IP Address", NA);
	else	
		printf ("%-14s %s\n", "IP Address", ipa);

	ipa = (char *)GetEepIpAddr( IPMASK );
	if( ipa == 0L )
		printf ("%-14s %s\n\n", "IP Mask", NA);
	else	
		printf ("%-14s %s\n\n", "IP Mask", ipa);

	printf("%-15s%d\n",   "SNMP Rx Count", snmp_count->inpktcount);
	printf("%-15s%d\n\n", "SNMP Tx Count", snmp_count->outpktcount);

	if(BridgeStatus->SNMPAuthentication == SNMP_ACC_COMMUNITY)
		printf ("%-14s %s\n\n\n", "Authentication", "COMMUNITY");
	else
	if(BridgeStatus->SNMPAuthentication == SNMP_ACC_NONE)
		printf ("%-14s %s\n\n\n", "Authentication", "NONE");
    else
		printf ("%-14s %s\n\n\n", "Authentication", "");

	PrintMultiHeaderTwo();

	printf ("%-14s ", "IP Router");
	for (i = 0; i < 2; i++)
	{
		ipa = (char *) inet_ntoa( BootRec->eep_RouterIP[i] );
		if( BootRec->eep_RouterIP[i] == 0 )
			ipa = NA;
		PrintMultipleIP( ipa );
	}
	putchar('\n');

	printf ("%-14s ", "Alarm Manager");
	for (i = 0; i < 2; i++)
	{
		ipa = (char *) inet_ntoa( BridgeStatus->SnmpMgr[i] );
		if( BridgeStatus->SnmpMgr[i] == 0 )
			ipa = NA;
		PrintMultipleIP( ipa );
	}
	putchar('\n');
}
/*	End SNMPStatusScreen()  */


/******************************************************************************/
/*	Start PrintMultipleIP()  */
void PrintMultipleIP(Buffer1)
char *Buffer1;
{
	printf ("%-15s ", Buffer1);
}
/*	End PrintMultipleIP()  */


/******************************************************************************/
/*  Start GetEepIpAddr() */
char *GetEepIpAddr( select )
uint select;
{

	EEP_BOOT *eep = 0;
	char *ipa;
 
		/* (EEP_BOOT *) GetEeprom(EEP_BOOT_ADDR, sizeof(EEP_BOOT)) */
	eep = &eep_boot_rec;

	switch( select ) {

		case MYIPADDR:
						ipa = (char *) inet_ntoa( eep->eep_IP );
						if( eep->eep_IP == 0 ) 
							ipa = 0;
						break;

		case IPMASK:
						ipa = (char *) inet_ntoa( eep->eep_NetMask );
						if( eep->eep_NetMask == 0 ) 
							ipa = 0;
						break;

		case TFTPSERVER:
						ipa = (char *) inet_ntoa( eep->eep_ServerIP );
						if( eep->eep_ServerIP == 0 )
							ipa = 0;
						break;

		case IPROUTR1:;
	}
	return(ipa);		
}
/*  End GetEepIpAddr() */

/******************************************************************************/
/*  Start GetImageFile() */
char *GetImageFile()  {

	EEP_BOOT *eep = 0;
	char *BootFile;

	eep = &eep_boot_rec;

	BootFile = &eep->eep_image_file[0];

	return( BootFile );
}
/* End GetImageFile() */

/******************************************************************************/
/*  Start GetRqstFile() */
char *GetRqstFile()  {

	EEP_BOOT *eep = 0;
	char *BootFile;

	eep = &eep_boot_rec;

	BootFile = &eep->eep_request_file[0];

	return( BootFile );
}
/* End GetRqstFile() */

/******************************************************************************/
/*  Start GetConfigFile() */
char *GetConfigFile()  {

	EEP_BOOT *eep = 0;
	char *BootFile;

	eep = &eep_boot_rec;

	BootFile = &eep->eep_config_file[0];

	return( BootFile );
}
/* End GetConfigFile */

/******************************************************************************/
/*	Start PrintMultipleHeader()  */
void PrintMultipleHeader()
{
	printf ("\t\t       No. 1           No. 2           No. 3           No. 4\n");
}
/*	End PrintMultipleHeader()  */

/******************************************************************************/
/*	Start PrintMultiHeaderTwo()  */
PrintMultiHeaderTwo()
{
	printf ("\t\t       No. 1           No. 2 \n");
}
/*	End PrintMultiHeaderTwo()  */


/******************************************************************************/
					/*	Start MainTrafficScreen()  */
MainTrafficScreen()
{

	Header();
	printf ("\t\t\t\t\t\t\t\t%s\n\n", TrafficMainScreen);

	TrafficPortHeader();

	printf ("%-24s", "Transmit Count");
	/* PrintPrcTrCntr( prcctl->prc_cnt_xmtd ); */
	PrintSonicTx();
	putchar ('\n');

	printf ("%-24s", "Receive Count");
	/* PrintPrcTrCntr( prcctl->prc_cnt_rcvd ); */
	PrintSonicRx();
	putchar ('\n');

	printf ("%-24s", "Rx CRC & Alignment Error");
	PrintSonicCrc();
	putchar ('\n');

	printf ("%-24s", "Rx No Resource Error");
	PrintSonicNre();
	putchar ('\n');

	printf ("%-24s", "Rx Overrun Error");
	PrintSonicRoe();
	putchar ('\n');

	printf ("%-24s", "Transmit Failure");
	PrintSonicTxFail();
	putchar ('\n');

    printf ("%-24s", "Transmit Collision");
    PrintSonicTxCol();
	putchar ('\n');

	printf ("%-24s", "Transmitter Lockup");
	PrintSonicTxLock();
	putchar ('\n');

	printf ("%-24s", "Receiver Lockup");
	PrintSonicRxLock();

	printf("\n\n%-24s", "STP Tx Config BPDU");
	PrintPrcTrCntr( &StpConfigTxBPDU[1] ); 
	
	printf("\n%-24s", "STP Rx Config BPDU");
	PrintPrcTrCntr( &StpConfigRxBPDU[1] );

	printf("\n%-24s", "STP Tx Top Change" );
	PrintPrcTrCntr( &StpTopChgTxBPDU[1] ); 

	printf("\n%-24s", "STP Rx Top Change" );
	PrintPrcTrCntr( &StpTopChgRxBPDU[1] ); 

	return(0);
}
/*	End MainTrafficScreen()  */


/******************************************************************************/
/*	Start TrafficPortHeader()  */
TrafficPortHeader()
{
	/* 5PORT - Uncomment when using 5 ports.....
	printf ("\t\t\t\t\t\t     %s 1     %s 2     %s 3     %s 4     %s 5\n", PORT, PORT, PORT, PORT, PORT);
	*/
	printf ("\t\t\t\t\t\t     %s 1     %s 2     %s 3     %s 4         \n", PORT, PORT, PORT, PORT);
}
/*	End TrafficPortHeader()  */

/******************************************************************************/
/*	Start PrintPrcTrCntr()  */
PrintPrcTrCntr( uint *Counter )
{
	int i;
	for (i = 0; i < ACTUALMAXPORT; i++ )
		printf (" %10ld", *(Counter+i));
}
/*	End PrintPrcTrCntr()  */
extern uint MacTx_Ct;
extern uint MACCopied_Ct;
extern uint MACNotCopied_Ct ;

/******************************************************************************/
/*	Start PrintSonicTx()   -- Total frames transmited */
PrintSonicTx()
{
	unsigned int i;

	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_sdvs[i].sv_txcnt);

	i = 0;

	/* FDDI TX COUNT */
	ShowMibAttr(1,fddiMACTransmit_Ct,4,1,&i);
	printf (" %10ld", (i >= ClrModMACtc) ? 
		(i - ClrModMACtc):i - (ClrModMACtc=0));
}
/*	End PrintSonicTx()  */

/******************************************************************************/
/*	Start PrintSonicRx()   -- Total frames received */
PrintSonicRx()
{
	uint i,value;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_sdvs[i].sv_rxcnt);

	value = 0;
	i = 0;
	/* MAC RX COUNT = NOT COPIED + COPIED CNT */
	ShowMibAttr(1,fddiMACCopied_Ct,4,1,&i);

	/* Fddi Rcv count is sum of MACcc and Fddi_Rcv_Pkt */
	i += Fddi_Rcv_Pkt;

	printf (" %10ld", (i >= ClrModMACcc) ? 
		(i - (ClrModMACcc)):i - (ClrModMACcc = 0));
}
/*	End PrintSonicRx()  */

/******************************************************************************/
/*	Start PrintSonicCrc()   -- CRC & Alignment Error */
PrintSonicCrc()
{
	int i;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_crc);
}
/*	End PrintSonicCrc()  */


/******************************************************************************/
/*	Start PrintSonicNre()    -- Rx No Resource Error */ 
PrintSonicNre()
{
	int i;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_lst);
}
/*	End PrintSonicNre()  */


/******************************************************************************/
/*	Start PrintSonicRoe()    -- Rx Overrun Error */
PrintSonicRoe()
{
	int i;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_rxfifo);
}
/*	End PrintSonicRoe()  */


/******************************************************************************/
/*	Start PrintSonicTxFail()    -- Tx Fail */
PrintSonicTxFail()
{
	int i;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_txfail);
}
/*	End PrintSonicTxFail()  */


/******************************************************************************/
/*	Start PrintSonicTxCol()    -- Tx Collisions */
PrintSonicTxCol()
{
	int i;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_clsn);
}
/*	End PrintSonicTxCol()  */

/******************************************************************************/
/*	Start PrintSonicTxLock()    -- Transmitter Lockup */
PrintSonicTxLock()
{
	int i;

	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_xmtlk);
}
/*	End PrintSonicTxLock()  */

/******************************************************************************/
/*	Start PrintSonicRxLock()    -- Receiver Lockup */
PrintSonicRxLock()
{
	int i;
	for (i = 0; i < ACTUALMAXPORT-1; i++ )
		printf (" %10ld", sv_vars[i].sv_rcvlk);
}
/*	End PrintSonicRxLock()  */

/******************************************************************************/
/*  Start PrintPortTrScrn() */
PrintPortTrScrn( uint PortMask )  {

	uint PortNum;

	putchar('\n');
	Header();
	switch (PortMask)  {
	
		case PORT1:
			PortNum = 1;
			break;

		case PORT2:
			PortNum = 2;
			break;

		case PORT3:
			PortNum = 3;
			break;

		case PORT4:
			PortNum = 4;
			break;
	}

	printf("\t\t\t\t  %s    %d    %s\n\n\n","P O R T",PortNum,
				    				"T R A F F I C    S C R E E N");
	printf("\t\t\tM A I N\t\t\t\t\t\t\t\t\t   S N M P\n\n");
	printf("%-24s %10ld\t\t", "Transmit Count",sv_sdvs[PortNum-1].sv_txcnt);
	printf("%-24s %10ld\n", "Transmit Count", 0 );
	printf("%-24s %10ld\t\t", "Receive Count",sv_sdvs[PortNum-1].sv_rxcnt );
	printf("%-24s %10ld\n", "Receive Count",0 );
	printf("%-24s %10ld\n", "Rx CRC & Alignment Error",
							 (sv_vars[PortNum-1].sv_crc));
	printf("%-24s %10ld\t\t\t\t", "Rx No Resource Error",
							        (sv_vars[PortNum-1].sv_lst) );
	printf("\t\tS T P\n");
	printf("%-24s %10ld\n", "Rx Overrun Error",
							 (sv_vars[PortNum-1].sv_rxfifo) );
	printf("%-24s %10ld\t\t", "Transmit Failure",
							 (sv_vars[PortNum-1].sv_txfail) );
	printf("%-24s %10ld\n","Tx Configuration BPDU", StpConfigTxBPDU[PortNum]);

	printf("%-24s %10ld\t\t", "Transmit Collision",
							 (sv_vars[PortNum-1].sv_clsn) );
	printf("%-24s %10ld\n","Rx Configuration BPDU", StpConfigRxBPDU[PortNum]);

	printf("%-24s %10ld\t\t", "Transmitter Lockup",
							 (sv_vars[PortNum-1].sv_xmtlk) );
	printf("%-24s %10ld\n","Tx Topology Change BPDU", StpTopChgTxBPDU[PortNum]);

	printf("%-24s %10ld\t\t", "Receiver Lockup",
							 (sv_vars[PortNum-1].sv_rcvlk) );
	printf("%-24s %10ld\n\n\n\n","Rx Topology Change BPDU",
								  StpTopChgRxBPDU[PortNum]);

}
/*  End PrintPortTrScrn() */

/******************************************************************************/
/*	Start SNMPOrConsolePswd()  */
SNMPOrConsolePswd(PswdType1)
int PswdType1;
{
	unsigned char OldPassword[MAXPSWD];
	unsigned char NewPassword[MAXPSWD];
	char *ConsoleOrSNMP;
    char *Pswd;
	char *p;

	Dip_reset();
	/*	Determine if this is a console or snmp password the user entered  */
	switch (PswdType1)
	{
		case 1:
			Pswd = BridgeStatus->ConsolePassword;
			ConsoleOrSNMP = CONSOLE;
			break;

		case 2:
			Pswd = BridgeStatus->SNMPPassword;
			ConsoleOrSNMP = SNMPPSWD;
			break;
	}

	printf ("Changing %s password for %s.\n", ConsoleOrSNMP, Model());
	printf ("Enter old %s password: ", ConsoleOrSNMP);

	/*	Get the password and validate against the store value  */
	if (GetPassword(OldPassword, MAXPSWD) == INVAL_PWD)
	{
		putchar ('\n');
		return (INVAL_PWD);
	}
	else
	if(( strcmp(Pswd, OldPassword) != 0 ) && !( sys.sys_switch & DIP4 ))
	{
		putchar ('\n');
		return (INVAL_PWD);
	}

	printf("\nEnter new %s password: ", ConsoleOrSNMP);

	/*	Get the new password and verify again  */
	if (GetPassword(OldPassword, MAXPSWD) == INVAL_PWD)
	{
		putchar ('\n');
		return (INVAL_PWD);
	}
	else
	{
		printf("\nRe-enter new %s password: ", ConsoleOrSNMP);
		if (GetPassword(NewPassword, MAXPSWD) == INVAL_PWD)
		{
			putchar ('\n');
			return (INVAL_PWD);
		}
		else
		if (strcmp(OldPassword, NewPassword) == 0)
		{
			putchar ('\n');
			strncpy(Pswd, NewPassword, MAXPSWD);
		}
		else
		{
			putchar ('\n');
			return (PWD_VER_FAIL);
		}
	}
	/*
	 *	K Kong	3.5.92
	 *	Password is the snmp community name.
	 *	We have to inform the admin bus driver that the
	 *	community has been changed.
	 */
	Pswd = (char *)NewPassword;
	p = BridgeStatus->ConsolePassword;
	while (*p != 0)
		*Pswd++ = ~*p++;
	*Pswd = '\0';
	AdmSetCommunity(NewPassword);
	return (0);
}
/*	End SNMPOrConsolePswd()  */

/******************************************************************************/
						/*	Start ChangeToIndex()  */
void ChangeToIndex(Number1, Index1)
unsigned char Number1;
uint          *Index1;
{

	switch (Number1)
	{
		case 'A':
			*Index1 = 0;
			break;

		case 'B':
			*Index1 = 1;
			break;

		case 'C':
			*Index1 = 2;
			break;

		case 'D':
			*Index1 = 3;
			break;

		case 'E':
			*Index1 = 4;
			break;

		case 'F':
			*Index1 = 5;
			break;

		case 'G':
			*Index1 = 6;
			break;

		case 'H':
			*Index1 = 7;
			break;

		case 'I':
			*Index1 = 8;
			break;

		case 'J':
			*Index1 = 9;
			break;
	}
}
/*	End ChangeToIndex()  */

/******************************************************************************/
/*	Start HexToMask()  */
HexToMask(px, ValueMask1, NumBytes1)
register char *px;			/* pointer to hex string      */
RECORDMASK *ValueMask1;
unsigned int NumBytes1;
{
	register unsigned char *pb;		/*	Pointer to binary string   */
	unsigned char HighByte, LowByte;	/*	Temporaries for result of HexValue() */
	int i;
	unsigned char *ptr;

	ptr = ValueMask1->AddressMask;

/* -----------------------------------------------------
 * convert a 12 digit hex-ASCII string to 6 bytes binary
 * , and put the converted string back on top of the first
 * bytes of the input string
 * ----------------------------------------------------- */
	pb = ValueMask1->AddressValue;
	for (i = 0; i < NumBytes1; i++)		/* for each of 6 pairs of digits */
	{
		if ((HighByte = HexValue(*px++, ptr, HIGH)) == BADHEX)	/* convert hi digit of pair */
			return (FAIL);
		if ((LowByte = HexValue(*px++, ptr, LOW)) == BADHEX)		/* convert lo digit of pair */
			return (FAIL);
		*pb++ = (HighByte << 4) + LowByte;		/* store bin val of the 2 hex digits */
		ptr++;
	}

	return (SUCCEED);
}
/*	End HexToMask()  */


/******************************************************************************/
/*	Start HexValue()  */
HexValue(c, ptr1, HighOrLow)
register char c;
register char *ptr1;
register unsigned char HighOrLow;
{
	if ('0' <= c && c <= '9')
	{
		*ptr1 |= HighOrLow;
		return c - '0';
	}

	if ('a' <= c && c <= 'f')
	{
		*ptr1 |= HighOrLow;
		return c - 'a' + 10;
	}

	if ('A' <= c && c <= 'F')
	{
		*ptr1 |= HighOrLow;
		return c - 'A' + 10;
	}

	if (c == 'x' || c == 'X')
	{
		return (0);
	}

	return (BADHEX);
}
/*	End HexValue()  */


/******************************************************************************/
/*	Start BinaryToMask()  */
BinaryToMask(CharPtr, BinaryMask1)
register char *CharPtr;		/*	Pointer to binary string  */
BINARYMASK *BinaryMask1;	/*	Store binary filter mask and value  */
{
	unsigned long *Value, *Mask;
	int	counter;

	Value = &BinaryMask1->BinValue;
	Mask = &BinaryMask1->BinMask;

	/*	Walk through the 32 input characters  */
	for (counter = 1; counter < 33; CharPtr++, counter++)
	{
		switch (*CharPtr)
		{
			case '0':
				/*	If not last character, then shift  */
				if (counter != 32)
				{
					*Value <<= 1;
					*Mask = SETBIT(*Mask) << 1;
				}
				else
					*Mask = SETBIT(*Mask);		/*	Last character, don't shift anymore  */
				break;

			case '1':
				/*	If not last character, then shift  */
				if (counter != 32)
				{
					*Value = SETBIT(*Value) << 1;
					*Mask = SETBIT(*Mask) << 1;
				}
				else
				{
					*Value = SETBIT(*Value);	/*	Last character, don't shift anymore  */
					*Mask = SETBIT(*Mask); 		/*	Last character, don't shiff anymore  */
				}

				break;

			case 'x':
			case 'X':
				/*	If not last character, then shift  */
				if (counter != 32)
				{
					*Value <<= 1;
					*Mask <<= 1;
				}
				break;

			/*	Any other character beside 0, 1, x, and X is invalid  */
			default:
				return (FAIL);	/*	FAIL is value 1  */
		}
	}

	return (SUCCEED);	/*	SUCCEED is value 0  */
}
/*	End BinaryToMask()  */


/******************************************************************************/
/*	Start IncrementDefinition()  */
void IncrementDefinition(Character)
unsigned char *Character;
{
	while (*Character != NULL)
	{
		switch (*Character)
		{
			case A:
				BridgeStatus->BMElement[0].BitMask.bm_count++;
				break;

			case B:
				BridgeStatus->BMElement[1].BitMask.bm_count++;
				break;

			case C:
				BridgeStatus->BMElement[2].BitMask.bm_count++;
				break;

			case D:
				BridgeStatus->BMElement[3].BitMask.bm_count++;
				break;

			case E:
				BridgeStatus->BMElement[4].BitMask.bm_count++;
				break;

			case F:
				BridgeStatus->BMElement[5].BitMask.bm_count++;
				break;

			case G:
				BridgeStatus->BMElement[6].BitMask.bm_count++;
				break;

			case H:
				BridgeStatus->BMElement[7].BitMask.bm_count++;
				break;

			case I:
				BridgeStatus->BMElement[8].BitMask.bm_count++;
				break;

			case J:
				BridgeStatus->BMElement[9].BitMask.bm_count++;
				break;
		}
		Character++;
	}
}
/*	End IncrementDefinition()  */


/******************************************************************************/
/*	Start DecrementDefinition()  */
void DecrementDefinition(Character)
unsigned char *Character;
{
	while (*Character != NULL)
	{
		switch (*Character)
		{
			case A:
				BridgeStatus->BMElement[0].BitMask.bm_count--;
				break;

			case B:
				BridgeStatus->BMElement[1].BitMask.bm_count--;
				break;

			case C:
				BridgeStatus->BMElement[2].BitMask.bm_count--;
				break;

			case D:
				BridgeStatus->BMElement[3].BitMask.bm_count--;
				break;

			case E:
				BridgeStatus->BMElement[4].BitMask.bm_count--;
				break;

			case F:
				BridgeStatus->BMElement[5].BitMask.bm_count--;
				break;

			case G:
				BridgeStatus->BMElement[6].BitMask.bm_count--;
				break;

			case H:
				BridgeStatus->BMElement[7].BitMask.bm_count--;
				break;

			case I:
				BridgeStatus->BMElement[8].BitMask.bm_count--;
				break;

			case J:
				BridgeStatus->BMElement[9].BitMask.bm_count--;
				break;
		}
		Character++;
	}
}
/*	End DecrementDefinition()  */

/*****************************************************************************/

/*	Start IsBlank()  */
IsBlank(TestCharacter)
register char TestCharacter;
{
	if (TestCharacter == ' ' || TestCharacter == '\n' ||
		TestCharacter == '\r' || TestCharacter == '\t' ||
		TestCharacter == '')
		return (TRUE);
	return (FALSE);
}
/*	End IsBlank()  */

/******************************************************************************/
/*	Start RemoveBlank()  */
RemoveBlank(Destination, Source)
unsigned char *Destination, *Source;
{
    int cnt = 1;
	while (*Source != NULL)
	{
		if (!IsBlank(*Source) )
		{
            if(cnt < BMFOLEN) {
			    *Destination = *Source;
			    Destination++;
            }
            cnt++;
		}
		Source++;
	}
    
    if( cnt > BMFOLEN )
        return(ERR_STR_TOO_LONG);
    else
	    return (0);
}
/*	End RemoveBlank()  */


unsigned int expcnt, stkcnt, parcnt;
unsigned char *expptr, *stkptr;


/******************************************************************************/
/*	Start Pop()  */
static char Pop()
{
	stkcnt--;
	return(*stkptr++);
}
/*	End Pop()  */


/******************************************************************************/
/*	Start Push()  */
static void Push(c)
char c;
{
	*--stkptr = c;
	stkcnt++;
}
/*	End Push()  */


/******************************************************************************/
/*	Start Precedence()  */
static int Precedence(c)
char c;
{
	switch(c)
	{
		case '!':
			return(3);

		case '&':
			return(2);

		case '|':
			return(1);

		default:
			return(0);
	}
}
/*	End Precedence()  */


/******************************************************************************/
/*	Start CleanUp()  */
static CleanUp(p, cnt)
char *p;
int cnt;
{
	while (stkcnt > cnt)
	{
		if (Precedence(*stkptr) < Precedence(*p))
			break;

		if ( (*expptr++ = Pop() ) != '!')
			expcnt--;
	}
}
/*	End CleanUp()  */


/******************************************************************************/
/*	Start Parse()  */
static unsigned char *Parse(p, cnt)
unsigned char *p;
int cnt;
{
	char c;

	while (c = *p++)
	{
		switch(c)
		{
			case '!':
			case '&':
			case '|':
				Push(c);
				break;

			case '(':
				parcnt++;
				if ( (p = Parse(p, stkcnt)) == NULL)
					return (NULL);
				CleanUp(p, cnt);
				break;

			case ')':
				parcnt--;
				return(p);

			default:
				if ( (toupper(c) < 'A') || (toupper(c) > 'J') ) {
					return( NULL );
                }
				if( isDefined( c ) == FALSE )  {
					return( NULL );
                }

				*expptr++ = c;
				expcnt++;
				CleanUp(p, cnt);
		}
	}
	return(p);
}
/*	End Parse()  */

/*****************************************************************************/
							/* Start isDefined() */
isDefined( char c )  {

	uint i;
 
	ChangeToIndex( toupper(c), &i ); 

	if(strlen(BridgeStatus->BMElement[i].ValueString) < 4)  {
		return(FALSE);
	}
	else
		return(TRUE);
}
/* End isDefined() */

/******************************************************************************/
						/*	Start ParseExpression()  */
ParseExpression(ReversePolish1, ExpressionBuffer1)
unsigned char *ReversePolish1;
unsigned char *ExpressionBuffer1;
{
	expcnt = stkcnt = parcnt = 0;
	expptr = ReversePolish1;
	stkptr = &ReversePolish1[BMFOLEN];

	if (Parse(ExpressionBuffer1, 0) == NULL) {
		return (ERR_INV_EXPRESSION);
    }

	if (expcnt != 1) {
		return (ERR_EXP_CNT);
    }
	if (parcnt) {
		return (ERR_PAR_CNT);
    }
	if (stkcnt) {
		return (ERR_STK_CNT);
    }
	*expptr = '\0';

	return (0);
}
/*	End ParseExpression()  */

/******************************************************************************/
/*	Start SetPortList()	*/
SetPortList(Vector2, Value, String1, String2, PortMask)
char *Vector2;
unsigned int *Value;
char *String1, *String2;
uint PortMask;
{
	unsigned int AllFlag;
	unsigned int FwdFilt;
	int ReturnCode;

	if (strcmpi(Vector2,String1 ) == 0)
	{
		FwdFilt = FORWARD;
		SetBitOrNot(&PortMask, FwdFilt, Value);
	}
	else
	if (strcmpi(Vector2,String2 ) == 0)
	{
		FwdFilt = FILTER;
		SetBitOrNot(&PortMask, FwdFilt, Value);
	}
	else
		return ( CMD_SYNTAX_ERR );


	return (0);
}
/*	End SetPortList()	*/

/******************************************************************************/
/*	Start SetPrcPortList()	*/
SetPrcPortList(Vector2, Value, String1, String2, PortMask)
char *Vector2;
byte *Value;
char *String1, *String2;
byte PortMask;
{
	unsigned int FwdFilt;
	int ReturnCode;

	if (strcmpi(Vector2,String1 ) == 0)
	{

		FwdFilt = FORWARD;
		SetPrcBitOrNot(&PortMask, FwdFilt, Value);
	}
	else
	if (strcmpi(Vector2,String2 ) == 0)
	{

		FwdFilt = FILTER;
		SetPrcBitOrNot(&PortMask, FwdFilt, Value);
	}
	else
		return ( CMD_SYNTAX_ERR );

	return (0);
}
/*	End SetPrcPortList()	*/


/******************************************************************************/
						/*	Start SetRestrict()	*/
SetRestrict(Vector2, state, PortMask)
char *Vector2;
uint state;
uint PortMask;
{
	PRCCTL *prcctl = &prc;
	char NewVector[50];
	unsigned int EnableDisable;
	int ReturnCode;


	strupr( Vector2 );
	if (state == FILTER) {
	
		sscanf (Vector2, "%s", &NewVector);
		EnableDisable = FILTER;


		if(strcmp("R", NewVector) == 0)    {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInMcast);
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInUcast);
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestOut);

		   SetBitOrNot(&PortMask,EnableDisable,&BridgeStatus->RestrictInMCast);
		   SetBitOrNot(&PortMask,EnableDisable,&BridgeStatus->RestrictInUCast);
		   SetBitOrNot(&PortMask,EnableDisable,&BridgeStatus->RestrictOutbound);
		}
		else
		if(strcmp("RI", NewVector) == 0 )  {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInUcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInUCast);
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInMcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInMCast);
		}
		else
		if(strcmp("RIM", NewVector) == 0)  {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInMcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInMCast);
		}
		else
		if(strcmp("RIU", NewVector) == 0)  {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInUcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInUCast);
		}
		else
		if(strcmp("RO", NewVector) == 0)   {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestOut);
		   SetBitOrNot(&PortMask,EnableDisable,&BridgeStatus->RestrictOutbound);
		}
		else
			return ( CMD_SYNTAX_ERR );
	}
	else
	if(state == FORWARD)  {
	
		sscanf (Vector2, "%s", &NewVector);
		EnableDisable = FORWARD;

		if(strcmp("R", NewVector) == 0)    {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInMcast);
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInUcast);
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestOut);

	   	   SetBitOrNot(&PortMask, EnableDisable,&BridgeStatus->RestrictInMCast);
		   SetBitOrNot(&PortMask, EnableDisable,&BridgeStatus->RestrictInUCast);
		   SetBitOrNot(&PortMask,EnableDisable,&BridgeStatus->RestrictOutbound);
		}
		else
		if(strcmp("RI", NewVector) == 0)   {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInUcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInUCast);
	   	   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInMcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInMCast);
		}
		else
		if(strcmp("RIM", NewVector) == 0)  {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInMcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInMCast);
		}
		else
		if(strcmp("RIU", NewVector) == 0)  {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestInUcast);
		   SetBitOrNot(&PortMask,EnableDisable, &BridgeStatus->RestrictInUCast);
		}
		else
		if(strcmp("RO", NewVector) == 0)   {
		   SetPrcBitOrNot(&PortMask, EnableDisable, &prcctl->Prc_RestOut);
		   SetBitOrNot(&PortMask,EnableDisable,&BridgeStatus->RestrictOutbound);
		}
		else
			return ( CMD_SYNTAX_ERR );
	}
	else
		return ( CMD_SYNTAX_ERR );
	return (0);
}
/*	End SetRestrict()	*/


/******************************************************************************/
					/*	Start BrgActivityScreen()  */
BrgActivityScreen()
{

	Header();
	printf("\t\t\t\t    %s\n\n\n","B R I D G E   A C T I V I T Y   S C R E E N");

	TrafficPortHeader();

	printf ("%-24s", "Transmit Count");
	/*PrintPrcTrCntr( prcctl->prc_cnt_xmtd ); */
	PrintSonicTx();
	putchar ('\n');

	printf ("%-24s", "Receive Count");
	/*PrintPrcTrCntr( prcctl->prc_cnt_rcvd ); */
	PrintSonicRx();
	putchar ('\n');

	printf ("%-24s", "Rx CRC & Alignment Error");
	PrintSonicCrc();
	putchar ('\n');

	printf ("%-24s", "Rx No Resource Error");
	PrintSonicNre();
	putchar ('\n');

	printf ("%-24s", "Rx Overrun Error");
	PrintSonicRoe();
	putchar ('\n');

	printf ("%-24s", "Transmit Failure");
	PrintSonicTxFail();
	putchar ('\n');

    printf ("%-24s", "Transmit Collision");
    PrintSonicTxCol();
	putchar ('\n');

	printf ("%-24s", "Transmitter Lockup");
	PrintSonicTxLock();
	putchar ('\n');

	printf ("%-24s", "Receiver Lockup");
	PrintSonicRxLock();

	printf("\n\n");
	DisplayAddrCnt(RAM);

	return(0);
}
/*	End BrgActivityScreen()  */

SwUpdateMsg()
	{
	printf("\nSoftware will be updated due to a request from the network manager\n\n");
	}
