/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      strcmpi.c
*
*       $Log:   /b/gregs/bridge/declike/util/strcmpi.c_v  $
 * 
 *    Rev 1.1   29 Jul 1993 16:40:40   vinay
 * fixed a bug in strcmpi()
 * 
 *    Rev 1.0   04 May 1993 16:04:18   franks
 * Initial revision.
 * 
 *    Rev 1.4   13 May 1992 14:46:32   franks
 * No change.
 * 
 *    Rev 1.3   04 May 1992 12:22:28   franks
 * No change.
 * 
 *    Rev 1.2   17 Apr 1992 16:18:02   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:12:52   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:51:56   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/
#include <types.h>

/*
 *	Case insensitive string comparision
 *	Compare until the end of the first string
 */

#define cap(c) ((c)&0x5f)
strcmpx(s,t)
char *s;
char *t;
{
	while (cap(*s) == cap(*t))
	{
		if (*s == 0)
			return 0;
		s++;
		t++;
	}
	return (cap(*s) < cap(*t)) ? -1 : 1;
}

strcmpi(s,t)
char *s;
char *t;
{
	while(*s != 0)
	{
		if(toupper(*s) != toupper(*t))
			return (toupper(*s) < toupper(*t)) ? -1 : 1;
		s++;
		t++;
	}
	return 0;
}
