
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	break.h
*
*	$Log:   /b/gregs/bridge/include/break.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:12:18   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:34:42   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:14   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:02:26   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:22   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:22   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

/* Description of a single hardware breakpoint
 *
 * The number of and types of entries in the table are determined by the
 * capabilities of the target processor.  The 'type' field should be hard-coded
 * into a target-specific file and should never be modified at runtime.
 * The 'active' and 'addr' fields should be modified to reflect current
 * breakpoint usage.
 */
struct bpt{
	char type;	/* BRK_DATA, BRK_INST, BRK_EOT			*/
	char active;	/* True if this breakpoint is in use		*/
	int *addr;	/* If active==TRUE, address at which bpt is placed */
};

#define BRK_DATA	0	/* Data breakpoint			*/
#define BRK_INST	1	/* Instruction breakpoint		*/
#define BRK_EOT		2	/* Dummy used to delimit end of bpt table */

extern struct bpt bptable[];

extern char have_data_bpts;	/* TRUE if there are one or more data breakpoint
				 * entries in the table,
				 */
