
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	bridges.h
*
*	$Log:   /b/gregs/bridge/include/bridges.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:12:18   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:34:44   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:19:14   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:02:28   franks
 * No change.
 * 
 *    Rev 1.1   30 Aug 1993 08:36:58   franks
 * Changed the bridge banner.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:24   franks
 * Initial revision.
 * 
 *    Rev 1.4   20 May 1992 08:33:14   franks
 * 1). Changed ADR_FLG_ORST_ALL from 0x1f to 0xf. 
 * 
 *    Rev 1.3   07 May 1992 09:00:34   franks
 * 1). Fixed problem with the BME error messages.
 * 
 *    Rev 1.2   28 Apr 1992 13:40:02   pvcs
 * Change Made by FrankS
 * Removed the ERR_TYPE_EXIST define from this header file and put it
 * in the 834error.h header file where it belongs.
 * 
 *    Rev 1.1   28 Apr 1992 13:37:46   pvcs
 * No change.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:22   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __BRIDGES_H
#define __BRIDGES_H v100

#ifndef __BITMASK_H
#include <bitmask.h>
#endif

#ifndef __DBD_H
#include <dbd.h>
#endif

/*	Macro Definition  */
#define	SETBIT(X)		(X | 0x00000001)

#define	TRUE		1	/*  Logical TRUE  */
#define	FALSE		0	/*  Logical FALSE  */
#define	NULL		0	/*  String Terminator */
#define NOTFOUND	-1
#define DONE		2

#define	STRLN		84	/*  Maximum length of input buffer  */
#define VCTLN		10	/*  Maximum no. of 'words' in input line  */
#define	ESC	       0x1B	/*  Escape character  */
#define BKS	       0x08	/*  Backspace character  */
#define	CR	       '\r'	/*  Carriage return character  */
#define	MAX_CATEGORY     5	/*  Maximum number of category  */
#define TAB	       '\t'     /*  Tab		 */
#define SPACE		' '	/*  Space character  */
#define	RECORDPAGE	15	/*  Max num of recs display on the screen  */
#define ADD		'+'
#define CLEAR		'-'
#define VT100		1
#define NONVT100    0

#define	SUCCEED		0	/*  O.K., Success  */
#define	FAIL		1	/*  Fail  */
#define	BADHEX		0xFF	/*  Bad hexadecimal value  */
#define	HIGH		0xF0	/*  Mask of high hexadecimal  */
#define	LOW		0x0F	/*  Mask of low hexadecimal  */
#define	MAXPSWD		12	/*  Maximum password characters  */

#define	UNIXLIKE	1
#define	DECLIKE		2

#define CONTROL		0
#define DATABASE	1
#define FILTERING	2
#define	MISCELLANEOUS	3
#define SNMP		4

#define SHORT		0
#define LONG		1

#define	MAXLOGTABLE	128
#define	LOGMESSAGE 	"EMPTY"

#define	MAXPORTBIT	0x0008     /* 5PORT -- Value for 5 ports is 0x0010 */
#define	ACTUALMAXPORT	4

#define	NA		"N/A"

/* PACKET SIZES */
#define MAXPACSZSTD	1518
#define MINPACSZSTD	64
#define MAXPACSZEXT	2100
#define MINPACSZEXT	16

/*	Console Or SNMP Password  */
#define	CONSOLE		"CONSOLE"
#define	SNMPPSWD	"SNMP"

/*	Port Number	*/
#define	NUMBERIC_ONE	1
#define	NUMBERIC_TWO	2
#define	NUMBERIC_THREE	3
#define	NUMBERIC_FOUR	4
#define	NUMBERIC_FIVE	5

/*	Port Character	*/
#define	CHARACTER_ONE	'1'
#define	CHARACTER_TWO	'2'
#define	CHARACTER_THREE	'3'
#define	CHARACTER_FOUR	'4'
#define CHARACTER_FIVE	'5'
#define	CHARACTER_ALL	'*'

/*	Port Bit Allocation	*/
#define	PORT1			0x0001
#define	PORT2			0x0002
#define	PORT3			0x0004
#define	PORT4			0x0008
#define	PORT5			0x0010
#define ALLPORT			(PORT1 | PORT2 | PORT3 | PORT4)  /* 5PORT */

/*	Port Mask Allocation	*/
#define	MASKPORT1		~PORT1
#define	MASKPORT2		~PORT2
#define	MASKPORT3		~PORT3
#define	MASKPORT4		~PORT4
#define MASKPORT5		~PORT5
#define	MASKALLPORT		~ALLPORT

/*	Unknown Multi-cast Bit Allocation	*/
#define	UNKMCAST1		0x0001
#define	UNKMCAST2		0x0002
#define	UNKMCAST3		0x0004
#define	UNKMCAST4		0x0008
#define	UNKMCAST5		0x0010

/*	Unknown Multi-cast Mask Allocation	*/
#define	MASKMCAST1		~UNKMCAST1
#define	MASKMCAST2		~UNKMCAST2
#define	MASKMCAST3		~UNKMCAST3
#define	MASKMCAST4		~UNKMCAST4
#define	MASKMCAST5		~UNKMCAST5

/*	Active State Bit Allocation	*/
#define	ACTIVE1			0x0001
#define	ACTIVE2			0x0002
#define	ACTIVE3			0x0004
#define	ACTIVE4			0x0008
#define	ACTIVE5			0x0010

/*	Active State Mask Allocation	*/
#define	MASKACTIVE1		~ACTIVE1
#define	MASKACTIVE2		~ACTIVE2
#define	MASKACTIVE3		~ACTIVE3
#define	MASKACTIVE4		~ACTIVE4
#define	MASKACTIVE5		~ACTIVE5

/*      Port Modes */
#define PORT_MODE_STP	0
#define PORT_MODE_OFF	1
#define PORT_MODE_ON	2
#define PORT_MODE_DISABLE	0
#define PORT_MODE_ENABLE	1
#define STP_MODE_DISABLE	0
#define STP_MODE_ENABLE		1

/* Bridge Mode */
#define BRG_MODE_ENABLE         1
#define BRG_MODE_DISABLE        0


/*      Packet Size */
#define STANDRD	        0	
#define EXTENDED	ALLPORT

/*	Miscellaneous Bit Allocation	*/
#define	MESSAGELOG		0x0001
#define	SYMBOLIC		0x0002

/*	Miscellaneous Mask Allocation	*/
#define	MASKMESSAGELOG	~MESSAGELOG
#define	MASKSYMBOLIC	~SYMBOLIC

/*	Bit Mask Permit or Block  */
#define	NONE		0
#define	PERMIT		1
#define	BLOCK		2
#define SETBLMODE	1
#define SETPRMODE	2
#define PERMITSTR		"PERMIT"
#define BLOCKSTR		"BLOCK"

#define PERMITMODE      1
#define BLOCKMODE       0

/*	Forward or Discard	*/
#define	FORWARD		1
#define	FILTER		2
#define FORWARDSTRING	"FORWARD"
#define FILTERSTRING	"FILTER"

/*	Enable or Disable	*/
#define	ENABL		2
#define	DISABL		1
#define ENABLEMODE	ALLPORT
#define DISABLEMODE	0
#define	ENABLESTRING	"ENABLED"
#define	DISABLESTRING	"DISABLED"

/*	Standard or Extended	*/
#define	STANDARD	1
#define	EXTEND		2
#define	STANDARDSTRING	"STANDARD"
#define	EXTENDSTRING	"EXTENDED"

/*	Transmit or Receive Threshhold  */
#define	TRANSMIT	1
#define	RECEIVE		2
#define	MINTHRESH	0
#define	MAXTHRESH	30000

/*	Bitmask minimum and maximum  */
#define	MINOFFSET	0
#define	MAXOFFSET	256
#define MINNUMBER	'A'
#define	MAXNUMBER	'J'


/*  Jump between different nim960 programs */
#define KERNEL_PROG		0xBAB1
#define TESTER_PROG		0xBAB2
#define PACMON_PROG		0XBAB3
#define TFTP_LOADER		0XBAB4
#define RESET			0XBAB5

/*  Which ip address ? */
#define MYIPADDR	1
#define IPMASK		2
#define TFTPSERVER	3
#define IPROUTR1	4

/*  Select between RAM and NVRAM records */
#define RAM			0x1111
#define NVRam			0x2222

/*	Console integer error code  */
#define ERR_INV_ARG		1
#define	ERR_UNK_CMD		2
#define	ERR_NOHELP		3
#define ERR_NOTGRP_ADR		5
#define ERR_NO_SPACE		6
#define ADR_NOT_DEL		8
#define ERR_HEX6_ADR		9
#define ERR_HEX4_ADR		11
#define ERR_TYPE_NOSLOT		13
#define SWITCH_ERROR		16
#define ERR_EXP_CNT		26
#define ERR_PAR_CNT		26
#define	ERR_STK_CNT		26
#define ERR_INV_PACKETSIZE	30

/*	Header and Copyright screen  */
#define	MainHeader	"HUGHES LAN SYSTEMS MULTIPORT FDDI/ETHERNET BRIDGE"
#define	MainCopyright	"(C) Copyright 1993 Hughes LAN Systems"
#define	AddressScreen	"ADDRESS FILTERING STATUS SCREEN"
#define	BitmaskScreen	"BITMASK FILTERING STATUS SCREEN"
#define	MainScreen	    "MAIN CONSOLE STATUS SCREEN"
#define	TrafficMainScreen   "MAIN TRAFFIC SCREEN"
#define	ProtocolScreen	"PROTOCOL FILTERING STATUS SCREEN"
#define	SNMPScreen	"SNMP PROTOCOL STATUS SCREEN"
#define	TrafficSNMPScreen	"SNMP PROTOCOL TRAFFIC SCREEN"
#define	STPScreen	"SPANNING TREE PROTOCOL STATUS SCREEN"
#define	TrafficSTPScreen  "SPANNING TREE PROTOCOL TRAFFIC SCREEN"
#define RAMDatabase		"FOWARDING DATABASE"
#define NVRAMDatabase	"SAVED ADDRESS DATABASE"

/*	General Messages  */
#define	DISABLETHRESH "Threshold value of 0 will disable the threshold timer."

/*	Address Record Attributes Bit Allocation  */
#define	ADR_FLG_STC	 0x04    /* Static */
#define	ADR_FLG_RST	 0x03    /* Restrict Inbound Both Uni and Multicast */
#define ADR_FLG_MRST         0x02    /* Restrict Inbound Multi-Cast */
#define ADR_FLG_URST         0x01    /* Restrict Inbound Uni-Cast   */
#define ADR_FLG_ORST_ALL     0x0F    /* Restrict outbound all ports */

/*  Command structure for each command in the command list  */
struct cmd
{
	char	*CmdString;	/*  Character pointer to cmd string  */
	char	*CmdName;	/*  Command in words  */
	int	CmdCount;	/*  Min no. of characters for a cmd match  */
	int	(*CmdFunction)();  /*  Int ptr to function to process cmd  */
	int	(*HelpFunction)(); /*  Int ptr to help routine  */
	char	*ShortHelp;	   /*  Char ptr to short help display  */
	int	CmdGroup;	   /*  Which grp does this cmd belong to  */
};

/*	Messages for command interface  */
struct error
{
	int	ErrorCode;		/*  Integer error code  */
	char	*ErrorMessage;		/*  Error code message  */
};

/*	Structure for logging error messages  */
typedef struct timedate
{
	unsigned char	Second;
	unsigned char	Minute;
	unsigned char	Hour;
	unsigned char	Date;
	unsigned char	Month;
	unsigned char	Year;
}TIMEDATE;

#define THE70S 631152000	/* num of seconds between jan 1, 1970 */
				/* 0:0:0 and jan 1, 1980 0:0:0        */

typedef struct errorlog
{
	TIMEDATE	TimeDateStamp;
	char		ErrorLogMessage[100];
}ERRORLOG;

/*	Structure for IP address format  */
typedef union ipadr
{
	long		IPAddress;
	unsigned char	IP[4];
}IP;

/*	Structure for record mask  */
typedef struct recordmask
{
	unsigned char	AddressValue[6];
	unsigned char	AddressMask[6];
	unsigned char   PortMask;
	unsigned char	OutMask;
	unsigned char	InMask;
	unsigned char	FlagMask;
}RECORDMASK;

typedef struct FilterRec {

	char sflag;
	char ro1;
	char ro2;
	char ro3;
	char ro4;
	char riu;
	char rim;
	char port1;
	char port2;
	char port3;
	char port4;
}FILTERREC;

#define NUMLADR	7

#endif
