
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	bus.h
*
*	$Log:   /b/gregs/bridge/include/bus.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:12:20   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:34:46   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:16   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:02:30   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:26   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:22   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

/***********************************************************************
 * $Id: bus.h,v 5.1 90/10/22 15:47:03 chrisb Exp $
 *
 *    Support for 80960CA bus controller
 *
 **********************************************************************/

/* 
 * Perform a bit-wise OR of the desired parameters to specify a region.
 *
 *
 *  bus_region_1_config =
 *      BURST_ENABLE | BUS_WIDTH_32 | NRAD(3) | NRDD(1) |
 *      NXDA(1) | NWAD(2) | NWDD(2);
 */
#ifndef __BUS_H
#define __BUS_H


#define BURST_ENABLE    0x1
#define READY_ENABLE    0x2
#define PIPELINE_ENABLE 0x4

#define BUS_WIDTH_8     0x0
#define BUS_WIDTH_16    (0x1 << 19)
#define BUS_WIDTH_32    (0x2 << 19)

#define BIG_ENDIAN      (0x1 << 22)

#define NRAD(WS)    (WS << 3)   /* WS can be 0-31   */
#define NRDD(WS)    (WS << 8)   /* WS can be 0-3    */
#define NXDA(WS)    (WS << 10)  /* WS can be 0-3    */
#define NWAD(WS)    (WS << 12)  /* WS can be 0-31   */
#define NWDD(WS)    (WS << 17)  /* WS can be 0-3    */


/* For ibr region F description
 */
#define BYTE_0(x)	(x & 0xff)
#define BYTE_1(x)	((x >>  8) & 0xff)
#define BYTE_2(x)	((x >> 16) & 0xff)
#define BYTE_3(x)	((x >> 24) & 0xff)

#endif
