
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	dips.h
*
*	$Log:   /b/gregs/bridge/include/dips.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:12:24   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:34:52   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:19:20   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:02:38   franks
 * No change.
 * 
 *    Rev 1.1   13 Jul 1993 09:59:56   gregs
 * Fixed ring number shift constant.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:32   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:26   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __DIP_H
#define __DIP_H

/*
	ALL SWITCHES: 	1 = switch 'off'
					0 = switch 'on' 

	Note that the location 'sys_switch' contains a copy of the DIP
	switches in RAM and this copy has been INVERTED (1 = switch 'on').

	Switches are mapped to bits in the register (and sys_switch) as
	follows:
			DIP SWITCH					register/sys_switch
		--------------------			------------------
		switch 2, position 8	==>		bit 0 (LSB)
		...			...					...
		switch 2, position 1	==>		bit 7

		switch 1, position 8	==>		bit 8
		switch 1, position 7	==>		bit 9
		switch 1, position 6	==>		bit 10
		switch 1, position 5	==>		bit 11
		switch 1, position 4	==>		not accessible
		switch 1, position 3	==>		bit 13
		switch 1, position 2	==>		bit 14
		switch 1, position 1	==>		not accessible
*/
/* For comparing against the value read from the DIP sw register... */
#define	DIP_SW_ON	0		/* test '==' for sw. ON,  '!=' for sw. OFF */

/* Switch 2 is DIPs 1 to 8 */
#define DIP1	0x0080		/* sw 2, pos 1 */
#define DIP2	0x0040
#define DIP3	0x0020
#define DIP4	0x0010
#define DIP5	0x0008
#define DIP6	0x0004
#define DIP7	0x0002
#define DIP8	0x0001		/* sw 2, pos 8 */

/* Switch 1 is DIPs 9 to 16 (of which 9 and 12 are unusable) */
#define DIP9x	0x8000		/* sw 1, pos 1 (UNUSABLE) */
#define DIP10	0x4000		/*		 pos 2 */
#define DIP11	0x2000		/*		 pos 3 */
#define DIP12x	0x1000		/*		 pos 4 (UNUSABLE) */
#define DIP13	0x0800		/*		 pos 5 */
#define DIP14	0x0400		/*		 pos 6 */
#define DIP15	0x0200		/*		 pos 7 */
#define DIP16	0x0100		/* sw 1, pos 8 */

#define	LAST_DIP_SWITCH		DIP16
#define	DIP_SWITCH_COUNT	16
/*
 *	The bits for setting the baud.
 */
#define	DIP_DEFAULT_OK	DIP1

#define	DIP_BAUD_MASK	(DIP3 | DIP2)
#define DIP_BAUD_1200	0
#define DIP_BAUD_2400	DIP2
#define DIP_BAUD_4800	DIP3
#define DIP_BAUD1_9600	(DIP3 | DIP2)

#define	DIP_PASSWD_OFF	DIP4
#define DIP_DEBUG_ON	DIP5
#define DIP_EPROM_BOOT	DIP6	/* if 'on' use eprom boot, not flash boot */

#define DIP_TESTER 		DIP8
#define	DIP_RING_NUM	(DIP13+DIP14+DIP15+DIP16)	/* ring no. */
#define	RING_NUM_SHIFT	8			/* bit shift for ring no. */

#endif /* __DIP_H */
