
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	filter.h
*
*	$Log:   /b/gregs/bridge/include/filter.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:12:28   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:34:54   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:22   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:02:44   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:34   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:28   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef	__FILTER_H
#define __FILTER_H v100

/******************************************************************************
*                                                                             *
* (c) CopyRight Hughes Lan Systems                                            *
*                                                                             *
* TITLE: filter.h                                                             *
*                                                                             *
******************************************************************************/


#define FILTABLESZ             	0xffffU  /* 64K bytes */
#define MAXUSRTYPE	       		10       /* max number of user-def protocols */
#define UTYPE                   1        /* user-defined protocol type */
#define PTYPE                   0	     /* pre-defined protocl type */
#define PROTNUM					12		 /* num of pre-defined protocols */

/* the following values are 'byte reversed' for word compares */
/* 'type' field definitions */

#define	IP_T		0x0008	/* 'type' field defining IP       */
#define	ARP_T		0x0608	/* 'type' field defining ARP      */
#define	REVARP_T	0x3580	/* 'type' field defining rev. ARP */
#define	DECNET1_T	0x0160  /* 'type' field defining DECNET   */
#define	DECNET2_T	0x0260	/* 'type' field defining DEC MOP Remote Console */
#define	DECNET3_T	0x0360	/* 'type' field defining DEC Phase IV   */
#define	DECNET4_T	0x0560	/* 'type' field defining DEC diagnostic   */
#define	DECNET5_T	0x0660	/* 'type' field defining DEC customer   */
#define DECNET6_T   0x3880  /* 'type' field defining DEC LanBridge Mngt */
#define DECNET7_T   0x0060  /* 'type' field defining DEC Unassigned */
#define DECNET8_T   0x3F80  /* 'type' field defining DEC LAN Trafffic Monitor */
#define DECLAT_T    0x0460  /* 'type' field defining DEC LAT      */
#define DECLAVC_T   0x0760  /* 'type' field defining DEC LAVC     */
#define	XNS1_T		0x0006  /* 'type' field defining XNS IDP     */
#define	XNS2_T		0x000a  /* 'type' field defining XNS PUP     */
#define	XNS4_T		0x0708	/* 'type' field defining XNS      */
#define	NOVELL_T	0x3781	/* 'type' field defining new Novell */
#define BRID1_T     0x0190  /* 'type' field defining BRIDGE bridge */
#define BRID2_T     0x0290  /* 'type' field defining BRIDGE terminal */
#define APPLE1_T    0x9b80  /* 'type' field defining Kinetics EtherTalk */
#define APPLE2_T    0xF380  /* 'type' field defining AppleTalk ARP (AARP) */
#define APPLE3_T    0xF480  /* 'type' field defining Kinetics AppleTalk */
#define APPLE4_T    0xF580  /* 'type' field defining Kinetics AppleTalk */
#define V2_L    	0x0100  /* 'type' V2 PID in LLC */

/* LSAP field definitions */
#define	NOVELL_L	0xffff		/* LSAP field defining NOVELL (IPX) */
#define	TOP_L		0xfefe		/* LSAP field defining TOP          */

/* Do not make changes to this list without making simultaneous */
/* changes to the Protocols[] structure in filter.c.            */

#define IP_P	    0
#define ARP_P	    1
#define REVARP_P    2
#define TOP_P		3
#define V2_P	    4
#define NOVELL_P    5
#define LAT_P       6
#define BRIDGE_P    7
#define TCP_P	    8
#define XNS_P	    9
#define DEC_P	    10
#define APPLE_P	    11


typedef struct ProtCntlRec  {

	char     *ProtName;  /* Full name of protocol */
	int      min;	     /* Minimum number of chars needed to recognize name */
	int      Index;
	unsigned prots[9];	 /* All of the protocol types assoc with this name */

} PROTCNTLREC;


/*
typedef struct {

	char      UProtStr[MAXUSRTYPE][5];  Str of hex chars rep user def type 
	unsigned  UProtTyp[MAXUSRTYPE];     Numeric rep of user def prot types  
	int       TypeCnt;                  Num protocol types def for prt. 

} USRPROTS;
*/

typedef struct UdpDir {

	char  UProtStr[9];
	uint  UProtTyp;
	uint  PrtSet;   
} UDPDIR;

#endif
