
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	fslog.h
*
*	$Log:   /b/gregs/bridge/include/fslog.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:12:28   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:34:56   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:24   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:02:46   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:36   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:28   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#define RSTLOG_COUNT 8 
#define RLOG_COUNT   255

#define RSTMSG0	0     /* Power Failure     */
#define RSTMSG1	1     /* Button Reset      */	
#define RSTMSG2	2     /* SNMP Reset        */
#define RSTMSG3	3     /* Software Crash    */ 
#define RSTMSG4 4     /* Self Test Failure */
#define RSTMSG5	5     /* Sftwr Reset Lvl 0 */
#define RSTMSG6	6     /* Sftwr Reset Lvl 1 */
#define RSTMSG7	7     /* Sftwr Reset Lvl 3 */
#define RSTMSG8	8     /* Sftwr Reset Lvl 4 */

typedef struct rlog_entry
	{
	shrt	rlog_no;
	shrt	rlog_nid_lo;
	shrt	rlog_nid_mi;
	shrt	rlog_nid_hi;
	byte	rlog_from_port;
	byte	rlog_to_port;
	byte	rlog_tm_sec;
	byte	rlog_tm_min;
	byte	rlog_tm_hour;
	byte	rlog_tm_mday;
	byte	rlog_tm_mon;
	byte	rlog_tm_year;
	} RLOG_ENTRY;

typedef struct rlog
	{
	int		rlog_count;
	RLOG_ENTRY 	rlog[RLOG_COUNT];
	} RLOG;


typedef struct rst_entry
	{
	shrt    rstlog_no;
	shrt	rstlog_msg_no;
	shrt	rstlog_up_hour;
	shrt	rstlog_up_min;
	byte	rstlog_tm_sec;
	byte	rstlog_tm_min;
	byte	rstlog_tm_hour;
	byte	rstlog_tm_mday;
	byte	rstlog_tm_mon;
	shrt	rstlog_tm_year;
	} RST_ENTRY;

typedef struct rstlog
	{
	int		rstlog_count;
	RST_ENTRY 	rstlog[RSTLOG_COUNT];
	} RESETLOG;



extern RLOG *relearnlog;
/* extern RESETLOG *resetlog; */
