
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	newctl.h
*
*	$Log:   /b/gregs/bridge/include/newctl.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:12:36   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:35:12   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:32   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:03:00   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:48   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:34   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* * BRIDGE PAKCET PROCESSOR CONTROL STRUCTURE */



#ifndef __PRCCTL_H
#define __PRCCTL_H

#ifndef	__BITMASK_H
#include <bitmask.h>
#endif

#include <target.h>

typedef struct pktprocctl
	{
	byte	Prc_PortStpState[SV_NMBR_PORT];	/* port spanning tree state */
	byte	Prc_PortState;		/* 0 disable, 1 enable */
	byte	Prc_StpMode;		/* 0 disable, 1 enable */
	byte	Prc_Learning; 		/* learning & aging enabled flags */
	byte	Prc_ProtFlt;		/* protocol filtering enabled */
	byte	Prc_ProtFltMode;	/* 0 = block, 1 = permit */
	byte	Prc_BitMskFlt;		/* bit mask filter enabled */
	byte	Prc_BitMskFltMode;	/* 0 = block, 1 = permit */
	byte	Prc_RestInUcast;	/* 0 = disable, 1 = enable */
	byte	Prc_RestInMcast;	/* 0 = disable, 1 = enable */
	byte	Prc_RestOut;		/* 0 = disable, 1 = enable */
	byte	Prc_UnknUcast;		/* filter unknown unicast */
	byte	Prc_UnknMcast;		/* filter unknown multicast */
	byte	Prc_UnknSource;		/* filter unknown source */
	byte	Prc_AgeCnt;		/* # records to be aged every 100ms*/
	byte 	Prc_BitMskFltExp[SV_NMBR_PORT][BMFOLEN];/* bit mask array */
	uint	Prc_MinPktSz[SV_NMBR_PORT]; /* frame minimum size */
	uint	Prc_MaxPktSz[SV_NMBR_PORT]; /* frame maximum size */
	/* frame processing counters */
	uint	prc_cnt_dsrd;		   /* frames discarded,database full */
	uint	prc_cnt_rcvd[SV_NMBR_PORT];/* frames received */
	uint	prc_cnt_xmtd[SV_NMBR_PORT];/* frames transmitted */
	uint	prc_cnt_lrng[SV_NMBR_PORT];/* frames causing learning */
	uint	prc_cnt_lxmt[SV_NMBR_PORT];/* frames forwarded up */
	uint	prc_cnt_ldsc[SV_NMBR_PORT];/* discard:frames too big for STP */
	uint	prc_cnt_rbig[SV_NMBR_PORT];/* discard:frame too large,rx port*/
	uint	prc_cnt_rsml[SV_NMBR_PORT];/* discard:frame too small,rx port*/
	uint	prc_cnt_xbig[SV_NMBR_PORT];/* discard:frame too large,tx port*/
	uint	prc_cnt_xsml[SV_NMBR_PORT];/* discard:frame too small,tx port*/
	uint	prc_cnt_home[SV_NMBR_PORT];/* discard:on segment dest */
	uint 	prc_cnt_rsux[SV_NMBR_PORT];/* flt unknown source */
	uint 	prc_cnt_rskm[SV_NMBR_PORT];/* flt known source,mcast dest.*/
	uint 	prc_cnt_rsku[SV_NMBR_PORT];/* flt known source,ucast dest.*/
	uint 	prc_cnt_rdum[SV_NMBR_PORT];/* flt unknown destination mcast*/
	uint 	prc_cnt_rduu[SV_NMBR_PORT];/* flt unknown destination ucast*/
	uint 	prc_cnt_rdkx[SV_NMBR_PORT];/* flt known destination */
	uint	prc_cnt_rpro[SV_NMBR_PORT];/* discard:restrict proto,rx port*/
	uint	prc_cnt_xpro[SV_NMBR_PORT];/* discard:restrict proto,tx port*/
	uint	prc_cnt_rbmf[SV_NMBR_PORT];/* discard:bit mask filter,rx port*/
	uint	prc_cnt_tbmf[SV_NMBR_PORT];/* discard:bit mask filter,tx port*/
	uint	prc_cnt_free[SV_NMBR_PORT];/* total discards on rx port */
	uint	prc_cnt_rspn[SV_NMBR_PORT];/* discard:incoming sp tree pkts*/
	uint	prc_cnt_tspn[SV_NMBR_PORT];/* discard:outgoing sp tree pkts*/
	uint	prc_cnt_rblk[SV_NMBR_PORT];/* discard:incoming  port blocked*/
	uint	prc_cnt_tblk[SV_NMBR_PORT];/* discard:outgoing port blocked*/
	} PRCCTL;

#endif
