#define TRAP_MANAGER_NO 2
typedef struct nvr_boot
	{
	int	nvr_boot_marker;
	in_name	nvr_IP;
	in_name nvr_ServerIP;
	in_name	nvr_NetMask;
	in_name nvr_RouterIP[2];
	ushort	nvr_hubid;
	ushort	nvr_slotid;
	ushort	nvr_oldhubid;
	ushort	nvr_oldslotid;
	char	nvr_request_file[64];
	char	nvr_image_file[64];
	char	nvr_config_file[64];
	int	nvr_OffsetGMT;			/* offset(seconds) of local  */
						/* time to GMT */
	in_name	nvr_TimeServer;
	in_name	nvr_BootpServer;
	char	nvr_BurnDate[8];		/* the date and time of last */
	char	nvr_BurnTime[8];		/* software was updated and */
						/* burned into the flash */
	ushort	nvr_BurnCycles;			/* how many times the flash */
						/* has been programmed */

	/*
	* the following values override the DIP switch if they are set
	* a -1 == value has not been set, use the DIP switch setting
	*/
	short	nvr_tty_baud;			/* tty baud rate */
	short	nvr_ring_number;		/* hub ring number */
#define MAX_RING_NUMBER	0xf
	short	nvr_ring_rate;			/* hub ring speed */
						/* 0 = 16 megabit */
						/* 1 = 4 megabit */
	short	nvr_save_mode_type;		/* previous value of mode type*/
	short	nvr_mode_type;			/* automatic startup type */
						/* 0 = load and exec flash */
						/* 1 = load and exec network */
						/* 3 = load from network */
						/*     burn flash */
						/*     load and exec flash */
	short	nvr_bootp_request;		/* 0 = send bootp at startup */
	short	nvr_bootp_error;
	short	nvr_debug;

	word	nvr_reset_cause;		/* reset type, 0-pwrup, */
						/* 1 - single, 2 - extended */
						/* ff - software */
	short	nvr_max_reset_level;		/* 1 .. 4 as demanded by init
						/* command */
	short	nvr_reset_level;		/* count times reset pushed */

	ushort	SNMPAuthentication;		/* none (1) community (4) */
	short	sysAdmAccess;
	in_name	SnmpMgr[TRAP_MANAGER_NO];
	uint	GenericTrap[TRAP_MANAGER_NO];
	uint	SpecificTrap[TRAP_MANAGER_NO];
	char	sysDescription[64];
	char	sysLocation[64];
	char	sysName[64];
	char	sysContact[64];
	char	systemPassword[16];

	char	nvr_flash_file[64];
	short	nvr_tty_parity;			/* tty parity	 */
	short	nvr_tty_data_length;		/* tty char size */
	short	nvr_tty_stop_bits;		/* tty stop bits */
	short	nvr_last_reset_cause;
	short	nvr_last_reset_level;
	short	nvr_reset_processed;
	short	nvr_bootp_media;
	short	nvr_spare_1;

	char	nvr_tty_prompt[32];		/* console prompt*/
	short	nvr_spare[240];			/* Need to keep this *accurate* or
						   the NVR_PORT stuff breaks... */
	/*
	* the last 16 bits is the checksum of the whole structure
	*/
	ushort	nvr_checksum;			/* nvram record ends here */
	} NVR_BOOT;

extern	NVR_BOOT	nvr_boot_rec;
#define BOOT_MARKER	0x544F4F42
