
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	prcctl.h
*
*	$Log:   /b/gregs/bridge/include/prcctl.h_v  $
 * 
 *    Rev 1.5   10 Jan 1994 09:59:36   gregs
 * Changed the batch count to 45.
 * 
 *    Rev 1.4   12 Oct 1993 09:12:42   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:35:20   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:38   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:03:16   franks
 * Changed the number of packets to be processed at a time from 52 to 45. This
 * change was made to accomodated the FDDI drvier.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:54   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:38   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* * BRIDGE PAKCET PROCESSOR CONTROL STRUCTURE */



#ifndef __PRCCTL_H
#define __PRCCTL_H

#ifndef	__BITMASK_H
#include <bitmask.h>
#endif

#include <target.h>

typedef struct pktprocctl
	{
	byte	Prc_PortState;		/* 0 disable, 1 enable */
	byte	Prc_StpMode;		/* 0 disable, 1 enable */
	byte	Prc_Learning; 		/* learning & aging enabled flags */
	byte	Prc_ProtFlt;		/* protocol filtering enabled */
	byte	Prc_ProtFltMode;	/* 0 = block, 1 = permit */
	byte	Prc_BitMskFlt;		/* bit mask filter enabled */
	byte	Prc_BitMskFltMode;	/* 0 = block, 1 = permit */
	byte	Prc_RestInUcast;	/* 0 = disable, 1 = enable */
	byte	Prc_RestInMcast;	/* 0 = disable, 1 = enable */
	byte	Prc_RestOut;		/* 0 = disable, 1 = enable */
	byte	Prc_UnknUcast;		/* filter unknown unicast */
	byte	Prc_UnknMcast;		/* filter unknown multicast */
	byte	Prc_PacketSize; 	/* frame minimum size */
	byte	Prc_AgeCnt;		/* # records to be aged every 100ms*/
	byte	Prc_DiscardBeforeLearn;
	byte	Prc_DontForward;
	byte	Prc_InFilter;
	byte	Prc_OutFilter;
	byte	Prc_Filter;
	byte	Prc_PortStpState[SV_NMBR_PORT];	/* port spanning tree state */
	byte 	Prc_BitMskFltExp[SV_NMBR_PORT][BMFOLEN];/* bit mask array */
	} PRCCTL;

typedef struct pktproccnt
	{
	/* frame processing counters */
	uint	Cnt_TooBig[SV_NMBR_PORT];
	uint	Cnt_TooSmall[SV_NMBR_PORT];
	uint	Cnt_PktFree[SV_NMBR_PORT];
	} PRCCNT;

extern PRCCNT prccnt;
extern	PRCCTL	prc;

/* do not increase BATCH to greater than 24, if done it might extend 	*
 * into the internal data ram allocated for register cashe 		*/

#define BATCH 47	/* number frames to process at one time */
extern PRCCTL *prcctl;
#endif
