
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	stp.h
*
*	$Log:   /b/gregs/bridge/include/stp.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:12:48   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:35:28   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:19:46   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:04:10   franks
 * No change.
 * 
 *    Rev 1.1   03 Sep 1993 11:56:32   vinay
 * added the path cost for fddi_pathcost
 * 
 *    Rev 1.0   07 Jul 1993 09:06:04   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:44   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/************************************************************************
*	Hughes LAN Systems
*	IEEE P802.1d/D9 Revision 9 July, 1989 
*	Spanning Tree Algorithm And Protocol 
*	Implemented by Kevin Huynh June, 1990
*
*	Modified by Kwok Kong 7.25.91.
*	-	port to 960 platform
*	-	int is 32 bits rather than 16 bits, replace some 
*		"typedef int"  to "typedef short"
*	-	Because of 960 alignmnet, do not declare a structure, i.e.
*		Identifier, inside Config_bpdu. 
*	-	Since Time is so commonly used names in C and the header
*		is included by other modules,  we change the type name
*		Time to StpTime.
*		
**************************************************************************/


/**************************************************************************
*	Defined Constants														*
***************************************************************************/


#define	IEEE8021D		3
#define	BRIDGE_TRANSPARENT	2

#define	Zero			0
#define One			1


#define False			0
#define True			1


#define acknowledge_true	0x80
#define acknowledge_false	~(acknowledge_true)

#define change_true		0x01
#define change_false		~(change_true)

/*	Port States */
#define	Disabled		0
#define Listening		1
#define STPLearning		2
#define	Forwarding		3
#define	Blocking		4


/*	Ticks in Hundredths of Seconds */
#define	TICKS_HUNDRED		100
/*
 *	Timer unit is in 1/256th of a second
 */
#define	STP_TIMER_UNIT		256

/*	BPDU Type Constants */
#define	Config_bpdu_type	0
#define Tcn_bpdu_type		128


/*	Pseudo-Implementation Constants */
/*	Arbitrary choice, to allow the code below to compile */
#define	No_of_ports		4


/*	Ports start at 1, arrays in C start at 0 */
#define All_ports 		(No_of_ports+1)


/*	Arbitrary */
#define Default_path_cost	10

/* Default path cost for different media speed */
#define TokenRing16_pathcost	63	/* 16MBPS Token Ring */
#define TokenBus10_pathcost	100	/* 10MBPS Token Bus  */ 
#define Ethernet10_pathcost	100	/* 10MBPS Ethernet   */
#define Fddi_pathcost		10	/* 100MBPS FDDI */
#define TokenRing4_pathcost	250	/* 4MBPS Token Ring  */
#define Broadband2_pathcost	500	/* 2MBPS Broadband   */
#define HSST1_pathcost		500	/* 2MBPS High Speed Serial    */
#define HSSV35_pathcost		15625	/* 64KBPS High Speed Serial   */
#define HSSRS232_pathcost	52083	/* 19.2KBPS High Speed Serial */

/* Default bridge's priority */
#define Stanley_priority	32758	/* NIM960 10MBPS to 10MBPS */
#define Ethernet10_priority	32768	/* 10MBPS to 10MBPS */
#define TokenBus10_priority	32778	/* 10MBPS to 10MBPS */
#define TokenRing16_priority	32788	/* 10MBPS to 16MBPS */
#define TokenRing4_priority	32798	/* 10MBPS to 4MBPS */
#define Broadband2_priority	32808	/* 10MBPS to 2MBPS  */
#define HSS_priority		32818	/* 10MBPS to 2MBPS  */

/*
 *	STP parameters
 *	p.108 - 109, table 4-1, 4-2, 4-3, 4-4 and 4-5
 */
#define	MAX_BRIDGE_DIA			7

#define	DEFAULT_BRIDGE_TRANSIT_DEALY	1
#define	MAX_BRIDGE_TRANSIT_DEALY	4

#define	DEFAULT_BPDU_TRANSMISSION_DEALY	1
#define	MAX_BPDU_TRANSMISSION_DEALY	4

#define	DEFAULT_MSG_AGE_INC_OVERESTIMATE	1
#define	MAX_MSG_AGE_INC_OVERESTIMATE	4

#define	DEFAULT_HELLO_TIME		2
#define	MIN_HELLO_TIME			1
#define	MAX_HELLO_TIME			10

#define	DEFAULT_MAX_AGE			20
#define	MIN_MAX_AGE			6
#define	MAX_MAX_AGE			40

#define	DEFAULT_FORWARD_DELAY		15
#define	MIN_FORWARD_DELAY		4
#define	MAX_FORWARD_DELAY		30

#define	BRIDGE_HOLD_TIME		1

#define	DEFAULT_BRIDGE_PRIORITY		32768
#define	MIN_BRIDGE_PRIORITY		0
#define	MAX_BRIDGE_PRIORITY		65535

#define	DEFAULT_PORT_PRIORITY		128
#define	MIN_PORT_PRIORITY		0
#define	MAX_PORT_PRIORITY		255

#define	MIN_PATH_COST			1
#define	MAX_PATH_COST			65535


#define root_mask		0x00ff
/*	Mininum increment possible to avoid underestimating age, allows
	for BPDU transmission time */
#define	Message_age_increment	1

/*	Reserved value for Bridge's root port parameter indicating no root port,
	used when Bridge is the root */
#define	No_port			0


/****************************************************************************
*	Typedefs, Structures And Union Declarations								*
*****************************************************************************/

/*	Basic Types */
/*	To align with case stropping convention used here Types and defined 
	constants have their initial letters capitalized. */
typedef int Int;


/*	(True, False) */
/*typedef Int Boolean;*/



/*	(Disabled, Listening, Learning, Forwarding, Blocking) */
typedef Int State;


/*	BPDU encoding types defined */
typedef unsigned short Protocol_identifiers;

typedef char Protocol_version;

typedef char BPDU_type;

typedef char FLAG;

typedef struct
	{
	unsigned short	priority;
	unsigned char	stp_address[6];
	}
	Identifier;

typedef unsigned long Cost;

typedef unsigned short Port_id;

typedef unsigned short StpTime;

/*
 *	Do not use sizeof operator as it gives 64 in the
 *	960 environment.
 */
#define	CONFIG_BPDU_SIZE	52

typedef struct
	{
	unsigned char	stphdr[20];
	BPDU_type	type;
	FLAG		topology_change_flag;
	/*
 	 *	We split Identifier because of the alignment problem 
	 *	in the 960 environment.
	 */
	unsigned short	root_id_priority;
	unsigned char	root_id_stp_address[6];
	/*
 	 *	We split root_path_cost because of the alignment problem 
	 *	in the 960 environment.
	 */	
	unsigned short	root_path_cost[2];
	/*
 	 *	We split Identifier because of the alignment problem 
	 *	in the 960 environment.
	 */
	unsigned short	bridge_id_priority;
	unsigned char	bridge_id_stp_address[6];
	Port_id		port_id;
	StpTime		message_age;
	StpTime		max_age;
	StpTime		hello_time;
	StpTime		forward_delay;
	}
	Config_bpdu;   	/* Configuration structure is 52 bytes */

/*
 *	Do not use sizeof operator as it gives 64 in the
 *	960 environment.
 */
#define	TCN_BPDU_SIZE	52

/*	Topology Change Notification BPDU Parameters */
typedef struct
	{
	unsigned char	stphdr[20];
	BPDU_type	type;
	}
	Tcn_bpdu; 	/* Topology Change Notice structure is 21 bytes */


/*	Bridge Parameters */
typedef struct
	{
	Identifier	designated_root;
	Cost		root_path_cost;
	Int		root_port;
	StpTime		max_age;
	StpTime		hello_time;
	StpTime		forward_delay;
	Identifier	bridge_id;
	StpTime		bridge_max_age;
	StpTime		bridge_hello_time;
	StpTime		bridge_forward_delay;
	Boolean		topology_change_detected;
	Boolean		topology_change;
	StpTime		topology_change_time;
	StpTime		hold_time;
	}
	Bridge_data;


/*	Port Parameters */
typedef struct
	{
	Port_id		port_id;
	State		state;
	Int		path_cost;
	Identifier	designated_root;
	Int		designated_cost;
	Identifier	designated_bridge;
	Port_id		designated_port;
	Boolean		topology_change_acknowledge;
	Boolean		config_pending;
	}
	Port_data;


/*	Types to support timers for this pseudo-implementation	*/
typedef struct
	{
	Boolean		active;
	StpTime		value;
	}
	Timer;
/*
 *	K Kong.	8.23.91
 *	The following are for statistics purpose
 */
extern ulong	StpConfigTxBPDU[];	/* number of STP Tx CONFIG BPDU STP */
extern ulong	StpConfigRxBPDU[];	/* number of STP RX CONFIG BPDU STP */
extern ulong	StpTopChgTxBPDU[];	/* number of STP Tx CHANGE BPDU STP */
extern ulong	StpTopChgRxBPDU[];	/* number of STP RX CHANGE BPDU STP */
extern ulong	StpForwardTransitions[];

extern	unsigned long	StpTopChgDet;
extern	unsigned long	StpTopChgUpTime;;

extern	Bridge_data	bridge_info;
extern	Port_data	port_info[All_ports];

extern void 	transmit_config(Int port_no);
extern Boolean	root_bridge(void);
extern Boolean	designated_port(Int port_no);
extern void	configuration_update(void);
extern void	port_state_selection(void);
extern void	topology_change_detection(void);
extern void	received_config_bpdu(Int port_no, Config_bpdu *config);
extern void	received_tcn_bpdu(Int port_no, Tcn_bpdu *tcn);
extern void	initialize_port(Int port_no);
extern void	disable_port(Int port_no);
extern void	start_hello_timer(void);
extern void	stop_tcn_timer(void);
extern void	stop_topology_change_timer(void);
extern void	tick();
