
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	sys.h
*
*	$Log:   /b/gregs/bridge/include/sys.h_v  $
 * 
 *    Rev 1.6   12 Oct 1993 09:12:48   franks
 * No change.
 * 
 *    Rev 1.5   29 Sep 1993 09:35:30   franks
 * No change.
 * 
 *    Rev 1.4   10 Sep 1993 15:19:48   franks
 * No change.
 * 
 *    Rev 1.3   08 Sep 1993 11:04:12   franks
 * No change.
 * 
 *    Rev 1.2   16 Jul 1993 08:30:04   gregs
 * Fixed peer/tree LED definitions.
 * 
 *    Rev 1.1   14 Jul 1993 10:01:22   gregs
 * Added new define for PEER_TREEB_PT.
 * 
 *    Rev 1.0   07 Jul 1993 09:06:04   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:44   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __SYS_H
#define __SYS_H

#include <target.h>
#include <dbd.h>

typedef struct sys_area
{
	char *sys_sram_alc_lo;
	char *sys_sram_alc_hi;
	char *sys_dram_alc_lo;
	char *sys_dram_alc_hi;
	word sys_switch;
	word sys_ledb;
	word sys_flk_ledb;
	word sys_ledm;
	word sys_flk_ledm;
	word sys_flk_cnt;
	word sys_leds;
	word sys_ctrl;
	word sys_ctrl1;
	word sys_ctrl2;
	int sys_baud;
	int sys_wdt_enable;
	word sys_remote_console;
	NID  sys_nid[MAX_PORTS];
	word sys_ledsg;
} SYS;

/* control 1 port bit definitions */
#define LR_MSK		0x0f

#define CTRL1_LR0	0x01
#define ENABLE_LR0		CTRL1_LR0
#define DISABLE_LR0		0

#define CTRL1_LR1	0x02
#define ENABLE_LR1	CTRL1_LR1
#define DISABLE_LR1	0

#define CTRL1_LR2	0x04
#define ENABLE_LR2	CTRL1_LR2
#define DISABLE_LR2	0

#define CTRL1_LR3	0x08
#define ENABLE_LR3	CTRL1_LR3
#define DISABLE_LR3	0

#define CTRL1_FDDIB_PT	0x10
#define PEER_TREEB_ON	CTRL1_FDDIB_PT
#define PEER_TREEB_OFF	0

#define CTRL1_NVR 	0x20
#define DISABLE_NVR	CTRL1_NVR
#define ENABLE_NVR	0

#define CTRL1_SYS_WDT 	0x40
#define ENABLE_SYS_WDT	CTRL1_SYS_WDT
#define DISABLE_SYS_WDT	0

#define CTRL1_BUS_WDT 	0x80
#define DISABLE_BUS_WDT	CTRL1_BUS_WDT
#define ENABLE_BUS_WDT	0

#define CTRL1_EEPROM 	0x100
#define DISABLE_EEPROM	CTRL1_EEPROM
#define ENABLE_EEPROM	0

#define	CTRL1_VPP		0x0200		/* flash voltage ctrl bit */
#define	VPP_ON			CTRL1_VPP
#define	VPP_OFF			0

#define CTRL1_FDDIA_PT	0x0400
#define PEER_TREEA_ON	CTRL1_FDDIA_PT
#define PEER_TREEA_OFF	0


#ifdef notdef	/* not on CHEETAH h/w */
/* control 2 port bit definitions */
#define CTRL2_FLASH_VOLTAGE	0x01
#define FLASH_PROG_VOLTAGE	CTRL2_FLASH_VOLTAGE
#define FLASH_NORMAL_VOLTAGE	0

#define CTRL2_DRAM_SIZE		0x02
#define DRAM_SIZE_4M		CTRL2_DRAM_SIZE
#define DRAM_SIZE_1M		0
#endif

/* these don't belong here, but... */
#define CTRL1_ETHER	0x10
#define ENABLE_THINET	CTRL1_ETHER
#define DISABLE_THINET	0

extern SYS sys;


#endif
