
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	time.h
*
*	$Log:   /b/gregs/bridge/include/time.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:12:52   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:35:36   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:52   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:04:20   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:06:10   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:46   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * <time.h> : time zone stuff for gnu cc.
 *            (Does *your* laser printer know what time zone it's in??)
 *
 * Andy Wilson, 18-Oct-89.
 */


#ifndef __TIME_H__
#define __TIME_H__
/*
 * must have size_t defined.
 */
#include <types.h>

struct	tm {	
	int	tm_sec;		/* seconds (0-59) */
	int	tm_min;		/* minutes (0-59) */
	int	tm_hour;	/* hours (0-23) */
	int	tm_mday;	/* days (1-31) */
	int	tm_mon;		/* months (0-11) */
	int	tm_year;	/* year -1900 */
	int	tm_wday;	/* day of week (sun = 0) */
	int	tm_yday;	/* day of year (0 - 365) */
	int	tm_isdst;	/* non-zero if DST */
};
/********************
extern long timezone;
extern int daylight;
extern char *tzname[];

clock_t clock(void);
time_t time(time_t *);
char *asctime(const struct tm *);
char *ctime(const time_t *);
struct tm *localtime(const time_t *);
double difftime(time_t, time_t);
time_t mktime(struct tm *);
size_t strftime( char *s, size_t, const char *,
		 const struct tm *);
**********************/

struct tm *gmtime(const time_t *);

#endif

