
typedef struct ffrm			/* FDDI frame structure               */
{
	byte unused1;			/* fill so 'dl' is on a word boundary */
	byte unused2;
	byte unused3;
	byte fc;				/* frame control     */
	shrt dl;				/* dest addr  -  low */
	shrt dm;				/* dest addr  -  mid */
	shrt dh;				/* dest addr  -  hi  */
	shrt sl;				/* src addr  -  low  */
	shrt sm;				/* src addr  -  mid  */
	shrt sh;				/* src addr  -  hi   */
/*	shrt ln;	*/			/* length            */ 
	shrt _s;				/* SNAP bytes 1 and 2 (LSAP)                     */
	shrt _n;				/* SNAP bytes 3 and 4 (ctrl and 1st byte of PID) */
	shrt _a;				/* SNAP bytes 5 and 6 (byte 2 and 3 of PID)      */
	shrt _p;				/* SNAP bytes 7 and 8 (type/last 2 bytes of PID) */
} FFHDR;


/* basic frame shape without the len field, which if the frame control */
/* byte where added to the beginning of the frame would be how the frame */
/* looked on FDDI.                                                       */
typedef struct xfrm
	{
	shrt dl;
	shrt dm;
	shrt dh;
	shrt sl;
	shrt sm;
	shrt sh;
	shrt _s;
	shrt _n;
	shrt _a;
	shrt _p;
	} XFRMHDR;

union 
{
	word w;
	shrt s[2];
	byte b[4];
} bitrev;					/* bit reverse temp loc (in Iram) */

#define	PID_TUNNEL		0xf800		/* bytes 2,3 of PID for 'tunnel' frame */
#define	PID_RFC1042		0x0000		/* bytes 2,3 of PID for '1042' frame */
#define	FDDI_FC			0x50		/* frame control (async, long addr, LLC) */
#define	DELTA_XL			7			/* net change in pkt len due to xlation */
#define	AARP_PT			0xF380		/* AARP protocol type (byte reversed) */
#define  FDDI_PORT_M		0x08
#define  ETH_PORTS_M		0x07
#define  FDDI_PORT_NUM	3
