
/**
*	Program Name:	loader
*
*	Filename:	main.c
*
*	Comments:
*
*	Copyright (c) 1992 by Huges LAN Systems.
**/
#include <krnl.h>
#include <target.h>
#include <memory.h>
#include <eeprecs.h>
#include <nim960h.h>
#include <sys.h>
#ifdef notdef
#include <uart.h>
#include <dips.h>
#include <led.h>
#include <sncvar.h>
#include <malloc.h>
#endif
#include "types.h"
#include "inc.h"

typedef struct {
  long x[4]; } QWORD;
typedef struct {
  long x[2]; } DWORD;

SYS sys;

/* 7 seg LED error codes */
#define	E7_EEP_BOOT		0x0B	/* bad eeprom booter */
#define	E7_DRAM_BOOT	0x0C	/* bad booter after copy to DRAM */
#define	E7_BAD_DRAM		0x0D	/* DRAM failed POST */
#define	E7_BAD_SRAM		0x0E	/* SRAM failed POST */

extern RamByteTest(), RamWordTest(), RamWordAddressTest();
extern Blink7SegLed(), Set7SegLed();

static u_short	cksum(unsigned short *buffer, int length);

printf(){}		/* dummy (referenced by uncalled routines in ramtest.c) */
Ei(){}			/* ... ditto ... */
Di(){}			/* ... ditto ... */

main()
{
	register word loadAddress;
	register NIM960_HDR *nim960_hdr = (NIM960_HDR *)FEPROM;
	unsigned short	csum;

	*(byte *)WDOGIO = 0;
	*(u_short *)GPWREG = 0x008f;		/* disable WDT, enable LANS */


	Set7SegLed(0x1);

	/*
	* for now, we only use EPROM program -yke
	*/
#ifdef yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy
	/*
	* Check and verify flash prom booter
	*/
	if ( (nim960_hdr->signature == NIM960_MAGIC) &&
	     (nim960_hdr->Entry != NULL) &&
	     ((csum = cksum((u_short *)FEPROM, nim960_hdr->FileLength >> 1)) == 0xFFFF || csum == 0) )
	{
		/*
		* flash booter is good, copy it
		* to dram and run from there
		*/
		memcpy((char *)nim960_hdr->TextLoadAddress, (char *)FEPROM,
			(nim960_hdr->TextLength + nim960_hdr->DataLength));
		if (memcmp((char *)nim960_hdr->TextLoadAddress,
			(char *)FEPROM,
			(nim960_hdr->TextLength + nim960_hdr->DataLength)) == 0)
		{
			(*((int (*)())nim960_hdr->Entry))(0);
		}
	}

	/*
	* flash booter is bad, we copy the
	* eprom booter to dram and run it
	*/

	Set7SegLed(2);
#endif /*yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy*/

	/*
	* Check and verify Eprom booter
	*/
	loadAddress = BEPROM512;
	nim960_hdr = (NIM960_HDR *)loadAddress;
	if ( (nim960_hdr->signature != NIM960_MAGIC) ||
	     (nim960_hdr->Entry == NULL) ||
	     ((csum = cksum((u_short *)loadAddress, nim960_hdr->FileLength >> 1)) != 0xFFFF
	     && csum != 0) )
	{
		/*
		* eprom is bad, we sit here and flash leds
		*/
		Blink7SegLed(E7_EEP_BOOT);
#define	E7_BAD_DRAM		0x0D	/* DRAM failed POST */
#define	E7_BAD_SRAM		0x0E	/* SRAM failed POST */
	}

	Set7SegLed(2);
	/*
	* copy eprom booter to dram and run there
	*/
	memcpy((char *)nim960_hdr->TextLoadAddress, (char *)loadAddress,
		(nim960_hdr->TextLength + nim960_hdr->DataLength));
	if (memcmp((char *)nim960_hdr->TextLoadAddress,
		(char *)loadAddress,
		(nim960_hdr->TextLength + nim960_hdr->DataLength)) == 0)
	{
	Set7SegLed(3);
		(*((int (*)())nim960_hdr->Entry))(0);
	}

	/*
	* something wrong with dram booter, sit here and flash leds
	*/
	Blink7SegLed(E7_DRAM_BOOT);
}


CheckStaticRam()
{
	/*
	 *	This is the first thing we do upon power up.
	 *	We want to make sure the sram is ok before we proceed.
	 *	If the sram is not working, we cannot do anything at all
	 *	apart from turning on some leds. 
	 *	It is important to noted that this function and the
	 *	functions this function call cannot use any sram. In
	 *	other words, all variables must be stored in registers
	 *	and the registers cache must be on.
	 *	We only test the first 32K of SRAM.
	 */

	 if ( RamByteTest(SRAM, 0x8000) != NULL  ||
	 	RamWordTest(SRAM, 0x8000) != NULL  ||
	 	RamWordAddressTest(SRAM, 0x8000) != NULL )
		{
		Blink7SegLed(E7_BAD_SRAM);
		}
}



CheckDynamicRam()
{
	/*
	 *	This is the first thing we do upon power up.
	 *	We want to make sure the dram is ok before we proceed.
	 *	If the dram is not working, we cannot do anything at all
	 *	apart from turning on some leds. 
	 *	It is important to noted that this function and the
	 *	functions this function call cannot use any dram. In
	 *	other words, all variables must be stored in registers
	 *	and the registers cache must be on.
	 *	We only test the first 256K of DRAM.
	 */

	 if ( RamByteTest(DRAM, 0x40000) != NULL  ||
	 	RamWordTest(DRAM, 0x40000) != NULL  ||
	 	RamWordAddressTest(DRAM, 0x40000) != NULL )
		{
		Blink7SegLed(E7_BAD_DRAM);
		}
}


/*
* let booter install nmi later
* for now put in a dummy
*/
int_nmi()
{
	Blink7SegLed(15);
}


unsigned short cksum(unsigned short *buffer, int length)
{
	unsigned long	sum = 0l;

	while (length--)
		{
		sum += *buffer++;
		/*
		 *	Add the carry bit in here as
		 *	length can be as long as 1 Meg or 
		 *	even more.
		 */
		sum = (sum & 0xFFFFl) + (sum >> 16);
		}
	/*
	 *	Add the remaining carry overflows
	 */
	while (sum >> 16)
		sum = (sum & 0xFFFFl) + (sum >> 16);
	return (unsigned short )sum;
}

#ifdef notdef
void *
memmove(dest, src, len)
void *dest;
const void *src;
size_t len;
{
  const void *lasts;
  void *lastd;
  void *retval;
  
  /*
   * check for overlap; if not, use the
   * (presumably faster) memcpy routine.
   */
  lasts = src + (len-1);
  lastd = dest + (len-1);
  if (((dest < src) || (dest > lasts)) &&
      ((lastd < src) || (lastd > lasts)))
    return memcpy(dest, src, len);
  
  /*
   * no joy; copy the strings byte-by-byte
   * in the appropriate order (increasing byte
   * addresses if dest<src, decreasing if dest>src).
   */
  
  retval = dest;
  if (dest < src)
    while (len--)
      *(char *)dest++ = *(char *)src++;
  else
    while (len--)
      *(char *)lastd-- = *(char *)lasts--;
  
  return retval;
}
#endif

void *
memcpy(dest, src, len)
void *dest;
const void *src;
size_t len;
{
  void *retval=dest;

  /*
   * try quad word moves if possible
   */
  if ((((long)dest | (long)src) & 0xF)==0)
    {
      while ( len >= sizeof(QWORD))
	{
	  *(QWORD *)dest = *(QWORD *)src;
	  dest += sizeof(QWORD);
	  src += sizeof(QWORD);
	  len -= sizeof(QWORD);
	}
      if (len==0) return retval;
    }
  /*
   * ... now long word moves ...
   */
  if ((((long)dest | (long)src) & 0x7)==0)
    {
      while ( len >= sizeof(DWORD))
	{
	  *(DWORD *)dest = *(DWORD *)src;
	  dest += sizeof(DWORD);
	  src += sizeof(DWORD);
	  len -= sizeof(DWORD);
	}
      if (len==0) return retval;
    }
  /*
   * ... single word moves ...
   */
  if ((((long)dest | (long)src) & 0x3)==0)
    {
      while ( len >= sizeof(long))
	{
	  *(long *)dest = *(long *)src;
	  dest += sizeof(long);
	  src += sizeof(long);
	  len -= sizeof(long);
	}
      if (len==0) return retval;
    }
  /*
   * ... short word moves ...
   */
  if ((((long)dest | (long)src) & 0x1)==0)
    {
      while ( len >= sizeof(short))
	{
	  *(short *)dest = *(short *)src;
	  dest += sizeof(short);
	  src += sizeof(short);
	  len -= sizeof(short);
	}
      if (len==0) return retval;
    }
  /*
   * finish up with byte moves.
   */
  while (len--)
    *(char *)dest++ = *(char *)src++;
  return retval;
}


/*
 * memcmp - compare bytes
 */
int				/* <0, == 0, >0 */
memcmp(s1, s2, size)
CONST VOIDSTAR s1;
CONST VOIDSTAR s2;
SIZET size;
{
	register CONST char *scan1;
	register CONST char *scan2;
	register SIZET n;

	scan1 = s1;
	scan2 = s2;
	for (n = size; n > 0; n--)
		if (*scan1 == *scan2) {
			scan1++;
			scan2++;
		} else
			return(*scan1 - *scan2);

	return(0);
}
