/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

/***********************************************************************
 *
 * This code is the first code invoked from the fault
 * procedure table. A C-level routine is called to analyze
 * and report the type of fault.
 *
 * On entry the user stack appears as follows:
 *
 *		    USER STACK
 *	  pfp ->+-----------------+ (LOWER MEMORY)
 *		| faulting        |
 *		|    frame        |
 *	fp-64 ->+-----------------+<- fault info starts here
 *		| resumption      |
 *		| record          |
 *		|- - - - - - - - -|
 *		| fault record	  |
 *	   fp ->+-----------------+
 *		| this procedure  |
 *		|                 |
 *		+-----------------+ (HIGHER MEMORY)
 *
 *
 **********************************************************************/ 

	.globl _fault

_fault:

	/*
	 * Set max priority in case of interrupts,
	 * disable trace faults
	 */

	ldconst	0x001f0000, r8	/* load pc data        */
	ldconst	0x001f0001, r9	/* load pc mask        */
	modpc	r8, r9, r8

	flushreg		/* make stack current  */

	/*
	 * Turn off trace.
	 * Store user register tc directly.
	 */
	ldconst	0x0ffe00fe, r13	# trace mask
	ldconst	0, r14		# all traces off
	modtc	r13, r14, r14	# leaves user's tc in r14

	/*
	 * Call C-level fault handler to identify fault type
	 */

	lda	-48(fp), g0	/* pass fault data */
	call	_fault_handler

	/******* NO RETURN _fault_handler should never return *******/
	b	_error
