#############################################################################
#	Program Name:	CHEETAH (836)
#
#	Filename:	Makefile
#
#	Creation Date:	07.16.93
#
#	Date:		07.16.93
#
#	Version:	1.0
#
#	Programmers:	Frank Salzmann
#
#	Modifications:
#
#	Comments:	The makefile is  for the CHEETAH
#			This makefile will call all other makefiles 
#			to produce the CHEETAH image.  The directory
#			structures are:=
#
#			Makefile	This file
#				
#			main.c		The main function
#			kernel/	It contains the time sliced kernel
#				and the timer services
#			tester/	It contains the power up self test
#					for :-
#						1	DRAM
#						2	SRAM
#						3	SHARED RAM
#						4	Flash eprom
#						5	tms
#						6	uart
#			system/	It contains the startup module,
#				fault table, interrupt table and
#				prob ...etc.
#			uart/	The uart driver
#
#	Copyright (c) 1993 by Hughes LAN Systems
#
#############################################################################

.LOGFILE .c_v(.c)
.LOGFILE .s_v(.s)
.LOGFILE .h_v(.h)

# Defaults to GNU/960 tool set:
#
CC	= gcc960			# gnu960 cross C compiler 
ARCH	= -ACA				# This is CA architecture
OPT	= -O3 -c -D__FDDI_CON  			# O3 - optimization level 3
					# c  - compile only
CFLAGS	= ${ARCH} -I${IDIR1} -I${IDIR2} -I${IDIR3} -I${IDIR4} -I${IDIR5} -I${IDIR6} -I${IDIR7} -I${IDIR8} ${OPT} -mstrict-align
					#
					# I - 	specify the search path for
					# 	any include files
					# mstrict-align
					#	Sequences of smaller memory
					#	reference are used instead
					#	of larger ones which might
					#	not be correctly aligned.
AS	= gas960			# gnu960 assembler
ASFLAGS	= ${ARCH}
LD	= gld960  			# gnu960 linker
TOOLSET = ${GFLAG}
VERSION = 
VER =

GETOPTS = -q

# Essential under System V, harmless elsewhere
SHELL = /bin/sh

# Standard rules
#
#.c_v.c:
#	=get $(GETOPTS) $<\($@\)
#
#.h_v.h:
#	=get $(GETOPTS) $<\($@\)
#
#.s_v.s:
#	=get $(GETOPTS) $<\($@\)

.c.o:
	${CC} ${CFLAGS} $*.c

.c.s:
	${CC} ${CFLAGS} -S -c $*.c

.s.o:
	${AS} ${ASFLAGS} -o $*.o $*.s


#------------------------------------------------------------------------------
# Where to find things (include files, ROM images)
#------------------------------------------------------------------------------
#PIDIR1	= /h/pvcs/bridge/include
#PIDIR2	= /h/pvcs/i960/include
#PSDIR	= /h/pvcs/bridge

IDIR1	= include
IDIR2	= ../i960/include
IDIR3	= ../fddi/fddicon/include
IDIR4	= ../fddi/fddicon/smt/dp83200if/headers
IDIR5	= ../fddi/fddicon/smt/headers
IDIR6	= declike/inc
IDIR7	= ../fddi/include
IDIR8	= ../fddi/fddicon/drv/include

LDIR    = lib
TCPLIB	= ../i960/lib
FDDI	= ../fddi/fddicon/lib
YANLIB  = /b/yan/fddi_ether/i960/sonic
SONICLIB = /b/gregs/bridge/sonic

#.PATH.h_v =  ${PIDIR1};${PIDIR2}
.PATH.h   = . ;${IDIR1} ;${IDIR2} 
#.PATH.c_v = ${PSDIR}
#.PATH.s_v = ${PSDIR}
#------------------------------------------------------------------------------
# TARG OBJECT FILES
#------------------------------------------------------------------------------
BRIDGE_OBJS= startup.o \
	main.o init.o tdummy.o fddidrv.o cam.o  \
	${LDIR}/proc_tst.o \
	${SONICLIB}/sonic \
	${TCPLIB}/krnl.o 


## Address at which 960CX Initial Boot Record must be linked
BRIDGE_ADDR = 0x2fff0000
#BRIDGE_ADDR = 0x30000000

cheetah:  startup.o main.o init.o tdummy.o fddidrv.o \
			cam.o Makefile dummy
	${LD} ${ARCH}  -o cheetah -R ${LDIR}/ramvar.o -M -Ttext ${BRIDGE_ADDR} \
		-e _start ${BRIDGE_OBJS} \
		${FDDI}/libfddidrv.a \
		/b/gregs/fddi/fddicon/tester/edfddinvr.o \
	${TCPLIB}/system.o \
		/b/gregs/fddi/boot/tester/boothelp.o \
		/b/gregs/fddi/i960/libutil/menuparse.o \
	${LDIR}/util.o ${TCPLIB}/uart.o \
	${TCPLIB}/slip.o ${LDIR}/prcb.o \
	${LDIR}/netio.o ${LDIR}/declike.o \
	${LDIR}/stp.o \
	${LDIR}/snmproutines.o ${LDIR}/snmptree.o ${LDIR}/fddi_routines.o\
	${TCPLIB}/snmp.o \
	${TCPLIB}/mib2.o \
	${TCPLIB}/util.o \
	${LDIR}/config.o \
	${LDIR}/pktgen.o \
	${TCPLIB}/adm.o \
	${LDIR}/tftpboot.o \
	${LDIR}/tr_util.o \
	${FDDI}/smtcsp.o ${FDDI}/smtfbm.o ${FDDI}/smtmsp.o \
	${FDDI}/smtcspif.o ${FDDI}/smtfbmif.o ${FDDI}/smtmspif.o \
	${TCPLIB}/debug.o \
	../i960/lib/bp_ring.o \
		${LDIR}/libtest.a \
		${FDDI}/libtester.a \
		${FDDI}/libfddiutil.a \
		${FDDI}/libfddimap.a \
		${FDDI}/libfddiutil.a \
		${TCPLIB}/libtcpip.a ${TCPLIB}/libutil.a \
		${TCPLIB}/libc.a \
		${FDDI}/libfddicoll.a > b.map
#		-ltcpip -ltest -lutil -lc -L../i960/lib -L./lib
#		/b/gregs/fddi/i960/util/config.o \

	gnm960 -n -o cheetah  > map_out.fs
	makenim cheetah
	boutnim cheetah cheetah.nim.fs 
	cp cheetah.nim.fs /tftpboot/cheetah.nim.fs

#	awk -f map.awk b.map > smap
#	sort -b +1 -2 smap -o smap

#	${LD} ${ARCH} -o cheetah -R ${LDIR}/ramvar.o -M -Ttext ${BRIDGE_ADDR} \
#	boutcoff -l cheetah

new:
	make mkdir
	make getcfg
	make getmf
	cd declike; make new
	cd ../i960; make snew
	make stanley

source:
	make mkdir
	make getcfg
	make getmf
	make getsrc
	cd declike; make VER = ${VERSION} source
	cd ../i960; make VER = ${VERSION} source

dummy:
	cd ../i960; make
	cd sonic; make
	cd stp; make
#	cd tftpboot; make
	cd util; make
#	cd tester; make
	cd system; make
	cd proc; make
	cd netio; make
	cd snmp/routines; make
	cd snmp/tree; make
	cd config; make
#	cd declike; make
#	cd pktgen; make
#	cd ramvar; make
	cd tr_util; make
	cd tr_config; make -r

mkdir:
	mkdir include lib
	mkdir stp tftpboot util tester system proc netio snmp
	mkdir snmp/include snmp/routines snmp/tree 
	mkdir config declike pktgen ramvar
	mkdir ../i960

getcfg:
	cp ${PSDIR}/stp/pvcs.cfg stp/pvcs.cfg
	cp ${PSDIR}/tftpboot/pvcs.cfg tftpboot/pvcs.cfg
	cp ${PSDIR}/util/pvcs.cfg util/pvcs.cfg
	cp ${PSDIR}/tester/pvcs.cfg tester/pvcs.cfg
	cp ${PSDIR}/system/pvcs.cfg system/pvcs.cfg
	cp ${PSDIR}/proc/pvcs.cfg proc/pvcs.cfg
	cp ${PSDIR}/netio/pvcs.cfg netio/pvcs.cfg
	cp ${PSDIR}/snmp/routines/pvcs.cfg snmp/routines/pvcs.cfg
	cp ${PSDIR}/snmp/tree/pvcs.cfg snmp/tree/pvcs.cfg
	cp ${PSDIR}/config/pvcs.cfg config/pvcs.cfg
	cp ${PSDIR}/declike/pvcs.cfg declike/pvcs.cfg
	cp ${PSDIR}/pktgen/pvcs.cfg pktgen/pvcs.cfg
	cp ${PSDIR}/ramvar/pvcs.cfg ramvar/pvcs.cfg
	cp ${PSDIR}/../i960/pvcs.cfg ../i960/pvcs.cfg

getmf:
	cd stp; get -cpvcs.cfg Makefile 
	cd tftpboot; get -cpvcs.cfg Makefile 
	cd util; get -cpvcs.cfg Makefile
	cd tester; get -cpvcs.cfg Makefile
	cd system; get -cpvcs.cfg Makefile
	cd proc; get -cpvcs.cfg Makefile
	cd netio; get -cpvcs.cfg Makefile
	cd snmp/routines; get -cpvcs.cfg Makefile
	cd snmp/tree; get -cpvcs.cfg Makefile
	cd config; get -cpvcs.cfg Makefile
	cd declike;  get -cpvcs.cfg Makefile
	cd pktgen; get -cpvcs.cfg Makefile
	cd ramvar; get -cpvcs.cfg Makefile
	cd ../i960; get -cpvcs.cfg Makefile

getsrc:
	get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/local.lst
	cd stp; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/stp/local.lst
	cd tftpboot; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/tftpboot/local.lst 
	cd util; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/util/local.lst
	cd tester; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/tester/local.lst
	cd system; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/system/local.lst
	cd proc; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/proc/local.lst
	cd netio; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/netio/local.lst
	cd snmp/routines; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/snmp/routines/local.lst
	cd snmp/tree; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/snmp/tree/local.lst
	cd config; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/config/local.lst
	cd pktgen; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/pktgen/local.lst
	cd ramvar; get -y -cpvcs.cfg -v${VERSION} @${PSDIR}/ramvar/local.lst
	

rmdir:
	rm -rf stp tftpboot util tester system proc
	rm -rf netio snmp config declike pktgen ramvar
	rm -rf include lib
	rm *.c *.o *.s
	rm -rf ../i960

cleanup:
	rm -f stp/*.o tftpboot/*.o tester/*.o system/*.o proc/*.o
	rm -f netio/*.o snmp/routines/*.o snmp/tree/*.o
	rm -f config/*.o declike/*/*.o 
	rm -f pktgen/*.o rm ram/var/*.o
	cd ../i960; make cleanup

#------------------------------------------------------------------------------
# HEADER-FILE DEPENDENCIES
#------------------------------------------------------------------------------
main.o: Makefile \
	${IDIR2}/types.h ${IDIR2}/krnl.h ${IDIR1}/memory.h ${IDIR1}/eeprecs.h \
	${IDIR2}/nim960h.h ${IDIR2}/uart.h ${IDIR1}/dips.h ${IDIR1}/led.h \
	${IDIR1}/sys.h ${IDIR1}/nvrecs.h ${IDIR1}/filter.h \
	${IDIR1}/prcadr.h ${IDIR1}/bitmask.h ${IDIR1}/log.h \
	${IDIR1}/target.h ${IDIR2}/malloc.h \
	${IDIR2}/dbd.h 

init.o: Makefile \
	${IDIR2}/types.h ${IDIR2}/krnl.h ${IDIR1}/target.h ${IDIR1}/sys.h \
	${IDIR1}/dips.h ${IDIR2}/sncvar.h ${IDIR2}/netbuf.h \
	${IDIR2}/tcpip.h ${IDIR2}/ether.h ${IDIR1}/eeprecs.h \
	${IDIR2}/udp.h ${IDIR2}/tftpboot.h ${IDIR2}/asn1.h \
	${IDIR2}/snmp.h ${IDIR2}/syteksnm.h \
	${IDIR2}/localio.h ${IDIR2}/buffer.h ${IDIR2}/time.h \
	${IDIR2}/malloc.h ${IDIR1}/led.h ${IDIR2}/sncvar.h ${IDIR2}/dbd.h \
	${IDIR2}/lme.h ${IDIR2}/sockets.h ${IDIR1}/memory.h  ${IDIR2}/error.h

tdummy.o:	Makefile ${IDIR2}/types.h ${IDIR2}/uart.h ${IDIR1}/eeprecs.h \
		${IDIR2}/eeprom.h ${IDIR1}/dips.h ${IDIR1}/prcctl.h
	
fddidrv.o:	Makefile ${IDIR2}/krnl.h ${IDIR2}/types.h \
		${IDIR2}/ether.h ${IDIR2}/error.h \
		${IDIR2}/netbuf.h ${IDIR2}/tcpip.h ${IDIR2}/pkt.h

cam.o: Makefile ${IDIR2}/types.h 
