/**
 *	Program Name:	nim960 bridge
 *	
 *	Filename:	netcon.c
 *
 *	$Log:   /b/gregs/bridge/netio/netcon.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:13:44   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:36:38   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:17:48   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:54:32   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:09:22   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:32:20   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#define	BS	0x08
#define	DL	0x15
#define	CR	0x0d
#define	LF	0x0a
#define	BELL	0x07
/*
 *	netcon.c
 *	To test the telnet moudle
 */

read_cmd()

	{
	int	c;

	printf("Read_cmd\n");
        /* if more data is ready */

        for(;;)
        	{
		c = netgetch();
		if (c != -1)
			HandleNetChar(c & 0x7f);
		ReSchedule();
		}
	}


HandleNetChar(int data)

	{
	static	char	LastChar = '\0';
	static	int	DataCount = 0;

	/*
	 *	Echo it on the console for debugging
	 */
	switch (data)
		{

		case BS:
			/* a back space */
			net_BS();
			if (DataCount != 0)
				DataCount--;
			break;

		case DL: 
			/* control-U line delete */
			while(DataCount--)
				net_BS();
			DataCount = 0;
			break;

		case LF:

			if(LastChar == CR)
				break;
		case CR:
			NetPuts("\r\n");
			DataCount = 0;
			LastChar = data;
			break;

		default:

			/* echo it first */
			if(DataCount > 78)
				/* send a bell, if more than 80 char */
				data = BELL;
			else
				NetPutch(data);
			DataCount++;
			LastChar = data;
		}
	}


net_BS()

	{
	/*
	 *	Put  BS ' ' BS
	 */
	NetPuts("\b \b");
	}
