#include <types.h>
#include <target.h>
#include <krnl.h>
#include <sys.h>
#include <dips.h>
#include <led.h>
#include <tmr.h>
#include <menuparse.h>
#include "packet.h"

extern int fault_cnt;
extern volatile int usec_ticks;

extern int msecInt();
extern int usecInt();
extern int TimeTicksInt();
extern int TimeSliceInt();

extern KRNL krnl;
PGEN pkt_gen;

pktgen_dnid(dummy, nargs, dnid)
int dummy;
int nargs;	/* Number of the following args that are valid */
byte *dnid;
{
	NID nid;

	if (!atohnid(dnid, &nid))
		ncopy(&pkt_gen.dnid, &nid);

	return 0;
}

pktgen_snid(dummy, nargs, snid)
int dummy;
int nargs;	/* Number of the following args that are valid */
byte *snid;
{
	NID nid;

	if (!atohnid(snid, &nid))
		ncopy(&pkt_gen.snid, &nid);

	return 0;
}

pktgen_data(dummy, nargs, data)
int dummy;
int nargs;	/* Number of the following args that are valid */
char *data;
{
	byte *byte_ptr;
	byte pkt_data[3];
	int byte_data,i;

	if (strlen(data) > 52)
	{
		printf("Syntax Error : Buffer length exceeded (52 bytes)\n");
		return 0;
	}

	pkt_data[2] = '\0';
	for (byte_ptr = (byte *)data, i = 0; *byte_ptr != '\0'; byte_ptr += 2, i++)
	{
		pkt_data[0] = *byte_ptr;
		if ((pkt_data[1] = *(byte_ptr + 1)) == '\0')
		{
			printf("\nOdd number of bytes entered\n");
			break;
		}

		if (atoh(&pkt_data[0], &byte_data) == FALSE)
		{
			printf("\nSyntax Error : A non hexadecimal character entered\n");
			break;
		}
		pkt_gen.data[i] = (byte)byte_data;
	}
	for ( ; i != 52; i++)
		pkt_gen.data[i] = (byte)byte_data;
	return 0;
}

pktgen_delay(dummy, nargs, delay)
int dummy;
int nargs;	/* Number of the following args that are valid */
int delay;
{
	pkt_gen.delay = delay;
	return 0;
}

pktgen(dummy, nargs)
int dummy;
int nargs;	/* Number of the following args that are valid */
{
	uint i,frames;
	char *bufptr;

	pktgen_display(dummy, nargs);
	if (!(AskYesNo("Start generating packets using the above parameters [y/n] : ")))
		return 0;
	printf("Type ESC to stop\n");
	bufptr = (char *)snc_gen_bufinit(&pkt_gen.dnid, &pkt_gen.snid, &pkt_gen.data, pkt_gen.size,pkt_gen.portlist);
	if (pkt_gen.frames)
		frames = pkt_gen.frames + 1;
	else
		frames = 0;

	for(i = 1; i != frames; i++)
	{
		while (snc_gen_transmit(bufptr, pkt_gen.portlist) == -1)
			;
		if (pkt_gen.delay)
			Pktgen_Delay(pkt_gen.delay);
		if (i == 0xffffffff)
			i = 0;
		if (UartGetch() == ESC)
			break;
			
	}
	printf("\n\t\t\tNumber of Frames Transmitted : %d\n", i - 1);
	return 0;
}

pktgen_display(dummy, nargs)
int dummy;
int nargs;	/* Number of the following args that are valid */
{
	byte *nid;
	byte *buf_ptr;
	int i;

	printf("\nInter Frame Delay     : %d\n", pkt_gen.delay);
	printf("Frame Size            : %d\n", pkt_gen.size);
	printf("Number of Frames      : %d\n", pkt_gen.frames);
	printf("Transmit Port List    : 0x%x\n", pkt_gen.portlist);
	nid = (byte *)&pkt_gen.dnid;
	printf("Destination address   : %02x%02x%02x%02x%02x%02x\n" 
	,*nid, *(nid + 1), *(nid + 2), *(nid + 3), *(nid + 4), *(nid + 5));
	nid = (byte *)&pkt_gen.snid;
	printf("Source address        : %02x%02x%02x%02x%02x%02x\n" 
	,*nid, *(nid + 1), *(nid + 2), *(nid + 3), *(nid + 4), *(nid + 5));
	printf("Frame Data            : ");
	for (buf_ptr = &pkt_gen.data[0],i = 0; i != 26 ; i++, buf_ptr++)
		printf("%02x", *buf_ptr);
	printf("\n                        ");
	for (; i != 52 ; i++, buf_ptr++)
		printf("%02x", *buf_ptr);
	printf("\n");
	return 0;
}


pktgen_size(dummy, nargs, size)
int dummy;
int nargs;	/* Number of the following args that are valid */
int size;
{
	pkt_gen.size = size;
	return 0;
}

pktgen_frames(dummy, nargs, frames)
int dummy;
int nargs;	/* Number of the following args that are valid */
int frames;
{
	pkt_gen.frames = frames;
	return 0;
}

pktgen_quit(dummy, nargs)
int dummy;
int nargs;	/* Number of the following args that are valid (1 or 2) */
{
	return 1;
}

pktgen_portlist(dummy, nargs, portlist)
int dummy;
int nargs;
int portlist;
{
	pkt_gen.portlist = portlist;
	return 0;
}

Pktgen_Delay(int delay) /* provides 10 USec interval delay */
{
	int i;

	for (i = 0; i != delay; i++)
	{
		usec_ticks = 0;
		stc_control(STC_LOD_CNT | STC_S2);
		stc_control(STC_ARM_CNT | STC_S2);/* ARM timer 2 */
		while (usec_ticks < 1)
			;
	}
}

atohnid(data, nid)
byte *data;
byte *nid;
{
	byte pkt_data[3];
	int byte_data;

	if (strlen(data) != 12)
	{
		printf("Syntax Error : Invalid length\n");
		return 1;
	}
	pkt_data[2] = '\0';
	for (; *data != '\0'; data += 2, nid++)
	{
		pkt_data[0] = *data;
		pkt_data[1] = *(data + 1);

		if (atoh(&pkt_data[0], &byte_data) == FALSE)
		{
			printf("\nSyntax Error : A non hexadecimal character entered\n");
			return 1;
		}
		*nid = (byte)byte_data;
	}
	return 0;
}


static const char
help_all[] =
	".                 - repeat previous command\n"
	"?                 - help info for optional cmd\n"
	"da[ta]            - packet data\n"
	"di[splay]         - display parameters\n"
	"dn[id]            - destination MAC address of packet\n"
	"del[ay]           - inter packet delay\n"
	"f[rames]          - number of frames to transmit\n"
	"g[enerate]        - start generating packets\n"
	"h[elp]            - help info for optional cmd\n"
	"p[ortlist]        - port list for generating packets\n"
	"q[uit]            - quit\n"
	"si[ze]            - size of packet\n"
	"sn[id]            - source MAC address of packet"
	;

static const char
dot_help[] =
	".      -  Repeat previous command.\n";


static const char
f_help[] =
	"f[rames] <Number of Frames(int)>\n"
	"Example: ->f 10  - Generate ten frames\n"
	" Number of Frames to be Generated(f 0  - generates infinite frames).\n";


static const char
da_help[] =
	"da[ta] <packet data (hexadecimal)>\n"
	"Example : ->da 001080aa  - the entered data follows the source address.\n"
	" The last byte is expanded to fill the rest of the packet.\n";


static const char
di_help[] =
	"di[splay]\n"
	" Display's the Data Generator settings.\n";


static const char
dn_help[] =
	"dn[id] <Destination MAC address>\n"
	"Example : ->dn 000010abcdef\n"
	" Destination MAC address.\n";


static const char
del_help[] =
	"del[ay] <inter frame delay (int)>\n"
	"Example : ->del 10  - Sucessive frames are sent in 100 usec intervals\n"
	" Inter Frame Delay(del 0  - transmits frames back to back.\n";


static const char
g_help[] =
	"g[enerate]\n"
	" Start generating packets.\n";


static const char
h_help[] =
	"h[elp] [<command>]\n"
	"? [<command>]\n"
	"  Gives help for optional 'command'. If no command is specified\n"
	"  or unknown 'command', print short version of all commands.\n";


static const char
p_help[] =
	"p[ortlist] <port bit mask(hexadecimal)>\n"
	"Example : ->p 0c  - packets are transmitted on ports 2 and 4\n"
	" Port list (Bit map of ports) to generate packets.\n";


static const char
q_help[] =
	"q[uit]\n"
	" Quit the Packet generator programme.\n";


static const char
si_help[] =
	"si[ze] <packet size(int)>\n"
	"Example : ->si 64  - The 64 byte frame is transmitted\n"
	" Size of Frame.\n";


static const char
sn_help[] =
	"sn[id] <Source MAC address>\n"
	"Example : ->sn 000010fedcba\n"
	" Source MAC address.\n";


const char *
pktgen_help_table[] = {
	help_all, dot_help, q_help, f_help, da_help, di_help,
	dn_help, del_help, g_help, h_help, p_help, q_help,
	si_help, sn_help,
	NULL
	};

/************************************************************************
 * COMMAND TABLE
 *
 * The following table describes the keyboard commands.
 * The fields in each entry have the following meanings:
 *
 * cmd_name
 *	Name of command as a '\0'-terminated string.  Only the number of
 *	leading characters required for a match with user-entered input
 *	appear here,
 *
 * cmd_action
 *	Function that actually performs the command.  It should be
 *	invoked with the following arguments, in order:
 *		- the cmd_internal_arg from the command entry.
 *		- the number of following arguments that are valid on
 *			this call (some arguments may be optional).
 *		- one or more user-entered arguments, already parsed
 *			according to the corresponding cmd_argtypes.
 *
 * cmd_internal_arg
 *	First argument to be passed to the command action function.
 *
 * cmd_argtypes
 *	A '\0'-terminated list of characters describing the legal
 *	user-entered arguments to the command.  The ascii version
 *	of each argument should be translated into the corresponding
 *	type before it is passed to the action function.  Valid types are:
 *
 *	D  The text may be either a decimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	H  The text may be either a hexadecimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	S  The ASCII string should be passed unchanged to the action function.
 *
 *	Upper case letters indicate required arguments, lower case letters
 *	indicated optional arguments.  It is assumed that all required
 *	arguments always precede all optional ones.
 *
 ************************************************************************/

static const struct cmd
pktgen_cmd_table[] = {
	{ ".",  0,		0,			"",	},
	{ "?",  menuparse_help,	(int)&pktgen_help_table,"s",	},
	{ "da", pktgen_data,	BYTE,			"S",	},
	{ "di", pktgen_display,	0,			"",	},
	{ "dn", pktgen_dnid,	BYTE,			"S",	},
	{ "del",pktgen_delay,	INT,			"D",	},
	{ "f", 	pktgen_frames,	INT,			"D",	},
	{ "g", 	pktgen,		BYTE,			"s",	},
	{ "h", 	menuparse_help,	(int)&pktgen_help_table,"s",	},
	{ "p", 	pktgen_portlist,INT,			"H",	},
	{ "q", 	pktgen_quit,	0,			"",	},
	{ "si", pktgen_size,	INT,			"D",	},
	{ "sn",	pktgen_snid,	BYTE,			"S",	},
	{ NULL, 0 }
};


PktGen()
{
	int i;

	fault_cnt = 1;
	stop_timers();
	init_timers(TimeTicksInt, usecInt, 1, 1);
	disable_wdt();
	InitSlipPort(9600);

	pkt_gen.delay = 10;
	pkt_gen.size = 64;
	pkt_gen.frames = 1;
	ncopy(&pkt_gen.snid, MyNid(0));
	pkt_gen.data[0] = '\0';
	pkt_gen.portlist = 0xf;
	if (snc_gen_init() == -1)
	{
		printf("Could Not Initialize the Sonic\n");
		return 0;
	}

	MenuParse("\n\t\tPacket Generator, Hughes LAN Systems\n", pktgen_cmd_table);

	Di();
	init_timers(TimeTicksInt, TimeSliceInt, 1, krnl.krnl_slice_time);
	Ei();
	enable_wdt();
	fault_cnt = 0;
}
