# Defaults to GNU/960 tool set:
#

.LOGFILE .c_v(.c)
.LOGFILE .s_v(.s)
.LOGFILE .h_v(.h)

CC	= gcc960
OPT	= -O3 -DSTANLEY
CFLAGS	= ${ARCH} -I${IDIR1}  -I${IDIR3} ${OPT} -mstrict-align
AS	= gas960
ASFLAGS	= ${ARCH}
LD	= gld960
TOOLSET = ${GFLAG}

# Essential under System V, harmless elsewhere
SHELL = /bin/sh

# Standard rules
#
.c_v.c:
	=get $(GETOPTS) $<\($@\)

.h_v.h:
	=get $(GETOPTS) $<\($@\)

.s_v.s:
	=get $(GETOPTS) $<\($@\)

.c.o:
	${CC} ${CFLAGS} -c  $*.c

.c.s:
	${CC} ${CFLAGS} -S -c $*.c

.s.o:
	${AS} ${ASFLAGS} -o $*.o $*.s


#------------------------------------------------------------------------------
# Where to find things (include files, ROM images)
#------------------------------------------------------------------------------
#ROOT	= /h/pvcs
ROOT	= junk			# do it can't clobber changes I've made
#PIDIR1	= ${ROOT}/bridge/include	# where the .h_v files are
#PIDIR2	= ${ROOT}/i960/include
#PSDIR	= ${ROOT}/bridge/proc		# where the .c_v and .s_v files are

IDIR1	= ../include
IDIR3	= ../../i960/include
.PATH.h_v =  ${PSDIR} ; ${PIDIR1} ;${PIDIR2}
.PATH.h   = .; ${IDIR1} ;${IDIR3} 
.PATH.c_v = ${PSDIR}
.PATH.s_v = ${PSDIR}


#------------------------------------------------------------------------------
# TARG OBJECT FILES
#------------------------------------------------------------------------------
TARG_OBJS =  prcpkt_tst.o prcage.o prcadr.o prclog.o prcglobals.o xlate.o

ARCH=-ACA

proc: ${TARG_OBJS} Makefile
	${LD} ${ARCH} -o proc -r ${TARG_OBJS}
	cp proc ../lib/proc_tst.o
	

#------------------------------------------------------------------------------
# HEADER-FILE DEPENDENCIES
#------------------------------------------------------------------------------
prcpkt_tst.o: ${IDIR3}/types.h ${IDIR3}/krnl.h ${IDIR3}/sncvar.h ${IDIR3}/sonic.h \
	  ${IDIR3}/dbd.h ${IDIR1}/prcctl.h ${IDIR1}/prcadr.h prcfrm.h \
	  ${IDIR1}/target.h ${IDIR1}/bitmask.h ${IDIR1}/bridges.h \
	  ${IDIR1}/nvrecs.h ${IDIR3}/nvram.h ${IDIR1}/memory.h \
	  ${IDIR1}/filter.h ${IDIR1}/log.h ${IDIR1}/stp.h

prcage.o: ${IDIR3}/types.h ${IDIR1}/target.h ${IDIR3}/sncvar.h \
	  ${IDIR3}/sonic.h ${IDIR3}/dbd.h ${IDIR1}/prcctl.h ${IDIR1}/bitmask.h \
	  ${IDIR1}/prcadr.h

prciramvar.o: ${IDIR3}/types.h ${IDIR1}/target.h ${IDIR1}/prcadr.h \
	      ${IDIR1}/prcctl.h ${IDIR1}/bitmask.h ${IDIR3}/dbd.h

prcadr.o: ${IDIR3}/types.h ${IDIR1}/target.h ${IDIR3}/sncvar.h ${IDIR3}/dbd.h \
	  ${IDIR3}/sonic.h ${IDIR1}/prcadr.h

prclog.o: ${IDIR3}/types.h ${IDIR1}/bridges.h ${IDIR1}/bitmask.h \
	  ${IDIR3}/dbd.h ${IDIR1}/rlog.h ${IDIR1}/time.h

prcglobals.o: ${IDIR3}/types.h ${IDIR1}/target.h ${IDIR3}/krnl.h \
	      ${IDIR1}/prcadr.h ${IDIR3}/dbd.h ${IDIR1}/rlog.h

xlate.o: ${IDIR3}/types.h prcfrm.h ${IDIR3}/pkt.h ${IDIR3}/sncvar.h
