/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	prcadr.c
*
*	$Log:   /b/gregs/bridge/proc/prcadr.c_v  $
 * 
 *    Rev 1.10   10 Jan 1994 09:22:44   franks
 * Moved working address database and the address hash table to sram.
 * 
 *    Rev 1.9   15 Nov 1993 14:08:14   franks
 * No change.
 * 
 *    Rev 1.8   26 Oct 1993 15:07:28   franks
 * No change.
 * 
 *    Rev 1.7   12 Oct 1993 09:15:12   franks
 * No change.
 * 
 *    Rev 1.6   29 Sep 1993 09:31:16   franks
 * No change.
 * 
 *    Rev 1.5   10 Sep 1993 15:09:12   franks
 * No change.
 * 
 *    Rev 1.4   08 Sep 1993 10:17:32   franks
 * No change.
 * 
 *    Rev 1.3   30 Jul 1993 13:10:32   franks
 * No change.
 * 
 *    Rev 1.2   06 Jul 1993 15:43:54   franks
 * No change.
 * 
 *    Rev 1.1   19 May 1993 14:48:34   franks
 * No change.
 * 
 *    Rev 1.0   04 May 1993 15:50:14   franks
 * Initial revision.
 * 
 *    Rev 1.1   14 May 1992 11:09:28   suresh
 * Removed usage of fault_cnt.
 * 
 *    Rev 1.0   30 Mar 1992 17:34:14   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
#include <types.h>
#include <target.h>
#include <krnl.h>
#include <sncvar.h>
#include <prcadr.h>


extern ADR *FreeAdrHead;
extern ADR *adr_recs;
extern ADR *AgeAdrPtr;
extern word AgeTimeCounter;
extern ADR **adr_hshs;

/*
 * THESE ARE THE ADDRESS RECORD GET AND PUT ROUTINES
 */

/* initialize all the address records into  a free list */
prc_ini_addr()
{
	register int i;
	register ADR *ap;

	/* init the free list */
	FreeAdrHead = 0;

	if ((adr_recs = (ADR *)smalloc(sizeof(ADR) * ADR_REC_CNT)) == NULL)
	{
		printf("Memory Limit Exceeded : prc_ini_addr, lmalloc\n");
		InitAbort();
	}

	memset(adr_recs, 0, sizeof(ADR) * ADR_REC_CNT);

	for (i = ADR_REC_CNT, ap = adr_recs; i != 0; i--, ap++)
	{
		ap->adr_nxt = FreeAdrHead;
		FreeAdrHead = ap;
	}

	AgeAdrPtr = adr_recs;
	AgeTimeCounter = 0;
	/* init the hash table */
	if ((adr_hshs = (ADR **)smalloc(ADR_HSH_CNT * sizeof(ADR *))) == NULL)
	{
		printf("Memory Limit Exceeded : prc_ini_addr, lmalloc\n");
		InitAbort();
	}
	memset(adr_hshs, 0, (ADR_HSH_CNT * sizeof(ADR *)));
}

/* get an address record from the free list */
ADR *prc_get_addr()
{
	register ADR *ap;

	Di();
	if (ap = FreeAdrHead)
		FreeAdrHead = ap->adr_nxt;
	Ei();
	return ap;
}

/* put an address record back on the free list */
prc_put_addr(ap)
ADR *ap;
{
	Di();
	memset(ap, 0, sizeof(ADR));
	ap->adr_nxt = FreeAdrHead;
	FreeAdrHead = ap;
	Ei();
}

