
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	prcage.c
*
*	$Log:   /b/gregs/bridge/proc/prcage.c_v  $
 * 
 *    Rev 1.9   15 Nov 1993 14:08:16   franks
 * No change.
 * 
 *    Rev 1.8   26 Oct 1993 15:07:30   franks
 * No change.
 * 
 *    Rev 1.7   12 Oct 1993 09:15:12   franks
 * No change.
 * 
 *    Rev 1.6   29 Sep 1993 09:31:18   franks
 * No change.
 * 
 *    Rev 1.5   10 Sep 1993 15:09:14   franks
 * No change.
 * 
 *    Rev 1.4   08 Sep 1993 10:17:34   franks
 * No change.
 * 
 *    Rev 1.3   30 Jul 1993 13:10:32   franks
 * No change.
 * 
 *    Rev 1.2   06 Jul 1993 15:43:56   franks
 * Added cam ageing
 * 
 *    Rev 1.1   19 May 1993 14:48:36   franks
 * No change.
 * 
 *    Rev 1.0   04 May 1993 15:50:18   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:34:16   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
/*
 * BRIDGE PAKCET PROCESSOR learned address aging
 */

#include <types.h>
#include <target.h>
#include <krnl.h>
#include <sncvar.h>
#include <prcctl.h>
#include <prcadr.h>


#define	FDDI_PORT_M		0x08	/* bit mask of FDDI port */

/*
 * Age a group of records
 *   This routine ages the 4000 address records.
 *   It walks the table of records circularly, first marking
 *   records as dirty, and then on the next pass, if dirty, removing them.
 *
 *   Only non-static records are aged.  Only ports that are learning are aged.
 *
 *   This routine executes once every 100ms, and processes N records at a time.
 *   N can be set by the user to adjust the frequency of aging. 
 *      N=10 causes aging in 100-200 seconds (appx 2 minutes).
 */
extern ADR *AgeAdrPtr;
extern word AgeTimeCounter;
extern APPL apl;
extern PRCCTL prc;

prc_age()
{
	ADR *ap = AgeAdrPtr;
	register PRCCTL *cp = &prc;
	register word n;

	if (apl.run_appl != APPL_BRIDGE)
		return;
	else if (!apl.inited[APPL_BRIDGE])
		return;

	/* slow down execution to once every 100ms */
	if (++AgeTimeCounter < 10)
		return;

	AgeTimeCounter = 0;

	/* 
	 * process N records, A counter value of 0 disables aging
	 */

	for (n = cp->Prc_AgeCnt; n != 0; n--)
	{
		/* advance to next record */
		if (++ap >= &adr_recs[ADR_REC_CNT])
			ap = adr_recs;

		/* verify that record is in use,non-static,on an ageable prt */
		if (!(ap->adr_flg & ADR_FLG_NUS)
		||    (ap->adr_flg & ADR_FLG_STC) 
		||   !(cp->Prc_Learning & ap->adr_hom))
			continue;

		if (ap->adr_flg & ADR_FLG_USD)
		{
			/* recently used, clear the used bit */
			ap->adr_flg &= ~ADR_FLG_USD;
			continue;
		}
		else
		{
			/* otherwise, delete the record */
			word hash;
			register ADR *ap2;

			/* If this is a port 4 FDDI address then remove from CAM */
			if( ap->adr_hom & FDDI_PORT_M )
				CamDel((ushort *)&ap->adr_low);

			/* get hash index */
			hash = (ap->adr_low ^ ap->adr_mid ^ ap->adr_high) >> 1;

			/* find records previous entry in hash table */
			for (ap2 = (ADR *)&adr_hshs[hash]; 
			     ap2->adr_nxt != ap && ap2->adr_nxt != 0; 
			     ap2 = ap2->adr_nxt)
				;
			if (ap2->adr_nxt == 0)
				continue;	/* this should never happen */

			/* detach record from hash table and free it */
			ap2->adr_nxt = ap->adr_nxt;
			prc_put_addr(ap);
		}
	}
	AgeAdrPtr = ap;
}
