
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	prclog.c
*
*	$Log:   /b/gregs/bridge/proc/prclog.c_v  $
 * 
 *    Rev 1.9   15 Nov 1993 14:08:24   franks
 * No change.
 * 
 *    Rev 1.8   26 Oct 1993 15:07:38   franks
 * No change.
 * 
 *    Rev 1.7   12 Oct 1993 09:15:16   franks
 * No change.
 * 
 *    Rev 1.6   29 Sep 1993 09:31:26   franks
 * No change.
 * 
 *    Rev 1.5   10 Sep 1993 15:09:20   franks
 * No change.
 * 
 *    Rev 1.4   08 Sep 1993 10:17:44   franks
 * No change.
 * 
 *    Rev 1.3   30 Jul 1993 13:10:34   franks
 * No change.
 * 
 *    Rev 1.2   06 Jul 1993 15:44:14   franks
 * No change.
 * 
 *    Rev 1.1   19 May 1993 14:48:42   franks
 * No change.
 * 
 *    Rev 1.0   04 May 1993 15:50:22   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:34:18   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <bridges.h>
#include <rlog.h>
#include <time.h>

extern RLOG relearnlog;
extern int rlog_cnt;

rlog_init()
{
	relearnlog.rlog_count = 0;
	relearnlog.rlog_full = 0;
}

rlog_learn(NID *nid, byte from_port, byte to_port)
{
	RLOG *rlog_ptr = &relearnlog;
	RLOG_ENTRY *rlog_entry_ptr = &rlog_ptr->rlog[rlog_ptr->rlog_count];

	rlog_entry_ptr->rlog_no = (shrt)rlog_ptr->rlog_count;
	rlog_entry_ptr->rlog_from_port = from_port;
	rlog_entry_ptr->rlog_to_port = to_port;
	rlog_entry_ptr->rlog_nid_lo = nid->nid[0];
	rlog_entry_ptr->rlog_nid_mi = nid->nid[1];
	rlog_entry_ptr->rlog_nid_hi = nid->nid[2];

	if (++rlog_ptr->rlog_count == RLOG_COUNT)
	{
		rlog_ptr->rlog_count = 0;
		rlog_ptr->rlog_full++;
	}
}

rlog_date_time()
{
	register RLOG *rlog_ptr = &relearnlog;
	register RLOG_ENTRY *rlog_entry_ptr;
	struct tm *DateTm;
	int i, j;

	if (!(DateTm = (struct tm *)Ticks2DateTm()))
		return;

	for (i = 0; i != rlog_cnt; i++)
	{
		j = rlog_ptr->rlog_count - i - 1;
		if (j < 0)
		{
			j += RLOG_COUNT;
		}

		rlog_entry_ptr = &rlog_ptr->rlog[j];
		rlog_entry_ptr->rlog_tm_sec = (byte)DateTm->tm_sec;
		rlog_entry_ptr->rlog_tm_min = (byte)DateTm->tm_min;
		rlog_entry_ptr->rlog_tm_hour = (byte)DateTm->tm_hour;
		rlog_entry_ptr->rlog_tm_mday = (byte)DateTm->tm_mday;
		rlog_entry_ptr->rlog_tm_mon = (byte)DateTm->tm_mon + 1;
		rlog_entry_ptr->rlog_tm_year = (byte)DateTm->tm_year;
	}
}

