/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the index routines for RFC1285-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBIDX.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
 *
 *	$Log:   /b/gregs/bridge/snmp/fddi_routines/rfc1285idx.c_v  $
 * 
 *    Rev 1.0   30 Jul 1993 13:21:42   franks
 * Initial revision.
 * 
 *    Rev 1.3   03 Feb 1993 08:51:48   nayan
 * 
 *    Rev 1.2   21 Jan 1993 13:27:42   shekhar
 * 
 *    Rev 1.1   06 Jan 1993 15:07:22   shekhar
 * added idx functions for PATH Group.
 * 
 *    Rev 1.0   16 Dec 1992 09:23:30   shekhar
 * Initial revision.
 *
 *
 *************************************************************************/

#define RFC1285_MIB_IDX

#include <types.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>
#include "fddi.h"

#define	printf(x)		


/**************************************************************************
*  Procedure    :   index_snmpFddiSMTEntry
*
**************************************************************************/

int index_snmpFddiSMTEntry(compc, compl, idx1 )
byte		*compc;
unsigned int	*compl;
	void * *idx1; 

{
	printf ("index_snmpFddiSMTEntry\n");
	
        if (*compc == 1 && *compl == 1)
		{
		/* idx is set to NULL, because we don't keep any tables;
		   the mib object values are retrieved from SMT MIB.  */
		*idx1 = NULL; 
                return 0;      
		}
        else 
                return NO_SUCH_NAME;
}

/**************************************************************************
*  Procedure    :   next_snmpFddiSMTEntry
*
**************************************************************************/

int next_snmpFddiSMTEntry(compc, compl, rtn_code, idx1 )
byte		*compc;
unsigned int	*compl;
	 int	rtn_code;
	void * *idx1; 

{
	printf ("next_snmpFddiSMTEntry");
	
        if (( *compc == 0 ) || ( *compc >= 1 && *compl < 1))
        {
                *compc = 1;
                *compl = 1;
		*idx1  = NULL;
        }
        else 
		return NO_SUCH_NAME;

        return 0;
}

/**************************************************************************
*  Procedure    :   index_snmpFddiMACEntry
*
**************************************************************************/

int index_snmpFddiMACEntry(compc, compl, idx1, idx2 )
byte		*compc;
unsigned int	*compl;
	void * *idx1; 
	void * *idx2; 

{
	printf ("index_snmpFddiMacEntry\n");

	if ( *compc != 2)
		return NO_SUCH_NAME;
	
	/* assume that there is only one SMT; so smt index is
	   always 1 */
	if ( *compl == 1 && *(compl+1) <= MAX_MAC_COUNT)
		{
		/* set idx's to null; we get the value of this object 
		   from SMT MIB, that's why the idx's are not required.  
		*/
		*idx1 = *idx2 = NULL;
		return 0;
		}
	else
		return NO_SUCH_NAME;	
}

/**************************************************************************
*  Procedure    :   next_snmpFddiMACEntry
*
**************************************************************************/

int next_snmpFddiMACEntry(compc, compl, rtn_code, idx1, idx2 )
byte		*compc;
unsigned int	*compl;
	 int	rtn_code;
	void * *idx1; 
	void * *idx2; 

{
	printf ("next_snmpFddiMacEntry\n");

	*idx1 =*idx2 = NULL;

	/* Assumed that SMTIndex is always 1 in our case */
	if ( (*compc == 0 ) || ( *compc == 1 && *compl <= 1) || 
		(*compc > 1 && *compl <= 1 && *(compl + 1) < 1 ))

		{
		*compc = 2;
		*compl++ = 1;   /* SMTIndex  */
		*compl = 1;	/* MACIndex  */
		}
	else if ( *compc > 1 && *compl == 1 && *(compl + 1) < MAX_MAC_COUNT )
		{
		*compc = 2;
		*(compl + 1) += 1;
		}	
		
	else  
		return NO_SUCH_NAME;

	return 0;
 
}

/**************************************************************************
*  Procedure    :   index_snmpFddiPORTEntry
*
**************************************************************************/

int index_snmpFddiPORTEntry(compc, compl, idx1, idx2 )
byte		*compc;
unsigned int	*compl;
	void * *idx1; 
	void * *idx2; 

{
	printf ("index_snmpFddiPortEntry\n");
	if ( *compc != 2)
		return NO_SUCH_NAME;
	
	/* assume that there is only one SMT, so the SMTIndex
	   is always 1  */
	if ( *compl == 1 && *(compl+1) <= MAX_PORT_COUNT)
		{
		/* set idx's to null; we get the value of these objects 
		   from SMT MIB, that's why the idx's are not required.  
		*/
		*idx1 = *idx2 = NULL;
		return 0;
		}
	else
		return NO_SUCH_NAME;	
	return 0;
}

/**************************************************************************
*  Procedure    :   next_snmpFddiPORTEntry
*
**************************************************************************/

int next_snmpFddiPORTEntry(compc, compl, rtn_code, idx1, idx2 )
byte		*compc;
unsigned int	*compl;
	 int	rtn_code;
	void * *idx1; 
	void * *idx2; 

{
	printf ("next_snmpFddiPortEntry\n");

	*idx1 =*idx2 = NULL;
	
	/* Assumed that SMTIndex is always 1 in our case */
	if ( (*compc == 0 ) || ( *compc == 1 && *compl <= 1) || 
		(*compc > 1 && *compl <= 1 && *(compl + 1) < 1 ))

		{
		*compc = 2;
		*compl++ = 1;   /* SMTIndex  */
		*compl = 1;	/* PORTIndex  */
		}
	else if ( *compc > 1 && *compl == 1 && *(compl + 1) < MAX_PORT_COUNT )
		{
		*compc = 2;
		*(compl + 1) += 1;
		}	
		
	else  
		return NO_SUCH_NAME;

	return 0;
}

/**************************************************************************
*  Procedure    :   index_snmpFddiATTACHMENTEntry
*
**************************************************************************/

int index_snmpFddiATTACHMENTEntry(compc, compl, idx1 )
byte		*compc;
unsigned int	*compl;
	void * *idx1; 

{
        printf ("index_snmpFddiAttachmentEntry\n");
  
        if ( *compc != 2)
                return NO_SUCH_NAME;
        
        /* assume that there is only one SMT, so the SMTIndex
           is always 1  */
        if ( *compl == 1 && *(compl+1) <= MAX_ATTACH_COUNT)
                {
                /* set idx's to null; we get the value of these objects
                   from SMT MIB, that's why the idx's are not required.
                */
                *idx1 = NULL;
                return 0;
                }
        else
                return NO_SUCH_NAME;
        return 0;



#ifdef REM
	printf ("index_snmpFddiAttachmentEntry\n");

        if (*compc == 1 && *compl == 1)
		{
		/* idx is set to NULL, because we don't keep any tables;
		   the mib object values are retrieved from SMT MIB.  */
		*idx1 = NULL; 
                return 0;      
		}
        else 
                return NO_SUCH_NAME;

#endif
}

/**************************************************************************
*  Procedure    :   next_snmpFddiATTACHMENTEntry
*
**************************************************************************/

int next_snmpFddiATTACHMENTEntry(compc, compl, rtn_code, idx1 )
byte		*compc;
unsigned int	*compl;
	 int	rtn_code;
	void * *idx1; 

{

        printf ("next_snmpFddiPortEntry\n");

        *idx1 = NULL;

        /* Assumed that SMTIndex is always 1 in our case */
        if ( (*compc == 0 ) || ( *compc == 1 && *compl <= 1) ||
                (*compc > 1 && *compl <= 1 && *(compl + 1) < 1 ))

                {
                *compc = 2;
                *compl++ = 1;   /* SMTIndex  */
                *compl = 1;     /* PORTIndex  */
                }
        else if ( *compc > 1 && *compl == 1 && *(compl + 1) < MAX_ATTACH_COUNT )
                {
                *compc = 2;
                *(compl + 1) += 1;
                }
                
        else    
                return NO_SUCH_NAME;
 
        return 0;



#ifdef REM
	printf ("next_snmpFddiAttachmentEntry\n");

        if (( *compc == 0 ) || ( *compc >= 1 && *compl < 1))
        {
                *compc = 1;
                *compl = 1;
		*idx1  = NULL;
        }
        else 
		return NO_SUCH_NAME;

        return 0;

#endif
}


/**************************************************************************
*  Procedure    :   index_snmpFddiPATHEntry
*
**************************************************************************/

int index_snmpFddiPATHEntry(compc, compl, idx1, idx2 )
byte		*compc;
unsigned int	*compl;
	void * *idx1; 
	void * *idx2; 

{
	printf ("index_snmpFddiPathEntry\n");

	if ( *compc != 2)
		return NO_SUCH_NAME;
	
	/* assume that there is only one SMT; so smt index is
	   always 1 */
	if ( *compl == 1 && *(compl+1) <= MAX_PATH_COUNT)
		{
		/* set idx's to null; we get the value of this object 
		   from SMT MIB, that's why the idx's are not required.  
		*/
		*idx1 = *idx2 = NULL;
		return 0;
		}
	else
		return NO_SUCH_NAME;	
}

/**************************************************************************
*  Procedure    :   next_snmpFddiPATHEntry
*
**************************************************************************/

int next_snmpFddiPATHEntry(compc, compl, rtn_code, idx1, idx2 )
byte			*compc;
unsigned int	*compl;
int				rtn_code;
void 			* *idx1; 
void 			* *idx2; 

{
	printf ("next_snmpFddiPathEntry\n");

	*idx1 =*idx2 = NULL;

	/* Assumed that SMTIndex is always 1 in our case */
	if ( (*compc == 0 ) || ( *compc == 1 && *compl <= 1) || 
		(*compc > 1 && *compl <= 1 && *(compl + 1) < 1 ))

		{
		*compc = 2;
		*compl++ = 1;   /* SMTIndex  */
		*compl = 1;		/* PATHIndex  */
		}
	else if ( *compc > 1 && *compl == 1 && *(compl + 1) < MAX_PATH_COUNT )
		{
		*compc = 2;
		*(compl + 1) += 1;
		}	
		
	else  
		return NO_SUCH_NAME;

	return 0;
 
}

