/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the service routines for RFC1285-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
 *
 *	$Log:   /b/gregs/bridge/snmp/fddimib/rfc1285svc.c_v  $
 * 
 *    Rev 1.2   15 Nov 1993 15:53:34   vinay
 * removed a debug message.
 * 
 *    Rev 1.1   29 Sep 1993 10:54:52   vinay
 * put the check for range for FEBRIDGE for the following objects
 * snmpFddiMACTReq, snmpFddiPortMACLoopTime, snmpFddiPORTTBMax
 * 
 *    Rev 1.0   30 Jul 1993 13:21:44   franks
 * Initial revision.
 * 
 *    Rev 1.28   16 Jun 1993 18:21:16   shekhar
 * frameStatus is made READ_ONLY
 * 
 *    Rev 1.27   14 Jun 1993 12:07:00   shekhar
 *  fddiMACT_MaxGreatestLowerBound is now implemented as READ ONLY because 
 * the SMT implements it as READ_ONLY.
 * 
 *    Rev 1.26   07 Jun 1993 12:03:20   jang
 * exchanged Frame_Ct and Copied_Ct
 * 
 *    Rev 1.25   28 May 1993 09:55:20   shekhar
 * 
 *    Rev 1.24   20 May 1993 16:59:32   shekhar
 * 
 *    Rev 1.23   20 May 1993 16:38:10   shekhar
 * 
 *    Rev 1.22   19 May 1993 11:07:58   shekhar
 * 
 *    Rev 1.21   19 May 1993 11:03:28   shekhar
 * 
 *    Rev 1.20   03 May 1993 16:29:02   shekhar
 * 
 *    Rev 1.19   27 Apr 1993 15:42:04   nayan
 * set operation on FrameErrorThreshold fixed.
 * 
 *    Rev 1.18   20 Apr 1993 15:47:16   nayan
 * added check to return badvalue when the conn policy to be purged 
 * is m_m.
 * 
 *    Rev 1.17   20 Apr 1993 12:15:46   shekhar
 * 
 *    Rev 1.16   12 Apr 1993 19:02:24   nayan
 * inactivated DEBUG  flag
 * 
 *    Rev 1.15   29 Mar 1993 17:45:02   shekhar
 * 
 *    Rev 1.14   18 Feb 1993 16:18:38   shekhar
 * 
 *    Rev 1.13   18 Feb 1993 16:03:42   shekhar
 * 
 *    Rev 1.12   12 Feb 1993 11:00:24   nayan
 * 
 *    Rev 1.11   09 Feb 1993 17:52:40   nayan
 * 
 *    Rev 1.10   05 Feb 1993 09:24:48   shekhar
 * 
 *    Rev 1.9   05 Feb 1993 09:05:22   nayan
 * 
 *    Rev 1.8   03 Feb 1993 08:49:56   nayan
 * 
 *    Rev 1.7   25 Jan 1993 17:05:46   shekhar
 * Set is now supported.
 * 
 *    Rev 1.6   25 Jan 1993 13:47:26   shekhar
 * 
 *    Rev 1.5   25 Jan 1993 11:48:52   nayan
 * 
 *    Rev 1.4   22 Jan 1993 18:47:14   shekhar
 * debug Changes.
 * 
 *    Rev 1.3   22 Jan 1993 18:17:22   nayan
 * debugged changes.
 * 
 *    Rev 1.2   21 Jan 1993 16:39:04   shekhar
 * all the GetMibAttr function now checks for the return value.
 * 
 *    Rev 1.0   16 Dec 1992 09:24:52   shekhar
 * Initial revision.
 *
 *************************************************************************/

#define RFC1285_MIB_SVC

#include <types.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>

#include <smtdefs.h>
#include <mibdefs.h>
#include <smttypes.h>
#include <fddihdr.h>
#include <nvrecs.h>


static u_long   chipset_objid[2] ;/*= { 0, 0 };*/

#define xxprintf(x)	

/*
#define DEBUG 1
*/

static TLVSetCountType 	setCount;
static SMTStationIdType myStationId;
static Boolean			ValidStaionId = FALSE;

extern int	ChangePortPcType (uint portno, uint PcType);

static int get_myStationId()
	{
	TLVParamType    buffer;
	uint			result;

#if 0
	printf("get_myStationId\n");
#endif

	if (ValidStaionId)
		return 1;

#if 0
        printf("get_myStationId - after check \n");
#endif

	/* get the station id */
	buffer.paramType = fddiSMTStationId;  
	buffer.paramLen  = 0;  
	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	if (result != RC_SUCCESS)
		return 0;
			
	memcpy((char *) &myStationId, buffer.SMTOTHER, 8);
	ValidStaionId = TRUE;		

	return 1;
	}



 
/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTNumber
*  Path         :   1.3.6.1.2.1.10.15.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The number of SMT implementations (regardless of
*                        their current state) on this network management
*                        application entity.  The value for this variable
*                        must remain constant at least from one re-
*                        initialization of the entity's network management
*                        system to the next re-initialization."
*
**************************************************************************/

int svc_snmpFddiSMTNumber(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	
	xxprintf("svc_snmpFddiSMTNumber\n");
	
	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = get_nxtidx(compc, compl ,rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) 1;	/* only one SMT */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTIndex
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A unique value for each SMT.  Its value ranges
*                        between 1 and the value of snmpFddiSMTNumber.  The
*                        value for each SMT must remain constant at least
*                        from one re-initialization of the entity's network
*                        management system to the next re-initialization."
*
**************************************************************************/

int svc_snmpFddiSMTIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 

	xxprintf("svc_snmpFddiSMTIndex\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) *compl;
			*lenp = 1; 
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTStationId
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.2
*  Access       :   RO
*  Syntax       :   FddiSMTStationIdType VT_STRING
*  Description  :   
*                        "Uniquely identifies an FDDI station."
*
**************************************************************************/

int svc_snmpFddiSMTStationId(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
	TLVParamType	buffer;
	uint			result;	
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTStationId\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		buffer.paramType = fddiSMTStationId;  
		buffer.paramLen  = 0;  
		result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
		if (result != RC_SUCCESS)
			return NO_SUCH_NAME;

        memcpy(value, buffer.SMTOTHER, 8);
        *lenp = 8;

		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTOpVersionId
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.3
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The version that this station is using for its
*                        operation (refer to ANSI 7.1.2.2)."
*
**************************************************************************/

int svc_snmpFddiSMTOpVersionId(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer; 
	uint			result;
 
	void * idx1; 

#if 0
	printf("svc_snmpFddiSMTOpVersionId *value = %x \n", *value);
#endif

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        buffer.paramType = fddiSMTOpVersionId;  
        buffer.paramLen  = 0;  
        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
		if (result != RC_SUCCESS)
			return NO_SUCH_NAME;

        *value = (UINT_32_T) buffer.SMTPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for SmtOPVersionId\n"); 

	        	buffer.paramType = fddiSMTOpVersionId;
		        buffer.paramLen  = 4;  
		        buffer.SMTPARAM16 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

					ReSchedule();   /* Reschedule so that this loop won't 
									   exceed max time required to reset */ 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0 				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return BAD_VALUE;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if (rtn_code == 0)
			{
			if (*value < 1 || *value > 0xffff)
				return BAD_VALUE;

			if (!get_myStationId())
				return NO_SUCH_NAME;
			}
		else
			return (rtn_code);
	}		
	
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTHiVersionId
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.4
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The highest version of SMT that this station
*                        supports (refer to ANSI 7.1.2.2)."
*
**************************************************************************/

int svc_snmpFddiSMTHiVersionId(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;
    TLVParamType    buffer;
 	uint			result;
	
	void * idx1; 

	xxprintf("svc_snmpFddiSMTHiVersionId\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
			{
        	buffer.paramType = fddiSMTHiVersionId;  
       	 	buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
			if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
        	*value = (UINT_32_T) buffer.SMTPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTLoVersionId
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.5
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The lowest version of SMT that this station
*                        supports (refer to ANSI 7.1.2.2)."
*
**************************************************************************/

int svc_snmpFddiSMTLoVersionId(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTLoVersionId\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        buffer.paramType = fddiSMTLoVersionId;
        buffer.paramLen  = 0;  
        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
        if (result != RC_SUCCESS)
			return NO_SUCH_NAME;
			
		*value = (UINT_32_T) buffer.SMTPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTMACCt
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.6
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The number of MACs in the station or
*                        concentrator."
*
**************************************************************************/

int svc_snmpFddiSMTMACCt(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;	
	uint			result;	
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTMacCt\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTMAC_Ct;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
			#if 0
			xxprintf ("result in Macct = %d\n", result);
			#endif	

        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
				 
			*value = (UINT_32_T) buffer.SMTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTNonMasterCt
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.7
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The number of Non Master PORTs (A, B, or S PORTs)
*                        in the station or concentrator."
*
**************************************************************************/

int svc_snmpFddiSMTNonMasterCt(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;

	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTNonMasterCt\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTNonMaster_Ct;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			*value = (UINT_32_T) buffer.SMTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTMasterCt
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.8
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The number of Master PORTs in a node.  If the
*                        node is not a concentrator, the value is zero."
*
**************************************************************************/

int svc_snmpFddiSMTMasterCt(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTMasterCt\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTMaster_Ct ;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
			if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	        *value = (UINT_32_T) buffer.SMTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTPathsAvailable
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.9
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the PATH types available
*                        in the station.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each type of PATH that
*                        this node has available, 2 raised to a power is
*                        added to the sum.  The powers are according to the
*                        following table:
*  
*                                 Path   Power
*                              Primary   0
*                            Secondary   1
*                                Local   2
*  
*                        For example, a station having Primary and Local
*                        PATHs available would have a value of 5 (2**0 +
*                        2**2)."
*
**************************************************************************/

int svc_snmpFddiSMTPathsAvailable(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTPathsAvailable\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTPathsAvailable;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			*value = (UINT_32_T)  buffer.SMTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTConfigCapabilities
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.10
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates capabilities that are
*                        present in the node.  If 'holdAvailable' is
*                        present, this indicates support of the optional
*                        Hold Function (refer to ANSI SMT 9.4.3.2).  If
*                        'CF-Wrap-AB' is present, this indicates that the
*                        WRAP_AB state is forced.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each of the configuration
*                        policies currently enforced on the node, 2 raised
*                        to a power is added to the sum.  The powers are
*                        according to the following table:
*  
*                                   Policy   Power
*                            holdAvailable   0
*                               CF-Wrap-AB   1 "
*
**************************************************************************/

int svc_snmpFddiSMTConfigCapabilities(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void * idx1; 

	xxprintf("svc_snmpFddiSMTConfigCapabilities\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTConfigCapabilities;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
				
	        *value = (UINT_32_T) buffer.SMTPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTConfigPolicy
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.11
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the configuration policies
*                        currently enforced in the node (refer to ANSI SMT
*                        9.4.3.2).  The 'configurationHold' policy refers
*                        to the Hold flag, and should not be present only
*                        if the Hold function is supported.  The 'CF-Wrap-
*                        AB' policy refers to the CF_Wrap_AB flag.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each of the configuration
*                        policies currently enforced on the node, 2 raised
*                        to a power is added to the sum.  The powers are
*                        according to the following table:
*  
*                                       Policy   Power
*                            configurationHold   0
*                                   CF-Wrap-AB   1 "
*
**************************************************************************/

int svc_snmpFddiSMTConfigPolicy(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTConfigPolicy\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTConfigPolicy;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
			
        	*value = (UINT_32_T) buffer.SMTPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for SmtConfigPolicy\n"); 

	        	buffer.paramType = fddiSMTConfigPolicy;
		        buffer.paramLen  = 4;  
		        buffer.SMTPARAM16 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if (rtn_code == 0)
			{
            if (*value < 0 || *value > 3) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
			}
		else
			return (rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTConnectionPolicy
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.12
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the connection policies
*                        enforced at the station.  A station sets the
*                        corresponding policy for each of the connection
*                        types that it rejects.  The letter designations, X
*                        and Y, in the 'rejectX-Y' names have the following
*                        significance:  X represents the PC-Type of the
*                        local PORT and Y represents a PC-Neighbor in the
*                        evaluation of Connection-Policy (PC-Type, PC-
*                        Neighbor) that is done to determine the setting of
*                        T-Val(3) in the PC-Signaling sequence (refer to
*                        ANSI Section 9.6.3).
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each of the connection
*                        policies currently enforced on the node, 2 raised
*                        to a power is added to the sum.  The powers are
*                        according to the following table:
*  
*                               Policy   Power
*                            rejectA-A   0
*                            rejectA-B   1
*                            rejectA-S   2
*                            rejectA-M   3
*                            rejectB-A   4
*                            rejectB-B   5
*                            rejectB-S   6
*                            rejectB-M   7
*                            rejectS-A   8
*                            rejectS-B   9
*                            rejectS-S   10
*                            rejectS-M   11
*                            rejectM-A   12
*                            rejectM-B   13
*                            rejectM-S   14
*                            rejectM-M   15
*  
*                        Implementors should note that the polarity of
*                        these bits is different in different places in an
*                        SMT system.  Implementors should take appropriate
*                        care."
*
**************************************************************************/

int svc_snmpFddiSMTConnectionPolicy(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result, temp;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTConnectionPolicy\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTConnectionPolicy;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
			
        	*value = (UINT_32_T) buffer.SMTPARAM16;
 		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for fddiSMTConnectionPolicy\n"); 

	        	buffer.paramType = fddiSMTConnectionPolicy;
		        buffer.paramLen  = 4;  
		        buffer.SMTPARAM16 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if (rtn_code == 0)
			{
            if (*value < 0 || *value > 0xffff) 
                return BAD_VALUE; 

			 /* extra check because it is not supported in SMT */
			 temp = *value & 0x00008000;
			if ( ! (temp ) )
				return BAD_VALUE;
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
			}
		else
			return (rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTTNotify
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.13
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The timer used in the Neighbor Notification
*                        protocol, reported in seconds and ranging from 2
*                        to 30 seconds (refer to ANSI SMT 8.3.1)."
*
**************************************************************************/

int svc_snmpFddiSMTTNotify(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTTNotify\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTT_Notify;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
	        *value = (UINT_32_T) buffer.SMTPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for fddiSMTT_Notify\n"); 

	        	buffer.paramType = fddiSMTT_Notify;
		        buffer.paramLen  = 4;  
		        buffer.SMTPARAM16 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if (rtn_code == 0)
			{
            if (*value < 2 || *value > 30) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
			}
		else
			return (rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTStatusReporting
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.14
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates whether the node implements the Status
*                        Reporting Protocol.  This object is included for
*                        compatibility with products that were designed
*                        prior to the adoption of this standard."
*
**************************************************************************/

int svc_snmpFddiSMTStatusReporting(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTStatusReporting\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	buffer.paramType = fddiSMTStatusReporting;  
        	buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
            if (buffer.SMTPARAM8 == 0)   
                *value = (UINT_32_T) 2;
	        else
				*value = (UINT_32_T) buffer.SMTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTECMState
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.15
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the current state of the ECM state
*                        machine (refer to ANSI SMT 9.5.2)."
*
**************************************************************************/

int svc_snmpFddiSMTECMState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTECMState\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTECMState;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
        	
			*value = (UINT_32_T) (buffer.SMTPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTCFState
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.16
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The attachment configuration for the station or
*                        concentrator (refer to ANSI SMT 9.7.4.3)."
*
**************************************************************************/

int svc_snmpFddiSMTCFState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTCFState\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTCF_State;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

        	*value = (UINT_32_T) (buffer.SMTPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTHoldState
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.17
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "This value indicates the current state of the
*                        Hold function.  The values are determined as
*                        follows:  'holding-prm' is set if the primary ring
*                        is operational and the Recovery Enable Flag is
*                        clear (NOT NO_Flag(primary) AND NOT RE_Flag).  is
*                        set if the secondary ring is operational and the
*                        Recovery Enable Flag is clear (NOT
*                        NO_Flag(secondary) AND NOT RE_Flag).  Ref 9.4.3.
*                        and 10.3.1.  the primary or secondary, i.e., the
*                        Recovery Enable, RE_Flag, is set."
*
**************************************************************************/

int svc_snmpFddiSMTHoldState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTHoldState\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	buffer.paramType = fddiSMTHoldState;  
       	 	buffer.paramLen  = 0;  
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
	        *value = (UINT_32_T) (buffer.SMTPARAM8 + 2);
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTRemoteDisconnectFlag
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.18
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A flag indicating that the station was remotely
*                        disconnected from the network.  A station requires
*                        a Connect Action (SM_CM_CONNECT.request (Connect))
*                        to rejoin and clear the flag (refer to ANSI
*  
*  
*  
*  
*  
*                        6.4.5.2)."
*
**************************************************************************/

int svc_snmpFddiSMTRemoteDisconnectFlag(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTRemoteDisconnectFlag\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiSMTRemoteDisconnectFlag;  
    	    buffer.paramLen  = 0;  
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

            if (buffer.SMTPARAM8 == 0)   
                *value = (UINT_32_T) 2;
			else
				*value = (UINT_32_T) buffer.SMTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiSMTStationAction
*  Path         :   1.3.6.1.2.1.10.15.1.2.1.19
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "This object, when read, always returns a value of
*                        other(1).  The behavior of setting this variable
*                        to each of the acceptable values is as follows:
*  
*                        Other:          Results in a badValue error.
*  
*                        Connect:        Generates an
*                        SM_CM_Connect.request(connect) signal to CMT
*                        indicating that the ECM State machine is to begin
*                        a connection sequence.  The
*                        fddiSMTRemoteDisconnectFlag is cleared on the
*                        setting of this variable to 1.  See ANSI Ref
*                        9.3.1.1.
*  
*                        Disconnect:     Generates an
*                        SM_CM_Connect.request(disconnect) signal to ECM
*                        and sets the fddiSMTRemoteDisconnectFlag.  See
*                        ANSI Ref 9.3.1.1.
*  
*                        Path-Test:      Initiates a station path test.
*                        The Path_Test variable (See ANSI Ref. 9.4.1) is
*                        set to Testing.  The results of this action are
*                        not specified in this standard.
*  
*                        Self-Test:      Initiates a station self test.
*                        The results of this action are not specified in
*                        this standard.
*  
*                        Attempts to set this object to all other values
*                        results in a badValue error.  Agents may elect to
*                        return a badValue error on attempts to set this
*                        variable to path-Test(4) or self-Test(5)."
*  
*  
*  
*  
*  
*
**************************************************************************/

int svc_snmpFddiSMTStationAction(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiSMTStationAction\n");

	rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        *value = (UINT_32_T) 1;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for fddiSMTStationAction\n"); 

	        	buffer.paramType = fddiSMTStationAction;
		        buffer.paramLen  = 4;  
		        buffer.SMTPARAM16 = *value - 2;	/* subtract 1 for SMT */
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 2 || *value > 5) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACNumber
*  Path         :   1.3.6.1.2.1.10.15.2.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The total number of MAC implementations (across
*                        all SMTs) on this network management application
*                        entity.  The value for this variable must remain
*                        constant at least from one re-initialization of
*                        the entity's network management system to the next
*                        re-initialization."
*
**************************************************************************/

int svc_snmpFddiMACNumber(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	xxprintf("svc_snmpFddiMACNumber\n");

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = get_nxtidx(compc, compl ,rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) MAX_MAC_COUNT;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACSMTIndex
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The value of the SMT index associated with this
*                        MAC."
*
**************************************************************************/

int svc_snmpFddiMACSMTIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 
	void * idx2; 

	xxprintf("svc_snmpFddiMACSmtIndex\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	*value = (UINT_32_T)*compl;
            *lenp = 1;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACIndex
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A unique value for each MAC on the managed
*                        entity.  The MAC identified by a particular value
*                        of this index is that identified by the same value
*                        of an ifIndex object instance.  That is, if a MAC
*                        is associated with the interface whose value of
*                        ifIndex in the Internet-Standard MIB is equal to
*                        5, then the value of snmpFddiMACIndex shall also
*                        equal 5.  The value for each MAC must remain
*                        constant at least from one re-initialization of
*                        the entity's network management system to the next
*                        re-initialization."
*
**************************************************************************/

int svc_snmpFddiMACIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 
	void * idx2; 

	xxprintf("svc_snmpFddiMACIndex\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	*value = (UINT_32_T)*compl;
            *lenp = 1;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACFrameStatusCapabilities
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.3
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the MAC's bridge and end-
*                        station capabilities for operating in a bridged
*                        FDDI network.
*  
*  
*  
*  
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each capability present,
*                        2 raised to a power is added to the sum.  The
*                        powers are according to the following table:
*  
*  
*                             Capability    Power
*                             FSC-Type0    0
*                              
*                              
*  
*                             FSC-Type1    1
*                              
*                              
*  
*                             FSC-Type2    2
*                              
*                              
*                              
*  
*                             FSC-Type0-programmable    8
*                              
*  
*                             FSC-Type1-programmable    9
*                              
*  
*                             FSC-Type2-programmable   10
*                              
*                        "
*
**************************************************************************/

int svc_snmpFddiMACFrameStatusCapabilities(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 


	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACFrameStatusCapabilities;  
    	    buffer.paramLen  = 0;  
			buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
#if 0
			printf("result = %d\n", result);
#endif

        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) buffer.MACPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTMaxGreatestLowerBound
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.4
*  Access       :   RW
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The greatest lower bound of T_Max supported for
*                        this MAC."
*
**************************************************************************/

int svc_snmpFddiMACTMaxGreatestLowerBound(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACTMaxGreatestBound\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACT_MaxGreatestLowerBound;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) - buffer.MACPARAM32;/* convert to twos compl */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
			return GEN_ERR;
#ifdef REM
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for fddiMACT_MaxGreatestLowerBound\n"); 

	        	buffer.paramType = fddiMACT_MaxGreatestLowerBound;  
		        buffer.paramLen  = 8;  
				buffer.MACINDEX = *(compl + 1);
		        buffer.MACPARAM32 = -(*value); /* convert to fddi time */
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);
                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
#endif

	case SNMP_TEST:  /* this mib is implemented as READ_ONLY in SMT */
		        return READ_ONLY;

	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTVXGreatestLowerBound
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.5
*  Access       :   RO
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The greatest lower bound of TVX supported for
*                        this MAC."
*
**************************************************************************/

int svc_snmpFddiMACTVXGreatestLowerBound(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
   	TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACTVXGreatestLowerBound\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACTVXGreatestLowerBound;
    	    buffer.paramLen  = 0; 
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

    	    *value = (UINT_32_T) -(buffer.MACPARAM32); /* convert to twos compl */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACPathsAvailable
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.6
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the PATH types available
*                        for this MAC.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each type of PATH that
*                        this MAC has available, 2 raised to a power is
*                        added to the sum.  The powers are according to the
*                        following table:
*  
*                                 Path   Power
*                              Primary   0
*                            Secondary   1
*                                Local   2 "
*
**************************************************************************/

int svc_snmpFddiMACPathsAvailable(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result; 
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACPathsAvailable\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACPathsAvailable;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T)  buffer.MACPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACCurrentPath
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.7
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the association of the MAC with a
*                        station PATH."
*
**************************************************************************/

int svc_snmpFddiMACCurrentPath(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACCurrentPaths\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACCurrentPath;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
			
	        *value = (UINT_32_T) buffer.MACPARAM16; 
			if (*value == 0)
				*value = 1;
			else
				*value = *value << 1;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACUpstreamNbr
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.8
*  Access       :   RO
*  Syntax       :   FddiMACLongAddressType VT_STRING
*  Description  :   
*                        "The MAC's upstream neighbor's long individual MAC
*                        address.  It may be determined by the Neighbor
*                        Information Frame protocol (refer to ANSI SMT
*                        7.2.1).  The value shall be reported as '00 00 00
*                        00 00 00' if it is unknown."
*
**************************************************************************/

int svc_snmpFddiMACUpstreamNbr(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACUpstreamNbr\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACUpstreamNbr; 
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			memcpy(value, buffer.MACADDR, 6);
			*lenp = 6;
		}
		else
			return NO_SUCH_NAME;
		break;

	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACOldUpstreamNbr
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.9
*  Access       :   RO
*  Syntax       :   FddiMACLongAddressType VT_STRING
*  Description  :   
*                        "The previous value of the MAC's upstream
*                        neighbor's long individual MAC address.  It may be
*                        determined by the Neighbor Information Frame
*                        protocol (refer to ANSI SMT 7.2.1).  The value
*                        shall be reported as '00 00 00 00 00 00' if it is
*                        unknown."
*
**************************************************************************/

int svc_snmpFddiMACOldUpstreamNbr(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	TLVParamType    buffer;
	int 			rtn_code;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACOldUpstreamNbr\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACOldUpstreamNbr;  
        	buffer.paramLen  = 0;  
    	    buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

        	memcpy(value, buffer.MACADDR, 6);
			*lenp = 6;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACDupAddrTest
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.10
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The Duplicate Address Test flag, Dup_Addr_Test
*                        (refer to ANSI 8.3.1)."
*
**************************************************************************/

int svc_snmpFddiMACDupAddrTest(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
	TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACDupAddrTest\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACDup_Addr_Test;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

    	    *value = (UINT_32_T) (buffer.MACPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACPathsRequested
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.11
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates PATH(s) desired for this
*                        MAC.
*  
*                        The value is a sum which represents the individual
*                        PATHs that are desired.  This value initially
*  
*  
*  
*  
*  
*                        takes the value zero, then for each type of PATH
*                        that this node is, 2 raised to a power is added to
*                        the sum.  The powers are according to the
*                        following table:
*  
*                                 Path   Power
*                              Primary   0
*                            Secondary   1
*                                Local   2
*                             Isolated   3
*  
*                        The precedence order is primary, secondary, local,
*                        and then isolated if multiple PATHs are desired
*                        are set."
*
**************************************************************************/

int svc_snmpFddiMACPathsRequested(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACPathsRequested\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACPathsRequested;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
	        *value = (UINT_32_T) buffer.MACPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
				xxprintf("\nset for fddiMACPathsRequested\n"); 

	        	buffer.paramType = fddiMACPathsRequested;  
		        buffer.paramLen  = 8;  
				buffer.MACINDEX = *(compl + 1);
		        buffer.MACPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 1 || *value > 0x0f) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACDownstreamPORTType
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.12
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the PC-Type of the first port that is
*                        downstream of this MAC (the exit port)."
*
**************************************************************************/

int svc_snmpFddiMACDownstreamPORTType(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACDownstreamPORTTYPE\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACDownstreamPORTType;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	        *value = (UINT_32_T) (buffer.MACPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACSMTAddress
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.13
*  Access       :   RO
*  Syntax       :   FddiMACLongAddressType VT_STRING
*  Description  :   
*                        "The 48 bit individual address of the MAC used for
*                        SMT frames."
*
**************************************************************************/

int svc_snmpFddiMACSMTAddress(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 


	xxprintf("svc_snmpFddiMACSMTAddress\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACSMTAddress;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	    
		    memcpy(value, buffer.MACADDR, 6);
    	    *lenp = 6;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTReq
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.14
*  Access       :   RW
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The value of T-Req (refer to ANSI MAC 2.2.1 and
*                        ANSI MAC 7.3.5.2)."
*
**************************************************************************/

int svc_snmpFddiMACTReq(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 
#ifdef __FEBRIDGE
	int t_max, t_min;
#endif
	

	xxprintf("svc_snmpFddiMACTReq\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACT_Req;
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
			
			/* convert to twos compliment */	
	        *value = (UINT_32_T) -(buffer.MACPARAM32);
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
#if 0
				printf("\nset for fddiMACT_Req val = %d\n", *value); 
#endif

	        	buffer.paramType = fddiMACT_Req;
		        buffer.paramLen  = 4;
				buffer.MACINDEX = *(compl + 1);
		        buffer.MACPARAM32 = -(*value); /* convert to fddi time */
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			if (!get_myStationId())
				return NO_SUCH_NAME;
#ifdef __FEBRIDGE
			ShowMibAttr(1,fddiMACT_Max,0,1,&t_max);
			ShowMibAttr(1,fddiMACT_Min,0,1,&t_min);
			if(*value < -t_min || *value > -t_max)
				return BAD_VALUE;
#endif
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTNeg
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.15
*  Access       :   RO
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The value of T-Neg (refer to ANSI MAC 2.2.1 and
*                        ANSI MAC 7.3.5.2)."
*
**************************************************************************/

int svc_snmpFddiMACTNeg(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACTNeg\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACT_Neg;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
#if 0
			printf("result in T-neg = %d\n", result);
#endif
			
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			/* convert to twos complement */	
	        *value = (UINT_32_T) -(buffer.MACPARAM32);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTMax
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.16
*  Access       :   RO
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The value of T-Max (refer to ANSI MAC 2.2.1 and
*                        ANSI MAC 7.3.5.2)."
*
**************************************************************************/

int svc_snmpFddiMACTMax(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 
    uint            macno;

	xxprintf("svc_snmpFddiMACTMax\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACT_Max;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			/* convert to twos compliment */
    	    *value = (UINT_32_T) -(buffer.MACPARAM32);
		}
		else
			return NO_SUCH_NAME;
		break;
        case SNMP_SET:
            if (rtn_code == 0)
                {
#if 0 
                printf("\nset for MACTMax val = %d\n", *value); 
#endif 
 
                macno = (*(compl + 1)) - 1; /* subtract 1 for array index */
				
				/* convert to fddi time */
                nvr_fddi_rec.MACInfo[macno].T_Max = (int) - (*value);
                PutFDDIRec(&nvr_fddi_rec);
                return 0;
                }
            else
                return GEN_ERR;
            break;
        case SNMP_TEST:
            return(rtn_code);
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTvxValue
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.17
*  Access       :   RO
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The value of TvxValue (refer to ANSI MAC 2.2.1
*                        and ANSI MAC 7.3.5.2)."
*
**************************************************************************/

int svc_snmpFddiMACTvxValue(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
	TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 
    uint            macno;

	xxprintf("svc_snmpFddiMACTvxValue\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACTvxValue;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			/* convert to twos cpmpliment */
        	*value = (UINT_32_T) - (buffer.MACPARAM32);
		}
		else
			return NO_SUCH_NAME;
		break;
        case SNMP_SET:
            if (rtn_code == 0)
                {
#if 0 
                printf("\nset for MACTvxVal val = %d\n", *value); 
#endif 
                macno = (*(compl + 1)) - 1; /* subtract 1 for array index */
				
				/* convert to fddi time */
                nvr_fddi_rec.MACInfo[macno].TVXValue = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
                return 0;
                }
            else
                return GEN_ERR;
            break;
        case SNMP_TEST:
            return(rtn_code);
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACTMin
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.18
*  Access       :   RO
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "The value of T-Min (refer to ANSI MAC 2.2.1 and
*                        ANSI MAC 7.3.5.2)."
*
**************************************************************************/

int svc_snmpFddiMACTMin(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 
    uint            macno;

	xxprintf("svc_snmpFddiMACTMin\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACT_Min;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
#if 0
            printf("\result = %d\n", result);
#endif
 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			/* convert to twos compliment */
        	*value = (UINT_32_T) -(buffer.MACPARAM32);
		}
		else
			return NO_SUCH_NAME;
		break;
        case SNMP_SET:
            if (rtn_code == 0)
                {
#if 0
                printf("\nset for MACTMin val = %d\n", *value); 
#endif
                macno = (*(compl + 1)) - 1; /* subtract 1 for array index */

				/* convert to fddi time */
                nvr_fddi_rec.MACInfo[macno].T_Min = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
                return 0;
                }
            else
                return GEN_ERR;
            break;
        case SNMP_TEST:
            return(rtn_code);
  
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACCurrentFrameStatus
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.19
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the MAC's operational
*                        frame status setting functionality.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each functionality
*                        present, 2 raised to a power is added to the sum.
*                        The powers are according to the following table:
*  
*                            Functionality   Power
*                                FSC-Type0   0
*                                 
*  
*                                FSC-Type1   1
*                                 
*                                 
*  
*                                FSC-Type2   2
*                                 
*                                 
*                        "
*
**************************************************************************/

int svc_snmpFddiMACCurrentFrameStatus(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
	TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACCurrentFrameStatus\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACFrameStatus;  
	        buffer.paramLen  = 0;  
    	    buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
 
 	       *value = (UINT_32_T) buffer.MACPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
#if DEBUG
				printf("\nset for fddiMACFrameStatus value = %d\n", *value); 
#endif

	        	buffer.paramType = fddiMACFrameStatus;
		        buffer.paramLen  = 8;  
				buffer.MACINDEX = *(compl + 1);

			/* do not divide by 2 to get the position of the bit
			 * in the bit string being set
			 */
		        buffer.MACPARAM16 = *value;
#if DEBUG				
				printf("value in svc = %d\n", *value);   
#endif
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if DEBUG				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
			return READ_ONLY;
#ifdef REM
		if(rtn_code == 0)
		{
			if (*value < 0 && *value > 7)
				return BAD_VALUE;

			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
#endif

	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACFrameCts
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.20
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                        "Frame_Ct (refer to ANSI MAC 2.2.1)."
*
**************************************************************************/

int svc_snmpFddiMACFrameCts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACFrameCts\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		  buffer.paramType = fddiMACCopied_Ct;
		  buffer.paramLen  = 0;  
		  buffer.MACINDEX = *(compl + 1);
		  result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
		  if (result != RC_SUCCESS)
		    return NO_SUCH_NAME;
        
		  *value = (UINT_32_T) buffer.MACPARAM32;
		}
		else
		  return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACErrorCts
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.21
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                        "Error_Ct (refer to ANSI MAC 2.2.1)."
*
**************************************************************************/

int svc_snmpFddiMACErrorCts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACErrorsCts\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACError_Ct;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) buffer.MACPARAM32;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACLostCts
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.22
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                        "Lost_Ct (refer to ANSI MAC 2.2.1)."
*
**************************************************************************/

int svc_snmpFddiMACLostCts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACLostCts\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACLost_Ct;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

    	    *value = (UINT_32_T) buffer.MACPARAM32;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACFrameErrorThreshold
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.23
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A threshold for determining when a MAC Condition
*                        report should be generated.  The condition is true
*                        when the ratio, ((delta snmpFddiMACLostCt + delta
*                        snmpFddiMACErrorCt) / (delta snmpFddiMACFrameCt +
*                        delta snmpFddiMACLostCt)) x 2**16. exceeds the
*                        threshold.  It is used to determine when a station
*                        has an unacceptable frame error threshold.  The
*                        sampling algorithm is implementation dependent.
*                        Any attempt to set this variable to a value of
*                        less than one shall result in a badValue error.
*                        Those who are familiar with the SNMP management
*                        framework will recognize that thresholds are not
*                        in keeping with the SNMP philosophy.  However,
*                        this variable is supported by underlying SMT
*                        implementations already and maintaining this
*                        threshold should not pose an undue additional
*                        burden on SNMP agent implementors."
*
**************************************************************************/

int svc_snmpFddiMACFrameErrorThreshold(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

#ifdef DEBUG
	printf("new svc_snmpFddiMACFrameErrorThreshold\n");
#endif

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACFrameErrorThreshold;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) buffer.MACPARAM16;
		}
		else
			return NO_SUCH_NAME;
		break;
    case SNMP_SET:
            if (rtn_code == 0)
                {
                xxprintf("\nset for FrameErrorThreshold\n");

                buffer.paramType = fddiMACFrameErrorThreshold; 
                buffer.paramLen  = 8;
                buffer.MACINDEX = *(compl + 1);
                buffer.MACPARAM16 = *value;
                do
                    {
                    result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer,
                                    &setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
                
                    } while (result == RC_BAD_SET_COUNT);
 
#if 0          
                printf("result of set = %d\n", result);
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
                
                return 0;
                }
            else 
                return NO_SUCH_NAME;
    case SNMP_TEST:
        if(rtn_code == 0)
            {
            if (*value < 1 || *value > 0xffff)
                return BAD_VALUE;

            if (!get_myStationId())
                return NO_SUCH_NAME;
            }
        else 
            return(rtn_code);
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACFrameErrorRatio
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.24
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "This attribute is the actual ratio, ((delta
*                        snmpFddiMACLostCt + delta snmpFddiMACErrorCt) /
*                        (delta snmpFddiMACFrameCt + delta
*                        snmpFddiMACLostCt)) x 2**16."
*
**************************************************************************/

int svc_snmpFddiMACFrameErrorRatio(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACFrameErrorRatio\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACFrameErrorRatio;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

    	    *value = (UINT_32_T) buffer.MACPARAM16;
 		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACRMTState
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.25
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the current state of the Ring
*                        Management state machine (refer to ANSI Section
*                        10)."
*
**************************************************************************/

int svc_snmpFddiMACRMTState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACRMTState\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACRMTState;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) (buffer.MACPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACDaFlag
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.26
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The RMT flag Duplicate Address Flag, DA_Flag
*                        (refer to ANSI 10.3.1.2)."
*
**************************************************************************/

int svc_snmpFddiMACDaFlag(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACDaFlag\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACDa_Flag;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			if (buffer.MACPARAM8 == 0)
				*value = (UINT_32_T) 2;
			else	
	 	       *value = (UINT_32_T) buffer.MACPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACUnaDaFlag
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.27
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A flag set when the upstream neighbor reports a
*                        duplicate address condition.  Reset when the
*                        condition clears."
*
**************************************************************************/

int svc_snmpFddiMACUnaDaFlag(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 


	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACUnaDa_Flag;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
        	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

#if 0
			printf("Index = %d\n", *(compl + 1));
			printf("result = %d\n", result);
#endif
            if (buffer.MACPARAM8 == 0)   
                *value = (UINT_32_T) 2;
			else   
	        	*value = (UINT_32_T) buffer.MACPARAM8;

		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACFrameCondition
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.28
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the MAC Condition is active when set.
*                        Cleared when the condition clears and on power
*                        up."
*
**************************************************************************/

int svc_snmpFddiMACFrameCondition(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

#if 0
	printf("svc_snmpFddiMACFrameCondition\n");
#endif

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiMACFrameErrorCondition;  
    	    buffer.paramLen  = 0;  
        	buffer.MACINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
#if 0
			printf("return value = %d\n", buffer.MACPARAM8);
#endif

            if (buffer.MACPARAM8 == 0)   
                *value = (UINT_32_T) 2;
  			else 
		    	*value = (UINT_32_T) buffer.MACPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACChipSet
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.29
*  Access       :   RO
*  Syntax       :   OBJECT VT_OBJECT
*  Description  :   
*                        "This object identifies the hardware chip(s) which
*                        is (are) principally responsible for the
*                        implementation of the MAC function.  A few OBJECT
*                        IDENTIFIERS are identified elsewhere in this memo.
*                        For those The assignment of additional OBJECT
*                        IDENTIFIERs to various types of hardware chip sets
*                        is managed by the IANA.  For example, vendors
*                        whose chip sets are not defined in this memo may
*                        request a number from the Internet Assigned
*                        Numbers Authority (IANA) which indicates the
*                        assignment of a enterprise specific subtree which,
*                        among other things, may be used to allocate OBJECT
*                        IDENTIFIER assignments for that enterprise's chip
*                        sets.  Similarly, in the absence of an
*                        appropriately assigned OBJECT IDENTIFIER in this
*                        memo or in an enterprise specific subtree of a
*                        chip vendor, a board or system vendor can request
*                        a number for a subtree from the IANA and make an
*                        appropriate assignment.  It is desired that,
*                        whenever possible, the same OBJECT IDENTIFIER be
*                        used for all chips of a given type.  Consequently,
*                        the assignment made in this memo for a chip, if
*                        any, should be used in preference to any other
*                        assignment and the assignment made by the chip
*                        manufacturer, if any, should be used in preference
*                        to assignments made by users of those chips.  If
*                        the hardware chip set is unknown, the object
*                        identifier
*  
*  			
*   
*  
*                        is returned.  Note that unknownChipSet is a
*                        syntactically valid object identifier, and any
*                        conformant implementation of ASN.1 and the BER
*                        must be able to generate and recognize this
*  
*  
*  
*  
*  
*                        value."
*
**************************************************************************/

int svc_snmpFddiMACChipSet(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 	rtn_code;
	uint	i;

	void 	* idx1; 
	void 	* idx2; 

	xxprintf("svc_snmpFddiMACChipSet\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		for (i = 0; i < 2; i++) 
			*value = chipset_objid[i]; 
		*lenp = 2; 
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiMACAction
*  Path         :   1.3.6.1.2.1.10.15.2.2.1.30
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "This object, when read, always returns a value of
*                        other(1).  The behavior of setting this variable
*                        to each of the acceptable values is as follows:
*  
*                        Other:                  Results in a badValue
*                                                error.
*  
*                        enableLLCService:       enables MAC service to
*                                                higher layers.
*  
*                        disableLLCService:      disables MAC service to
*                                                higher layers.
*  
*                        connectMAC:             connect this MAC in
*                                                station.
*  
*                        disconnectMAC:          disconnect this MAC in
*                                                station.
*  
*                        Attempts to set this object to all other values
*                        results in a badValue error."
*
**************************************************************************/

int svc_snmpFddiMACAction(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACAction\n");

	rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        *value = (UINT_32_T) 1;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
	        	{
#if 0
				printf("\nset for fddiMACAction value = %d\n", *value); 
#endif
	        	buffer.paramType = fddiMACAction;
		        buffer.paramLen  = 8;  
				buffer.MACINDEX = *(compl + 1);
		        buffer.MACPARAM16 = *value - 2; 
							/* subtracted 2 to get in SMT range */
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if(rtn_code == 0)
			{
            if (*value < 2 || *value > 5) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
			}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTNumber
*  Path         :   1.3.6.1.2.1.10.15.4.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The total number of PORT implementations (across
*                        all SMTs) on this network management application
*                        entity.  The value for this variable must remain
*                        constant at least from one re-initialization of
*                        the entity's network management system to the next
*                        re-initialization."
*
**************************************************************************/

int svc_snmpFddiPORTNumber(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	xxprintf("svc_snmpFddiPORTNumber\n");

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = get_nxtidx(compc, compl ,rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) MAX_PORT_COUNT;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTSMTIndex
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*  
*  
*  
*  
*  
*                        "The value of the SMT index associated with this
*                        PORT."
*
**************************************************************************/

int svc_snmpFddiPORTSMTIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 
	void * idx2; 

	xxprintf("svc_snmpFddiPORTSmtIndex\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	*value = (UINT_32_T)*compl;
            *lenp = 1;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTIndex
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A unique value for each PORT within a given SMT.
*                        Its value ranges between 1 and the sum of the
*                        values of snmpFddiSMTNonMasterCt
*                        { snmpFddiSMTEntry 6 } and snmpFddiSMTMasterCt
*                        { snmpFddiSMTEntry 7 } on the given SMT.  The
*                        value for each PORT must remain constant at least
*                        from one re-initialization of the entity's network
*                        management system to the next re-initialization."
*
**************************************************************************/

int svc_snmpFddiPORTIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 
	void * idx2; 

	xxprintf("svc_snmpFddiPORTIndex\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	*value = (UINT_32_T)*compl;
            *lenp = 1;
  		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTPCType
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.3
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "PC_Type (refer to ANSI SMT 9.2.2 and ANSI SMT
*                        9.6.3.2)."
*
**************************************************************************/

int svc_snmpFddiPORTPCType(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
	TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 
	uint			portno;
	uint			PcType;

#ifdef 0
	printf("svc_snmpFddiPORTPCType\n");
#endif

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTPC_Type ;  
    	    buffer.paramLen  = 0;  
			buffer.PORTINDEX = *(compl + 1);

			
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 

            if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

        	*value = (UINT_32_T) ( buffer.PORTPARAM8 + 1) ;
		}
		else
			return NO_SUCH_NAME;
		break;
        case SNMP_SET:
            if (rtn_code == 0)
                {
                xxprintf("\nset for fddiPORTPC_Type \n"); 

				portno = *(compl + 1);
				PcType = *value - 1;

#ifdef DEBUG 
        		printf("portno = %d PcType = %d \n", portno, PcType);
#endif 
        
				
				return (ChangePortPcType(portno, PcType));

#ifdef REM	
				/* get the previous port type */
            	buffer.paramType = fddiPORTPC_Type ;
            	buffer.paramLen  = 0;  
            	buffer.PORTINDEX = portno;
 
            	result = GetMIBAttr(sizeof(buffer), &buffer, 
												(TLVSetCountType *) NULL);

            	if (result != RC_SUCCESS)
                	return NO_SUCH_NAME;

            	prevPcType = (uint) buffer.PORTPARAM8;

				
 
				/* If Transition is from A--->M Change only UI defaults */ 

				if (portno == 1)
					nvr_fddi_rec.UI_Defaults.Port1_PC_Type = 
												(byte)(*value - 1);								else if (portno == 6)
					 nvr_fddi_rec.UI_Defaults.Port6_PC_Type = 
                                                (byte)(*value - 1);	
                PutFDDIRec(&nvr_fddi_rec);
#endif
				return 0;
                }
            else
                return GEN_ERR;
            break;
        case SNMP_TEST:
	 	if (*value < 1 && *value > 4)
			return BAD_VALUE;	

#ifdef DEBUG
		printf("portno = %d PcType = %d \n", portno, PcType);
		portno = *(compl + 1);
		PcType = *value - 1;

		
		/* check if the port is 1 or 6; user is not allowed 
		   to modify 2-5 ports */
		if (portno != 1 && portno != 6)
			return BAD_VALUE;

		/* check if user is trying to set port 1 type to B */
		if (portno == 1 && PcType == PC_Type_B)
			return BAD_VALUE;
		
		/* check if user is trying to set port 6 type top A */  
        if (portno == 6 && PcType == PC_Type_A) 
            return BAD_VALUE;

#endif
               return 0;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTPCNeighbor
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.4
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The type (PC_Neighbor) of the remote PORT that is
*                        determined in PC_Signaling in R_Val (1,2) (refer
*                        to ANSI SMT 9.6.3.2)."
*
**************************************************************************/

int svc_snmpFddiPORTPCNeighbor(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTPCNeighbor\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTPC_Neighbor;  
    	    	buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);

        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 

            if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
		
	        *value = (UINT_32_T) (buffer.PORTPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTConnectionPolicies
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.5
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the node's PORT policies.
*  
*  
*  
*  
*  
*                        Pc-MAC-LCT, Pc-MAC-Loop, and Pc-MAC-Placement
*                        indicate how the respective PC Signaling
*                        Capability flags should  be set (refer to ANSI SMT
*                        9.4.3.2).
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each PORT policy, 2
*                        raised to a power is added to the sum.  The powers
*                        are according to the following table:
*  
*                                      Policy   Power
*                                  Pc-MAC-LCT   0
*                                 Pc-MAC-Loop   1
*                            Pc-MAC-Placement   2 "
*
**************************************************************************/

int svc_snmpFddiPORTConnectionPolicies(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTConnectionPolicies\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTConnectionPolicies;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
    	    result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
        	
			*value = (UINT_32_T)  buffer.PORTPARAM8;
 		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
                xxprintf("\nset for fddiPORTConnectionPolicies\n");
                
	        	buffer.paramType = fddiPORTConnectionPolicies;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 0 || *value > 7) 
                return BAD_VALUE;
#ifdef REM
			 /* extra check because it is not supported in SMT */ 
			if (*value & 0x04) 
				return BAD_VALUE; 
#endif
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTRemoteMACIndicated
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.6
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The indication, in PC-Signaling that the remote
*                        partner intends to place a MAC in the output token
*                        PATH of this PORT.  Signaled as R_Val (9) (refer
*                        to ANSI SMT 9.6.3.2)."
*
**************************************************************************/

int svc_snmpFddiPORTRemoteMACIndicated(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTRemoteMACIndicated\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTRemoteMACIndicated;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

            if (buffer.PORTPARAM8 == 0)
                *value = (UINT_32_T) 2;
            else   
                *value = (UINT_32_T) buffer.PORTPARAM8;
         
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTCEState
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.7
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the current state of PORT's
*                        Configuration Element (CE) (refer to ANSI 9.7.5).
*                        Note that this value represents the Current Path
*                        information for this PORT."
*
**************************************************************************/

int svc_snmpFddiPORTCEState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTCEState\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTCE_State;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) (buffer.PORTPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTPathsRequested
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.8
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the desired association(s)
*                        of the port with a station PATH.  The 'Primary'
*                        Path is the default.  The value of 'Secondary' is
*                        only meaningful for S (slave) or M (master) PORT
*                        PC-Types.  This value effects the setting of the
*                        CF_Insert_S, and CF_Insert_L flags (refer to ANSI
*                        Section 9.4.3).  If the 'Primary' PATH is present,
*                        then the Primary PATH (the default PATH) is
*                        selected.  If the 'Secondary' PATH is present and
*                        the 'Primary' PATH is not present, then the
*                        CF_Insert_S flag is set.  If the 'Local' PATH is
*                        sent and neither the 'Primary' or 'Secondary'
*                        PATHs are sent, then the CF_Insert_L flag is set.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each type of PATH
*                        desired, 2 raised to a power is added to the sum.
*                        The powers are according to the following table:
*  
*                                 Path   Power
*                              Primary   0
*                            Secondary   1
*                                Local   2
*                             Isolated   3 "
*
**************************************************************************/

int svc_snmpFddiPORTPathsRequested(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTPathsRequested\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTPathsRequested;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

    	    *value = (UINT_32_T) buffer.PORTPARAM8;
#if 0               
                printf("value got is %d\n", *value); 
#endif
 
 		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTPathsRequested;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
				printf("value set is %d\n", *value);
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
#if 0               
                printf("value to be set is %d\n", *value); 
#endif
 
            if (*value < 1 || *value > 0x0f) 
                return BAD_VALUE; 
		
			/* when port 1 and 6 is of type S then none of the ports 
			   should be put on secondary */	
			if (nvr_fddi_rec.PORTInfo[PHY_A].PC_Type == PC_Type_S &&
				(*value & PA_SECONDARY)== PA_SECONDARY)
				return BAD_VALUE;
				
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTMACPlacement
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.9
*  Access       :   RO
*  Syntax       :   FddiResourceId VT_NUMBER
*  Description  :   
*                        "Indicates the upstream MAC, if any, that is
*                        associated with the PORT.  The value shall be zero
*                        if there is no MAC associated with the PORT.
*                        Otherwise, the value shall be equal to the value
*                        of snmpFddiMACIndex associated with the MAC."
*
**************************************************************************/

int svc_snmpFddiPORTMACPlacement(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiMACPlacement\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	buffer.paramType = fddiPORTMACPlacement;  
	        buffer.paramLen  = 0;  
    	    buffer.PORTINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
	        *value = (UINT_32_T) buffer.PORTPARAM16;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTAvailablePaths
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.10
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A value that indicates the PATH types available
*                        for M and S PORTs.
*  
*                        The value is a sum.  This value initially takes
*                        the value zero, then for each type of PATH that
*                        this port has available, 2 raised to a power is
*                        added to the sum.  The powers are according to the
*                        following table:
*  
*                                 Path   Power
*                              Primary   0
*                            Secondary   1
*                                Local   2 "
*
**************************************************************************/

int svc_snmpFddiPORTAvailablePaths(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void	 		* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTAvailablePaths\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTAvailablePaths; 
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T)  buffer.PORTPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTMACLoopTime
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.11
*  Access       :   RW
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "Time for the optional MAC Local Loop, T_Next(9),
*                        which is greater-than or equal-to 200 milliseconds
*                        (refer to ANSI SMT 9.4.4.2.3)."
*
**************************************************************************/

int svc_snmpFddiPORTMACLoopTime(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTMACLoopTime\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTMACLoop_Time;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
		
    	    *value = (UINT_32_T) buffer.PORTPARAM32;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
                xxprintf("\nset for fddiPORTMACLoop_Time\n");
                
	        	buffer.paramType = fddiPORTMACLoop_Time;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM32 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);
                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
            break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 0x002625a0 || *value > 0x7fffffff) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTTBMax
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.12
*  Access       :   RW
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "TB_Max (refer to ANSI SMT 9.4.4.2.1)."
*
**************************************************************************/

int svc_snmpFddiPORTTBMax(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTTBMax\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTTB_Max;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
			/* convert to twos compliment */		
    	    *value = (UINT_32_T) -(buffer.PORTPARAM32);
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
                xxprintf("\nset for fddiPORTTB_Max\n");
                
	        	buffer.paramType = fddiPORTTB_Max;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM32 = -(*value); /* convert to fddi time */
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
            break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			if (!get_myStationId())
				return NO_SUCH_NAME;

#ifdef __FEBRIDGE
			if(*value < 0 || *value > 0x7fffffff)
				return BAD_VALUE;
#endif
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTBSFlag
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.13
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The Break State, BS_Flag (refer to ANSI SMT
*                        9.4.3.4)."
*
**************************************************************************/

int svc_snmpFddiPORTBSFlag(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void	 		* idx2; 

	xxprintf("svc_snmpFddiPORTBSFlag\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTBS_Flag;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

            if (buffer.PORTPARAM8 == 0)   
                *value = (UINT_32_T) 2;
			else   
	        	*value = (UINT_32_T) buffer.PORTPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLCTFailCts
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.14
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                        "The count of the consecutive times the link
*                        confidence test (LCT) has failed during connection
*                        management (refer to ANSI 9.4.1)."
*
**************************************************************************/

int svc_snmpFddiPORTLCTFailCts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
   	TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTLCTFailCts\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTLCTFail_Ct;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
    	    result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) buffer.PORTPARAM32;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLerEstimate
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.15
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A long term average link error rate.  It ranges
*                        from 10**-4 to 10**-15 and is reported as the
*                        absolute value of the exponent of the estimate."
*
**************************************************************************/

int svc_snmpFddiPORTLerEstimate(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTLerEstimate\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
    	    buffer.paramType = fddiPORTLer_Estimate;  
	        buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
    	    result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	    
		    *value = (UINT_32_T) buffer.PORTPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLemRejectCts
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.16
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                        "A link error monitoring count of the times that a
*                        link has been rejected."
*
**************************************************************************/

int svc_snmpFddiPORTLemRejectCts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTLemRejectCts\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
    	    buffer.paramType = fddiPORTLem_Reject_Ct;  
	        buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
    	    result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	    
		    *value = (UINT_32_T) buffer.PORTPARAM32;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLemCts
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.17
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                        "The aggregate link error monitor error count, set
*  
*  
*  
*  
*  
*                        to zero only on station power_up."
*
**************************************************************************/

int svc_snmpFddiPORTLemCts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTLemCts\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
    	    buffer.paramType = fddiPORTLem_Ct;  
	        buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
    	    result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
	        *value = (UINT_32_T) buffer.PORTPARAM32;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLerCutoff
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.18
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The link error rate estimate at which a link
*                        connection will be broken.  It ranges from 10**-4
*                        to 10**-15 and is reported as the absolute value
*                        of the exponent."
*
**************************************************************************/

int svc_snmpFddiPORTLerCutoff(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTMACLerCutOff\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTLer_Cutoff;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

    	    *value = (UINT_32_T) buffer.PORTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
                xxprintf("\nset for fddiPORTLer_Cutoff\n");
                
	        	buffer.paramType = fddiPORTLer_Cutoff;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);


                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
            break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 4 || *value > 0x0f) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLerAlarm
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.19
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The link error rate estimate at which a link
*                        connection will generate an alarm.  It ranges from
*                        10**-4 to 10**-15 and is reported as the absolute
*                        value of the exponent of the estimate."
*
**************************************************************************/

int svc_snmpFddiPORTLerAlarm(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTMACLerAlarm\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTLer_Alarm;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	    	if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) buffer.PORTPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
                xxprintf("\nset for fddiPORTLer_Alarm\n");
                
	        	buffer.paramType = fddiPORTLer_Alarm;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
            break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 4 || *value > 0x0f) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTConnectState
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.20
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "An indication of the connect state of this PORT.
*                        Basically, this gives a higher level view of the
*                        state of the connection by grouping PCM states and
*                        the PC-Withhold flag state.  The supported values
*                        and their corresponding PCM states and PC-Withhold
*                        condition, when relevant, are:
*  
*  
*  
*  
*  
*  
*                          disabled: (PC0:Off, PC9:Maint)
*  
*                        connecting: (PC1(Break) || PC3 (Connect) || PC4
*                        (Next)                 || PC5 (Signal) || PC6
*                        (Join) || PC7 (Verify))             &&
*                        (PC_Withhold = None)
*  
*                           standby: (NOT PC_Withhold == None)
*  
*                            active: (PC2:Trace || PC8:Active) "
*
**************************************************************************/

int svc_snmpFddiPORTConnectState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 
    uint            portno;

	xxprintf("svc_snmpFddiPORTConnectState\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTConnectState;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
	
	        *value = (UINT_32_T) ( buffer.PORTPARAM16 + 1);
		}
		else
			return NO_SUCH_NAME;
		break;
        case SNMP_SET:
            if (rtn_code == 0)
                {
				return GEN_ERR;
#if REM
                printf("\nset for fddiPORTConnectState \n");

                portno = (*(compl + 1)) - 1; /* subtract 1 for array index */
                nvr_fddi_rec.PORTInfo[portno].port_state =
                                            (byte)(*value - 1);
                PutFDDIRec(&nvr_fddi_rec);
                return 0;
#endif
                }
            else 
                return GEN_ERR;
            break;
        case SNMP_TEST:
			return READ_ONLY;
#ifdef REM	
        if (*value < 1 || *value > 4)
            return BAD_VALUE;
		return 0;
#endif
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTPCMState
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.21
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "(refer to SMT 9.6.2)."
*
**************************************************************************/

int svc_snmpFddiPORTPCMState(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTPCMState\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTPCMState;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

	        *value = (UINT_32_T) ( buffer.PORTPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTPCWithhold
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.22
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "PC_Withhold, (refer to ANSI SMT 9.4.1)."
*
**************************************************************************/

int svc_snmpFddiPORTPCWithhold(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTPCWithhold\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	buffer.paramType = fddiPORTPC_Withhold;  
        	buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
				
        	*value = (UINT_32_T) (buffer.PORTPARAM8 + 1);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTLerCondition
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.23
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "This variable is set to true whenever LerEstimate
*                        is less than or equal to LerAlarm."
*
**************************************************************************/

int svc_snmpFddiPORTLerCondition(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTLerCondition\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiPORTLerCondition;  
    	    buffer.paramLen  = 0;  
        	buffer.PORTINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			if (buffer.PORTPARAM8 == 0)
				*value = (UINT_32_T) 2;
			else
				*value = (UINT_32_T) buffer.PORTPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTChipSet
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.24
*  Access       :   RO
*  Syntax       :   OBJECT VT_OBJECT
*  Description  :   
*                        "This object identifies the hardware chip(s) which
*                        is (are) principally responsible for the
*                        implementation of the PORT (PHY) function.  A few
*                        OBJECT IDENTIFIERS are identified elsewhere in
*                        this memo.  For those The assignment of additional
*                        OBJECT IDENTIFIERs to various types of hardware
*                        chip sets is managed by the IANA.  For example,
*                        vendors whose chip sets are not defined in this
*                        memo may request a number from the Internet
*                        Assigned Numbers Authority (IANA) which indicates
*                        the assignment of a enterprise specific subtree
*                        which, among other things, may be used to allocate
*                        OBJECT IDENTIFIER assignments for that
*                        enterprise's chip sets.  Similarly, in the absence
*                        of an appropriately assigned OBJECT IDENTIFIER in
*                        this memo or in an enterprise specific subtree of
*                        a chip vendor, a board or system vendor can
*                        request a number for a subtree from the IANA and
*                        make an appropriate assignment.  It is desired
*                        that, whenever possible, the same OBJECT
*                        IDENTIFIER be used for all chips of a given type.
*                        Consequently, the assignment made in this memo for
*                        a chip, if any, should be used in preference to
*                        any other assignment and the assignment made by
*                        the chip manufacturer, if any, should be used in
*                        preference to assignments made by users of those
*                        chips.  If the hardware chip set is unknown, the
*                        object identifier
*  
*   
*  
*                        is returned.  Note that unknownChipSet is a
*                        syntactically valid object identifier, and any
*                        conformant implementation of ASN.1 and the BER
*                        must be able to generate and recognize this
*  
*  
*  
*  
*  
*                        value."
*
**************************************************************************/

int svc_snmpFddiPORTChipSet(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 	rtn_code;
	uint	i;
	void 	* idx1; 
	void 	* idx2; 

	xxprintf("svc_snmpFddiPORTChipSet\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			for (i = 0; i < 2; i++) 
				*value = chipset_objid[i]; 
			*lenp = 2; 
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiPORTAction
*  Path         :   1.3.6.1.2.1.10.15.4.2.1.25
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "This object, when read, always returns a value of
*                        other(1).  The behavior of setting this variable
*                        to each of the acceptable values is as follows:
*  
*                        Other:          Results in a badValue error.
*  
*                        maintPORT:      Signal PC_Maint
*  
*                        enablePORT:     Signal PC_Enable
*  
*                        disablePORT:    Signal PC_Disable
*  
*                        startPORT:      Signal PC_Start
*  
*                        stopPORT:       Signal PC_Stop
*  
*                        Signals cause an SM_CM_CONTROL.request service to
*                        be generated with a control_action of `Signal' and
*                        the `variable' parameter set with the appropriate
*                        value (i.e., PC_Maint, PC_Enable, PC_Disable,
*                        PC_Start, PC_Stop).  Ref. ANSI SMT Section 9.3.2.
*  
*                        Attempts to set this object to all other values
*                        results in a badValue error."
*
**************************************************************************/

int svc_snmpFddiPORTAction(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
	uint			result;
	void 			* idx1; 
	void 			* idx2; 

	xxprintf("svc_snmpFddiPORTAction\n");

	rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
				, &idx1, &idx2 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        *value = (UINT_32_T) 1; /* always returns 1 */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
                xxprintf("\nnew compile: set for fddiPORTAction\n");
                
	        	buffer.paramType = fddiPORTAction;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM16 = *value - 2; /* subtract 2 for SMT */
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 2 || *value > 6) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTNumber
*  Path         :   1.3.6.1.2.1.10.15.5.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The total number of attachments (across all SMTs)
*                        on this network management application entity.
*                        The value for this variable must remain constant
*                        at least from one re-initialization of the
*                        entity's network management system to the next
*                        re-initialization."
*
**************************************************************************/

int svc_snmpFddiATTACHMENTNumber(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	xxprintf("svc_snmpFddiAttachmentNumber\n");

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = get_nxtidx(compc, compl ,rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) MAX_ATTACH_COUNT;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTSMTIndex
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The value of the SMT index associated with this
*                        ATTACHMENT."
*
**************************************************************************/

int svc_snmpFddiATTACHMENTSMTIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 

	xxprintf("svc_snmpFddiAttachmentSmtIndex\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	*value = (UINT_32_T)*compl;
            *lenp = 1;
  		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTIndex
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "A unique value for each ATTACHMENT on a given
*                        SMT.  Its value ranges between 1 and the sum of
*                        the values of snmpFddiSMTNonMasterCt {
*                        snmpFddiSMTEntry 6 } and snmpFddiSMTMasterCt {
*                        snmpFddiSMTEntry 7 } on the given SMT.  The value
*                        for each ATTACHMENT must remain constant at least
*                        from one re-initialization of the entity's network
*                        management system to the next re-initialization."
*
**************************************************************************/

int svc_snmpFddiATTACHMENTIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int rtn_code;

	void * idx1; 

	xxprintf("svc_snmpFddiAttachmentIndex\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
        	*value = (UINT_32_T)* (compl + 1);
            *lenp = 1;
  		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTClass
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.3
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The Attachment class.  This  represents a PORT or
*                        a pair of PORTs plus the associated optional
*                        optical bypass that are managed as a functional
*                        unit.  The PORT associations are the following:
*  
*                            single-attachment - S PORTs
*                              dual-attachment - A/B PORT Pairs
*                                 concentrator - M PORTs "
*
**************************************************************************/

int svc_snmpFddiATTACHMENTClass(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void	 		* idx1; 
	
	xxprintf("svc_snmpFddiAttachmentClass\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
#if 0
			printf("attachmentclass index is %d\n", *(compl+1));
#endif
	        buffer.paramType = fddiATTACHMENTClass;  
    	    buffer.paramLen  = 0;  
			buffer.ATTACHINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

        	*value = (UINT_32_T) (buffer.ATTACHPARAM16 + 1);

#if 0
			printf("value return is %d", *value);
#endif
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTOpticalBypassPresent
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.4
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "The value of this value is false for 'single-
*                        attachment' and { snmpFddiATTACHMENT 11 }.
*                        Correct operation of CMT for single-attachment and
*                        concentrator attachments requires that a bypass
*                        function must not loopback the network side of the
*                        MIC, but only the node side."
*
**************************************************************************/

int svc_snmpFddiATTACHMENTOpticalBypassPresent(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiAttachmentOpticalBypassPr\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiATTACHMENTOpticalBypassPresent;  
    	    buffer.paramLen  = 0;  
        	buffer.ATTACHINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

            if (buffer.ATTACHPARAM8 == 0)   
                *value = (UINT_32_T) 2;
            else   
                *value = (UINT_32_T) buffer.ATTACHPARAM8;
 			
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTIMaxExpiration
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.5
*  Access       :   RO
*  Syntax       :   FddiTime VT_NUMBER
*  Description  :   
*                        "I_Max (refer to ANSI SMT 9.4.4.2.1).  It is
*                        recognized that some currently deployed systems do
*                        not implement an optical bypass.  Systems which do
*                        not implement optical bypass should return a value
*                        of 0."
*
**************************************************************************/

int svc_snmpFddiATTACHMENTIMaxExpiration(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiAttachmentIMaxExpiration\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiATTACHMENTI_MaxExpiration;  
    	    buffer.paramLen  = 0;  
        	buffer.ATTACHINDEX = *(compl + 1);
        	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

			/* convert to twos compliment */	
	        *value = (UINT_32_T) -(buffer.ATTACHPARAM32);
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTInsertedStatus
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.6
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates whether the attachment is currently
*                        inserted in the node."
*
**************************************************************************/

int svc_snmpFddiATTACHMENTInsertedStatus(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void	 		* idx1; 

	xxprintf("svc_snmpFddiAttachmentInsertedStatus\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiATTACHMENTInsertedStatus;  
    	    buffer.paramLen  = 0;  
        	buffer.ATTACHINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;

            if (buffer.ATTACHPARAM8 == 0)   
                *value = (UINT_32_T) 2;
			else   
	        	*value = (UINT_32_T) buffer.ATTACHPARAM8;
		}
		else
			return NO_SUCH_NAME;
        break;
	case SNMP_SET:
		return GEN_ERR;
	case SNMP_TEST:
		return READ_ONLY;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_snmpFddiATTACHMENTInsertPolicy
*  Path         :   1.3.6.1.2.1.10.15.5.2.1.7
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                        "Indicates the Insert Policy for this Attachment.
*                        Insert: True (1), Don't Insert:  False (2),
*                        Unimplemented (3)"
*
**************************************************************************/

int svc_snmpFddiATTACHMENTInsertPolicy(service, compc, compl, lenp, value, index)
unsigned int	service;
byte			*compc;
unsigned int	*compl;
int				*lenp;
UINT_32_T		*value;
int				index;
{
	int 			rtn_code;
    TLVParamType    buffer;
 	uint			result;
	void 			* idx1; 

	xxprintf("svc_snmpFddiAttachmentInsertPolicy\n");

	rtn_code = index_snmpFddiATTACHMENTEntry(compc, compl, &idx1 );

	switch(service)
	{
	case SNMP_GETNXT:
	rtn_code = next_snmpFddiATTACHMENTEntry(compc, compl ,rtn_code
				, &idx1 );
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
	        buffer.paramType = fddiATTACHMENTInsertPolicy;  
    	    buffer.paramLen  = 0;  
        	buffer.ATTACHINDEX = *(compl + 1);
	        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	        if (result != RC_SUCCESS)
				return NO_SUCH_NAME;
			
            if (buffer.ATTACHPARAM8 == 0)   
                *value = (UINT_32_T) 2;
			else   
    	    	*value = (UINT_32_T) buffer.ATTACHPARAM8;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
        	if (rtn_code == 0)
                {
				xxprintf("\nset for fddiATTACHMENTInsertPolicy\n"); 

	        	buffer.paramType = fddiATTACHMENTInsertPolicy;
		        buffer.paramLen  = 8;  
				buffer.ATTACHINDEX = *(compl + 1);
				if (*value == 2) 	/* that is FALSE make it 0 */
			        buffer.ATTACHPARAM8 = *value - 2;
				else	
			        buffer.ATTACHPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				xxprintf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
            if (*value < 1 || *value > 2) 
                return BAD_VALUE; 
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

