/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       smtsvc.c
 *
 *      Description:    This file contains svcs for SMT MIB objects 
 *						not defined in rfc1285.
 *
 *      $Log:   /b/gregs/bridge/snmp/fddi_routines/smtsvc.c_v  $
 * 
 *    Rev 1.0   30 Jul 1993 13:21:46   franks
 * Initial revision.
 * 
 *    Rev 1.22   07 Jun 1993 12:04:08   jang
 * exchanged Frame_Ct and Copied_Ct
 * 
 *    Rev 1.21   28 May 1993 09:55:46   shekhar
 * 
 *    Rev 1.20   27 Apr 1993 18:32:40   nayan
 * fixed set operation on PORTMaintLineState
 * 
 *    Rev 1.19   27 Apr 1993 15:40:44   nayan
 * get operation on TPri2 fixed.
 * 
 *    Rev 1.18   02 Apr 1993 18:07:42   shekhar
 * 
 *    Rev 1.17   12 Mar 1993 11:16:54   shekhar
 * implemented mac stripping.
 * 
 *    Rev 1.16   01 Mar 1993 17:49:28   nayan
 * 
 *    Rev 1.15   18 Feb 1993 16:19:00   shekhar
 * 
 *    Rev 1.14   18 Feb 1993 16:05:56   shekhar
 * 
 *    Rev 1.13   17 Feb 1993 16:00:50   nayan
 * 
 *    Rev 1.12   12 Feb 1993 11:00:48   nayan
 * 
 *    Rev 1.11   10 Feb 1993 18:40:46   shekhar
 * 
 *    Rev 1.10   10 Feb 1993 18:00:08   nayan
 * 
 *    Rev 1.9   09 Feb 1993 17:53:12   nayan
 * 
 *    Rev 1.8   03 Feb 1993 08:50:22   nayan
 * 
 *    Rev 1.7   26 Jan 1993 13:23:40   shekhar
 * 
 *    Rev 1.6   25 Jan 1993 11:51:08   nayan
 * 
 *    Rev 1.5   25 Jan 1993 09:30:18   shekhar
 * Implemented Set.
 * 
 *    Rev 1.4   22 Jan 1993 18:18:38   nayan
 * debuge changes
 * 
 *    Rev 1.3   22 Jan 1993 09:10:14   shekhar
 * return value of GetMIBAttr is now checked.
 * 
 *    Rev 1.2   06 Jan 1993 15:08:22   shekhar
 * 
 *    Rev 1.1   06 Jan 1993 14:31:44   shekhar
 * Initial Version.
 *
 *
 *      Revision:
 *      1-000           Jan 6 1993      Shekhar Ambe
 *                      
 *******************************************************************
 */

#include <types.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>

#include <smtdefs.h>
#include <mibdefs.h>
#include <smttypes.h>
#include <fddihdr.h>
#include <nvrecs.h>
#include <miscsmtmib.h>
#include <drv.h>

static TLVSetCountType 	setCount;
static SMTStationIdType myStationId;
static Boolean			ValidStaionId = FALSE;

extern SMT_PRIVATE_MAC_OBJECTS	SmtMibMacObjects[];
extern SMT_PRIVATE_PORT_OBJECTS SmtMibPortObjects[];


static int get_myStationId()
	{
	TLVParamType    buffer;
	uint			result;

#if 0
	printf("get_myStationId\n");
#endif

	if (ValidStaionId)
		return 1;
#if 0
    printf("get_myStationId - after check \n");
#endif

	/* get the station id */
	buffer.paramType = fddiSMTStationId;  
	buffer.paramLen  = 0;  
	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
	if (result != RC_SUCCESS)
		return 0;
			
	memcpy((char *) &myStationId, buffer.SMTOTHER, 8);
	ValidStaionId = TRUE;		

	return 1;
	}


int svc_FddiMACNotCopiedThreshold(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void * idx1;
    void * idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACNotCopiedThreshold;  
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
				if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
				
		        *value = (UINT_32_T) buffer.MACPARAM16;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
	        	{
#if 0
			printf("\nset for threshold value = %d\n", *value); 
#endif
	        	buffer.paramType = fddiMACNotCopiedThreshold;  
		        buffer.paramLen  = 8;  
				buffer.MACINDEX = *(compl + 1);
		        buffer.MACPARAM16 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					
					} while (result == RC_BAD_SET_COUNT);

#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
        case SNMP_TEST:
			if (*value < 0 || *value > 0xffff)
				return BAD_VALUE;

			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
		
        return 0;
	}


int svc_FddiMACStripping(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
        int 	rtn_code, req_val;
		uint	macno;
        void 	* idx1;
        void 	* idx2;
 
        rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
        switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );


                /* FALL TRHROUGH */
        case SNMP_GET:
                return NO_SUCH_NAME;
        case SNMP_SET:
                {
				macno = *(compl + 1) - 1;
				if (*value == 1)  /* enable */
					req_val = DRV_ENABLE;
				else
					req_val = DRV_DISABLE; 
				DRV_ControlReq(macno, HLS_CTRL_MAC_STRIP, req_val);
                }
                break;
        case SNMP_TEST:
                if(rtn_code == 0)
                	{
					if (*value < 1 && *value > 2)
						return BAD_VALUE;	 
                	}
                else
                        return(rtn_code);
                break;
        }
        return 0;
}

int svc_FddiMACTPri0(service, compc, compl, lenp, value, index)
unsigned int    service;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
	int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
	uint			macno;
 
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );


        /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri0;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
				if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
				
				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
                else
                	return NO_SUCH_NAME;
                break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */
				/* convert to fddi time */
				nvr_fddi_rec.MACInfo[macno].T_Pri[0] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
            return(rtn_code);
        }
        return 0;
	}

int svc_FddiMACTPri1(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
    uint            macno;

    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri1;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
				
				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
       		else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */
				/* convert to fddi time */
				nvr_fddi_rec.MACInfo[macno].T_Pri[1] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
       		return (rtn_code); 
		}

        return 0;
	}


int svc_FddiMACTPri2(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
    uint            macno;

    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri2;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
       		else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */

				/* convert to twos compliment */
				nvr_fddi_rec.MACInfo[macno].T_Pri[2] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
            return (rtn_code); 
        }
        return 0;
}

int svc_FddiMACTPri3(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
    uint            macno;

    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri3;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
       		else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */

				/* convert to twos compliment */
				nvr_fddi_rec.MACInfo[macno].T_Pri[3] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
            return (rtn_code); 
        }
        return 0;
}

int svc_FddiMACTPri4(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
    uint            macno;

    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri4;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
       		else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */

				/* convert to twos compliment */
				nvr_fddi_rec.MACInfo[macno].T_Pri[4] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
            return (rtn_code); 
        }
        return 0;
}

int svc_FddiMACTPri5(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
    uint            macno;

    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri5;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
       		else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */
			
				/* convert to twos compliment */
				nvr_fddi_rec.MACInfo[macno].T_Pri[5] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
            return (rtn_code); 
        }
        return 0;
}

int svc_FddiMACTPri6(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
    uint            macno;

    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACT_Pri6;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.MACPARAM32);
                }
       		else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
				{
				
				macno = (*(compl + 1)) - 1;	/* subtract 1 for array index */

				/* convert to twos compliment */
				nvr_fddi_rec.MACInfo[macno].T_Pri[6] = (int) -(*value);
                PutFDDIRec(&nvr_fddi_rec);
				return 0;
			    }
			else
				return GEN_ERR;
            break;
        case SNMP_TEST:
            return (rtn_code); 
        }
        return 0;
}

int svc_FddiPATHRingLatency(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHRingLatency;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PATHPARAM32;
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiPATHClassPATHRingLatency;
		        buffer.paramLen  = 8;  
				buffer.PATHINDEX = *(compl + 1);
		        buffer.PATHPARAM32 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);
                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}


int svc_FddiPATHTRmode(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHT_Rmode;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PATHPARAM32;
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiPATHClassPATHT_Rmode;
		        buffer.paramLen  = 8;  
				buffer.PATHINDEX = *(compl + 1);
		        buffer.PATHPARAM32 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;

}

int svc_FddiPATHType(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHClassType;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) (buffer.PATHPARAM16);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
			break;
        }
        return 0;
	}

int svc_FddiPATHOrder(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHPORTOrder;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) (buffer.PATHPARAM16 + 1);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_FddiPATHTraceStatus(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHTraceStatus;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) (buffer.PATHPARAM16 + 1);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}

int svc_FddiPATHSba(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHSba;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PATHPARAM32;
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}
	
int svc_FddiPATHSbaOverhead(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHSbaOverhead;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PATHPARAM16;
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiPATHClassPATHSbaOverhead;
		        buffer.paramLen  = 4;  
				buffer.PATHINDEX = *(compl + 1);
		        buffer.PATHPARAM16 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
            if (*value < 0 || *value > 0xffff)
                return BAD_VALUE;
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}

int svc_FddiPATHStatus(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHStatus;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) (buffer.PATHPARAM16 + 1);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_FddiPATHConfiguration(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassPATHConfiguration;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PATHPARAM32;
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_FddiPATHTraceMaxExpiration(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassTrace_MaxExpiration;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.PATHPARAM32);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiPATHClassTrace_MaxExpiration;
		        buffer.paramLen  = 8;  
				buffer.PATHINDEX = *(compl + 1);

				/* convert to twos compliment */
		        buffer.PATHPARAM32 = -(*value);
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}

int svc_FddiPATHTvxLowerBound(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassTVXLowerBound;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.PATHPARAM32);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiPATHClassTVXLowerBound;
		        buffer.paramLen  = 8;  
				buffer.PATHINDEX = *(compl + 1);
				
				/* convert to twos compliment */
		        buffer.PATHPARAM32 = -(*value);
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}

int svc_FddiPATHTMaxLowerBound(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPATHEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiPATHEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPATHClassT_MaxLowerBound;
		        buffer.paramLen  = 0;  
				buffer.PATHINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				/* convert to twos compliment */
		        *value = (UINT_32_T) -(buffer.PATHPARAM32);
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiPATHClassT_MaxLowerBound;
		        buffer.paramLen  = 8;  
				buffer.PATHINDEX = *(compl + 1);

				/* convert to twos compliment */
		        buffer.PATHPARAM32 = -(*value);
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}

	
int svc_snmpFddiSMTReportLimit(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
	int 			rtn_code;
    void 			* idx1;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
                                , &idx1 );
                /* FALL TRHROUGH */
        case SNMP_GET:
       		if (rtn_code == 0)
                {
	        	buffer.paramType = fddiSMTReportLimit;
		        buffer.paramLen  = 0;  
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.SMTPARAM32;
                }
                else
                	return NO_SUCH_NAME;
                break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiSMTReportLimit;
		        buffer.paramLen  = 4;  
		        buffer.SMTPARAM32 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
            break;
        case SNMP_TEST:
			if (*value < 1)
				return BAD_VALUE;

			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}


int svc_snmpFddiSMTUserData(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
	int 			rtn_code;
    void 			* idx1;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
                                , &idx1 );
                /* FALL TRHROUGH */
        case SNMP_GET:
       		if (rtn_code == 0)
                {
	        	buffer.paramType = fddiSMTUserData;
		        buffer.paramLen  = 0;  
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
				
				memcpy(value, buffer.SMTOTHER, 32);
				*lenp = 32;
                }
                else
                	return NO_SUCH_NAME;
                break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {

	        	buffer.paramType = fddiSMTUserData;
		        buffer.paramLen  = 32;  
		        memcpy(buffer.SMTOTHER, value, 32);
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
                }
			else
				return NO_SUCH_NAME;
            break;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
}

int svc_snmpFddiPORTMaintLineState(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTMaintLineState;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) (buffer.PORTPARAM8 + 1);
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {
                
	        	buffer.paramType = fddiPORTMaintLineState;
		        buffer.paramLen  = 8;  
				buffer.PORTINDEX = *(compl + 1);
		        buffer.PORTPARAM8 = *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;

                }
			else
				return NO_SUCH_NAME;
            break;
        case SNMP_TEST:
            if (*value < 0 || *value > 4)
                return BAD_VALUE;
 
			if (!get_myStationId())
				return NO_SUCH_NAME;
			break;
        }
        return 0;
	}


int svc_snmpFddiPORTFotxClass(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTFotxClass;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) (buffer.PORTPARAM8 + 1);
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}

int svc_snmpFddiPORTElBErrorCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTEBError_Ct;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PORTPARAM32;
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiPORTBaseLerEstimate(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTLer_Estimate;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PORTPARAM8;
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}


int svc_snmpFddiPORTBaseLemRejectCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTLem_Reject_Ct;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
		        *value = (UINT_32_T) buffer.PORTPARAM32;
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}


int svc_snmpFddiPORTBaseLemCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTBaseLem_Ct;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.PORTPARAM32;
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}

int svc_snmpFddiPORTBaseLerTimeStamp(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiPORTBaseLer_TimeStamp;
		        buffer.paramLen  = 0;  
				buffer.PORTINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				*lenp = 8;
				memcpy(value, &buffer.PORTPARAM8, 8);
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
	}


int svc_snmpFddiPORTLerConditionCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	uint			portno;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
				portno = *(compl+1) - 1;  /* port no starts from 0 */
				*value = (UINT_32_T) SmtMibPortObjects[portno].LerConditionCts;
				}
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiPORTUndesiredConnectionCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	uint			portno;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
                portno = *(compl+1) - 1;  /* port no starts from 0 */ 
                *value = (UINT_32_T) 
							SmtMibPortObjects[portno].UndesiredConnectionCts;
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiPORTEBErrorConditionCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	uint			portno;
 
    rtn_code = index_snmpFddiPORTEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiPORTEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );
                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
                portno = *(compl+1) - 1;  /* port no starts from 0 */ 
                *value = (UINT_32_T) 
							SmtMibPortObjects[portno].EbErrorConditionCts;
                }
            else
                return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACReceiveCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void * idx1;
    void * idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
		  buffer.paramType = fddiMACFrame_Ct;  
		  buffer.paramLen  = 0;  
		  buffer.MACINDEX = *(compl + 1);
		  result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
		  if (result != RC_SUCCESS)
		    return NO_SUCH_NAME;

		  *value = (UINT_32_T) buffer.MACPARAM32;
                }
        	else
		  return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACTransmitCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACTransmit_Ct;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.MACPARAM32;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACTokenCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACToken_Ct;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.MACPARAM32;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiMACTvxExpiredCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACTvxExpired_Ct;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.MACPARAM32;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiMACNotCopiedCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
            	buffer.paramType = fddiMACNotCopied_Ct;
            	buffer.paramLen  = 0;
            	buffer.MACINDEX = *(compl + 1);
            	result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
            	if (result != RC_SUCCESS)
                	return NO_SUCH_NAME;

            	*value = (UINT_32_T) buffer.MACPARAM32;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiMACLateCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACLate_Ct;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.MACPARAM16;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiMACRingOpCts(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACRingOp_Ct;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

		        *value = (UINT_32_T) buffer.MACPARAM32;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiPATHTraceStarted(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int 			rtn_code;
    void 			* idx1;
    void 			* idx2;
	uint			macno;
 
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
			    macno = *(compl+1) - 1;  /* macno starts from 0 */	
                *value = (UINT_32_T) SmtMibMacObjects[macno].PathTraceStarted;
                }
            else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
                {
					return NO_SUCH_NAME;
                }
			else
				return NO_SUCH_NAME;
        case SNMP_TEST:
			return NO_SUCH_NAME;
	
        }
        return 0;
}

int svc_snmpFddiPATHTraceTerminated(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
        int rtn_code;
 
        void * idx1;
        void * idx2;
		uint macno;
 
        rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
        switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );


                /* FALL TRHROUGH */
        case SNMP_GET:
                if (rtn_code == 0)
                {
                macno = *(compl+1) - 1;  /* macno starts from 0 */  
                *value = (UINT_32_T) SmtMibMacObjects[macno].PathTraceTerminated;
                }
                else
                        return NO_SUCH_NAME;
                break;
        case SNMP_SET:
                {
				return NO_SUCH_NAME;
                }
                break;
        case SNMP_TEST:
			return NO_SUCH_NAME;
            break;
        }
        return 0;
}

int svc_snmpFddiPATHTracePropagated(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
        int rtn_code;
 
        void * idx1;
        void * idx2;
		uint macno;
 
        rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
        switch(service)
        {   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );


                /* FALL TRHROUGH */
        case SNMP_GET:
                if (rtn_code == 0)
                {
                macno = *(compl+1) - 1;  /* macno starts from 0 */  
                *value = (UINT_32_T) SmtMibMacObjects[macno].PathTracePropagated;
                }
                else
                        return NO_SUCH_NAME;
                break;
        case SNMP_SET:
                {
				return GEN_ERR;
                }
                break;
        case SNMP_TEST:
				return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACDownstreamNbr(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void * idx1;
    void * idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACDownstreamNbr;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

	        	memcpy(value, buffer.MACADDR, 6);
				*lenp = 6;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACRootConcentratorMAC(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void * idx1;
    void * idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACRootConcentratorMAC;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

            	if (buffer.MACPARAM8 == 0)
                	*value = (UINT_32_T) 2;
            	else   
                	*value = (UINT_32_T) buffer.MACPARAM8;
 
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACLongAliases(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void * idx1;
    void * idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACLongAliases;  
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL);
 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				memcpy(value, (uChar *) buffer.MACOTHER, 6);
				*lenp = 6;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
	        	{

	        	buffer.paramType = fddiMACLongAliases;  
		        buffer.paramLen  = 4;  
				buffer.MACINDEX = *(compl + 1);
				memcpy((uChar *) buffer.MACOTHER, value, 6);
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
                break;
        }
        return 0;
}

int svc_snmpFddiMACShortAliases(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACShortAliases;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				*value = buffer.MACPARAM16;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
	        	{
	        	buffer.paramType = fddiMACShortAliases;
		        buffer.paramLen  = 4;  
				buffer.MACINDEX = *(compl + 1);
				buffer.MACPARAM16 =  *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
                break;
        }
        return 0;
}

int svc_snmpFddiMACLongGrpAddrs(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACLongGrpAddrs;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				memcpy(value, (uChar *) buffer.MACADDR, 6);
				*lenp = 6;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
	        	{

	        	buffer.paramType = fddiMACLongGrpAddrs;
		        buffer.paramLen  = 4;  
				buffer.MACINDEX = *(compl + 1);
				memcpy((uChar *) buffer.MACADDR, value, 6);
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
                break;
        }
        return 0;
}

int svc_snmpFddiMACShortGrpAddrs(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACShortGrpAddrs;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

				*value = buffer.MACPARAM16;
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
        	if (rtn_code == 0)
	        	{
	        	buffer.paramType = fddiMACShortGrpAddrs;
		        buffer.paramLen  = 4;  
				buffer.MACINDEX = *(compl + 1);
				buffer.MACPARAM16 =  *value;
				do
					{
		        	result = ChangeMIBAttr(sizeof(buffer), (uchar *)&buffer, 
									&setCount, &myStationId);

                    ReSchedule();   /* Reschedule so that this loop won't
                                       exceed max time required to reset */
 
					} while (result == RC_BAD_SET_COUNT);
#if 0				
				printf("result of set = %d\n", result);   
#endif
                if (result != RC_SUCCESS)
                        return GEN_ERR;
					
				return 0;
			    }
			else
				return NO_SUCH_NAME;
        	break;
        case SNMP_TEST:
			if (!get_myStationId())
				return NO_SUCH_NAME;
                break;
        }
        return 0;
}

int svc_snmpFddiMACNotCopiedCondition(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACNotCopiedCondition;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;

	            if (buffer.MACPARAM8 == 0)
   		             *value = (UINT_32_T) 2;
            	else
                	*value = (UINT_32_T) buffer.MACPARAM8;
 
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}

int svc_snmpFddiMACLLCServiceAvailable(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
    int rtn_code;
 
    void 			* idx1;
    void 			* idx2;
	TLVParamType    buffer;
	uint			result;
				         
    rtn_code = index_snmpFddiMACEntry(compc, compl, &idx1, &idx2 );
 
    switch(service)
    	{   
        case SNMP_GETNXT:
        rtn_code = next_snmpFddiMACEntry(compc, compl ,rtn_code
                                , &idx1, &idx2 );

                /* FALL TRHROUGH */
        case SNMP_GET:
        	if (rtn_code == 0)
                {
	        	buffer.paramType = fddiMACLLCServiceAvailable;
		        buffer.paramLen  = 0;  
				buffer.MACINDEX = *(compl + 1);
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
	
	            if (buffer.MACPARAM8 == 0)
   		             *value = (UINT_32_T) 2;
       		     else
           		     *value = (UINT_32_T) buffer.MACPARAM8;
 
                }
        	else
                return NO_SUCH_NAME;
            break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


int svc_snmpFddiSMTLastSetStationID(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
	int 			rtn_code;
    void 			* idx1;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
                                , &idx1 );
                /* FALL TRHROUGH */
        case SNMP_GET:
       		if (rtn_code == 0)
                {
	        	buffer.paramType = fddiSMTLastSetStationId;
		        buffer.paramLen  = 0;  
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
#if 0				
				printf("result of set = %d\n", result);   
#endif

		        memcpy(value, buffer.SMTOTHER, 8);
				*lenp = 8;
                }
                else
                	return NO_SUCH_NAME;
                break;
        case SNMP_SET:
				return GEN_ERR;
        case SNMP_TEST:
				return READ_ONLY;
        }
        return 0;
	}


int svc_snmpFddiSMTRemoteDisconnectStationID(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
	{
	int 			rtn_code;
    void 			* idx1;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
                                , &idx1 );
                /* FALL TRHROUGH */
        case SNMP_GET:
       		if (rtn_code == 0)
                {
#ifdef NEWCODE				
	        	buffer.paramType = fddiSMTRemoteDisconnectStationId;
		        buffer.paramLen  = 0;  
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
#if 0				
				printf("result of set = %d\n", result);   
#endif

		        memcpy(value, buffer.SMTOTHER, 8);
				*lenp = 8;
#endif
				/* remove these two lines later */
		        memset(value, 0, 8);
				*lenp = 8;
                }
                else
                	return NO_SUCH_NAME;
                break;
        case SNMP_SET:
				return GEN_ERR;
        case SNMP_TEST:
				return READ_ONLY;
        }
        return 0;
	}


int svc_snmpFddiSMTManufacturerData(service, compc, compl, lenp, value, index)
unsigned int    service;
byte            *compc;
unsigned int    *compl;
int             *lenp;
UINT_32_T       *value;
int             index;
{
	int 			rtn_code;
    void 			* idx1;
	TLVParamType    buffer;
	uint			result;
 
    rtn_code = index_snmpFddiSMTEntry(compc, compl, &idx1 );
 
    switch(service)
        {
        case SNMP_GETNXT:
        	rtn_code = next_snmpFddiSMTEntry(compc, compl ,rtn_code
                                , &idx1 );
                /* FALL TRHROUGH */
        case SNMP_GET:
       		if (rtn_code == 0)
                {
	        	buffer.paramType = fddiSMTManufacturerData;
		        buffer.paramLen  = 0;  
		        result = GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); 
            	if (result != RC_SUCCESS)
					return NO_SUCH_NAME;
#if 0				
				printf("result of set = %d\n", result);   
#endif
				memcpy(value, buffer.SMTOTHER, 32);
				*lenp = 32;
                }
                else
                	return NO_SUCH_NAME;
                break;
        case SNMP_SET:
			return GEN_ERR;
        case SNMP_TEST:
			return READ_ONLY;
        }
        return 0;
}


