/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the service routines for RFC1286-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#define RFC1286-MIB_SVC

#include <types.h> 
#include <target.h>
#include <krnl.h>
#include <bridges.h>
#include <dbd.h>
#include <snmp.h>
#include <asn1.h>
#include <syteksnm.h>
#include <prcctl.h>
#include <sncvar.h>

/****************************************************************************
**
**   CHK_PRTIDX ROUTINE
**
**   Check the instance of a tabular object which is indexed by port number.
**
**   Return: 0:            If instance count 1 and instance value is between
**                         1 and 4.
**           NO_SUCH_NAME: All other conditions.
**
****************************************************************************/

chk_prtidx(uint inst_len, uint index) {

   if( (inst_len != 1) || (index < 1) || (index > 4) )
       return( NO_SUCH_NAME );
   else
       return(0);
}


/****************************************************************************
**
**   GET_NXTPRTIDX ROUTINE
**
**   Increment the instance of a tabular object which is indexed
**   by port number.
**
**   Return: 0:            If instance count 1 and instance value is between
**                         1 and 4.
**           NO_SUCH_NAME: All other conditions.
**
****************************************************************************/

get_nxtprtidx( uint *inst_len, uint *index, int retval ) {

    if( *inst_len == 0 ) {

        *inst_len = 1;
        *index    = 1;
    }
    else
    if(( retval != 0 ) || ((++(*index)) > 4))
        return(ERR_INSTANCE);

    return(0);
}

/**************************************************************************
*  Procedure    :   svc_dot1dBaseBridgeAddress
*  Path         :   1.3.6.1.2.1.17.1.1
*  Access       :   RO
*  Syntax       :   MacAddress VT_STRING
*  Description  :   
*                 "The MAC address used by this bridge when it must
*                 be referred to in a unique fashion.   It is
*                 recommended that this be the numerically smallest
*                 MAC address of all ports that belong to this
*                 bridge.  However it is only required to be unique.
*                 When concatenated with dot1dStpPriority a unique
*                 BridgeIdentifier is formed which is used in the
*                 Spanning Tree Protocol."
*
**************************************************************************/

int svc_dot1dBaseBridgeAddress(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			get_ifaddr((int *)lenp, value);
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

extern int NumberOfSonicPort;
/**************************************************************************
*  Procedure    :   svc_dot1dBaseNumPorts
*  Path         :   1.3.6.1.2.1.17.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The number of ports controlled by this bridging
*                 entity."
*
**************************************************************************/

int svc_dot1dBaseNumPorts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) NumberOfSonicPort;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dBaseType
*  Path         :   1.3.6.1.2.1.17.1.3
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "Indicates what type of bridging this bridge can
*                 perform.  If a bridge is actually performing a
*                 certain type of bridging this will be indicated by
*                 entries in the port table for the given type."
*
**************************************************************************/

int svc_dot1dBaseType(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T)2/* transparent-only */;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dBasePort
*  Path         :   1.3.6.1.2.1.17.1.4.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The port number of the port for which this entry
*                 contains bridge management information."
*
**************************************************************************/

int svc_dot1dBasePort(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_prtidx(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtprtidx((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T)*compl;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dBasePortIfIndex
*  Path         :   1.3.6.1.2.1.17.1.4.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The value of the instance of the ifIndex object,
*                 defined in [4,6], for the interface corresponding
*                 to this port."
*
**************************************************************************/

int svc_dot1dBasePortIfIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_prtidx(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtprtidx((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T)*compl;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dBasePortCircuit
*  Path         :   1.3.6.1.2.1.17.1.4.1.3
*  Access       :   RO
*  Syntax       :   OBJECT VT_OBJECT
*  Description  :   
*                 "For a port which (potentially) has the same value
*                 of dot1dBasePortIfIndex as another port on the
*                 same bridge, this object contains the name of an
*                 object instance unique to this port.  For example,
*                 in the case where multiple ports correspond one-
*                 to-one with multiple X.25 virtual circuits, this
*                 value might identify an (e.g., the first) object
*                 instance associated with the X.25 virtual circuit
*                 corresponding to this port.
*  
*                 For a port which has a unique value of
*                 dot1dBasePortIfIndex, this object can have the
*                 value { 0 0 }."
*
**************************************************************************/

int svc_dot1dBasePortCircuit(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_prtidx(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtprtidx((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T)0;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dBasePortDelayExceededDiscards
*  Path         :   1.3.6.1.2.1.17.1.4.1.4
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                 "The number of frames discarded by this port due
*                 to excessive transit delay through the bridge.  It
*                 is incremented by both transparent and source
*                 route bridges."
*
**************************************************************************/

int svc_dot1dBasePortDelayExceededDiscards(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_prtidx(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtprtidx((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T)0;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

extern PRCCNT prccnt;
/**************************************************************************
*  Procedure    :   svc_dot1dBasePortMtuExceededDiscards
*  Path         :   1.3.6.1.2.1.17.1.4.1.5
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                 "The number of frames discarded by this port due
*                 to an excessive size.  It is incremented by both
*                 transparent and source route bridges."
*
**************************************************************************/

int svc_dot1dBasePortMtuExceededDiscards(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_prtidx(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtprtidx((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) prccnt.Cnt_TooBig[*compl - 1];
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

