/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for HLS-ADMIN-BUS
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/
#include <asn1.h>
#include <priv_tbl.h> 
#include <snmp.h>
#include <mib.h>
#include <libfuncs.h>
#include <syteksnm.h>
#include <adminBus.h>

static MIBLEAF_T hlsAdminBusConsoleRcvdOctets_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusConsoleRcvdOctets );

static MIBLEAF_T hlsAdminBusConsoleSentOctets_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusConsoleSentOctets );

static MIBLEAF_T hlsAdminBusTimeouts_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusTimeouts );

static MIBLEAF_T hlsAdminBusInits_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusInits );

static MIBLEAF_T hlsAdminBusRcvdICmds_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusRcvdICmds );

static MIBLEAF_T hlsAdminBusIssuedICmds_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusIssuedICmds );

static MIBLEAF_T hlsAdminBusUnknownICmds_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusUnknownICmds );

static MIBLEAF_T hlsAdminBusRelayerRefuseds_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusRelayerRefuseds );

static MIBLEAF_T hlsAdminBusRelayerAccepteds_leaf = LEAF( VT_COUNTER,RO,49,svc_hlsAdminBusRelayerAccepteds );

static MIBARC_T hlsAdminBus_arcs[] = { 
				ARC(1,hlsAdminBusConsoleRcvdOctets_leaf),
				ARC(2,hlsAdminBusConsoleSentOctets_leaf),
				ARC(3,hlsAdminBusTimeouts_leaf),
				ARC(4,hlsAdminBusInits_leaf),
				ARC(5,hlsAdminBusRcvdICmds_leaf),
				ARC(6,hlsAdminBusIssuedICmds_leaf),
				ARC(7,hlsAdminBusUnknownICmds_leaf),
				ARC(8,hlsAdminBusRelayerRefuseds_leaf),
				ARC(9,hlsAdminBusRelayerAccepteds_leaf),
			END_OF_ARC_LIST};

MIBNODE_T hlsAdminBus_node = NODE (hlsAdminBus_arcs);

