/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for HLSBRIDGES-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <asn1.h>
#include <priv_tbl.h> 
#include <snmp.h>
#include <mib.h>
#include <libfuncs.h>
#include <syteksnm.h>
#include <hlsBridges.h>

static MIBLEAF_T bridgeModel_leaf = LEAF( VT_NUMBER,RO,49,svc_bridgeModel );

static MIBLEAF_T bridgeMode_leaf = LEAF( VT_NUMBER,RW,49,svc_bridgeMode );

static MIBLEAF_T ageingOption_leaf = LEAF( VT_NUMBER,RO,49,svc_ageingOption );

static MIBLEAF_T chLearnMode_leaf = LEAF( VT_NUMBER,RW,49,svc_chLearnMode );

static MIBLEAF_T chRestrictMode_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictMode );

static MIBLEAF_T chOriginMode_leaf = LEAF( VT_NUMBER,RO,49,svc_chOriginMode );

static MIBLEAF_T chGroupFwdMode_leaf = LEAF( VT_NUMBER,RW,49,svc_chGroupFwdMode );

static MIBLEAF_T chIndFwdMode_leaf = LEAF( VT_NUMBER,RW,49,svc_chIndFwdMode );

static MIBLEAF_T chDefRestrictFlag_leaf = LEAF( VT_NUMBER,RW,49,svc_chDefRestrictFlag );

static MIBLEAF_T chDefStaticFlag_leaf = LEAF( VT_NUMBER,RW,49,svc_chDefStaticFlag );

static MIBLEAF_T chDefOriginFlag_leaf = LEAF( VT_NUMBER,RW,49,svc_chDefOriginFlag );

static MIBLEAF_T chInCRCs_leaf = LEAF( VT_COUNTER,RO,49,svc_chInCRCs );

static MIBLEAF_T chInOverruns_leaf = LEAF( VT_COUNTER,RO,49,svc_chInOverruns );

static MIBLEAF_T chOutColls_leaf = LEAF( VT_COUNTER,RO,49,svc_chOutColls );

static MIBLEAF_T chWhos_leaf = LEAF( VT_COUNTER,RO,49,svc_chWhos );

static MIBLEAF_T chInRunts_leaf = LEAF( VT_COUNTER,RO,49,svc_chInRunts );

static MIBLEAF_T chInGiants_leaf = LEAF( VT_COUNTER,RO,49,svc_chInGiants );

static MIBLEAF_T chInLenErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_chInLenErrors );

static MIBLEAF_T chInLocks_leaf = LEAF( VT_COUNTER,RO,49,svc_chInLocks );

static MIBLEAF_T chOutLocks_leaf = LEAF( VT_COUNTER,RO,49,svc_chOutLocks );

static MIBLEAF_T chNoBuffers_leaf = LEAF( VT_COUNTER,RO,49,svc_chNoBuffers );

static MIBLEAF_T channelNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_channelNumber );
static MIBARC_T channelEntry_arcs[] = { 
				ARC(1,chLearnMode_leaf),
				ARC(2,chRestrictMode_leaf),
				ARC(3,chOriginMode_leaf),
				ARC(4,chGroupFwdMode_leaf),
				ARC(5,chIndFwdMode_leaf),
				ARC(6,chDefRestrictFlag_leaf),
				ARC(7,chDefStaticFlag_leaf),
				ARC(8,chDefOriginFlag_leaf),
				ARC(9,chInCRCs_leaf),
				ARC(10,chInOverruns_leaf),
				ARC(11,chOutColls_leaf),
				ARC(12,chWhos_leaf),
				ARC(13,chInRunts_leaf),
				ARC(14,chInGiants_leaf),
				ARC(15,chInLenErrors_leaf),
				ARC(16,chInLocks_leaf),
				ARC(17,chOutLocks_leaf),
				ARC(18,chNoBuffers_leaf),
				ARC(19,channelNumber_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T channelEntry_node = NODE (channelEntry_arcs);

static MIBARC_T channelTable_arcs[] = { 
				ARC(1,channelEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T channelTable_node = NODE (channelTable_arcs);

static MIBLEAF_T protocolBlocking_leaf = LEAF( VT_STRING,RO,49,svc_protocolBlocking );

static MIBLEAF_T reason_leaf = LEAF( VT_NUMBER,RO,49,svc_reason );

static MIBLEAF_T uptime_leaf = LEAF( VT_NUMBER,RO,49,svc_uptime );

static MIBARC_T resetLogEntry_arcs[] = { 
				ARC(1,reason_leaf),
				ARC(2,uptime_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T resetLogEntry_node = NODE (resetLogEntry_arcs);

static MIBARC_T resetLogTable_arcs[] = { 
				ARC(1,resetLogEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T resetLogTable_node = NODE (resetLogTable_arcs);

static MIBLEAF_T packetSize_leaf = LEAF( VT_NUMBER,RO,49,svc_packetSize );

static MIBLEAF_T transmitDeadmanTimer_leaf = LEAF( VT_NUMBER,RW,49,svc_transmitDeadmanTimer );

static MIBLEAF_T receiveDeadmanTimer_leaf = LEAF( VT_NUMBER,RW,49,svc_receiveDeadmanTimer );

static MIBLEAF_T bridgeStpMode_leaf = LEAF( VT_NUMBER,RW,49,svc_bridgeStpMode );

static MIBLEAF_T bridgeConsoleTimeout_leaf = LEAF( VT_NUMBER,RW,49,svc_bridgeConsoleTimeout );

extern multiPortBridge_node;

static MIBARC_T hlsBridges_arcs[] = { 
				ARC(4,bridgeModel_leaf),
				ARC(15,bridgeMode_leaf),
				ARC(16,ageingOption_leaf),
				ARC(17,channelTable_node),
				ARC(18,protocolBlocking_leaf),
				ARC(19,resetLogTable_node),
				ARC(20,packetSize_leaf),
				ARC(21,transmitDeadmanTimer_leaf),
				ARC(22,receiveDeadmanTimer_leaf),
				ARC(25,multiPortBridge_node),
				ARC(26,bridgeStpMode_leaf),
				ARC(27,bridgeConsoleTimeout_leaf),
			END_OF_ARC_LIST};

       MIBNODE_T hlsBridges_node = NODE (hlsBridges_arcs);

