/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for HLS-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <asn1.h>
#include <priv_tbl.h> 
#include <snmp.h>
#include <mib.h>
#include <libfuncs.h>
#include <syteksnm.h>
#include <hls.h>


static MIBLEAF_T sysType_leaf = LEAF( VT_NUMBER,RO,49,svc_sysType );

static MIBLEAF_T serialNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_serialNumber );

static MIBLEAF_T bootPromVersion_leaf = LEAF( VT_STRING,RO,49,svc_bootPromVersion );

static MIBLEAF_T sysAdmAccess_leaf = LEAF( VT_NUMBER,RW,49,svc_sysAdmAccess );

static MIBLEAF_T appSwVersion_leaf = LEAF( VT_STRING,RO,49,svc_appSwVersion );

static MIBLEAF_T hlsMibVersion_leaf = LEAF( VT_NUMBER,RO,49,svc_hlsMibVersion );

static MIBLEAF_T systemReset_leaf = LEAF( VT_NUMBER,RW,49,svc_systemReset );

static MIBLEAF_T clearCounter_leaf = LEAF( VT_NUMBER,RW,49,svc_clearCounter );

static MIBLEAF_T systemDate_leaf = LEAF( VT_STRING,RW,49,svc_systemDate );

static MIBLEAF_T systemTime_leaf = LEAF( VT_STRING,RW,49,svc_systemTime );

static MIBLEAF_T sysIpAddress_leaf = LEAF( VT_IPADDRESS,RW,49,svc_sysIpAddress );

static MIBLEAF_T primaryRouter_leaf = LEAF( VT_IPADDRESS,RW,49,svc_primaryRouter );

static MIBLEAF_T sysNetMask_leaf = LEAF( VT_IPADDRESS,RW,49,svc_sysNetMask );

static MIBLEAF_T snmpAuth_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpAuth );

static MIBLEAF_T trapManagerNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_trapManagerNumber );

static MIBLEAF_T trapManagerDest_leaf = LEAF( VT_IPADDRESS,RW,49,svc_trapManagerDest );

static MIBLEAF_T trapGeneric_leaf = LEAF( VT_STRING,RW,49,svc_trapGeneric );

static MIBLEAF_T trapEnterprise_leaf = LEAF( VT_STRING,RW,49,svc_trapEnterprise );

static MIBLEAF_T trapEntryType_leaf = LEAF( VT_NUMBER,RW,49,svc_trapEntryType );

static MIBARC_T trapManagerEntry_arcs[] = { 
				ARC(1,trapManagerDest_leaf),
				ARC(2,trapGeneric_leaf),
				ARC(3,trapEnterprise_leaf),
				ARC(4,trapEntryType_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T trapManagerEntry_node = NODE (trapManagerEntry_arcs);

static MIBARC_T trapManagerTable_arcs[] = { 
				ARC(1,trapManagerEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T trapManagerTable_node = NODE (trapManagerTable_arcs);

static MIBLEAF_T slotId_leaf = LEAF( VT_NUMBER,RO,49,svc_slotId );

static MIBLEAF_T hubId_leaf = LEAF( VT_NUMBER,RO,49,svc_hubId );

static MIBLEAF_T tftpServer_leaf = LEAF( VT_IPADDRESS,RW,49,svc_tftpServer );

static MIBLEAF_T netInterfaceSeg_leaf = LEAF( VT_STRING,RW,49,svc_netInterfaceSeg );

static MIBLEAF_T timeServer_leaf = LEAF( VT_IPADDRESS,RO,49,svc_timeServer );

static MIBLEAF_T systemPassword_leaf = LEAF( VT_STRING,RW,49,svc_systemPassword );

static MIBLEAF_T initAdminPort_leaf = LEAF( VT_NUMBER,RW,49,svc_initAdminPort );

static MIBLEAF_T tftpTimer_leaf = LEAF( VT_NUMBER,RW,49,svc_tftpTimer );

static MIBLEAF_T powerRequirement_leaf = LEAF( VT_NUMBER,RO,49,svc_powerRequirement );

static MIBLEAF_T lastClearSystemCountersTime_leaf = LEAF( VT_TIMETICKS,RO,49,svc_lastClearSystemCountersTime );

static MIBLEAF_T systemInitCause_leaf = LEAF( VT_NUMBER,RO,49,svc_systemInitCause );

static MIBLEAF_T productName_leaf = LEAF( VT_STRING,RO,49,svc_productName );

static MIBLEAF_T bootPServer_leaf = LEAF( VT_IPADDRESS,RO,49,svc_bootPServer );

static MIBLEAF_T updateSoftware_leaf = LEAF( VT_NUMBER,RW,49,svc_updateSoftware );

static MIBLEAF_T updateSWDate_leaf = LEAF( VT_STRING,RO,49,svc_updateSWDate );

static MIBLEAF_T updateSWTime_leaf = LEAF( VT_STRING,RO,49,svc_updateSWTime );

static MIBLEAF_T dipSwitches_leaf = LEAF( VT_STRING,RO,49,svc_dipSwitches );

static MIBLEAF_T bootPConfigRequest_leaf = LEAF( VT_STRING,RW,49,svc_bootPConfigRequest );

static MIBLEAF_T tftpConfigFile_leaf = LEAF( VT_STRING,RW,49,svc_tftpConfigFile );

static MIBLEAF_T tftpImageFile_leaf = LEAF( VT_STRING,RO,49,svc_tftpImageFile );

static MIBLEAF_T ledStatus_leaf = LEAF( VT_STRING,RO,49,svc_ledStatus );

static MIBLEAF_T secondaryRouter_leaf = LEAF( VT_IPADDRESS,RW,49,svc_secondaryRouter );

static MIBLEAF_T burnCycles_leaf = LEAF( VT_NUMBER,RO,49,svc_burnCycles );

static MIBARC_T hlsSystem_arcs[] = { 
				ARC(1,snmpAuth_leaf),
				ARC(7,trapManagerNumber_leaf),
				ARC(8,trapManagerTable_node),
				ARC(9,slotId_leaf),
				ARC(10,hubId_leaf),
				ARC(11,tftpServer_leaf),
				ARC(13,netInterfaceSeg_leaf),
				ARC(14,timeServer_leaf),
				ARC(15,systemPassword_leaf),
				ARC(16,initAdminPort_leaf),
				ARC(18,tftpTimer_leaf),
				ARC(20,powerRequirement_leaf),
				ARC(21,lastClearSystemCountersTime_leaf),
				ARC(22,systemInitCause_leaf),
				ARC(23,productName_leaf),
				ARC(24,bootPServer_leaf),
				ARC(27,updateSoftware_leaf),
				ARC(28,updateSWDate_leaf),
				ARC(29,updateSWTime_leaf),
				ARC(32,dipSwitches_leaf),
				ARC(33,bootPConfigRequest_leaf),
				ARC(34,tftpConfigFile_leaf),
				ARC(35,tftpImageFile_leaf),
				ARC(36,ledStatus_leaf),
				ARC(37,secondaryRouter_leaf),
				ARC(38,burnCycles_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T hlsSystem_node = NODE (hlsSystem_arcs);

extern hlsBridges_node;
extern hlsAdminBus_node;

static MIBARC_T hls_arcs[] = { 
				ARC(2,hlsBridges_node),
				ARC(3,sysType_leaf),
				ARC(4,serialNumber_leaf),
				ARC(5,bootPromVersion_leaf),
				ARC(6,sysAdmAccess_leaf),
				ARC(7,appSwVersion_leaf),
				ARC(9,hlsMibVersion_leaf),
				ARC(11,systemReset_leaf),
				ARC(12,clearCounter_leaf),
				ARC(13,systemDate_leaf),
				ARC(14,systemTime_leaf),
				ARC(17,sysIpAddress_leaf),
				ARC(18,primaryRouter_leaf),
				ARC(19,sysNetMask_leaf),
				ARC(20,hlsSystem_node),
				ARC(29,hlsAdminBus_node),
			END_OF_ARC_LIST};

       MIBNODE_T hls_node = NODE (hls_arcs);

