/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for RFC1213-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <asn1.h>
#include <priv_tbl.h> 
#include <snmp.h>
#include <mib.h>
#include <libfuncs.h>
#include <syteksnm.h>
#include <rfc1213.h>


static MIBLEAF_T sysDescr_leaf = LEAF( VT_STRING,RO,49,svc_sysDescr );

static MIBLEAF_T sysObjectID_leaf = LEAF( VT_OBJECT,RO,49,svc_sysObjectID );

static MIBLEAF_T sysUpTime_leaf = LEAF( VT_TIMETICKS,RO,49,svc_sysUpTime );

static MIBLEAF_T sysContact_leaf = LEAF( VT_STRING,RW,49,svc_sysContact );

static MIBLEAF_T sysName_leaf = LEAF( VT_STRING,RW,49,svc_sysName );

static MIBLEAF_T sysLocation_leaf = LEAF( VT_STRING,RW,49,svc_sysLocation );

static MIBLEAF_T sysServices_leaf = LEAF( VT_NUMBER,RO,49,svc_sysServices );

static MIBLEAF_T ifNumber_leaf = LEAF( VT_NUMBER,RO,49,svc_ifNumber );

static MIBLEAF_T ifIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_ifIndex );

static MIBLEAF_T ifDescr_leaf = LEAF( VT_STRING,RO,49,svc_ifDescr );

static MIBLEAF_T ifType_leaf = LEAF( VT_NUMBER,RO,49,svc_ifType );

static MIBLEAF_T ifMtu_leaf = LEAF( VT_NUMBER,RO,49,svc_ifMtu );

static MIBLEAF_T ifSpeed_leaf = LEAF( VT_GAUGE,RO,49,svc_ifSpeed );

static MIBLEAF_T ifPhysAddress_leaf = LEAF( VT_STRING,RO,49,svc_ifPhysAddress );

static MIBLEAF_T ifAdminStatus_leaf = LEAF( VT_NUMBER,RW,49,svc_ifAdminStatus );

static MIBLEAF_T ifOperStatus_leaf = LEAF( VT_NUMBER,RO,49,svc_ifOperStatus );

static MIBLEAF_T ifLastChange_leaf = LEAF( VT_TIMETICKS,RO,49,svc_ifLastChange );

static MIBLEAF_T ifInOctets_leaf = LEAF( VT_COUNTER,RO,49,svc_ifInOctets );

static MIBLEAF_T ifInUcastPkts_leaf = LEAF( VT_COUNTER,RO,49,svc_ifInUcastPkts );

static MIBLEAF_T ifInNUcastPkts_leaf = LEAF( VT_COUNTER,RO,49,svc_ifInNUcastPkts );

static MIBLEAF_T ifInDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_ifInDiscards );

static MIBLEAF_T ifInErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_ifInErrors );

static MIBLEAF_T ifInUnknownProtos_leaf = LEAF( VT_COUNTER,RO,49,svc_ifInUnknownProtos );

static MIBLEAF_T ifOutOctets_leaf = LEAF( VT_COUNTER,RO,49,svc_ifOutOctets );

static MIBLEAF_T ifOutUcastPkts_leaf = LEAF( VT_COUNTER,RO,49,svc_ifOutUcastPkts );

static MIBLEAF_T ifOutNUcastPkts_leaf = LEAF( VT_COUNTER,RO,49,svc_ifOutNUcastPkts );

static MIBLEAF_T ifOutDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_ifOutDiscards );

static MIBLEAF_T ifOutErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_ifOutErrors );

static MIBLEAF_T ifOutQLen_leaf = LEAF( VT_GAUGE,RO,49,svc_ifOutQLen );

static MIBLEAF_T ifSpecific_leaf = LEAF( VT_OBJECT,RO,49,svc_ifSpecific );

static MIBARC_T ifEntry_arcs[] = { 
				ARC(1,ifIndex_leaf),
				ARC(2,ifDescr_leaf),
				ARC(3,ifType_leaf),
				ARC(4,ifMtu_leaf),
				ARC(5,ifSpeed_leaf),
				ARC(6,ifPhysAddress_leaf),
				ARC(7,ifAdminStatus_leaf),
				ARC(8,ifOperStatus_leaf),
				ARC(9,ifLastChange_leaf),
				ARC(10,ifInOctets_leaf),
				ARC(11,ifInUcastPkts_leaf),
				ARC(12,ifInNUcastPkts_leaf),
				ARC(13,ifInDiscards_leaf),
				ARC(14,ifInErrors_leaf),
				ARC(15,ifInUnknownProtos_leaf),
				ARC(16,ifOutOctets_leaf),
				ARC(17,ifOutUcastPkts_leaf),
				ARC(18,ifOutNUcastPkts_leaf),
				ARC(19,ifOutDiscards_leaf),
				ARC(20,ifOutErrors_leaf),
				ARC(21,ifOutQLen_leaf),
				ARC(22,ifSpecific_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T ifEntry_node = NODE (ifEntry_arcs);

static MIBARC_T ifTable_arcs[] = { 
				ARC(1,ifEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T ifTable_node = NODE (ifTable_arcs);

static MIBLEAF_T atIfIndex_leaf = LEAF( VT_NUMBER,RW,49,svc_atIfIndex );

static MIBLEAF_T atPhysAddress_leaf = LEAF( VT_STRING,RW,49,svc_atPhysAddress );

static MIBLEAF_T atNetAddress_leaf = LEAF( VT_IPADDRESS,RW,49,svc_atNetAddress );

static MIBARC_T atEntry_arcs[] = { 
				ARC(1,atIfIndex_leaf),
				ARC(2,atPhysAddress_leaf),
				ARC(3,atNetAddress_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T atEntry_node = NODE (atEntry_arcs);

static MIBARC_T atTable_arcs[] = { 
				ARC(1,atEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T atTable_node = NODE (atTable_arcs);

static MIBLEAF_T ipForwarding_leaf = LEAF( VT_NUMBER,RW,49,svc_ipForwarding );

static MIBLEAF_T ipDefaultTTL_leaf = LEAF( VT_NUMBER,RW,49,svc_ipDefaultTTL );

static MIBLEAF_T ipInReceives_leaf = LEAF( VT_COUNTER,RO,49,svc_ipInReceives );

static MIBLEAF_T ipInHdrErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_ipInHdrErrors );

static MIBLEAF_T ipInAddrErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_ipInAddrErrors );

static MIBLEAF_T ipForwDatagrams_leaf = LEAF( VT_COUNTER,RO,49,svc_ipForwDatagrams );

static MIBLEAF_T ipInUnknownProtos_leaf = LEAF( VT_COUNTER,RO,49,svc_ipInUnknownProtos );

static MIBLEAF_T ipInDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_ipInDiscards );

static MIBLEAF_T ipInDelivers_leaf = LEAF( VT_COUNTER,RO,49,svc_ipInDelivers );

static MIBLEAF_T ipOutRequests_leaf = LEAF( VT_COUNTER,RO,49,svc_ipOutRequests );

static MIBLEAF_T ipOutDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_ipOutDiscards );

static MIBLEAF_T ipOutNoRoutes_leaf = LEAF( VT_COUNTER,RO,49,svc_ipOutNoRoutes );

static MIBLEAF_T ipReasmTimeout_leaf = LEAF( VT_NUMBER,RO,49,svc_ipReasmTimeout );

static MIBLEAF_T ipReasmReqds_leaf = LEAF( VT_COUNTER,RO,49,svc_ipReasmReqds );

static MIBLEAF_T ipReasmOKs_leaf = LEAF( VT_COUNTER,RO,49,svc_ipReasmOKs );

static MIBLEAF_T ipReasmFails_leaf = LEAF( VT_COUNTER,RO,49,svc_ipReasmFails );

static MIBLEAF_T ipFragOKs_leaf = LEAF( VT_COUNTER,RO,49,svc_ipFragOKs );

static MIBLEAF_T ipFragFails_leaf = LEAF( VT_COUNTER,RO,49,svc_ipFragFails );

static MIBLEAF_T ipFragCreates_leaf = LEAF( VT_COUNTER,RO,49,svc_ipFragCreates );

static MIBLEAF_T ipAdEntAddr_leaf = LEAF( VT_IPADDRESS,RO,49,svc_ipAdEntAddr );

static MIBLEAF_T ipAdEntIfIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_ipAdEntIfIndex );

static MIBLEAF_T ipAdEntNetMask_leaf = LEAF( VT_IPADDRESS,RO,49,svc_ipAdEntNetMask );

static MIBLEAF_T ipAdEntBcastAddr_leaf = LEAF( VT_NUMBER,RO,49,svc_ipAdEntBcastAddr );

static MIBLEAF_T ipAdEntReasmMaxSize_leaf = LEAF( VT_NUMBER,RO,49,svc_ipAdEntReasmMaxSize );

static MIBARC_T ipAddrEntry_arcs[] = { 
				ARC(1,ipAdEntAddr_leaf),
				ARC(2,ipAdEntIfIndex_leaf),
				ARC(3,ipAdEntNetMask_leaf),
				ARC(4,ipAdEntBcastAddr_leaf),
				ARC(5,ipAdEntReasmMaxSize_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T ipAddrEntry_node = NODE (ipAddrEntry_arcs);

static MIBARC_T ipAddrTable_arcs[] = { 
				ARC(1,ipAddrEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T ipAddrTable_node = NODE (ipAddrTable_arcs);

static MIBLEAF_T ipRouteDest_leaf = LEAF( VT_IPADDRESS,RW,49,svc_ipRouteDest );

static MIBLEAF_T ipRouteIfIndex_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteIfIndex );

static MIBLEAF_T ipRouteMetric1_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteMetric1 );

static MIBLEAF_T ipRouteMetric2_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteMetric2 );

static MIBLEAF_T ipRouteMetric3_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteMetric3 );

static MIBLEAF_T ipRouteMetric4_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteMetric4 );

static MIBLEAF_T ipRouteNextHop_leaf = LEAF( VT_IPADDRESS,RW,49,svc_ipRouteNextHop );

static MIBLEAF_T ipRouteType_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteType );

static MIBLEAF_T ipRouteProto_leaf = LEAF( VT_NUMBER,RO,49,svc_ipRouteProto );

static MIBLEAF_T ipRouteAge_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteAge );

static MIBLEAF_T ipRouteMask_leaf = LEAF( VT_IPADDRESS,RW,49,svc_ipRouteMask );

static MIBLEAF_T ipRouteMetric5_leaf = LEAF( VT_NUMBER,RW,49,svc_ipRouteMetric5 );

static MIBLEAF_T ipRouteInfo_leaf = LEAF( VT_OBJECT,RO,49,svc_ipRouteInfo );

static MIBARC_T ipRouteEntry_arcs[] = { 
				ARC(1,ipRouteDest_leaf),
				ARC(2,ipRouteIfIndex_leaf),
				ARC(3,ipRouteMetric1_leaf),
				ARC(4,ipRouteMetric2_leaf),
				ARC(5,ipRouteMetric3_leaf),
				ARC(6,ipRouteMetric4_leaf),
				ARC(7,ipRouteNextHop_leaf),
				ARC(8,ipRouteType_leaf),
				ARC(9,ipRouteProto_leaf),
				ARC(10,ipRouteAge_leaf),
				ARC(11,ipRouteMask_leaf),
				ARC(12,ipRouteMetric5_leaf),
				ARC(13,ipRouteInfo_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T ipRouteEntry_node = NODE (ipRouteEntry_arcs);

static MIBARC_T ipRouteTable_arcs[] = { 
				ARC(1,ipRouteEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T ipRouteTable_node = NODE (ipRouteTable_arcs);

static MIBLEAF_T ipNetToMediaIfIndex_leaf = LEAF( VT_NUMBER,RW,49,svc_ipNetToMediaIfIndex );

static MIBLEAF_T ipNetToMediaPhysAddress_leaf = LEAF( VT_STRING,RW,49,svc_ipNetToMediaPhysAddress );

static MIBLEAF_T ipNetToMediaNetAddress_leaf = LEAF( VT_IPADDRESS,RW,49,svc_ipNetToMediaNetAddress );

static MIBLEAF_T ipNetToMediaType_leaf = LEAF( VT_NUMBER,RW,49,svc_ipNetToMediaType );

static MIBARC_T ipNetToMediaEntry_arcs[] = { 
				ARC(1,ipNetToMediaIfIndex_leaf),
				ARC(2,ipNetToMediaPhysAddress_leaf),
				ARC(3,ipNetToMediaNetAddress_leaf),
				ARC(4,ipNetToMediaType_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T ipNetToMediaEntry_node = NODE (ipNetToMediaEntry_arcs);

static MIBARC_T ipNetToMediaTable_arcs[] = { 
				ARC(1,ipNetToMediaEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T ipNetToMediaTable_node = NODE (ipNetToMediaTable_arcs);

static MIBLEAF_T ipRoutingDiscards_leaf = LEAF( VT_COUNTER,RO,49,svc_ipRoutingDiscards );

static MIBLEAF_T icmpInMsgs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInMsgs );

static MIBLEAF_T icmpInErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInErrors );

static MIBLEAF_T icmpInDestUnreachs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInDestUnreachs );

static MIBLEAF_T icmpInTimeExcds_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInTimeExcds );

static MIBLEAF_T icmpInParmProbs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInParmProbs );

static MIBLEAF_T icmpInSrcQuenchs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInSrcQuenchs );

static MIBLEAF_T icmpInRedirects_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInRedirects );

static MIBLEAF_T icmpInEchos_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInEchos );

static MIBLEAF_T icmpInEchoReps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInEchoReps );

static MIBLEAF_T icmpInTimestamps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInTimestamps );

static MIBLEAF_T icmpInTimestampReps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInTimestampReps );

static MIBLEAF_T icmpInAddrMasks_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInAddrMasks );

static MIBLEAF_T icmpInAddrMaskReps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpInAddrMaskReps );

static MIBLEAF_T icmpOutMsgs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutMsgs );

static MIBLEAF_T icmpOutErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutErrors );

static MIBLEAF_T icmpOutDestUnreachs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutDestUnreachs );

static MIBLEAF_T icmpOutTimeExcds_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutTimeExcds );

static MIBLEAF_T icmpOutParmProbs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutParmProbs );

static MIBLEAF_T icmpOutSrcQuenchs_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutSrcQuenchs );

static MIBLEAF_T icmpOutRedirects_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutRedirects );

static MIBLEAF_T icmpOutEchos_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutEchos );

static MIBLEAF_T icmpOutEchoReps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutEchoReps );

static MIBLEAF_T icmpOutTimestamps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutTimestamps );

static MIBLEAF_T icmpOutTimestampReps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutTimestampReps );

static MIBLEAF_T icmpOutAddrMasks_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutAddrMasks );

static MIBLEAF_T icmpOutAddrMaskReps_leaf = LEAF( VT_COUNTER,RO,49,svc_icmpOutAddrMaskReps );

static MIBLEAF_T tcpRtoAlgorithm_leaf = LEAF( VT_NUMBER,RO,49,svc_tcpRtoAlgorithm );

static MIBLEAF_T tcpRtoMin_leaf = LEAF( VT_NUMBER,RO,49,svc_tcpRtoMin );

static MIBLEAF_T tcpRtoMax_leaf = LEAF( VT_NUMBER,RO,49,svc_tcpRtoMax );

static MIBLEAF_T tcpMaxConn_leaf = LEAF( VT_NUMBER,RO,49,svc_tcpMaxConn );

static MIBLEAF_T tcpActiveOpens_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpActiveOpens );

static MIBLEAF_T tcpPassiveOpens_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpPassiveOpens );

static MIBLEAF_T tcpAttemptFails_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpAttemptFails );

static MIBLEAF_T tcpEstabResets_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpEstabResets );

static MIBLEAF_T tcpCurrEstab_leaf = LEAF( VT_GAUGE,RO,49,svc_tcpCurrEstab );

static MIBLEAF_T tcpInSegs_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpInSegs );

static MIBLEAF_T tcpOutSegs_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpOutSegs );

static MIBLEAF_T tcpRetransSegs_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpRetransSegs );

static MIBLEAF_T tcpConnState_leaf = LEAF( VT_NUMBER,RW,49,svc_tcpConnState );

static MIBLEAF_T tcpConnLocalAddress_leaf = LEAF( VT_IPADDRESS,RO,49,svc_tcpConnLocalAddress );

static MIBLEAF_T tcpConnLocalPort_leaf = LEAF( VT_NUMBER,RO,49,svc_tcpConnLocalPort );

static MIBLEAF_T tcpConnRemAddress_leaf = LEAF( VT_IPADDRESS,RO,49,svc_tcpConnRemAddress );

static MIBLEAF_T tcpConnRemPort_leaf = LEAF( VT_NUMBER,RO,49,svc_tcpConnRemPort );

static MIBARC_T tcpConnEntry_arcs[] = { 
				ARC(1,tcpConnState_leaf),
				ARC(2,tcpConnLocalAddress_leaf),
				ARC(3,tcpConnLocalPort_leaf),
				ARC(4,tcpConnRemAddress_leaf),
				ARC(5,tcpConnRemPort_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T tcpConnEntry_node = NODE (tcpConnEntry_arcs);

static MIBARC_T tcpConnTable_arcs[] = { 
				ARC(1,tcpConnEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T tcpConnTable_node = NODE (tcpConnTable_arcs);

static MIBLEAF_T tcpInErrs_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpInErrs );

static MIBLEAF_T tcpOutRsts_leaf = LEAF( VT_COUNTER,RO,49,svc_tcpOutRsts );

static MIBLEAF_T udpInDatagrams_leaf = LEAF( VT_COUNTER,RO,49,svc_udpInDatagrams );

static MIBLEAF_T udpNoPorts_leaf = LEAF( VT_COUNTER,RO,49,svc_udpNoPorts );

static MIBLEAF_T udpInErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_udpInErrors );

static MIBLEAF_T udpOutDatagrams_leaf = LEAF( VT_COUNTER,RO,49,svc_udpOutDatagrams );

static MIBLEAF_T udpLocalAddress_leaf = LEAF( VT_IPADDRESS,RO,49,svc_udpLocalAddress );

static MIBLEAF_T udpLocalPort_leaf = LEAF( VT_NUMBER,RO,49,svc_udpLocalPort );

static MIBARC_T udpEntry_arcs[] = { 
				ARC(1,udpLocalAddress_leaf),
				ARC(2,udpLocalPort_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T udpEntry_node = NODE (udpEntry_arcs);

static MIBARC_T udpTable_arcs[] = { 
				ARC(1,udpEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T udpTable_node = NODE (udpTable_arcs);

static MIBLEAF_T snmpInPkts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInPkts );

static MIBLEAF_T snmpOutPkts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutPkts );

static MIBLEAF_T snmpInBadVersions_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInBadVersions );

static MIBLEAF_T snmpInBadCommunityNames_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInBadCommunityNames );

static MIBLEAF_T snmpInBadCommunityUses_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInBadCommunityUses );

static MIBLEAF_T snmpInASNParseErrs_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInASNParseErrs );

static MIBLEAF_T snmpInTooBigs_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInTooBigs );

static MIBLEAF_T snmpInNoSuchNames_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInNoSuchNames );

static MIBLEAF_T snmpInBadValues_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInBadValues );

static MIBLEAF_T snmpInReadOnlys_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInReadOnlys );

static MIBLEAF_T snmpInGenErrs_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInGenErrs );

static MIBLEAF_T snmpInTotalReqVars_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInTotalReqVars );

static MIBLEAF_T snmpInTotalSetVars_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInTotalSetVars );

static MIBLEAF_T snmpInGetRequests_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInGetRequests );

static MIBLEAF_T snmpInGetNexts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInGetNexts );

static MIBLEAF_T snmpInSetRequests_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInSetRequests );

static MIBLEAF_T snmpInGetResponses_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInGetResponses );

static MIBLEAF_T snmpInTraps_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpInTraps );

static MIBLEAF_T snmpOutTooBigs_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutTooBigs );

static MIBLEAF_T snmpOutNoSuchNames_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutNoSuchNames );

static MIBLEAF_T snmpOutBadValues_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutBadValues );

static MIBLEAF_T snmpOutGenErrs_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutGenErrs );

static MIBLEAF_T snmpOutGetRequests_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutGetRequests );

static MIBLEAF_T snmpOutGetNexts_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutGetNexts );

static MIBLEAF_T snmpOutSetRequests_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutSetRequests );

static MIBLEAF_T snmpOutGetResponses_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutGetResponses );

static MIBLEAF_T snmpOutTraps_leaf = LEAF( VT_COUNTER,RO,49,svc_snmpOutTraps );

static MIBLEAF_T snmpEnableAuthenTraps_leaf = LEAF( VT_NUMBER,RW,49,svc_snmpEnableAuthenTraps );

static MIBARC_T snmp_arcs[] = { 
				ARC(1,snmpInPkts_leaf),
				ARC(2,snmpOutPkts_leaf),
				ARC(3,snmpInBadVersions_leaf),
				ARC(4,snmpInBadCommunityNames_leaf),
				ARC(5,snmpInBadCommunityUses_leaf),
				ARC(6,snmpInASNParseErrs_leaf),
				ARC(8,snmpInTooBigs_leaf),
				ARC(9,snmpInNoSuchNames_leaf),
				ARC(10,snmpInBadValues_leaf),
				ARC(11,snmpInReadOnlys_leaf),
				ARC(12,snmpInGenErrs_leaf),
				ARC(13,snmpInTotalReqVars_leaf),
				ARC(14,snmpInTotalSetVars_leaf),
				ARC(15,snmpInGetRequests_leaf),
				ARC(16,snmpInGetNexts_leaf),
				ARC(17,snmpInSetRequests_leaf),
				ARC(18,snmpInGetResponses_leaf),
				ARC(19,snmpInTraps_leaf),
				ARC(20,snmpOutTooBigs_leaf),
				ARC(21,snmpOutNoSuchNames_leaf),
				ARC(22,snmpOutBadValues_leaf),
				ARC(24,snmpOutGenErrs_leaf),
				ARC(25,snmpOutGetRequests_leaf),
				ARC(26,snmpOutGetNexts_leaf),
				ARC(27,snmpOutSetRequests_leaf),
				ARC(28,snmpOutGetResponses_leaf),
				ARC(29,snmpOutTraps_leaf),
				ARC(30,snmpEnableAuthenTraps_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T snmp_node = NODE (snmp_arcs);

static MIBARC_T udp_arcs[] = { 
				ARC(1,udpInDatagrams_leaf),
				ARC(2,udpNoPorts_leaf),
				ARC(3,udpInErrors_leaf),
				ARC(4,udpOutDatagrams_leaf),
				ARC(5,udpTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T udp_node = NODE (udp_arcs);

static MIBARC_T tcp_arcs[] = { 
				ARC(1,tcpRtoAlgorithm_leaf),
				ARC(2,tcpRtoMin_leaf),
				ARC(3,tcpRtoMax_leaf),
				ARC(4,tcpMaxConn_leaf),
				ARC(5,tcpActiveOpens_leaf),
				ARC(6,tcpPassiveOpens_leaf),
				ARC(7,tcpAttemptFails_leaf),
				ARC(8,tcpEstabResets_leaf),
				ARC(9,tcpCurrEstab_leaf),
				ARC(10,tcpInSegs_leaf),
				ARC(11,tcpOutSegs_leaf),
				ARC(12,tcpRetransSegs_leaf),
				ARC(13,tcpConnTable_node),
				ARC(14,tcpInErrs_leaf),
				ARC(15,tcpOutRsts_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T tcp_node = NODE (tcp_arcs);

static MIBARC_T icmp_arcs[] = { 
				ARC(1,icmpInMsgs_leaf),
				ARC(2,icmpInErrors_leaf),
				ARC(3,icmpInDestUnreachs_leaf),
				ARC(4,icmpInTimeExcds_leaf),
				ARC(5,icmpInParmProbs_leaf),
				ARC(6,icmpInSrcQuenchs_leaf),
				ARC(7,icmpInRedirects_leaf),
				ARC(8,icmpInEchos_leaf),
				ARC(9,icmpInEchoReps_leaf),
				ARC(10,icmpInTimestamps_leaf),
				ARC(11,icmpInTimestampReps_leaf),
				ARC(12,icmpInAddrMasks_leaf),
				ARC(13,icmpInAddrMaskReps_leaf),
				ARC(14,icmpOutMsgs_leaf),
				ARC(15,icmpOutErrors_leaf),
				ARC(16,icmpOutDestUnreachs_leaf),
				ARC(17,icmpOutTimeExcds_leaf),
				ARC(18,icmpOutParmProbs_leaf),
				ARC(19,icmpOutSrcQuenchs_leaf),
				ARC(20,icmpOutRedirects_leaf),
				ARC(21,icmpOutEchos_leaf),
				ARC(22,icmpOutEchoReps_leaf),
				ARC(23,icmpOutTimestamps_leaf),
				ARC(24,icmpOutTimestampReps_leaf),
				ARC(25,icmpOutAddrMasks_leaf),
				ARC(26,icmpOutAddrMaskReps_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T icmp_node = NODE (icmp_arcs);

static MIBARC_T ip_arcs[] = { 
				ARC(1,ipForwarding_leaf),
				ARC(2,ipDefaultTTL_leaf),
				ARC(3,ipInReceives_leaf),
				ARC(4,ipInHdrErrors_leaf),
				ARC(5,ipInAddrErrors_leaf),
				ARC(6,ipForwDatagrams_leaf),
				ARC(7,ipInUnknownProtos_leaf),
				ARC(8,ipInDiscards_leaf),
				ARC(9,ipInDelivers_leaf),
				ARC(10,ipOutRequests_leaf),
				ARC(11,ipOutDiscards_leaf),
				ARC(12,ipOutNoRoutes_leaf),
				ARC(13,ipReasmTimeout_leaf),
				ARC(14,ipReasmReqds_leaf),
				ARC(15,ipReasmOKs_leaf),
				ARC(16,ipReasmFails_leaf),
				ARC(17,ipFragOKs_leaf),
				ARC(18,ipFragFails_leaf),
				ARC(19,ipFragCreates_leaf),
				ARC(20,ipAddrTable_node),
				ARC(21,ipRouteTable_node),
				ARC(22,ipNetToMediaTable_node),
				ARC(23,ipRoutingDiscards_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T ip_node = NODE (ip_arcs);

static MIBARC_T at_arcs[] = { 
				ARC(1,atTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T at_node = NODE (at_arcs);

static MIBARC_T interfaces_arcs[] = { 
				ARC(1,ifNumber_leaf),
				ARC(2,ifTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T interfaces_node = NODE (interfaces_arcs);

static MIBARC_T system_arcs[] = { 
				ARC(1,sysDescr_leaf),
				ARC(2,sysObjectID_leaf),
				ARC(3,sysUpTime_leaf),
				ARC(4,sysContact_leaf),
				ARC(5,sysName_leaf),
				ARC(6,sysLocation_leaf),
				ARC(7,sysServices_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T system_node = NODE (system_arcs);

extern dot1dBridge_node;
extern transmission_node;

static MIBARC_T mib2_arcs[] = { 
				ARC(1,system_node),
				ARC(2,interfaces_node),
				ARC(3,at_node),
				ARC(4,ip_node),
				ARC(5,icmp_node),
				ARC(6,tcp_node),
				ARC(7,udp_node),
				ARC(10,transmission_node),
				ARC(11,snmp_node),
				ARC(17,dot1dBridge_node),
			END_OF_ARC_LIST};

	MIBNODE_T mib2_node = NODE (mib2_arcs);

