/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for RFC1284-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <asn1.h>
#include <priv_tbl.h> 
#include <snmp.h>
#include <mib.h>
#include <libfuncs.h>
#include <syteksnm.h>
#include <rfc1284.h>

#ifdef __FDDI_ETH_BRG
extern fddi_node;
#endif

static MIBLEAF_T dot3Index_leaf = LEAF( VT_NUMBER,RO,49,svc_dot3Index );

static MIBLEAF_T dot3InitializeMac_leaf = LEAF( VT_NUMBER,RW,49,svc_dot3InitializeMac );

static MIBLEAF_T dot3MacSubLayerStatus_leaf = LEAF( VT_NUMBER,RW,49,svc_dot3MacSubLayerStatus );

static MIBLEAF_T dot3MulticastReceiveStatus_leaf = LEAF( VT_NUMBER,RW,49,svc_dot3MulticastReceiveStatus );

static MIBLEAF_T dot3TxEnabled_leaf = LEAF( VT_NUMBER,RW,49,svc_dot3TxEnabled );

static MIBLEAF_T dot3TestTdrValue_leaf = LEAF( VT_GAUGE,RO,49,svc_dot3TestTdrValue );

static MIBARC_T dot3Entry_arcs[] = { 
				ARC(1,dot3Index_leaf),
				ARC(2,dot3InitializeMac_leaf),
				ARC(3,dot3MacSubLayerStatus_leaf),
				ARC(4,dot3MulticastReceiveStatus_leaf),
				ARC(5,dot3TxEnabled_leaf),
				ARC(6,dot3TestTdrValue_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T dot3Entry_node = NODE (dot3Entry_arcs);

static MIBARC_T dot3Table_arcs[] = { 
				ARC(1,dot3Entry_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot3Table_node = NODE (dot3Table_arcs);

static MIBLEAF_T dot3StatsIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_dot3StatsIndex );

static MIBLEAF_T dot3StatsAlignmentErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsAlignmentErrors );

static MIBLEAF_T dot3StatsFCSErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsFCSErrors );

static MIBLEAF_T dot3StatsSingleCollisionFrames_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsSingleCollisionFrames );

static MIBLEAF_T dot3StatsMultipleCollisionFrames_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsMultipleCollisionFrames );

static MIBLEAF_T dot3StatsSQETestErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsSQETestErrors );

static MIBLEAF_T dot3StatsDeferredTransmissions_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsDeferredTransmissions );

static MIBLEAF_T dot3StatsLateCollisions_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsLateCollisions );

static MIBLEAF_T dot3StatsExcessiveCollisions_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsExcessiveCollisions );

static MIBLEAF_T dot3StatsInternalMacTransmitErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsInternalMacTransmitErrors );

static MIBLEAF_T dot3StatsCarrierSenseErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsCarrierSenseErrors );

static MIBLEAF_T dot3StatsExcessiveDeferrals_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsExcessiveDeferrals );

static MIBLEAF_T dot3StatsFrameTooLongs_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsFrameTooLongs );

static MIBLEAF_T dot3StatsInRangeLengthErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsInRangeLengthErrors );

static MIBLEAF_T dot3StatsOutOfRangeLengthFields_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsOutOfRangeLengthFields );

static MIBLEAF_T dot3StatsInternalMacReceiveErrors_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3StatsInternalMacReceiveErrors );

static MIBARC_T dot3StatsEntry_arcs[] = { 
				ARC(1,dot3StatsIndex_leaf),
				ARC(2,dot3StatsAlignmentErrors_leaf),
				ARC(3,dot3StatsFCSErrors_leaf),
				ARC(4,dot3StatsSingleCollisionFrames_leaf),
				ARC(5,dot3StatsMultipleCollisionFrames_leaf),
				ARC(6,dot3StatsSQETestErrors_leaf),
				ARC(7,dot3StatsDeferredTransmissions_leaf),
				ARC(8,dot3StatsLateCollisions_leaf),
				ARC(9,dot3StatsExcessiveCollisions_leaf),
				ARC(10,dot3StatsInternalMacTransmitErrors_leaf),
				ARC(11,dot3StatsCarrierSenseErrors_leaf),
				ARC(12,dot3StatsExcessiveDeferrals_leaf),
				ARC(13,dot3StatsFrameTooLongs_leaf),
				ARC(14,dot3StatsInRangeLengthErrors_leaf),
				ARC(15,dot3StatsOutOfRangeLengthFields_leaf),
				ARC(16,dot3StatsInternalMacReceiveErrors_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T dot3StatsEntry_node = NODE (dot3StatsEntry_arcs);

static MIBARC_T dot3StatsTable_arcs[] = { 
				ARC(1,dot3StatsEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot3StatsTable_node = NODE (dot3StatsTable_arcs);

static MIBLEAF_T dot3CollIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_dot3CollIndex );

static MIBLEAF_T dot3CollCount_leaf = LEAF( VT_NUMBER,RO,49,svc_dot3CollCount );

static MIBLEAF_T dot3CollFrequencies_leaf = LEAF( VT_COUNTER,RO,49,svc_dot3CollFrequencies );

static MIBARC_T dot3CollEntry_arcs[] = { 
				ARC(1,dot3CollIndex_leaf),
				ARC(2,dot3CollCount_leaf),
				ARC(3,dot3CollFrequencies_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T dot3CollEntry_node = NODE (dot3CollEntry_arcs);

static MIBARC_T dot3CollTable_arcs[] = { 
				ARC(1,dot3CollEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot3CollTable_node = NODE (dot3CollTable_arcs);

static MIBARC_T dot3_arcs[] = { 
				ARC(1,dot3Table_node),
				ARC(2,dot3StatsTable_node),
				ARC(5,dot3CollTable_node),
			END_OF_ARC_LIST};

static MIBNODE_T dot3_node = NODE (dot3_arcs);

static MIBARC_T transmission_arcs[] = { 
				ARC(7,dot3_node),
				#ifdef __FDDI_ETH_BRG
				ARC(15,fddi_node),
				#endif
			END_OF_ARC_LIST};

       MIBNODE_T transmission_node = NODE (transmission_arcs);

